<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Regvar extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdregv;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $dsregv;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('regvar');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdregv' => isset($rec->cdregv) && (string)$rec->cdregv !== '' ? (string)$rec->cdregv : 0,
      'dsregv' => isset($rec->dsregv) && (string)$rec->dsregv !== '' ? (string)$rec->dsregv : new RawValue('""')
    );

    $query  = 'cdregv = :cdregv:';
    $params = array(
      'cdregv' => $values['cdregv']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewGroup($dsregv) {
    $query = 'INSERT INTO regvar (cdregv, dsregv)
      VALUES ((SELECT COALESCE((MAX(p.cdregv) + 1), 1) FROM regvar p), :dsregv)';
    Di::getDefault()->get('db')->query($query, array('dsregv' => $dsregv));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateGroup($cdregv, $dsregv) {
    $query = 'UPDATE regvar r
      SET r.dsregv = :dsregv
      WHERE r.cdregv = :cdregv';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'dsregv' => $dsregv));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregv($cdregv) {
    $query = 'DELETE r
      FROM regvar r
      WHERE r.cdregv = :cdregv';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv));
  }
  //endregion
}
