<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Regqtm extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var double
   * @Column(type="double", nullable=false)
   */
  public $qtamin;

  /**
   *
   * @var double
   * @Column(type="double", nullable=false)
   */
  public $qtamul;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('regqtm');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'qtamin' => isset($rec->qtamin) && (string)$rec->qtamin !== '' ? (string)$rec->qtamin : 0,
      'qtamul' => isset($rec->qtamul) && (string)$rec->qtamul !== '' ? (string)$rec->qtamul : 0
    );

    $query  = 'cdartn = :cdartn: AND cdarti = :cdarti: AND cdcolo = :cdcolo:';
    $params = array(
      'cdartn' => $values['cdartn'],
      'cdarti' => $values['cdarti'],
      'cdcolo' => $values['cdcolo']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Regqtm arrays
   */
  public static function getRules($cdartn, $cdarti, $cdcolo) {
    // Priority order: cdarti + cdcolo, cdarti, cdcolo
    $query = "SELECT r1.qtamin AS qtamin, r1.qtamul AS qtamul
      FROM regqtm r1
      WHERE r1.cdarti = :cdarti AND r1.cdcolo = :cdcolo
      UNION
      SELECT r2.qtamin AS qtamin, r2.qtamul AS qtamul
      FROM regqtm r2
      WHERE r2.cdarti = :cdarti
      UNION
      SELECT r3.qtamin AS qtamin, r3.qtamul AS qtamul
      FROM regqtm r3
      WHERE r3.cdartn = :cdartn
      LIMIT 1";
    $params = array("cdcolo" => (string)$cdcolo, "cdarti" => (string)$cdarti, "cdartn" => (string)$cdartn);
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Regqtm array
   */
  public static function getModelRules($cdartn) {
    $query = "SELECT rm.cdartn, rm.qtamin, rm.qtamul
      FROM regqtm rm
      WHERE rm.cdartn = :cdartn";
    $params = array('cdartn' => $cdartn);
    $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    if (count($result) > 0) {
      return $result[0];
    } else {
      return array('cdartn' => $cdartn, 'qtamin' => 1, 'qtamul' => 1);
    }
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function createNewModelRule($cdartn, $qtamin, $qtamul) {
    $params = array('cdartn' => $cdartn, 'qtamin' => $qtamin, 'qtamul' => $qtamul);

    $query = "INSERT INTO regqtm (cdartn, cdarti, cdcolo, qtamin, qtamul)
      VALUES (:cdartn, '', '', :qtamin, :qtamul)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRules($whereCatalogs, $whereLines, $params) {
    $where = $whereCatalogs != '' ? "WHERE c.cdcata IN ($whereCatalogs) " : '';
    if ($whereLines != '') {
      $where .= ($whereCatalogs != '' ? "AND " : "WHERE ") . " t.cdlinm IN ($whereLines)";
    }

    $query = "DELETE r
      FROM regqtm r
      INNER JOIN anaart a ON a.cdartn = r.cdartn
      INNER JOIN tipolo t ON t.cdartn = r.cdartn
      INNER JOIN ctarti c ON c.cdarti = a.cdarti
      $where";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE regqtm";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
