<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Regqta extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $taglia;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $postgl;

  /**
   *
   * @var double
   * @Column(type="double", nullable=false)
   */
  public $qtamin;

  /**
   *
   * @var double
   * @Column(type="double", nullable=false)
   */
  public $qtamul;

  /**
   *
   * @var double
   * @Column(type="double", nullable=false)
   */
  public $qtamax;

  /**
   *
   * @var integer
   * @Column(type="integer", length=1, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=1, nullable=false)
   */
  public $flprom;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('regqta');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'taglia' => isset($rec->taglia) && (string)$rec->taglia !== '' ? (string)$rec->taglia : new RawValue('""'),
      'postgl' => isset($rec->postgl) && (string)$rec->postgl !== '' ? (string)$rec->postgl : 0,
      'qtamin' => isset($rec->qtamin) && (string)$rec->qtamin !== '' ? (string)$rec->qtamin : 0,
      'qtamul' => isset($rec->qtamul) && (string)$rec->qtamul !== '' ? (string)$rec->qtamul : 0,
      'qtamax' => isset($rec->qtamax) && (string)$rec->qtamax !== '' ? (string)$rec->qtamax : 0,
      'flbloc' => isset($rec->flbloc) && (string)$rec->flbloc !== '' ? (string)$rec->flbloc : 0,
      'flprom' => isset($rec->flprom) && (string)$rec->flprom !== '' ? (string)$rec->flprom : 0
    );

    $query  = 'cdartn = :cdartn: AND cdarti = :cdarti: AND cdcolo = :cdcolo: AND taglia = :taglia:';
    $params = array(
      'cdartn' => $values['cdartn'],
      'cdarti' => $values['cdarti'],
      'cdcolo' => $values['cdcolo'],
      'taglia' => $values['taglia']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Regqta objects
   */
  public static function getRules($cdartn, $cdarti, $cdcolo) {
    $query = "SELECT r.cdartn, r.cdarti, r.cdcolo, r.taglia, r.postgl, r.qtamin, r.qtamul, r.qtamax, r.flbloc, r.flprom
      FROM Go2B\Models\Regqta r
      WHERE r.cdartn = :cdartn:
      OR (r.cdarti = :cdarti: AND r.cdcolo = '')
      OR (r.cdarti = :cdarti: AND r.cdcolo = :cdcolo:)";

    $params = array('cdcolo' => $cdcolo, 'cdarti' => $cdarti, 'cdartn' => $cdartn);
    $regqta = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);

    return count($regqta) > 0 ? $regqta : array();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Regqta objects
   */
  public static function getPromoFlagFromModelArticleAndColorAndSize($cdartn, $cdarti, $cdcolo, $taglia) {
    $query = "SELECT r.flprom
      FROM Go2B\Models\Regqta r
      WHERE (r.cdartn = :cdartn: OR r.cdarti = :cdarti:)
      AND r.cdcolo = :cdcolo:
      AND r.taglia = :taglia:";
    $params = array('cdartn' => $cdartn, 'cdarti' => $cdarti, 'cdcolo' => $cdcolo, 'taglia' => $taglia);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Regqta objects
   */
  public static function getPromoFlagFromModelArticleAndSize($cdartn, $cdarti, $taglia) {
    $query = "SELECT r.flprom
      FROM Go2B\Models\Regqta r
      WHERE (r.cdartn = :cdartn: OR r.cdarti = :cdarti:)
      AND r.cdcolo = ''
      AND r.taglia = :taglia:";
    $params = array('cdartn' => $cdartn, 'cdarti' => $cdarti, 'taglia' => $taglia);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Regqta objects
   */
  public static function getPromoFlagFromModelArticleAndColor($cdartn, $cdarti, $cdcolo) {
    $query = "SELECT r.flprom
      FROM Go2B\Models\Regqta r
      WHERE (r.cdartn = :cdartn: OR r.cdarti = :cdarti:)
      AND r.cdcolo = :cdcolo:
      AND r.taglia = ''";
    $params = array('cdartn' => $cdartn, 'cdarti' => $cdarti, 'cdcolo' => $cdcolo);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Regqta objects
   */
  public static function getPromoFlagFromModelArticle($cdartn, $cdarti) {
    $query = "SELECT r.flprom
      FROM Go2B\Models\Regqta r
      WHERE (r.cdartn = :cdartn: OR r.cdarti = :cdarti:)
      AND r.cdcolo = ''
      AND r.taglia = ''";
    $params = array('cdartn' => $cdartn, 'cdarti' => $cdarti);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function createNewModelRule($cdartn, $qtamin, $qtamul) {
    $params = array('cdartn' => $cdartn, 'qtamin' => $qtamin, 'qtamul' => $qtamul);

    $query = "INSERT INTO regqta (cdartn, cdarti, cdcolo, taglia, postgl, qtamin, qtamul, qtamax, flbloc, flprom)
      VALUES (:cdartn, '', '', '', 0, :qtamin, :qtamul, 0, 0, 0)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRules($whereCatalogs, $whereLines, $params) {
    $where = $whereCatalogs != '' ? "WHERE c.cdcata IN ($whereCatalogs) " : '';
    if ($whereLines != '') {
      $where .= ($whereCatalogs != '' ? "AND " : "WHERE ") . " t.cdlinm IN ($whereLines)";
    }

    $query = "DELETE r
      FROM regqta r
      INNER JOIN anaart a ON a.cdartn = r.cdartn
      INNER JOIN tipolo t ON t.cdartn = r.cdartn
      INNER JOIN ctarti c ON c.cdarti = a.cdarti
      $where";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE regqta";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
