<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Pvtest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdprom;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsprom;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtiniz;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtfine;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tputil;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valore;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $quanti;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $flescl;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqapp;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tipapp;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont1;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont2;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont3;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $provvi;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpport;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('pvtest');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdprom' => isset($rec->cdprom) && (string)$rec->cdprom !== '' ? (string)$rec->cdprom : new RawValue('""'),
      'dsprom' => isset($rec->dsprom) && (string)$rec->dsprom !== '' ? (string)$rec->dsprom : new RawValue('""'),
      'dtiniz' => isset($rec->dtiniz) && (string)$rec->dtiniz !== '' ? (string)$rec->dtiniz : '0000-00-00',
      'dtfine' => isset($rec->dtfine) && (string)$rec->dtfine !== '' ? (string)$rec->dtfine : '0000-00-00',
      'tputil' => isset($rec->tputil) && (string)$rec->tputil !== '' ? (string)$rec->tputil : new RawValue('""'),
      'valore' => isset($rec->valore) && (string)$rec->valore !== '' ? (string)$rec->valore : 0,
      'quanti' => isset($rec->quanti) && (string)$rec->quanti !== '' ? (string)$rec->quanti : 0,
      'flescl' => isset($rec->flescl) && (string)$rec->flescl !== '' ? (string)$rec->flescl : 0,
      'seqapp' => isset($rec->seqapp) && (string)$rec->seqapp !== '' ? (string)$rec->seqapp : 0,
      'tipapp' => isset($rec->tipapp) && (string)$rec->tipapp !== '' ? (string)$rec->tipapp : new RawValue('""'),
      'scont1' => isset($rec->scont1) && (string)$rec->scont1 !== '' ? (string)$rec->scont1 : 0,
      'scont2' => isset($rec->scont2) && (string)$rec->scont2 !== '' ? (string)$rec->scont2 : 0,
      'scont3' => isset($rec->scont3) && (string)$rec->scont3 !== '' ? (string)$rec->scont3 : 0,
      'provvi' => isset($rec->provvi) && (string)$rec->provvi !== '' ? (string)$rec->provvi : 0,
      'tpport' => isset($rec->tpport) && (string)$rec->tpport !== '' ? (string)$rec->tpport : new RawValue('""'),
      'tpanag' => isset($rec->tpanag) && (string)$rec->tpanag !== '' ? (string)$rec->tpanag : new RawValue('""'),
      'cdanag' => isset($rec->cdanag) && (string)$rec->cdanag !== '' ? (string)$rec->cdanag : new RawValue('""')
    );

    $query  = 'cdprom = :cdprom:';
    $params = array(
      'cdprom' => $values['cdprom']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Pvtest objects
   */
  public static function getPromoFromOrder($nuordc) {
    $query = "SELECT t.cdprom, t.dsprom
      FROM Go2B\Models\Pvtest t
      INNER JOIN Go2B\Models\Ocprot o ON o.nuordc = :nuordc: AND t.cdprom = o.cdprom";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Pvtest objects
   */
  public static function getAllPromos() {
    $query = "SELECT p.cdprom, p.dsprom, p.dtiniz, p.dtfine, p.flescl
      FROM Go2B\Models\Pvtest p
      ORDER BY p.cdprom";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Pvtest arrays
   */
  public static function getPromosFromOrderAndCustomer($nuordc, $cdanag, $tpanag) {
    $query = "SELECT t.cdprom, t.dsprom, t.tputil, t.flescl, t.seqapp,
      COALESCE(o.nuordc, 0) AS attiva, COALESCE(n.strdes, '') AS strdes
      FROM pvtest t
      LEFT JOIN ocprot o ON t.cdprom = o.cdprom AND o.nuordc = :nuordc
      LEFT JOIN pvnote n ON n.cdprom = t.cdprom AND n.tpnota = 'COMM'
      WHERE ((t.dtiniz <= CURRENT_DATE() OR t.dtiniz IS NULL) AND (t.dtfine >= CURRENT_DATE() OR t.dtfine IS NULL))
      AND ((t.tpanag = :tpanag AND t.cdanag = :cdanag) OR t.cdanag = '' OR t.cdanag IS NULL OR t.cdanag = 0)
      GROUP BY t.cdprom
      ORDER BY t.seqapp DESC";
    $params = array('nuordc' => $nuordc, 'tpanag' => $tpanag, 'cdanag' => $cdanag);
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Pvtest object
   */
  public static function getPromo($cdprom) {
    $query = "SELECT p.cdprom, p.dsprom,
      p.dtiniz AS raw_dtiniz, DATE_FORMAT(p.dtiniz, '%d/%m/%Y') AS dtiniz,
      p.dtfine AS raw_dtfine, DATE_FORMAT(p.dtfine, '%d/%m/%Y') AS dtfine, p.flescl
      FROM Go2B\Models\Pvtest p";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
    return count($result) == 1 ? $result[0] : null;
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag) {
    $query = 'UPDATE pvtest p
      INNER JOIN anagra a ON a.tpanag = p.tpanag AND a.cdanag = p.cdanag
      SET p.tpanag = "CL", p.cdanag = :cdanag
      WHERE p.tpanag = "CN" AND p.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deletePromo($cdprom) {
    $query = "DELETE p.*
      FROM pvtest p
      WHERE p.cdprom = :cdprom";
    Di::getDefault()->get('db')->query($query, array('cdprom' => $cdprom));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE pvtest";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
