<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Pvnote extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdprom;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpnota;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $idlang;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $strdes;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('pvnote');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdprom' => isset($rec->cdprom) && (string)$rec->cdprom !== '' ? (string)$rec->cdprom : new RawValue('""'),
      'tpnote' => isset($rec->tpnote) && (string)$rec->tpnote !== '' ? (string)$rec->tpnote : new RawValue('""'),
      'idlang' => isset($rec->idlang) && (string)$rec->idlang !== '' ? (string)$rec->idlang : new RawValue('""'),
      'strdes' => isset($rec->strdes) && (string)$rec->strdes !== '' ? (string)$rec->strdes : new RawValue('""')
    );

    $query  = 'cdprom = :cdprom: AND tpnote = :tpnote: AND idlang = :idlang:';
    $params = array(
      'cdprom' => $values['cdprom'],
      'tpnote' => $values['tpnote'],
      'idlang' => $values['idlang']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE pvnote";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
