<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Pvgrup extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nurgrp;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdprom;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpinpu;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdtitl;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdserm;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpmode;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('pvgrup');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nurgrp' => isset($rec->nurgrp) && (string)$rec->nurgrp !== '' ? (string)$rec->nurgrp : 0,
      'cdprom' => isset($rec->cdprom) && (string)$rec->cdprom !== '' ? (string)$rec->cdprom : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'tpinpu' => isset($rec->tpinpu) && (string)$rec->tpinpu !== '' ? (string)$rec->tpinpu : new RawValue('""'),
      'cdtitl' => isset($rec->cdtitl) && (string)$rec->cdtitl !== '' ? (string)$rec->cdtitl : new RawValue('""'),
      'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
      'cdserm' => isset($rec->cdserm) && (string)$rec->cdserm !== '' ? (string)$rec->cdserm : new RawValue('""'),
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'tpmode' => isset($rec->tpmode) && (string)$rec->tpmode !== '' ? (string)$rec->tpmode : new RawValue('""')
    );

    $query  = 'nurgrp = :nurgrp:';
    $params = array(
      'nurgrp' => $values['nurgrp']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Pvgrup arrays
   */
  public static function getPromoGroups($cdprom) {
    $query = 'SELECT p.*
      FROM pvgrup p
      WHERE p.cdprom = :cdprom
      ORDER BY p.seqrap DESC';
    return Di::getDefault()->get('db')->query($query, array('cdprom' => $cdprom))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getMaxNurgrp() {
    $query = "SELECT MAX(p.nurgrp) AS nurgrp
      FROM Go2B\Models\Pvgrup p";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
    return count($result) == 1 ? $result[0]->nurgrp : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function insertNewPromoGroup($nurgrp, $cdprom, $tpinpu, $cdtitl, $cdlinm, $cdserm, $cdartn, $cdarti, $tpmode) {
    $params = array('nurgrp' => $nurgrp, 'cdprom' => $cdprom, 'tpinpu' => $tpinpu,
      'cdtitl' => $cdtitl, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm,
      'tpmode' => $tpmode, 'cdartn' => $cdartn, 'cdarti' => $cdarti
    );
    $query = 'INSERT INTO pvgrup (nurgrp, cdprom, seqrap, tpinpu, cdtitl,
      cdlinm, cdserm, cdartn, cdarti, tpmode)
      VALUES (:nurgrp, :cdprom, 0, :tpinpu, :cdtitl, :cdlinm, :cdserm,
      :cdartn, :cdarti, :tpmode);';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deletePromoGroups($cdprom) {
    $query = "DELETE p.*
      FROM pvgrup p
      WHERE p.cdprom = :cdprom";
    Di::getDefault()->get('db')->query($query, array('cdprom' => $cdprom));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE pvgrup";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
