<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Pvcorp extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nurpro;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdprom;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpinpu;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdtitl;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdserm;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpmode;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpvend;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmisu;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqsca;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valore;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $quanti;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtamin;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtamul;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $mintve;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $minmis;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $mincol;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $prezzo;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont1;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont2;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scont3;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $provvi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $preven;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $flqtfa;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $flcolo;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('pvcorp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nurpro' => isset($rec->nurpro) && (string)$rec->nurpro !== '' ? (string)$rec->nurpro : 0,
      'cdprom' => isset($rec->cdprom) && (string)$rec->cdprom !== '' ? (string)$rec->cdprom : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'tpinpu' => isset($rec->tpinpu) && (string)$rec->tpinpu !== '' ? (string)$rec->tpinpu : new RawValue('""'),
      'cdtitl' => isset($rec->cdtitl) && (string)$rec->cdtitl !== '' ? (string)$rec->cdtitl : new RawValue('""'),
      'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
      'cdserm' => isset($rec->cdserm) && (string)$rec->cdserm !== '' ? (string)$rec->cdserm : new RawValue('""'),
      'tpmode' => isset($rec->tpmode) && (string)$rec->tpmode !== '' ? (string)$rec->tpmode : new RawValue('""'),
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'tpvend' => isset($rec->tpvend) && (string)$rec->tpvend !== '' ? (string)$rec->tpvend : new RawValue('""'),
      'cdmisu' => isset($rec->cdmisu) && (string)$rec->cdmisu !== '' ? (string)$rec->cdmisu : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'seqsca' => isset($rec->seqsca) && (string)$rec->seqsca !== '' ? (string)$rec->seqsca : 0,
      'valore' => isset($rec->valore) && (string)$rec->valore !== '' ? (string)$rec->valore : 0,
      'quanti' => isset($rec->quanti) && (string)$rec->quanti !== '' ? (string)$rec->quanti : 0,
      'qtamin' => isset($rec->qtamin) && (string)$rec->qtamin !== '' ? (string)$rec->qtamin : 0,
      'qtamul' => isset($rec->qtamul) && (string)$rec->qtamul !== '' ? (string)$rec->qtamul : 0,
      'mintve' => isset($rec->mintve) && (string)$rec->mintve !== '' ? (string)$rec->mintve : 0,
      'minmis' => isset($rec->minmis) && (string)$rec->minmis !== '' ? (string)$rec->minmis : 0,
      'mincol' => isset($rec->mincol) && (string)$rec->mincol !== '' ? (string)$rec->mincol : 0,
      'prezzo' => isset($rec->prezzo) && (string)$rec->prezzo !== '' ? (string)$rec->prezzo : 0,
      'scont1' => isset($rec->scont1) && (string)$rec->scont1 !== '' ? (string)$rec->scont1 : 0,
      'scont2' => isset($rec->scont2) && (string)$rec->scont2 !== '' ? (string)$rec->scont2 : 0,
      'scont3' => isset($rec->scont3) && (string)$rec->scont3 !== '' ? (string)$rec->scont3 : 0,
      'provvi' => isset($rec->provvi) && (string)$rec->provvi !== '' ? (string)$rec->provvi : 0,
      'preven' => isset($rec->preven) && (string)$rec->preven !== '' ? (string)$rec->preven : 0,
      'flqtfa' => isset($rec->flqtfa) && (string)$rec->flqtfa !== '' ? (string)$rec->flqtfa : 0,
      'flcolo' => isset($rec->flcolo) && (string)$rec->flcolo !== '' ? (string)$rec->flcolo : 0
    );

    $query  = 'nurpro = :nurpro:';
    $params = array(
      'nurpro' => $values['nurpro']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Pvcorp objects
   */
  public static function getAllPromoDetailsForPromo($cdprom) {
    $query = 'SELECT c.*
      FROM Go2B\Models\Pvcorp c
      WHERE c.cdprom = :cdprom:
      ORDER BY c.seqsca ASC, c.seqrap ASC';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdprom' => $cdprom));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Pvcorp arrays
   */
  public static function getPromoDetails($cdprom) {
    $query = 'SELECT c.*
      FROM pvcorp c
      WHERE c.cdprom = :cdprom
      ORDER BY seqrap DESC, quanti ASC, valore ASC';
    return Di::getDefault()->get('db')->query($query, array('cdprom' => $cdprom))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Pvcorp arrays
   */
  public static function getPromoDetailsForFirstPromoStep($cdprom) {
    $query = 'SELECT c.*
      FROM pvcorp c
      WHERE c.cdprom = :cdprom
      AND c.seqsca = (SELECT MIN(cs.seqsca) FROM pvcorp cs)
      ORDER BY c.seqrap ASC';
    return Di::getDefault()->get('db')->query($query, array('cdprom' => $cdprom))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Pvcorp arrays
   */
  public static function getPromoDetailsForDNPromo($cdprom, $nuordc) {
    $query = "SELECT pc.seqrap, pc.tpinpu, pc.cdtitl, pc.cdlinm, pc.cdserm, pc.tpmode, pc.cdartn, pc.cdarti,
      GROUP_CONCAT(pc.scont1 ORDER BY pc.seqsca ASC SEPARATOR ';') AS scont1,
      GROUP_CONCAT(pc.scont2 ORDER BY pc.seqsca ASC SEPARATOR ';') AS scont2,
      GROUP_CONCAT(pc.scont3 ORDER BY pc.seqsca ASC SEPARATOR ';') AS scont3,
      GROUP_CONCAT(pc.prezzo ORDER BY pc.seqsca ASC SEPARATOR ';') AS prezzo,
      GROUP_CONCAT(pc.quanti ORDER BY pc.seqsca ASC SEPARATOR ';') AS quanti,
      GROUP_CONCAT(pc.valore ORDER BY pc.seqsca ASC SEPARATOR ';') AS valore,
      COALESCE(tl.code,lm.code,sm.code2,tm.code,tp.code,aa.code,'') AS cdinpu,
      COALESCE(tl.descri,lm.descri,sm.descri,tm.descri,tp.descri,aa.descri,'') AS dsinpu,
      COALESCE(tl.quanti,lm.quanti,sm.quanti,tm.quanti,tp.quanti,aa.quanti,0) AS ord_quanti,
      COALESCE(tl.valore,lm.valore,sm.valore,tm.valore,tp.valore,aa.valore,0) AS ord_valore
      FROM pvcorp pc
      LEFT JOIN (
        SELECT tl.cdtitl AS code, tl.dstitl AS descri, COALESCE(SUM(ot.quanti), 0) AS quanti, COALESCE(SUM(ot.prezzo * ot.quanti), 0) AS valore
        FROM anaart aa
        INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
        INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm
        INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
        LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
        GROUP BY code
      ) AS tl ON pc.cdtitl = tl.code AND pc.tpinpu = 'TL'
      LEFT JOIN (
        SELECT lm.cdlinm AS code, lm.dslinm AS descri, COALESCE(SUM(ot.quanti), 0) AS quanti, COALESCE(SUM(ot.prezzo * ot.quanti), 0) AS valore
        FROM anaart aa
        INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
        INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm
        LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
        LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
        GROUP BY code
      ) AS lm ON pc.cdlinm = lm.code AND pc.tpinpu = 'LI'
      LEFT JOIN (
        SELECT sm.cdlinm AS code1, sm.cdserm AS code2, sm.dsserm AS descri, COALESCE(SUM(ot.quanti), 0) AS quanti, COALESCE(SUM(ot.prezzo * ot.quanti), 0) AS valore
        FROM anaart aa
        INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
        INNER JOIN sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
        LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
        LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
        GROUP BY code1, code2
      ) AS sm ON pc.cdlinm = sm.code1 AND pc.cdserm = sm.code2 AND pc.tpinpu = 'SE'
      LEFT JOIN (
        SELECT tm.tpmode AS code, tm.dstmod AS descri, COALESCE(SUM(ot.quanti), 0) AS quanti, COALESCE(SUM(ot.prezzo * ot.quanti), 0) AS valore
        FROM anaart aa
        INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
        INNER JOIN tpmode tm ON tp.tpmode = tm.tpmode
        LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
        LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
        GROUP BY code
      ) AS tm ON pc.tpmode = tm.code AND pc.tpinpu = 'TM'
      LEFT JOIN (
        SELECT tp.cdartn AS code, tp.dsartn AS descri, COALESCE(SUM(ot.quanti), 0) AS quanti, COALESCE(SUM(ot.prezzo * ot.quanti), 0) AS valore
        FROM anaart aa
        INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
        LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
        LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
        GROUP BY code
      ) AS tp ON pc.cdartn = tp.code AND pc.tpinpu = 'AN'
      LEFT JOIN (
        SELECT aa.cdarti AS code, aa.dsarti AS descri, COALESCE(SUM(ot.quanti), 0) AS quanti, COALESCE(SUM(ot.prezzo * ot.quanti), 0) AS valore
        FROM anaart aa
        LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
        LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
        GROUP BY code
      ) AS aa ON pc.cdarti = aa.code AND pc.tpinpu = 'AR'
      WHERE pc.cdprom = :cdprom
      GROUP BY pc.seqrap
      ORDER BY pc.seqrap ASC, pc.seqsca ASC";
    return Di::getDefault()->get('db')->query($query, array('cdprom' => $cdprom, 'nuordc' => $nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getMaxNurpro() {
    $query = "SELECT MAX(p.nurpro) AS nurpro
      FROM Go2B\Models\Pvcorp p";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
    return count($result) == 1 ? $result[0]->nurpro : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function insertNewPromoDetail($nurpro, $cdprom, $seqrap, $tpinpu,
    $cdtitl, $cdlinm, $cdserm, $tpmode, $cdartn, $cdarti, $valore,
    $quanti, $prezzo, $scont1, $scont2, $scont3, $provvi, $preven) {
    $params = array('nurpro' => $nurpro, 'cdprom' => $cdprom,
      'seqrap' => $seqrap, 'tpinpu' => $tpinpu, 'cdtitl' => $cdtitl,
      'cdlinm' => $cdlinm, 'cdserm' => $cdserm, 'tpmode' => $tpmode,
      'cdartn' => $cdartn, 'cdarti' => $cdarti, 'valore' => $valore,
      'quanti' => $quanti, 'prezzo' => $prezzo, 'scont1' => $scont1,
      'scont2' => $scont2, 'scont3' => $scont3, 'provvi' => $provvi,
      'preven' => $preven
    );
    $query = 'INSERT INTO pvcorp (nurpro, cdprom, seqrap, tpinpu, cdtitl,
      cdlinm, cdserm, tpmode, cdartn, cdarti, tpvend, cdmisu, cdcolo, seqsca,
      valore, quanti, qtamin, qtamul, mintve, minmis, mincol, prezzo, scont1,
      scont2, scont3, provvi, preven, flqtfa, flcolo)
      VALUES (:nurpro, :cdprom, :seqrap, :tpinpu, :cdtitl, :cdlinm, :cdserm,
      :tpmode, :cdartn, :cdarti, "", "", "", 0, :valore, :quanti, 0, 0, 0, 0, 0,
      :prezzo, :scont1, :scont2, :scont3, :provvi, :preven);';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deletePromoDetails($cdprom) {
    $query = "DELETE p.*
      FROM pvcorp p
      WHERE p.cdprom = :cdprom";
    Di::getDefault()->get('db')->query($query, array('cdprom' => $cdprom));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE pvcorp";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
