<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Postgl extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdtagl;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $postgl;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $taglia;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('postgl');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdtagl' => isset($rec->cdtagl) && (string)$rec->cdtagl !== '' ? (string)$rec->cdtagl : new RawValue('""'),
      'postgl' => isset($rec->postgl) && (string)$rec->postgl !== '' ? (string)$rec->postgl : 0,
      'taglia' => isset($rec->taglia) && (string)$rec->taglia !== '' ? (string)$rec->taglia : new RawValue('""')
    );

    $query  = 'cdtagl = :cdtagl: AND postgl = :postgl:';
    $params = array(
      'cdtagl' => $values['cdtagl'],
      'postgl' => $values['postgl']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Postgl arrays
   */
  public static function getAllSizes($cdtagl) {
    $query = "SELECT p.cdtagl, p.postgl, p.taglia
      FROM postgl p
      WHERE p.cdtagl = :cdtagl
      ORDER BY p.postgl";
    $params = array('cdtagl' => $cdtagl);
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getAllArticleSizeCodesFromCatalog($cdcata, $items) {
    $params = array('cdcata' => $cdcata, 'tpdato' => 'des_' . strtolower($items['lang']));

    $innerJoinAnaper = '';
    $andWhere = '';
    if (isset($items['cdpers'])) {
      $params['cdpers'] = $items['cdpers'];
      $andWhere .= ' AND ap.cdpers = :cdpers: ';
      $innerJoinAnaper = 'INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers ';
    }

    $join = '';
    if ($items['from'] != 'all') {
      switch ($items['from']) {
        case 'sermod':
          $params['code1'] = $items['code1'];
          $params['code2'] = $items['code2'];
          $andWhere .= ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ';
          break;
        case 'linmod':
          $params['code'] = $items['code'];
          $andWhere .= ' AND tp.cdlinm = :code: ';
          break;
        case 'titlin':
          $params['code'] = $items['code'];
          $join = 'INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
                   INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl';
          $andWhere .= ' AND tl.cdtitl = :code: ';
          break;
      }
    }

    $query = "SELECT DISTINCT pt.taglia AS codice, COALESCE(ai.valore,pt.taglia) AS descri
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON pt.cdtagl = tp.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      $innerJoinAnaper
      $join
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'taglia' AND ai.codic1 = pt.taglia AND ai.codic2 = '' AND ai.tpdato = :tpdato:
      WHERE ca.cdcata = :cdcata:
      $andWhere
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY pt.taglia
      ORDER BY pt.taglia + 0, pt.cdtagl, pt.postgl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithPrices($cdtagl, $cdarti, $nulist) {
    $query = "SELECT DISTINCT p.postgl, p.taglia,
      COALESCE(l1.prezzo,l2.prezzo,'-') AS prezzo,
      COALESCE(l1.preven,l2.preven,'-') AS preven,
      COALESCE(l1.cdvalu,l2.cdvalu,(SELECT l3.cdvalu FROM Go2B\Models\Lstest l3 WHERE l3.nulist = :nulist:),' ') AS cdvalu
      FROM Go2B\Models\Postgl p
      LEFT JOIN Go2B\Models\Lscorp l1 ON p.taglia = l1.taglia AND l1.cdarti = :cdarti: AND l1.nulist = :nulist:
      LEFT JOIN Go2B\Models\Lscorp l2 ON l2.cdarti = :cdarti: AND l2.nulist = :nulist:
      WHERE p.cdtagl = :cdtagl:
      ORDER BY p.postgl";
    $params = array('cdtagl' => $cdtagl, 'cdarti' => $cdarti, 'nulist' => $nulist);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithPricesFromNurorc($nurorc) {
    $query = "SELECT DISTINCT p.postgl, p.taglia,
      COALESCE(l1.prezzo,l2.prezzo,'-') AS prezzo,
      COALESCE(l1.preven,l2.preven,'-') AS preven,
      COALESCE(l1.cdvalu,l2.cdvalu,(SELECT l3.cdvalu FROM Go2B\Models\Lstest l3 WHERE l3.nulist = ot.nulist),' ') AS cdvalu
      FROM Go2B\Models\Postgl p
      INNER JOIN Go2B\Models\Tipolo tp ON p.cdtagl = tp.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Occorp oc ON oc.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      LEFT JOIN Go2B\Models\Lscorp l1 ON p.taglia = l1.taglia AND l1.cdarti = oc.cdarti AND l1.nulist = ot.nulist
      LEFT JOIN Go2B\Models\Lscorp l2 ON l2.cdarti = oc.cdarti AND l2.nulist = ot.nulist
      WHERE oc.nurorc = :nurorc:
      GROUP BY p.postgl
      ORDER BY p.postgl";
    $params = array('nurorc' => $nurorc);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithPriceForSpecialXls($cdtagl, $cdarti, $nulist) {
    $query = "SELECT DISTINCT p.postgl, p.taglia,
      COALESCE(l1.prezzo,l2.prezzo,0) AS prezzo
      FROM Go2B\Models\Postgl p
      LEFT JOIN Go2B\Models\Lscorp l1 ON p.taglia = l1.taglia AND l1.cdarti = :cdarti: AND l1.nulist = :nulist:
      LEFT JOIN Go2B\Models\Lscorp l2 ON l2.cdarti = :cdarti: AND l2.nulist = :nulist:
      WHERE p.cdtagl = :cdtagl:
      ORDER BY p.postgl";
    $params = array('cdtagl' => $cdtagl, 'cdarti' => $cdarti, 'nulist' => $nulist);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithPricesFromArticleAndSizeCode($cdarti, $nulist, $cdtagl) {
    $query = "SELECT pt.cdtagl, pt.postgl, pt.taglia,
      COALESCE(l1.prezzo,l2.prezzo,0) AS prezzo,
      COALESCE(l1.cdvalu,l2.cdvalu,'EUR') AS cdvalu
      FROM Go2B\Models\Postgl pt
      LEFT JOIN Go2B\Models\Lscorp l1 ON l1.cdarti = :cdarti: AND l1.taglia = pt.taglia AND l1.nulist = :nulist:
      LEFT JOIN Go2B\Models\Lscorp l2 ON l2.cdarti = :cdarti: AND l2.taglia = '' AND l2.nulist = :nulist:
      WHERE pt.cdtagl = :cdtagl:
      ORDER BY pt.taglia ASC";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti, 'nulist' => $nulist, 'cdtagl' => $cdtagl));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesFromCdarti($cdarti) {
    $query = 'SELECT pt.taglia
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdtagl = pt.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      WHERE aa.cdarti = :cdarti: ';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesFromCdartiConfigurator($nupers) {
    $query = 'SELECT pt.taglia
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdtagl = pt.cdtagl
      INNER JOIN Go2B\Models\Ocpert p ON p.cdartn = tp.cdartn
      WHERE p.nupers = :nupers: ';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nupers' => $nupers));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithQuantityForArticle($nuordc, $cdartn, $cdarti, $cdcolo, $nulist) {
    $query = "SELECT pt.postgl, pt.taglia,
      COALESCE(lc.prezzo,0) AS prezzo,
      COALESCE(
        (SELECT og.quanti
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
        INNER JOIN Go2B\Models\Octest ot ON oc.nuordc = ot.nuordc
        WHERE ot.nuordc = :nuordc: AND og.dstagl = pt.taglia AND oc.cdarti = :cdarti: AND oc.cdcolo = :cdcolo:),0) AS quanti,
      COALESCE(r1.qtamin,r2.qtamin,r3.qtamin,r4.qtamin,r5.qtamin,r6.qtamin,1) AS qtamin,
      COALESCE(r1.qtamul,r2.qtamul,r3.qtamul,r4.qtamul,r5.qtamul,r6.qtamul,1) AS qtamul,
      COALESCE(r1.qtamax,r2.qtamax,r3.qtamax,r4.qtamax,r5.qtamax,r6.qtamax,0) AS qtamax
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdtagl = pt.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON aa.cdarti = lc.cdarti AND lc.nulist = :nulist: AND (lc.taglia = '' OR lc.taglia = pt.taglia)
      LEFT JOIN Go2B\Models\Regqta r1 ON r1.cdarti = aa.cdarti AND r1.cdcolo = :cdcolo: AND r1.taglia = pt.taglia
      LEFT JOIN Go2B\Models\Regqta r2 ON r2.cdarti = aa.cdarti AND r2.cdcolo = :cdcolo: AND r2.taglia = ''
      LEFT JOIN Go2B\Models\Regqta r3 ON r3.cdarti = aa.cdarti AND r3.cdcolo = '' AND r3.taglia = pt.taglia
      LEFT JOIN Go2B\Models\Regqta r4 ON r4.cdarti = aa.cdarti AND r4.cdcolo = '' AND r4.taglia = ''
      LEFT JOIN Go2B\Models\Regqta r5 ON r5.cdartn = :cdartn: AND r5.taglia = pt.taglia
      LEFT JOIN Go2B\Models\Regqta r6 ON r6.cdartn = :cdartn: AND r6.taglia = ''
      WHERE aa.cdarti = :cdarti:
      ORDER BY pt.postgl ASC";

    $params = array('cdarti' => $cdarti, 'cdartn' => $cdartn, 'cdcolo' => $cdcolo, 'nuordc' => $nuordc, 'nulist' => $nulist);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithQuantityForFabricWizard($cdartn, $cdarti, $nulist) {
    $query = "SELECT pt.postgl, pt.taglia, COALESCE(lc.prezzo,0) AS prezzo,
      COALESCE(r5.qtamin,r6.qtamin,1) AS qtamin, COALESCE(r5.qtamul,r6.qtamul,1) AS qtamul,
      COALESCE(r5.qtamax,r6.qtamax,0) AS qtamax, COALESCE(r5.flbloc,r6.flbloc,0) AS flbloc
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdtagl = pt.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON aa.cdarti = lc.cdarti AND lc.nulist = :nulist: AND (lc.taglia = '' OR lc.taglia = pt.taglia)
      LEFT JOIN Go2B\Models\Regqta r5 ON r5.cdartn = :cdartn: AND r5.taglia = pt.taglia
      LEFT JOIN Go2B\Models\Regqta r6 ON r6.cdartn = :cdartn: AND r6.taglia = ''
      WHERE aa.cdarti = :cdarti:
      ORDER BY pt.postgl ASC";

    $params = array('cdarti' => $cdarti, 'cdartn' => $cdartn, 'nulist' => $nulist);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithQuantityForArticleWizard($nuordc, $cdartn, $cdarti, $nulist, $withQuantity = true) {
    $params = array('cdarti' => $cdarti, 'cdartn' => $cdartn, 'nulist' => $nulist);
    if ($withQuantity) {
      $params['nuordc'] = $nuordc;
      $quanti = 'COALESCE(ot.quanti,0) AS quanti';
      $leftJoin = "LEFT JOIN Go2B\Models\Occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc:
                   LEFT JOIN Go2B\Models\Octagl ot ON oc.nurorc = ot.nurorc AND pt.taglia = ot.dstagl";
    } else {
      $leftJoin = '';
      $quanti = '0 AS quanti';
    }

    $query = "SELECT pt.postgl, pt.taglia, COALESCE(lc.prezzo,0) AS prezzo,
      COALESCE(r5.qtamin,r6.qtamin,1) AS qtamin, COALESCE(r5.qtamul,r6.qtamul,1) AS qtamul,
      COALESCE(r5.qtamax,r6.qtamax,0) AS qtamax, COALESCE(r5.flbloc,r6.flbloc,0) AS flbloc, $quanti
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdtagl = pt.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      $leftJoin
      LEFT JOIN Go2B\Models\Lscorp lc ON aa.cdarti = lc.cdarti AND lc.nulist = :nulist: AND (lc.taglia = '' OR lc.taglia = pt.taglia)
      LEFT JOIN Go2B\Models\Regqta r5 ON r5.cdartn = :cdartn: AND r5.taglia = pt.taglia
      LEFT JOIN Go2B\Models\Regqta r6 ON r6.cdartn = :cdartn: AND r6.taglia = ''
      WHERE aa.cdarti = :cdarti:
      ORDER BY pt.postgl ASC";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getSizesWithQuantityForConfiguratorWizard($nuordc, $cdartn, $cdarti) {
    $query = "SELECT pt.postgl, pt.taglia,
      COALESCE(r5.qtamin,r6.qtamin,1) AS qtamin, COALESCE(r5.qtamul,r6.qtamul,1) AS qtamul,
      COALESCE(r5.qtamax,r6.qtamax,0) AS qtamax, COALESCE(r5.flbloc,r6.flbloc,0) AS flbloc,
      COALESCE((SELECT ot.quanti
        FROM Go2B\Models\Octagl ot
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = ot.nurorc
        WHERE oc.cdarti = :cdarti: AND oc.nuordc = :nuordc: AND ot.dstagl = pt.taglia),0) AS quanti
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdtagl = pt.cdtagl
      LEFT JOIN Go2B\Models\Regqta r5 ON r5.cdartn = :cdartn: AND r5.taglia = pt.taglia
      LEFT JOIN Go2B\Models\Regqta r6 ON r6.cdartn = :cdartn: AND r6.taglia = ''
      WHERE tp.cdartn = :cdartn:
      ORDER BY pt.postgl ASC";

    $params = array('nuordc' => $nuordc, 'cdartn' => $cdartn, 'cdarti' => $cdarti);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getAllSizesFromCdtagl($cdtagl) {
    $query = "SELECT pt.postgl, pt.taglia
      FROM Go2B\Models\Postgl pt
      WHERE pt.cdtagl = :cdtagl:
      ORDER BY pt.postgl ASC";
    $params = array('cdtagl' => $cdtagl);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl objects
   */
  public static function getAllSizesWithAvailabilityForArticle($cdarti) {
    $query = "SELECT pt.postgl, pt.taglia, COALESCE(dc.quanti,0) AS quanti
      FROM Go2B\Models\Postgl pt
      INNER JOIN Go2B\Models\Tipolo tp ON pt.cdtagl = tp.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Dscorp dc ON dc.cdarti = aa.cdarti AND dc.taglia = pt.taglia
      WHERE aa.cdarti = :cdarti:
      ORDER BY pt.postgl ASC";
    $params = array('cdarti' => $cdarti);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl arrays
   */
  public static function getAllSizesFromCatalog($cdcata) {
    $query =
      "SELECT DISTINCT IF(
          (SELECT COUNT(p1.taglia)
          FROM postgl p1
          WHERE p1.taglia NOT REGEXP '^[0-9]+[\\.\\,]?[0-9]*$' AND p1.taglia = pt.taglia) >
          (SELECT COUNT(p2.taglia)
          FROM postgl p2
          WHERE p2.taglia REGEXP '^[0-9]+[\\.\\,]?[0-9]*$' AND p2.taglia = pt.taglia),
          CONCAT('text', pt.taglia), pt.taglia) AS sortable, pt.taglia
        FROM ctarti ca
        INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
        INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
        LEFT JOIN b2b_tipval ba ON ba.cdartn = tp.cdartn
        WHERE ca.cdcata = :cdcata
        AND tp.flbloc = 0 AND aa.flbloc = 0
        AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
        ORDER BY sortable + 0, pt.cdtagl, pt.postgl ";
    return Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl arrays
   */
  public static function getAllSizesForPdf($cdcata, $articles) {
    $params = array('cdcata' => $cdcata);
    $where = '';
    $i = 0;
    foreach ($articles as $article) {
      $where .= ':cdarti' . $i . ',';
      $params['cdarti' . $i] = $article->cdarti;
      $i++;
    }
    $where = $where != '' ? ' AND ca.cdarti IN (' . substr($where,0,-1) . ')' : '';
    $query =
      "SELECT DISTINCT IF(
        (SELECT COUNT(p1.taglia)
        FROM postgl p1
        WHERE p1.taglia NOT REGEXP '^[0-9]+[\\.\\,]?[0-9]*$' AND p1.taglia = pt.taglia) >
        (SELECT COUNT(p2.taglia)
        FROM postgl p2
        WHERE p2.taglia REGEXP '^[0-9]+[\\.\\,]?[0-9]*$' AND p2.taglia = pt.taglia),
        CONCAT('text', pt.taglia), pt.taglia) AS sortable, pt.taglia
      FROM ctarti ca
      INNER JOIN anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
      WHERE ca.cdcata = :cdcata
      $where
      ORDER BY sortable + 0, pt.cdtagl, pt.postgl ";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl arrays
   */
  public static function getAllSizesFromOrder($nuordc) {
    $regexp = " '^[0-9]+[\\.\\,]?[0-9]*$' ";
    $query =
      "SELECT DISTINCT IF(
        (SELECT COUNT(p1.taglia)
        FROM postgl p1
        WHERE p1.taglia NOT REGEXP $regexp AND p1.cdtagl = pt.cdtagl) > 0,
        CONCAT('text', pt.taglia), pt.taglia) AS sortable, pt.taglia
      FROM occorp oc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
      WHERE oc.nuordc = :nuordc
      ORDER BY sortable + 0, pt.cdtagl, pt.postgl ";
    /*  "SELECT DISTINCT IF(
        (SELECT COUNT(p1.taglia)
        FROM postgl p1
        WHERE p1.taglia NOT REGEXP '^[0-9]+[\\.\\,]?[0-9]*$' AND p1.taglia = pt.taglia) >
        (SELECT COUNT(p2.taglia)
        FROM postgl p2
        WHERE p2.taglia REGEXP '^[0-9]+[\\.\\,]?[0-9]*$' AND p2.taglia = pt.taglia),
        CONCAT('text', pt.taglia), pt.taglia) AS sortable, pt.taglia
      FROM occorp oc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
      WHERE oc.nuordc = :nuordc
      ORDER BY sortable + 0, pt.cdtagl, pt.postgl ";*/
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Postgl arrays
   */
  public static function getAllSizesFromConfiguratorOrder($nuordc) {
    $regexp = " '^[0-9]+[\\.\\,]?[0-9]*$' ";
    $query =
      "SELECT DISTINCT IF(
        (SELECT COUNT(p1.taglia)
        FROM postgl p1
        WHERE p1.taglia NOT REGEXP $regexp AND p1.cdtagl = pt.cdtagl) > 0,
        CONCAT('text', pt.taglia), pt.taglia) AS sortable, pt.taglia, pt.cdtagl, pt.postgl
      FROM occorp oc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
      WHERE oc.nuordc = :nuordc AND oc.cdcolo != 'CUSTOM'
      UNION
      SELECT DISTINCT IF(
        (SELECT COUNT(p1.taglia)
        FROM postgl p1
        WHERE p1.taglia NOT REGEXP $regexp AND p1.cdtagl = pt.cdtagl) > 0,
        CONCAT('text', pt.taglia), pt.taglia) AS sortable, pt.taglia, pt.cdtagl, pt.postgl
      FROM occorp oc2
      INNER JOIN ocpert pe ON pe.nuordc = oc2.nuordc AND pe.nupers = oc2.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = pe.cdartn
      INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
      WHERE oc2.nuordc = :nuordc AND oc2.cdcolo = 'CUSTOM'
      ORDER BY sortable + 0, cdtagl, postgl ";
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc))->fetchAll();
  }
  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateSize($cdtagl, $postgl, $new_pos, $dstagl, $new_ds) {
    $query1 = "UPDATE Go2B\Models\Postgl pt INNER JOIN Tipolo tp ON pt.cdtagl = tp.cdtagl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Lscorp ls ON ls.cdarti = aa.cdarti AND ls.taglia = pt.taglia
      SET pt.postgl = :pos, pt.taglia = :size, ls.taglia = :size
      WHERE pt.cdtagl = :cdtagl AND pt.postgl = :postgl";

    $query2 = "UPDATE Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      SET og.dstagl = :size
      WHERE tp.cdtagl = :cdtagl AND og.dstagl = :dstagl";

    Di::getDefault()->get('db')->query($query1, array('cdtagl' => $cdtagl, 'postgl' => $postgl, 'pos' => $new_pos, 'size' => $new_ds));
    Di::getDefault()->get('db')->query($query2, array('cdtagl' => $cdtagl, 'dstagl' => $dstagl, 'size' => $new_ds));
  }
  //endregion
}
