<?php

namespace Go2B\Models;

use Go2B\Controllers\Utility;
use Go2B\Library\Environment;
use Go2B\Plugins\Nav\ApiKOC;
use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Octest extends Model
{
  const ORDER_STATUS_OPEN = 0;
  const ORDER_STATUS_NOT_SEND = 1;
  const ORDER_STATUS_SENT = 2;
  const ORDER_STATUS_ACCEPTED = 3;
  const ORDER_STATUS_REJECTED = 4;
  const ORDER_STATUS_WAITING = 5;
  const ORDER_STATUS_CUSTOMER_CONFIRM = 6;

  /* 0 = cart / open -- 1° step
   * 1 = not sent / provisional -- 2° step (if quantity > 0)
   * 2 = sent -- 4° step
   * 3 = accepted -- 5° step (if accepted)
   * 4 = rejected -- 5° step (if rejected)
   * 5 = waiting for quantity (provisional with all zero quantities) -- 2° step (if quantity == 0)
   * 6 = customer confirm (customer can't modify order anymore) -- 3° step (if present)
   */

  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuordc;

  /**
   * @var string
   */
  protected $codice_ordine;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id_usr;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cddesm;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $nulist;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  /* 0 = availability
   * 1 = reservation
   */
  public $tpordc;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=true)
   */
  /* 0 = availability
   * 1 = reservation
   */
  public $cdtipord;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=true)
   */
  public $tppaga;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=true)
   */
  public $tpport;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=true)
   */
  public $tpindo;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=true)
   */
  public $cdetic;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtcrea;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtmcli;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtinvi;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  /* 0 = cart / open -- 1° step
   * 1 = not sent / provisional -- 2° step (if quantity > 0)
   * 2 = sent -- 4° step
   * 3 = accepted -- 5° step (if accepted)
   * 4 = rejected -- 5° step (if rejected)
   * 5 = waiting for quantity (provisional with all zero quantities) -- 2° step (if quantity == 0)
   * 6 = customer confirm (customer can't modify order anymore) -- 3° step (if present)
   */
  public $flstat;

  /**
   *
   * @var string
   * @Column(type="string", length=200, nullable=true)
   */
  public $notcli;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=true)
   */
  public $nuordn;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtordn;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=true)
   */
  public $cdvett;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=true)
   */
  public $cdcoup;

  /**
   *
   * @var string
   * @Column(type="string", length=200, nullable=true)
   */
  public $notazi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtmcoi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtmcof;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flnosc;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize()
  {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
    $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('octest');

    // Relazione OneToOne con Usrage (o Usrusr)
    $this->hasOne(
      'id_usr',
      B2bUsrage::class,
      'id_usr',
      [
        'alias' => 'agente',
        'reusable' => true,
      ]
    );
  }

  /**
   * Allows to query the first order in progress for current user
   *
   * @param mixed $parameters
   * @return Octest
   */
  public static function findOrderInProgress($id_usr)
  {
    return parent::findFirst(array('id_usr = :id_usr: AND flstat = 0', 'bind' => array('id_usr' => $id_usr)));
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg)
  {
    $values = array(
      'nuordc' => isset($rec->nuordc) && (string)$rec->nuordc !== '' ? (string)$rec->nuordc : 0,
      'flstat' => isset($rec->flstat) && (string)$rec->flstat !== '' ? (string)$rec->flstat : 4
    );

    $query  = 'nuordc = :nuordc:';
    $params = array(
      'nuordc' => $values['nuordc']
    );

    // Always "upd"
    if ($row = self::findFirst(array($query, 'bind' => $params))) {
      $values['cddesm'] = !empty($values['cddesm']) ? $values['cddesm'] : (!empty($row->cddesm) ? $row->cddesm : new RawValue('""'));
      $row->save($values);
    }
  }
  //endregion

  //region Aux functions
  /**
   * Return "order by" clause from parameter
   */
  private static function getOrderBy($ordering)
  {
    switch ($ordering) {
      case 0:
        return 'ORDER BY oc.cdarti, oc.seqdet ';
      case 1:
        return 'ORDER BY oc.seqrap ';
      case 2:
        return 'ORDER BY oc.seqrap DESC ';
    }
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Octest arrays
   */
  public static function getAllOrdersCreatedByAgent($id_usr, $cdagen)
  {
      $identificativiClienti = Anaage::getAvailableCustomerAndDestinationCodeListForCdagen($cdagen);

    // agent -- get all orders created from agent (read + write)
    $query = "SELECT " . self::getParamToColumnNuordc() . ", ot.tpanag, ot.cdanag, DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea, COALESCE(ag.descri,'') AS descri1, ot.nulist,
      ot.cdcata, COALESCE(ag.descri,'') AS descri2, ot.tpordc, ot.flstat, ot.flnosc,
      COALESCE((SELECT COUNT(oc.nurorc) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS num_rows,
      COALESCE((SELECT SUM(oc.quanti) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS tot_qty,
      (
          SELECT COALESCE(SUM(b2boa.addval), 0)
            FROM Go2B\Models\B2bOrdadd b2boa
            WHERE b2boa.nuordc = ot.nuordc
      ) + (
          COALESCE((SELECT SUM(
            og.quanti *
            IF(COALESCE(op.prezzo, 0) > 0, op.prezzo, og.prezzo) *
            IF(
              ot.flnosc = 1,
              1,
              (1 - og.scont1 / 100) * (1 - COALESCE(op.scont1,0) / 100) * (1 - COALESCE(op.scont2,0) / 100) * (1 - COALESCE(op.scont3,0) / 100)
            ))
            FROM Go2B\Models\Octagl og
            INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
            LEFT JOIN Go2B\Models\Ocproc op ON op.nuordc = oc.nuordc AND op.cdarti = oc.cdarti
            WHERE oc.nuordc = ot.nuordc), 0)
      ) AS tot_prc,
      'all' AS chmod, 'true' AS is_available,
      COALESCE(ag.scont1,0) AS anagra_scont1, COALESCE(ag.scont2,0) AS anagra_scont2,
      COALESCE(ag.scont3,0) AS anagra_scont3, ot.tpport, ot.tppaga,
      CONCAT(ct.cdstag,' ', ct.cdtitl) as cdtitl, IF(age.id_usr IS NULL,'CL','AG') AS owner_order,IF(age.id_usr IS NULL,CONCAT(ag.tpanag, '-', ag.cdanag), age.cdagen) AS owner_code, usr.username AS owner_name, ot.cdtipord
      FROM Go2B\Models\Octest ot
      LEFT JOIN Go2B\Models\Anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag
      INNER JOIN GO2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      INNER JOIN GO2B\Models\B2bSysusr usr ON usr.id = ot.id_usr 
      LEFT JOIN GO2B\Models\B2bUsrage age ON age.id_usr = ot.id_usr 
      LEFT JOIN GO2B\Models\B2bUsrana ana ON ana.id_usr = ot.id_usr 
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND (
            ot.id_usr = :id_usr: 
            OR ot.id_usr IN ( SELECT bua.id_usr FROM GO2B\Models\B2bUsrage bua WHERE bua.cdagen = :cdagen: )
            OR ( 
                ana.id_usr IS NOT NULL 
                AND (ot.cddesm = '' OR CONCAT(ot.tpanag, '-', ot.cddesm) IN ('" . implode("','", $identificativiClienti[Ageana::TIPDAT_DESTINATION]) . "'))
                AND (CONCAT(ot.tpanag, '-', ot.cdanag) IN ('" . implode("','", $identificativiClienti[Ageana::TIPDAT_CUSTOMER]) . "'))
            )
      )
      ORDER BY ot.nuordc";

    return Di::getDefault()->get('modelsManager')
        ->executeQuery($query, [
            'id_usr' => $id_usr,
            'cdagen' => $cdagen,
        ])
        ->toArray();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getAllOrdersCreatedByAgentForCustomer($tpanag, $cdanag)
  {
    // customer -- get all orders created from agents (only read)
    $query = "SELECT " . self::getParamToColumnNuordc() . ", ot.tpanag, ot.cdanag, DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea, COALESCE(ag.descri,'') AS descri1, ot.nulist,
      ot.cdcata, COALESCE(aa.dsagen,'') AS descri2, ot.tpordc, ot.flstat, ot.flnosc,
      COALESCE((SELECT COUNT(oc.nurorc) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS num_rows,
      COALESCE((SELECT SUM(oc.quanti) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS tot_qty,
      (
          SELECT COALESCE(SUM(b2boa.addval), 0)
            FROM Go2B\Models\B2bOrdadd b2boa
            WHERE b2boa.nuordc = ot.nuordc
      ) + (
          COALESCE((SELECT SUM(
            og.quanti *
            IF(COALESCE(op.prezzo, 0) > 0, op.prezzo, og.prezzo) *
            IF(
              ot.flnosc = 1,
              1,
              (1 - og.scont1 / 100) * (1 - COALESCE(op.scont1,0) / 100) * (1 - COALESCE(op.scont2,0) / 100) * (1 - COALESCE(op.scont3,0) / 100)
            ))
            FROM Go2B\Models\Octagl og
            INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
            LEFT JOIN Go2B\Models\Ocproc op ON op.nuordc = oc.nuordc AND op.cdarti = oc.cdarti
            WHERE oc.nuordc = ot.nuordc),0)
      ) AS tot_prc,
      'read' AS chmod, 'true' AS is_available,
      COALESCE(ag.scont1,0) AS anagra_scont1, COALESCE(ag.scont2,0) AS anagra_scont2,
      COALESCE(ag.scont3,0) AS anagra_scont3, ot.tpport, ot.tppaga,
      CONCAT(ct.cdstag,' ', ct.cdtitl) as cdtitl, 'AG' AS owner_order, aa.cdagen AS owner_code, 
      usr.username AS owner_name, ot.cdtipord
      FROM Go2B\Models\Octest ot
      INNER JOIN GO2B\Models\B2bSysusr usr ON usr.id = ot.id_usr 
      INNER JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = ot.id_usr
      LEFT JOIN Go2B\Models\Anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag
      LEFT JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen
      INNER JOIN GO2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      WHERE ot.tpanag = :tpanag: AND ot.cdanag = :cdanag: AND ot.flstat != 0 AND ot.flstat != 4
      ORDER BY ot.nuordc";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getAllOrdersCreatedByDestinationForCustomer($tpanag, $cdanag)
  {
    // customer -- get all orders created from destinations (only read)
    $query = "SELECT " . self::getParamToColumnNuordc() . ", ot.tpanag, ot.cdanag, DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea, COALESCE(ag.descri,'') AS descri1, ot.nulist,
      ot.cdcata, COALESCE(dm.desvid,'') AS descri2, ot.tpordc, ot.flstat, ot.flnosc,
      COALESCE((SELECT COUNT(oc.nurorc) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS num_rows,
      COALESCE((SELECT SUM(oc.quanti) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS tot_qty,
      (
          SELECT COALESCE(SUM(b2boa.addval), 0)
            FROM Go2B\Models\B2bOrdadd b2boa
            WHERE b2boa.nuordc = ot.nuordc
      ) + (
          COALESCE((SELECT SUM(
            og.quanti *
            IF(
              ot.flnosc = 1,
              1,
              IF(COALESCE(op.prezzo, 0) > 0, op.prezzo, og.prezzo) *
              (1 - og.scont1 / 100) * (1 - COALESCE(op.scont1,0) / 100) * (1 - COALESCE(op.scont2,0) / 100) * (1 - COALESCE(op.scont3,0) / 100)
            ))
            FROM Go2B\Models\Octagl og
            INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
            LEFT JOIN Go2B\Models\Ocproc op ON op.nuordc = oc.nuordc AND op.cdarti = oc.cdarti
            WHERE oc.nuordc = ot.nuordc),0)
      ) AS tot_prc,
      'read' AS chmod, 'true' AS is_available,
      COALESCE(ag.scont1,0) AS anagra_scont1, COALESCE(ag.scont2,0) AS anagra_scont2,
      COALESCE(ag.scont3,0) AS anagra_scont3, ot.tpport, ot.tppaga,
      CONCAT(ct.cdstag,' ', ct.cdtitl) as cdtitl, IF(age.id_usr IS NULL,'CL','AG') AS owner_order, IF(age.id_usr IS NULL,CONCAT(ag.tpanag, '-', ag.cdanag), age.cdagen) AS owner_code, usr.username AS owner_name, ot.cdtipord
      FROM Go2B\Models\Octest ot
      INNER JOIN GO2B\Models\B2bSysusr usr ON usr.id = ot.id_usr 
      INNER JOIN Go2B\Models\B2bUsrdsm ud ON ud.id_usr = ot.id_usr
      INNER JOIN GO2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      LEFT JOIN Go2B\Models\Anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag
      LEFT JOIN Go2B\Models\Desmer dm ON dm.tpanag = ag.tpanag AND dm.cddesm = ud.cddesm AND dm.cdanag = ag.cdanag
      LEFT JOIN GO2B\Models\B2busrage age ON age.id_usr = ot.id_usr 
      LEFT JOIN GO2B\Models\B2busrana ana ON ana.id_usr = ot.id_usr 
      WHERE ot.tpanag = :tpanag: AND ot.cdanag = :cdanag: AND ot.flstat != 0 AND ot.flstat != 4
      ORDER BY ot.nuordc";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getAllOrdersCreatedByCustomer($id_usr)
  {
    // customer -- get all orders created from himself (read + write)
    $query = "SELECT " . self::getParamToColumnNuordc() . ", ot.tpanag, ot.cdanag, DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea, COALESCE(ag.descri,'') AS descri1, ot.nulist,
      ot.cdcata, COALESCE(ag.descri,'') AS descri2, ot.tpordc, ot.flstat, ot.flnosc,
      COALESCE((SELECT COUNT(oc.nurorc) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS num_rows,
      COALESCE((SELECT SUM(oc.quanti) FROM Go2B\Models\Occorp oc WHERE oc.nuordc = ot.nuordc),0) AS tot_qty,
      (
          SELECT COALESCE(SUM(b2boa.addval), 0)
            FROM Go2B\Models\B2bOrdadd b2boa
            WHERE b2boa.nuordc = ot.nuordc
      ) + (
          COALESCE((SELECT SUM(
            og.quanti *
            IF(COALESCE(op.prezzo, 0) > 0, op.prezzo, og.prezzo) *
            IF(
              ot.flnosc = 1,
              1,
              IF(
                og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
                (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
                (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
              ))
            )
            FROM Go2B\Models\Octagl og
            INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
            LEFT JOIN Go2B\Models\Ocproc op ON op.nuordc = oc.nuordc AND op.cdarti = oc.cdarti
            WHERE oc.nuordc = ot.nuordc),0)
      ) AS tot_prc,
      'all' AS chmod, 'true' AS is_available,
      COALESCE(ag.scont1,0) AS anagra_scont1, COALESCE(ag.scont2,0) AS anagra_scont2,
      COALESCE(ag.scont3,0) AS anagra_scont3, ot.tpport, ot.tppaga,
      CONCAT(ct.cdstag,' ', ct.cdtitl) as cdtitl, 'CL' AS owner_order, CONCAT(ag.tpanag, '-', ag.cdanag) AS owner_code, usr.username AS owner_name, ot.cdtipord
      FROM Go2B\Models\Octest ot
      INNER JOIN GO2B\Models\B2bSysusr usr ON usr.id = ot.id_usr 
      LEFT JOIN Go2B\Models\Anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag
      INNER JOIN GO2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      WHERE ot.id_usr = :id_usr: AND ot.flstat != 0 AND ot.flstat != 4
      ORDER BY ot.nuordc";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getFilteredOrders($isPeriod, $dtiniz, $dtfine, $isAgent, $whoseSet, $whichSeason, $status, $types, $prices, $withBlocks = false)
  {
    // Period or latest orders
    if ($isPeriod) {
      $andWherePeriod = ' AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine: ';
      $limit  = '';
      $params = array(
        'dtiniz' => $dtiniz,
        'dtfine' => $dtfine
      );
    } else {
      $andWherePeriod = '';
      $limit  = ' LIMIT 100 ';
      $params = array();
    }

    // With blocks?
    if ($withBlocks) {
      $blocks =
        ", COALESCE((SELECT COUNT(c.nurorc) > 0
          FROM Go2B\Models\Occorp c
          INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
          WHERE c.nuordc = ot.nuordc AND a.tpvend = 'CUSTOM'),false) AS variant_block ";
    } else {
      $blocks = ', 0 AS variant_block';
    }

    // Whose
    if ($isAgent) {
      $selectFieldsAgent = ' aa.cdagen, aa.dsagen, ';
      $joinAgent =
        ' LEFT JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = ot.id_usr
        LEFT JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen ';
      if ($whoseSet == '-1') {
        $andWhereWhose = ' AND aa.cdagen != "" ';
      } else {
        $agents = explode(',', $whoseSet);
        $i = 0;
        foreach ($agents as $el) {
          $agentsConditions[] = ' aa.cdagen = :cdagen' . $i . ': ';
          $params['cdagen' . $i] = $el;
          $i++;
        }
        $andWhereWhose = count($agentsConditions) > 0 ? implode(" OR ", $agentsConditions) : '';
        $andWhereWhose = $andWhereWhose != '' ? "AND ($andWhereWhose)" : '';
      }
    } else {
      $selectFieldsAgent = ' COALESCE(aa.cdagen,"") AS cdagen, COALESCE(aa.dsagen,"") AS dsagen, ';
      $joinAgent =
        ' LEFT JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = ot.id_usr
        LEFT JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen ';
      if ($whoseSet == '-1') {
        $andWhereWhose = '';
      } else {
        $customers = explode(',', $whoseSet);
        $i = 0;
        foreach ($customers as $el) {
          $customersConditions[] = ' ot.cdanag = :cdanag' . $i . ': ';
          $params['cdanag' . $i] = $el;
          $i++;
        }
        $andWhereWhose = count($customersConditions) > 0 ? implode(" OR ", $customersConditions) : '';
        $andWhereWhose = $andWhereWhose != '' ? "AND ($andWhereWhose)" : '';
      }
    }

    // Seasons
    if ($whichSeason != '-1') {
      $seasons = explode(',', $whichSeason);
      $i = 0;
      foreach ($seasons as $el) {
        $seasonsConditions[] = ' ot.cdstag = :cdstag' . $i . ': ';
        $params['cdstag' . $i] = $el;
        $i++;
      }
      $andWhereWhichSeason = count($seasonsConditions) > 0 ? implode(" OR ", $seasonsConditions) : '';
      $andWhereWhichSeason = $andWhereWhichSeason != '' ? "AND ($andWhereWhichSeason)" : '';
    } else {
      $andWhereWhichSeason = '';
    }

    // Status conditions
    $statusConditions = array();
    if (!empty($status)) {
      foreach ($status as $el) {
        $statusConditions[] = ' ot.flstat = :flstat' . $el . ': ';
        $params['flstat' . $el] = $el;
      }
    }
    $andWhereStatus = count($statusConditions) > 0 ? implode(" OR ", $statusConditions) : '';
    $andWhereStatus = $andWhereStatus != '' ? "AND ($andWhereStatus)" : '';

    // Types conditions
    $typesConditions = array();
    if (!empty($types)) {
      foreach ($types as $el) {
        $el = $el == 'ava' ? 0 : 1;
        $typesConditions[] = ' ot.tpordc = :tpordc' . $el . ': ';
        $params['tpordc' . $el] = $el;
      }
    }
    $andWhereTypes = count($typesConditions) > 0 ? implode(" OR ", $typesConditions) : '';
    $andWhereTypes = $andWhereTypes != '' ? "AND ($andWhereTypes)" : '';

    // Prices conditions
    $havingPrices = '';
    if (!empty($prices)) {
      $havingPrices = 'HAVING ';
      for ($i = 0; $i < count($prices); $i++) {
        if ($prices[$i] == 'Y') {
          $havingPrices .= ($i > 0 ? ' OR ' : '') . ' noprice = 0 ';
        } else if ($prices[$i] == 'N') {
          $havingPrices .= ($i > 0 ? ' OR ' : '') . ' noprice = 1 ';
        }
      }
    }

    $query = "SELECT ot.nuordc, COALESCE(bu.username,'') AS username,
      $selectFieldsAgent
      ag.descri, ot.cdcata, COALESCE(ct.dscata, '') AS dscata,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea,
      DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi,
      DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtinvi, '%d/%m/%Y') AS dtinvi,
      (SELECT COUNT(oc.nurorc) > 0
        FROM Go2B\Models\Occorp oc
        INNER JOIN Go2B\Models\Octagl og ON og.nurorc = oc.nurorc
        WHERE oc.nuordc = ot.nuordc AND og.prezzo = 0) AS noprice,
      (SELECT SUM(oc.quanti)
        FROM Go2B\Models\Occorp oc
        WHERE oc.nuordc = ot.nuordc) AS quanti,
      (SELECT SUM(og.quanti * og.prezzo *
        IF(ot.flnosc = 1,
          1,
          IF(
            og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
            (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
            (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
          ))
        )
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
        WHERE oc.nuordc = ot.nuordc) AS valore,
      COALESCE(lt.cdvalu, 'EUR') AS cdvalu, ot.tpanag, ot.cdanag, ot.flstat, ot.flnosc $blocks
      FROM Go2B\Models\Octest ot
      LEFT JOIN Go2B\Models\B2bSysusr bu ON bu.id = ot.id_usr
      $joinAgent
      INNER JOIN Go2B\Models\Anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
      LEFT JOIN Go2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      LEFT JOIN Go2B\Models\Lstest lt ON lt.nulist = ot.nulist
      WHERE ot.flstat != 0 AND ot.flstat != 4
      $andWherePeriod
      $andWhereWhose
      $andWhereWhichSeason
      $andWhereStatus
      $andWhereTypes
      $havingPrices
      ORDER BY ot.nuordc DESC
      $limit";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getClosedOrders($id_usr)
  {
    $query = "SELECT o.nuordc, DATE_FORMAT(o.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(o.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(o.dtmcof, '%d/%m/%Y') AS dtmcof,
      COALESCE(a.descri,'') AS descri, COALESCE(c.dscata,'') AS dscata
      FROM Go2B\Models\Octest o
      LEFT JOIN Go2B\Models\Anagra a ON a.tpanag = o.tpanag AND a.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Cttest c ON c.cdcata = o.cdcata
      WHERE o.id_usr = :id_usr: AND o.flstat != 0 AND o.flstat != 4
      ORDER BY o.nuordc DESC";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getAllOpenOrders()
  {
    $query = "SELECT ot.nuordc, COALESCE(bu.username,'') AS username, COALESCE(aa.cdagen, '') AS cdagen,
      COALESCE(aa.dsagen, '') AS dsagen, ag.descri, ot.cdcata, COALESCE(ct.dscata, '') AS dscata,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea,
      DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi,
      DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtinvi, '%d/%m/%Y') AS dtinvi,
      (SELECT SUM(oc.quanti)
        FROM Go2B\Models\Occorp oc
        WHERE oc.nuordc = ot.nuordc) AS quanti,
      (SELECT SUM(og.quanti * og.prezzo *
        IF(
          og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
          (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
          (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
        ))
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
        WHERE oc.nuordc = ot.nuordc) AS valore,
      lt.cdvalu, ot.tpanag, ot.cdanag, ot.flstat
      FROM Go2B\Models\Octest ot
      LEFT JOIN Go2B\Models\B2bSysusr bu ON bu.id = ot.id_usr
      LEFT JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = ot.id_usr
      LEFT JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen
      INNER JOIN Go2B\Models\Anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
      LEFT JOIN Go2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      INNER JOIN Go2B\Models\Lstest lt ON lt.nulist = ot.nulist
      WHERE ot.flstat = 0
      ORDER BY ot.dtcrea DESC, ot.nuordc DESC ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getLatest10Orders()
  {
    $query = "SELECT ot.nuordc, COALESCE(aa.cdagen, '') AS cdagen,
      COALESCE(aa.dsagen, '') AS dsagen, ag.descri, ot.cdcata, COALESCE(ct.dscata, '') AS dscata,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea,
      DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi,
      DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtinvi, '%d/%m/%Y') AS dtinvi,
      (SELECT SUM(oc.quanti)
        FROM Go2B\Models\Occorp oc
        WHERE oc.nuordc = ot.nuordc) AS quanti,
      (SELECT SUM(og.quanti * og.prezzo *
        IF(
          og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
          (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
          (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
        ))
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
        WHERE oc.nuordc = ot.nuordc) AS valore,
      COALESCE(ag.scont1,0) AS anagra_scont1, COALESCE(ag.scont2,0) AS anagra_scont2,
      COALESCE(ag.scont3,0) AS anagra_scont3,
      lt.cdvalu, ot.tpanag, ot.cdanag, ot.flstat
      FROM Go2B\Models\Octest ot
      LEFT JOIN Go2B\Models\B2bSysusr bu ON bu.id = ot.id_usr
      LEFT JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = ot.id_usr
      LEFT JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen
      INNER JOIN Go2B\Models\Anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
      LEFT JOIN Go2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      INNER JOIN Go2B\Models\Lstest lt ON lt.nulist = ot.nulist
      WHERE ot.flstat != 0 AND ot.flstat != 4
      ORDER BY ot.nuordc DESC, ot.nuordc DESC
      LIMIT 10";

    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest objects
   */
  public static function getLatest10OpenOrders()
  {
    $query = "SELECT ot.nuordc, COALESCE(aa.cdagen, '') AS cdagen,
      COALESCE(aa.dsagen, '') AS dsagen, ag.descri, ot.cdcata, COALESCE(ct.dscata, '') AS dscata,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea,
      DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi,
      DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtinvi, '%d/%m/%Y') AS dtinvi,
      (SELECT SUM(oc.quanti)
        FROM Go2B\Models\Occorp oc
        WHERE oc.nuordc = ot.nuordc) AS quanti,
      (SELECT SUM(og.quanti * og.prezzo *
        IF(
          og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
          (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
          (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
        ))
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
        WHERE oc.nuordc = ot.nuordc) AS valore,
      COALESCE(ag.scont1,0) AS anagra_scont1, COALESCE(ag.scont2,0) AS anagra_scont2,
      COALESCE(ag.scont3,0) AS anagra_scont3,
      lt.cdvalu, ot.tpanag, ot.cdanag, ot.flstat
      FROM Go2B\Models\Octest ot
      LEFT JOIN Go2B\Models\B2bSysusr bu ON bu.id = ot.id_usr
      LEFT JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = ot.id_usr
      LEFT JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen
      INNER JOIN Go2B\Models\Anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
      LEFT JOIN Go2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      INNER JOIN Go2B\Models\Lstest lt ON lt.nulist = ot.nulist
      WHERE ot.flstat = 0
      ORDER BY ot.dtcrea DESC, ot.nuordc DESC
      LIMIT 10";

    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest arrays
   */
  public static function getPaymentOrderInfo($nuordc, $idlang = 'IT')
  {
    if ($idlang != 'IT') {
      $params = array('nuordc' => $nuordc, 'idlang' => $idlang);
      $dspaga = "COALESCE(c.dspaga,d1.descri,t.dspaga,'') AS dspaga";
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dspaga' AND d1.codic1 = t.tppaga AND d1.idlang = :idlang ";
    } else {
      $params = array('nuordc' => $nuordc);
      $dspaga = "COALESCE(c.dspaga, t.dspaga,'') AS dspaga";
      //$dspaga = "COALESCE(c.dspaga,t.dspaga,'') AS dspaga";
      $lnJoin = '';
    }

    /*   $query = "SELECT COALESCE(c.numpag, 0) AS id, o.tppaga, $dspaga, COALESCE(c.valmin,0) AS valmin,
      COALESCE(c.valmax,0) AS valmax, COALESCE(oc.addval,COALESCE(c.preagg,0)) AS preagg
      FROM octest o
      LEFT JOIN b2b_cuspag c ON c.tppaga = o.tppaga AND
        (c.cdnazi = (SELECT d.cdnazi FROM desmer d WHERE d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag LIMIT 1) OR
         c.cdnazi = (SELECT a.cdnazi FROM anagra a WHERE a.tpanag = o.tpanag AND a.cdanag = o.cdanag LIMIT 1) OR
         c.cdnazi = 'ALL')
      LEFT JOIN tppaga t ON t.tppaga = o.tppaga
      LEFT JOIN b2b_ordadd oc ON oc.nuordc = o.nuordc AND oc.addfld = :fieldCustomPaga
      $lnJoin
      WHERE o.nuordc = :nuordc ";
    $params['fieldCustomPaga'] = B2bOrdadd::SPESA_AGGIUNTIVA_PAGAMENTO;

 */
    $query = "SELECT COALESCE(oc.id,0) AS id , o.tppaga, $dspaga, 0 as valmin, 99999 as valmax, COALESCE(oc.addval,0) AS preagg
    FROM octest o
    LEFT JOIN b2b_cuspag c ON
     (
        c.tppaga = o.tppaga AND
        (
          c.cdnazi = 'ALL' OR
          c.cdnazi = (SELECT d.cdnazi FROM desmer d WHERE d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag LIMIT 1) OR
          c.cdnazi = (SELECT a.cdnazi FROM anagra a WHERE a.tpanag = o.tpanag AND a.cdanag = o.cdanag LIMIT 1)
        )
      )
    LEFT JOIN tppaga t ON t.tppaga = o.tppaga
    LEFT JOIN b2b_ordadd oc ON oc.nuordc = o.nuordc AND oc.addfld = :fieldCustomPaga
    $lnJoin
    WHERE o.nuordc = :nuordc LIMIT 1";
    $params['fieldCustomPaga'] = B2bOrdadd::SPESA_AGGIUNTIVA_PAGAMENTO;

    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest arrays
   */
  public static function getShipmentOrderInfo($nuordc, $idlang = 'IT')
  {
    if ($idlang != 'IT') {
      $params = array('nuordc' => $nuordc, 'idlang' => $idlang);
      $dstpor = "COALESCE(d1.descri,t.dstpor,'') AS dstpor";
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = t.tpport AND d1.idlang = :idlang ";
    } else {
      $params = array('nuordc' => $nuordc);
      $dstpor = "COALESCE(c.dstpor,t.dstpor,'') AS dstpor";
      //      $dstpor = "COALESCE(t.dstpor,'') AS dstpor";l
      $lnJoin = '';
    }

    //  -- COALESCE(c.dsvett,'') AS dsvett
    /*    $query = "SELECT COALESCE(c.numpor, 0) AS id, o.tpport, $dstpor, COALESCE(c.valmin,0) AS valmin, COALESCE(c.valmax,0) AS valmax,
       COALESCE(oc.addval,COALESCE(c.preagg,0)) AS preagg, COALESCE(occ.addval,COALESCE(c.contra,'')) AS contra
      FROM octest o
      LEFT JOIN b2b_cuspor c ON c.tpport = o.tpport AND
        (c.cdnazi = (SELECT d.cdnazi FROM desmer d WHERE d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag LIMIT 1) OR
        c.cdnazi = (SELECT a.cdnazi FROM anagra a WHERE a.tpanag = o.tpanag AND a.cdanag = o.cdanag LIMIT 1) OR
        c.cdnazi = 'ALL')
      LEFT JOIN tpport t ON t.tpport = o.tpport
      LEFT JOIN b2b_ordadd oc ON oc.nuordc = o.nuordc AND oc.addfld = :fieldCustomPort
      LEFT JOIN b2b_ordadd occ ON occ.nuordc = o.nuordc AND occ.addfld = :fieldCustomContra
      $lnJoin
      WHERE o.nuordc = :nuordc ";*/

    $query = "SELECT COALESCE(oc.id, 0) AS id, o.tpport, $dstpor, 0 AS valmin, 99999 AS valmax, COALESCE(oc.addval,0) AS preagg, COALESCE(occ.addval,'') AS contra
      FROM octest o
      LEFT JOIN b2b_cuspor c ON 
      (
        c.tpport = o.tpport AND
        (
          c.cdnazi = 'ALL' OR
          c.cdnazi = (SELECT d.cdnazi FROM desmer d WHERE d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag LIMIT 1) OR
          c.cdnazi = (SELECT a.cdnazi FROM anagra a WHERE a.tpanag = o.tpanag AND a.cdanag = o.cdanag LIMIT 1)
        )
      )
      LEFT JOIN tpport t ON t.tpport = o.tpport
      LEFT JOIN b2b_ordadd oc ON oc.nuordc = o.nuordc AND oc.addfld = :fieldCustomPort
      LEFT JOIN b2b_ordadd occ ON occ.nuordc = o.nuordc AND occ.addfld = :fieldCustomContra
      $lnJoin
      WHERE o.nuordc = :nuordc LIMIT 1"; // Aggiunto LIMIT 1 per evitare che ci si più di un elemento su ordini già confermati

    $params['fieldCustomPort'] = B2bOrdadd::SPESA_AGGIUNTIVA_SPEDIZIONE;
    $params['fieldCustomContra'] = B2bOrdadd::SPESA_AGGIUNTIVA_CONTRASSEGNO;

    //      echo($query);
    //      var_dump($params);
    //      exit();
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  public function getAdditionalPayments()
  {
    return B2bOrdadd::find(['conditions' => 'nuordc = :nuordc:', 'bind' => ['nuordc' => $this->nuordc]]);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest arrays
   */
  public static function getOrderForLardiniCsv($nuordc, $ordering)
  {
    $orderBy = self::getOrderBy($ordering);
    $query = "SELECT tp.cdstag, tp.cdlinm, tp.cdartn, oc.cdvari, ag.cdanag,
      ag.desvid, ag.cdagen, ot.nuordc, DATE_FORMAT(ot.dtcrea,'%d%m%y') AS dtcrea,
      oc.cdarti, aa.cdpers, oc.cdcolo,
      COALESCE(b2bcp.additional_code,'') AS addvar,
      COALESCE(og1.quanti,0) AS tg1, COALESCE(og2.quanti,0) AS tg2,
      COALESCE(og3.quanti,0) AS tg3, COALESCE(og4.quanti,0) AS tg4,
      COALESCE(og5.quanti,0) AS tg5, COALESCE(og6.quanti,0) AS tg6,
      COALESCE(og7.quanti,0) AS tg7, COALESCE(og8.quanti,0) AS tg8,
      COALESCE(og9.quanti,0) AS tg9, COALESCE(og10.quanti,0) AS tg10,
      COALESCE((
        (COALESCE(og1.quanti,0) * COALESCE(og1.prezzo,0) * (1 - (COALESCE(og1.scont1,0) / 100)) * (1 - (COALESCE(og1.scont2,0) / 100)) * (1 - (COALESCE(og1.scont3,0) / 100))) +
        (COALESCE(og2.quanti,0) * COALESCE(og2.prezzo,0) * (1 - (COALESCE(og2.scont1,0) / 100)) * (1 - (COALESCE(og2.scont2,0) / 100)) * (1 - (COALESCE(og2.scont3,0) / 100))) +
        (COALESCE(og3.quanti,0) * COALESCE(og3.prezzo,0) * (1 - (COALESCE(og3.scont1,0) / 100)) * (1 - (COALESCE(og3.scont2,0) / 100)) * (1 - (COALESCE(og3.scont3,0) / 100))) +
        (COALESCE(og4.quanti,0) * COALESCE(og4.prezzo,0) * (1 - (COALESCE(og4.scont1,0) / 100)) * (1 - (COALESCE(og4.scont2,0) / 100)) * (1 - (COALESCE(og4.scont3,0) / 100))) +
        (COALESCE(og5.quanti,0) * COALESCE(og5.prezzo,0) * (1 - (COALESCE(og5.scont1,0) / 100)) * (1 - (COALESCE(og5.scont2,0) / 100)) * (1 - (COALESCE(og5.scont3,0) / 100))) +
        (COALESCE(og6.quanti,0) * COALESCE(og6.prezzo,0) * (1 - (COALESCE(og6.scont1,0) / 100)) * (1 - (COALESCE(og6.scont2,0) / 100)) * (1 - (COALESCE(og6.scont3,0) / 100))) +
        (COALESCE(og7.quanti,0) * COALESCE(og7.prezzo,0) * (1 - (COALESCE(og7.scont1,0) / 100)) * (1 - (COALESCE(og7.scont2,0) / 100)) * (1 - (COALESCE(og7.scont3,0) / 100))) +
        (COALESCE(og8.quanti,0) * COALESCE(og8.prezzo,0) * (1 - (COALESCE(og8.scont1,0) / 100)) * (1 - (COALESCE(og8.scont2,0) / 100)) * (1 - (COALESCE(og8.scont3,0) / 100))) +
        (COALESCE(og9.quanti,0) * COALESCE(og9.prezzo,0) * (1 - (COALESCE(og9.scont1,0) / 100)) * (1 - (COALESCE(og9.scont2,0) / 100)) * (1 - (COALESCE(og9.scont3,0) / 100))) +
        (COALESCE(og10.quanti,0) * COALESCE(og10.prezzo,0) * (1 - (COALESCE(og10.scont1,0) / 100)) * (1 - (COALESCE(og10.scont2,0) / 100)) * (1 - (COALESCE(og10.scont3,0) / 100)))
      ) * 100,0) AS prezzo,
      COALESCE(ai.valore,DATE_FORMAT(oc.dtmcli,'%d%m%y')) AS dtmcli, ot.notcli, ot.tppaga,
      oc.cddesm, COALESCE(dm.indiri,'') AS indiri, COALESCE(dm.ccitta,'') AS ccitta,
      COALESCE(dm.codcap,'') AS codcap, COALESCE(dd2.valore,'') AS cddrop
      FROM octest ot
      INNER JOIN occorp oc ON oc.nuordc = ot.nuordc
      INNER JOIN anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN b2b_cusper b2bcp ON aa.cdpers = b2bcp.cdpers
      LEFT JOIN b2b_addinf ai ON ai.tabell = 'anaart' AND ai.codic1 = aa.cdarti AND ai.tpdato = 'dtmcli'
      LEFT JOIN b2b_addinf dd2 ON dd2.tabell = 'anaper' AND dd2.codic1 = aa.cdpers AND dd2.tpdato = 'cddrop'
      LEFT JOIN desmer dm ON ot.tpanag = dm.tpanag AND oc.cddesm = dm.cddesm AND ot.cdanag = dm.cdanag
      LEFT JOIN postgl pt1 ON pt1.cdtagl = tp.cdtagl AND pt1.postgl = 1
      LEFT JOIN octagl og1 ON og1.nurorc = oc.nurorc AND og1.dstagl = pt1.taglia
      LEFT JOIN postgl pt2 ON pt2.cdtagl = tp.cdtagl AND pt2.postgl = 2
      LEFT JOIN octagl og2 ON og2.nurorc = oc.nurorc AND og2.dstagl = pt2.taglia
      LEFT JOIN postgl pt3 ON pt3.cdtagl = tp.cdtagl AND pt3.postgl = 3
      LEFT JOIN octagl og3 ON og3.nurorc = oc.nurorc AND og3.dstagl = pt3.taglia
      LEFT JOIN postgl pt4 ON pt4.cdtagl = tp.cdtagl AND pt4.postgl = 4
      LEFT JOIN octagl og4 ON og4.nurorc = oc.nurorc AND og4.dstagl = pt4.taglia
      LEFT JOIN postgl pt5 ON pt5.cdtagl = tp.cdtagl AND pt5.postgl = 5
      LEFT JOIN octagl og5 ON og5.nurorc = oc.nurorc AND og5.dstagl = pt5.taglia
      LEFT JOIN postgl pt6 ON pt6.cdtagl = tp.cdtagl AND pt6.postgl = 6
      LEFT JOIN octagl og6 ON og6.nurorc = oc.nurorc AND og6.dstagl = pt6.taglia
      LEFT JOIN postgl pt7 ON pt7.cdtagl = tp.cdtagl AND pt7.postgl = 7
      LEFT JOIN octagl og7 ON og7.nurorc = oc.nurorc AND og7.dstagl = pt7.taglia
      LEFT JOIN postgl pt8 ON pt8.cdtagl = tp.cdtagl AND pt8.postgl = 8
      LEFT JOIN octagl og8 ON og8.nurorc = oc.nurorc AND og8.dstagl = pt8.taglia
      LEFT JOIN postgl pt9 ON pt9.cdtagl = tp.cdtagl AND pt9.postgl = 9
      LEFT JOIN octagl og9 ON og9.nurorc = oc.nurorc AND og9.dstagl = pt9.taglia
      LEFT JOIN postgl pt10 ON pt10.cdtagl = tp.cdtagl AND pt10.postgl = 10
      LEFT JOIN octagl og10 ON og10.nurorc = oc.nurorc AND og10.dstagl = pt10.taglia
      WHERE ot.nuordc = :nuordc
      GROUP BY oc.nurorc
      $orderBy ";
    // ORDER BY cddrop, oc.cddesm, tp.cdlinm, oc.seqrap, oc.nurorc";
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Octest arrays
   */
  public static function getOrderForZanottiCsv($nuordc)
  {
    $query = "SELECT
	    ot.cdanag AS 'cod_cli',
      CONCAT(ot.nuordc, '_', IF(COALESCE(ac.valore, 0) = 0, 1, 2)) AS 'rif_ord_ext',
	    COALESCE(SUBSTRING(ct.cdstag FROM 1 FOR 4), '0000') AS 'cod_stagione',
	    COALESCE(CONCAT('C', SUBSTRING(ct.cdstag FROM 2 FOR 3)), 'C000') AS 'cod_stagione_co',
	    ot.tpindo AS 'classe_oc',
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS 'data_ord',
	    DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS 'data_ult_cons',
	    DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS 'data_prima_cons',
	    ot.tppaga AS 'cod_pag',
	    ot.nulist AS 'cod_listino',
	    LEFT(ot.cddesm,LOCATE('-',ot.cddesm)-1) AS 'cod_destinaz_div',
	    ar.cdartn AS 'cod_art',
	    IF(ot.cdcata = 'OLD', '', ar.cdcolo) AS 'var_art',
	    IFNULL(p1.valore,'') AS 'bolla',
	    IFNULL(p2.valore,'') AS 'forma',
	    IFNULL(p3.valore,'') AS 'suola',
	    IFNULL(p4.valore,'') AS 'tacco',
	    IFNULL(p5.valore,'') AS 'tomaia',
      IFNULL(p6.valore,'') AS 'accessori',
	    IFNULL(p7.valore,'') AS 'fodera',
	    IF(ot.cdcata = 'OLD', ar.cdcolo, IFNULL(p8.valore,'')) AS 'note',
	    IFNULL(q01.quanti,'0') as 'size01',
	    IFNULL(
        (SELECT q02.quanti
        FROM octagl q02
        INNER JOIN postgl t02 ON q02.dstagl = t02.taglia
        WHERE q02.nurorc = oc.nurorc AND t02.cdtagl = tp.cdtagl AND t02.postgl = 2),'0') as 'size02',
	    IFNULL(
        (SELECT q03.quanti
        FROM octagl q03
        INNER JOIN postgl t03 ON q03.dstagl = t03.taglia
        WHERE q03.nurorc = oc.nurorc AND t03.cdtagl = tp.cdtagl AND t03.postgl = 3),'0') as 'size03',
	    IFNULL(
        (SELECT q04.quanti
        FROM octagl q04
        INNER JOIN postgl t04 ON q04.dstagl = t04.taglia
        WHERE q04.nurorc = oc.nurorc AND t04.cdtagl = tp.cdtagl AND t04.postgl = 4),'0') as 'size04',
	    IFNULL(
        (SELECT q05.quanti
        FROM octagl q05
        INNER JOIN postgl t05 ON q05.dstagl = t05.taglia
        WHERE q05.nurorc = oc.nurorc AND t05.cdtagl = tp.cdtagl AND t05.postgl = 5),'0') as 'size05',
	    IFNULL(
        (SELECT q06.quanti
        FROM octagl q06
        INNER JOIN postgl t06 ON q06.dstagl = t06.taglia
        WHERE q06.nurorc = oc.nurorc AND t06.cdtagl = tp.cdtagl AND t06.postgl = 6),'0') as 'size06',
	    IFNULL(
        (SELECT q07.quanti
        FROM octagl q07
        INNER JOIN postgl t07 ON q07.dstagl = t07.taglia
        WHERE q07.nurorc = oc.nurorc AND t07.cdtagl = tp.cdtagl AND t07.postgl = 7),'0') as 'size07',
	    IFNULL(
        (SELECT q08.quanti
        FROM octagl q08
        INNER JOIN postgl t08 ON q08.dstagl = t08.taglia
        WHERE q08.nurorc = oc.nurorc AND t08.cdtagl = tp.cdtagl AND t08.postgl = 8),'0') as 'size08',
	    IFNULL(
        (SELECT q09.quanti
        FROM octagl q09
        INNER JOIN postgl t09 ON q09.dstagl = t09.taglia
        WHERE q09.nurorc = oc.nurorc AND t09.cdtagl = tp.cdtagl AND t09.postgl = 9),'0') as 'size09',
	    IFNULL(
        (SELECT q10.quanti
        FROM octagl q10
        INNER JOIN postgl t10 ON q10.dstagl = t10.taglia
        WHERE q10.nurorc = oc.nurorc AND t10.cdtagl = tp.cdtagl AND t10.postgl = 10),'0') as 'size10',
	    IFNULL(
        (SELECT q11.quanti
        FROM octagl q11
        INNER JOIN postgl t11 ON q11.dstagl = t11.taglia
        WHERE q11.nurorc = oc.nurorc AND t11.cdtagl = tp.cdtagl AND t11.postgl = 11),'0') as 'size11',
	    IFNULL(
        (SELECT q12.quanti
        FROM octagl q12
        INNER JOIN postgl t12 ON q12.dstagl = t12.taglia
        WHERE q12.nurorc = oc.nurorc AND t12.cdtagl = tp.cdtagl AND t12.postgl = 12),'0') as 'size12',
	    IFNULL(
        (SELECT q13.quanti
        FROM octagl q13
        INNER JOIN postgl t13 ON q13.dstagl = t13.taglia
        WHERE q13.nurorc = oc.nurorc AND t13.cdtagl = tp.cdtagl AND t13.postgl = 13),'0') as 'size13',
	    IFNULL(
        (SELECT q14.quanti
        FROM octagl q14
        INNER JOIN postgl t14 ON q14.dstagl = t14.taglia
        WHERE q14.nurorc = oc.nurorc AND t14.cdtagl = tp.cdtagl AND t14.postgl = 14),'0') as 'size14',
	    IFNULL(
        (SELECT q15.quanti
        FROM octagl q15
        INNER JOIN postgl t15 ON q15.dstagl = t15.taglia
        WHERE q15.nurorc = oc.nurorc AND t15.cdtagl = tp.cdtagl AND t15.postgl = 15),'0') as 'size15',
	    IFNULL(
        (SELECT q16.quanti
        FROM octagl q16
        INNER JOIN postgl t16 ON q16.dstagl = t16.taglia
        WHERE q16.nurorc = oc.nurorc AND t16.cdtagl = tp.cdtagl AND t16.postgl = 16),'0') as 'size16',
	    IFNULL(
        (SELECT q17.quanti
        FROM octagl q17
        INNER JOIN postgl t17 ON q17.dstagl = t17.taglia
        WHERE q17.nurorc = oc.nurorc AND t17.cdtagl = tp.cdtagl AND t17.postgl = 17),'0') as 'size17',
	    IFNULL(
        (SELECT q18.quanti
        FROM octagl q18
        INNER JOIN postgl t18 ON q18.dstagl = t18.taglia
        WHERE q18.nurorc = oc.nurorc AND t18.cdtagl = tp.cdtagl AND t18.postgl = 18),'0') as 'size18',
	    IFNULL(
        (SELECT q19.quanti
        FROM octagl q19
        INNER JOIN postgl t19 ON q19.dstagl = t19.taglia
        WHERE q19.nurorc = oc.nurorc AND t19.cdtagl = tp.cdtagl AND t19.postgl = 19),'0') as 'size19',
	    IFNULL(
        (SELECT q20.quanti
        FROM octagl q20
        INNER JOIN postgl t20 ON q20.dstagl = t20.taglia
        WHERE q20.nurorc = oc.nurorc AND t20.cdtagl = tp.cdtagl AND t20.postgl = 20),'0') as 'size20',
	    IFNULL(
        (SELECT q21.quanti
        FROM octagl q21
        INNER JOIN postgl t21 ON q21.dstagl = t21.taglia
        WHERE q21.nurorc = oc.nurorc AND t21.cdtagl = tp.cdtagl AND t21.postgl = 21),'0') as 'size21',
	    IFNULL(
        (SELECT q22.quanti
        FROM octagl q22
        INNER JOIN postgl t22 ON q22.dstagl = t22.taglia
        WHERE q22.nurorc = oc.nurorc AND t22.cdtagl = tp.cdtagl AND t22.postgl = 22),'0') as 'size22',
	    IFNULL(
        (SELECT q23.quanti
        FROM octagl q23
        INNER JOIN postgl t23 ON q23.dstagl = t23.taglia
        WHERE q23.nurorc = oc.nurorc AND t23.cdtagl = tp.cdtagl AND t23.postgl = 23),'0') as 'size23',
	    IFNULL(
        (SELECT q24.quanti
        FROM octagl q24
        INNER JOIN postgl t24 ON q24.dstagl = t24.taglia
        WHERE q24.nurorc = oc.nurorc AND t24.cdtagl = tp.cdtagl AND t24.postgl = 24),'0') as 'size24',
	    oc.quanti AS 'tot_pairs',
	    REPLACE(q01.prezzo, '.', ',') AS 'prezzo_unit',
      IF(
        ot.flnosc = 1,
        0,
        REPLACE(ROUND(
          (100 * (1 - (q01.prezzo *
            IF(
             q01.scont1 > 0 OR q01.scont2 > 0 OR q01.scont3 > 0,
             (1 - (q01.scont1 / 100)) * (1 - (q01.scont2 / 100)) * (1 - (q01.scont3 / 100)),
             (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
            )) / q01.prezzo)), 2), '.', ',')
      ) AS 'perc_sconto',
	    IFNULL(ot.notcli,'') AS 'note_ordine',
      COALESCE(ac.valore, 0) AS availability
      FROM octest ot
      INNER JOIN anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
	    INNER JOIN cttest ct ON ct.cdcata = ot.cdcata
	    INNER JOIN occorp oc ON oc.nuordc = ot.nuordc
	    INNER JOIN anaart ar ON ar.cdarti = oc.cdarti
	    INNER JOIN tipolo tp ON tp.cdartn = ar.cdartn
	    LEFT JOIN sparti p1 ON p1.cdarti = oc.cdarti AND p1.tpcomp = 'BOLLA'
	    LEFT JOIN sparti p2 ON p2.cdarti = oc.cdarti AND p2.tpcomp = 'FORMA'
	    LEFT JOIN sparti p3 ON p3.cdarti = oc.cdarti AND p3.tpcomp = 'SUOLA'
	    LEFT JOIN sparti p4 ON p4.cdarti = oc.cdarti AND p4.tpcomp = 'TACCO'
	    LEFT JOIN sparti p5 ON p5.cdarti = oc.cdarti AND p5.tpcomp = 'TOMAIA'
	    LEFT JOIN sparti p6 ON p6.cdarti = oc.cdarti AND p6.tpcomp = 'ACCESSORI'
	    LEFT JOIN sparti p7 ON p7.cdarti = oc.cdarti AND p7.tpcomp = 'FODERA'
	    LEFT JOIN sparti p8 ON p8.cdarti = oc.cdarti AND p8.tpcomp = 'NOTE'
	    LEFT JOIN postgl t01 ON t01.cdtagl = tp.cdtagl AND t01.postgl = 1
	    LEFT JOIN octagl q01 ON q01.nurorc = oc.nurorc AND q01.dstagl = t01.taglia
      LEFT JOIN artcla ac ON ac.tpinpu = 'AR' AND ac.codice = ar.cdarti AND ac.tpclas = 'DISP'
      WHERE ot.nuordc = :nuordc
      GROUP BY oc.nurorc
      ORDER BY oc.seqrap";
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Octest object
   */
  public static function getOrderForDetailFromNuordc($nuordc)
  {
    $query = "SELECT o.tpanag, o.cdanag, a.descri AS dsanag,
      o.cdcata, COALESCE(ct.dscata,'') AS dscata,
      a.indiri AS indiri_a, a.ccitta AS ccitta_a, a.provin AS provin_a, COALESCE(n1.dsnazi,'') AS dsnazi_a,
      o.cddesm, COALESCE(d.desvid,'') AS dsdesm,
      COALESCE(d.indiri,'') AS indiri_d, COALESCE(d.ccitta,'') AS ccitta_d, COALESCE(d.provin,'') AS provin_d, COALESCE(n2.dsnazi,'') AS dsnazi_d,
      COALESCE(b.indema,a.indema,'') AS indema, COALESCE(b.conrif,'') AS conrif,
      o.nulist, COALESCE(l.dslist,'') AS dslist, COALESCE(l.cdvalu,'EUR') AS cdvalu,
      o.tpordc, o.cdetic, COALESCE(e.dsetic,'') AS dsetic, o.nuordc,
      DATE_FORMAT(o.dtcrea, '%d/%m/%Y') AS dtcrea, DATE_FORMAT(o.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(o.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(o.dtmcof, '%d/%m/%Y') AS dtmcof,
      o.dtmcli AS dtmcli_n, o.dtmcoi AS dtmcoi_n, o.dtmcof AS dtmcof_n,
      o.tpindo, o.cdcoup, o.notazi, o.notcli, o.flstat, o.flnosc,
      o.tppaga, COALESCE(tg.dspaga,'') AS dspaga, o.tpport, COALESCE(tr.dstpor,'') AS dstpor,
      COALESCE(c.dscoup,'') AS dscoup, COALESCE(c.tpcoup,-1) AS tpcoup, COALESCE(c.impsco,-1) AS impsco,
      COALESCE(i.dsaiva,'') AS dsaiva, COALESCE(i.aliquo,0) AS aliquo,
      COALESCE(a.scont1,0) AS anagra_scont1, COALESCE(a.scont2,0) AS anagra_scont2,
      COALESCE(a.scont3,0) AS anagra_scont3,
      (SELECT COUNT(oc.nurorc)
        FROM Go2B\Models\Occorp oc
        WHERE oc.nuordc = :nuordc:) AS rows,
      (SELECT SUM(oc.quanti)
        FROM Go2B\Models\Occorp oc
        WHERE oc.nuordc = :nuordc:) AS quanti,
      (SELECT SUM(og.quanti * og.prezzo)
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
        WHERE oc.nuordc = :nuordc:) AS implor,
      (SELECT SUM(og.quanti * og.prezzo *
          IF(
            o.flnosc = 1,
            1,
            IF(
              og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
              (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
              (1 - (a.scont1 / 100)) * (1 - (a.scont2 / 100)) * (1 - (a.scont3 / 100))
            )
          )
        )
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
        WHERE oc.nuordc = :nuordc:) AS impnet
      FROM Go2B\Models\Octest o
      LEFT JOIN Go2B\Models\Cttest ct ON o.cdcata = ct.cdcata
      LEFT JOIN Go2B\Models\Anagra a ON a.tpanag = o.tpanag AND a.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Desmer d ON d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Ananaz n1 ON a.cdnazi = n1.cdnazi
      LEFT JOIN Go2B\Models\Ananaz n2 ON d.cdnazi = n2.cdnazi
      LEFT JOIN Go2B\Models\Anaeti e ON e.cdetic = o.cdetic
      LEFT JOIN Go2B\Models\B2bCoupon c ON c.cdcoup = o.cdcoup
      LEFT JOIN Go2B\Models\B2bOrdema b ON b.nuordc = o.nuordc
      LEFT JOIN Go2B\Models\Anaiva i ON i.cdaiva = a.cdesen
      LEFT JOIN Go2B\Models\Lstest l ON o.nulist = l.nulist
      LEFT JOIN Go2B\Models\Tppaga tg ON tg.tppaga = o.tppaga
      LEFT JOIN Go2B\Models\Tpport tr ON tr.tpport = o.tpport
      WHERE o.nuordc = :nuordc:";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc))[0];
  }

  /**
   * Query:   SELECT
   * Return:  Octest object
   */
  public static function getOrderFromNuordc($nuordc)
  {
    $query = "SELECT o.tpanag, o.cdanag, o.cdcata, a.descri AS dsanag,
      a.indiri AS indiri_a, a.ccitta AS ccitta_a, a.provin AS provin_a,
      COALESCE(b.indema,a.indema,'') AS indema, COALESCE(b.conrif,'') AS conrif, o.cddesm,
      COALESCE(d.desvid,'') AS dsdesm, COALESCE(d.indiri,'') AS indiri_d,
      COALESCE(d.ccitta,'') AS ccitta_d, COALESCE(d.provin,'') AS provin_d,
      COALESCE(n1.dsnazi,'') AS dsnazi_a, COALESCE(n2.dsnazi,'') AS dsnazi_d,
      o.nulist, o.tpordc, o.cdetic, COALESCE(e.dsetic,'') AS dsetic, o.nuordc,
      DATE_FORMAT(o.dtcrea, '%d/%m/%Y') AS dtcrea, DATE_FORMAT(o.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(o.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(o.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(o.dtinvi, '%d/%m/%Y') AS dtinvi,
      o.dtmcli AS dtmcli_n, o.dtmcoi AS dtmcoi_n, o.dtmcof AS dtmcof_n,
      o.tpindo, o.cdcoup, o.notazi, o.notcli, o.flnosc,
      o.tppaga, o.tpport, COALESCE(c.dscoup,'') AS dscoup,
      COALESCE(c.tpcoup,-1) AS tpcoup, COALESCE(c.impsco,-1) AS impsco,
      COALESCE(i.dsaiva,'') AS dsaiva, COALESCE(i.aliquo,0) AS aliquo,
      COALESCE(a.scont1,0) AS anagra_scont1, COALESCE(a.scont2,0) AS anagra_scont2,
      COALESCE(a.scont3,0) AS anagra_scont3
      FROM Go2B\Models\Octest o
      LEFT JOIN Go2B\Models\Anagra a ON a.tpanag = o.tpanag AND a.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Desmer d ON d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Ananaz n1 ON a.cdnazi = n1.cdnazi
      LEFT JOIN Go2B\Models\Ananaz n2 ON d.cdnazi = n2.cdnazi
      LEFT JOIN Go2B\Models\Anaeti e ON e.cdetic = o.cdetic
      LEFT JOIN Go2B\Models\B2bCoupon c ON c.cdcoup = o.cdcoup
      LEFT JOIN Go2B\Models\B2bOrdema b ON b.nuordc = o.nuordc
      LEFT JOIN Go2B\Models\Anaiva i ON i.cdaiva = a.cdesen
      WHERE o.nuordc = :nuordc: AND o.flstat != 0 AND o.flstat != 4";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc))[0];
  }

  /**
   * Query:   SELECT
   * Return:  Octest object
   */
  public static function getGenericOrderFromNuordc($nuordc)
  {
    $query = "SELECT o.tpanag, o.cdanag, o.id_usr, o.cdcata, ct.dscata,
      a.descri AS dsanag, a.indiri AS indiri_a, a.ccitta AS ccitta_a, a.provin AS provin_a,
      COALESCE(b.indema,a.indema,'') AS indema, COALESCE(b.conrif,'') AS conrif, o.cddesm,
      COALESCE(d.desvid,'') AS dsdesm, COALESCE(d.indiri,'') AS indiri_d,
      COALESCE(d.ccitta,'') AS ccitta_d, COALESCE(d.provin,'') AS provin_d,
      COALESCE(n1.dsnazi,'') AS dsnazi_a, COALESCE(n2.dsnazi,'') AS dsnazi_d,
      o.nulist, o.tpordc, o.cdetic, COALESCE(e.dsetic,'') AS dsetic, o.nuordc,
      DATE_FORMAT(o.dtcrea, '%d/%m/%Y') AS dtcrea, DATE_FORMAT(o.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(o.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(o.dtmcof, '%d/%m/%Y') AS dtmcof,
      o.dtmcli AS dtmcli_n, o.dtmcoi AS dtmcoi_n, o.dtmcof AS dtmcof_n,
      o.tpindo, o.cdcoup, o.notazi, o.notcli, o.flnosc,
      o.tppaga, o.tpport, COALESCE(c.dscoup,'') AS dscoup,
      COALESCE(c.tpcoup,-1) AS tpcoup, COALESCE(c.impsco,-1) AS impsco,
      COALESCE(i.dsaiva,'') AS dsaiva, COALESCE(i.aliquo,0) AS aliquo,
      COALESCE(a.scont1,0) AS anagra_scont1, COALESCE(a.scont2,0) AS anagra_scont2,
      COALESCE(a.scont3,0) AS anagra_scont3
      FROM Go2B\Models\Octest o
      LEFT JOIN Go2B\Models\Cttest ct ON ct.cdcata = o.cdcata
      LEFT JOIN Go2B\Models\Anagra a ON a.tpanag = o.tpanag AND a.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Desmer d ON d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Ananaz n1 ON a.cdnazi = n1.cdnazi
      LEFT JOIN Go2B\Models\Ananaz n2 ON d.cdnazi = n2.cdnazi
      LEFT JOIN Go2B\Models\Anaeti e ON e.cdetic = o.cdetic
      LEFT JOIN Go2B\Models\B2bCoupon c ON c.cdcoup = o.cdcoup
      LEFT JOIN Go2B\Models\B2bOrdema b ON b.nuordc = o.nuordc
      LEFT JOIN Go2B\Models\Anaiva i ON i.cdaiva = a.cdesen
      WHERE o.nuordc = :nuordc:";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc))[0];
  }

  /**
   * Query:   SELECT
   * Return:  Octest object
   */
  public static function getOrderForPdf($nuordc, $idlang = 'IT')
  {
    if ($idlang != 'IT') {
      $dstpor = "COALESCE(d1.descri,r.dstpor,'') AS dstpor";
      $dspaga = "COALESCE(d2.descri,g.dspaga,'') AS dspaga";
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = r.tpport AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dspaga' AND d2.codic1 = g.tppaga AND d2.idlang = :idlang: ";
    } else {
      $dstpor = "COALESCE(r.dstpor,'') AS dstpor";
      $dspaga = "COALESCE(g.dspaga,'') AS dspaga";
      $lnJoin = '';
    }

    $nuordcPlus = self::getParamToColumnNuordc('t');
    $query = "SELECT $nuordcPlus, t.id_usr,  t.tpanag, t.cdanag,
      a.descri AS dsanag, t.cddesm, c.cdcata,
      COALESCE(c.dscata,'') AS dscata, COALESCE(c.cdstag,'') AS cdstag, t.nulist,
      COALESCE(l.dslist,'') AS dslist, COALESCE(l.cdvalu,'EUR') AS cdvalu,
      t.tpordc, r.tpport, g.tppaga, $dstpor, $dspaga, t.tpindo,
      COALESCE(e.dsetic,'') AS dsetic, DATE_FORMAT(t.dtcrea, '%d/%m/%Y') AS dtcrea,
      DATE_FORMAT(t.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(t.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(t.dtmcof, '%d/%m/%Y') AS dtmcof,
      COALESCE(s.dsscad,'') AS dsscad, t.flstat, t.notcli, t.notazi, t.cdvett,
      COALESCE(v.dsvett,'') AS dsvett, t.cdcoup, COALESCE(p.dscoup,'') AS dscoup,
      COALESCE(ua.cdagen,a.cdagen) AS cdagen, COALESCE(ag1.dsagen,ag2.dsagen) AS dsagen,
      COALESCE(a.scont1,0) AS anagra_scont1, COALESCE(a.scont2,0) AS anagra_scont2,
      COALESCE(a.scont3,0) AS anagra_scont3, t.flnosc
      FROM Go2B\Models\Octest t
      INNER JOIN Go2B\Models\Anagra a ON a.tpanag = t.tpanag AND a.cdanag = t.cdanag
      LEFT JOIN Go2B\Models\Cttest c ON t.cdcata = c.cdcata
      LEFT JOIN Go2B\Models\Lstest l ON t.nulist = l.nulist
      LEFT JOIN Go2B\Models\Tpport r ON t.tpport = r.tpport
      LEFT JOIN Go2B\Models\Tppaga g ON t.tppaga = g.tppaga
      LEFT JOIN Go2B\Models\Anaeti e ON t.cdetic = e.cdetic
      LEFT JOIN Go2B\Models\Anavet v ON t.cdvett = v.cdvett
      LEFT JOIN Go2B\Models\Scacon s ON t.cdcata = s.cdcata AND t.dtmcli = s.dtmcli
      LEFT JOIN Go2B\Models\B2bCoupon p ON t.cdcoup = p.cdcoup
      LEFT JOIN Go2B\Models\B2bUsrage ua ON ua.id_usr = t.id_usr
      LEFT JOIN Go2B\Models\Anaage ag1 ON ag1.cdagen = ua.cdagen
      LEFT JOIN Go2B\Models\Anaage ag2 ON ag2.cdagen = a.cdagen
      $lnJoin
      WHERE t.nuordc = :nuordc:
      GROUP BY t.nuordc";

    $params = $idlang != 'IT'
      ? array('nuordc' => $nuordc, 'idlang' => $idlang)
      : array('nuordc' => $nuordc);

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Octest object
   */
  public static function getCurrentOrder($id_usr)
  {
    $query = "SELECT o.tpanag, o.cdanag, o.cdcata, COALESCE(ct.dsstag,'') AS dsstag,
      COALESCE(ct.cdstag,'') AS cdstag, COALESCE(ts.dsstag,'') AS dsstag, a.descri AS dsanag,
      a.indiri AS indiri_a, a.ccitta AS ccitta_a, a.provin AS provin_a,
      COALESCE(b.indema,a.indema,'') AS indema, COALESCE(b.conrif,'') AS conrif, o.cddesm,
      COALESCE(d.desvid,'') AS dsdesm, COALESCE(d.indiri,'') AS indiri_d,
      COALESCE(d.ccitta,'') AS ccitta_d, COALESCE(d.provin,'') AS provin_d,
      COALESCE(n1.dsnazi,'') AS dsnazi_a, COALESCE(n2.dsnazi,'') AS dsnazi_d,
      o.nulist, COALESCE(l.cdvalu,'EUR') AS cdvalu, COALESCE(a.rulist,'') AS rulist,
      o.tpordc, o.cdtipord, o.cdetic, COALESCE(e.dsetic,'') AS dsetic, o.nuordc,
      DATE_FORMAT(o.dtcrea, '%d/%m/%Y') AS dtcrea, DATE_FORMAT(o.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(o.dtmcoi, '%d/%m/%Y') AS dtmcoi, DATE_FORMAT(o.dtmcof, '%d/%m/%Y') AS dtmcof,
      o.dtmcli AS dtmcli_n, o.dtmcoi AS dtmcoi_n, o.dtmcof AS dtmcof_n,
      o.tpindo, COALESCE(ic.dsindo,'') AS dsindo, o.notcli, o.notazi, o.cdcoup,
      COALESCE(c.dscoup,'') AS dscoup, COALESCE(c.tpcoup,-1) AS tpcoup,
      COALESCE(c.impsco,-1) AS impsco, COALESCE(i.dsaiva,'') AS dsaiva,
      COALESCE(i.aliquo,0) AS aliquo, COALESCE(a.scont1,0) AS anagra_scont1,
      COALESCE(a.scont2,0) AS anagra_scont2, COALESCE(a.scont3,0) AS anagra_scont3,
      COALESCE(dr.valore,0) AS fldbrw, o.flnosc, o.tpport, o.tppaga
      FROM Go2B\Models\Octest o
      LEFT JOIN Go2B\Models\Anagra a ON a.tpanag = o.tpanag AND a.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Desmer d ON d.tpanag = o.tpanag AND d.cddesm = o.cddesm AND d.cdanag = o.cdanag
      LEFT JOIN Go2B\Models\Ananaz n1 ON a.cdnazi = n1.cdnazi
      LEFT JOIN Go2B\Models\Ananaz n2 ON d.cdnazi = n2.cdnazi
      LEFT JOIN Go2B\Models\Anaeti e ON e.cdetic = o.cdetic
      LEFT JOIN Go2B\Models\B2bAddinf dr ON dr.tabell = 'octest' AND dr.codic1 = o.nuordc AND dr.codic2 = '' AND dr.tpdato = 'fldbrw'
      LEFT JOIN Go2B\Models\B2bCoupon c ON c.cdcoup = o.cdcoup
      LEFT JOIN Go2B\Models\B2bOrdema b ON b.nuordc = o.nuordc
      LEFT JOIN Go2B\Models\Lstest l ON l.nulist = o.nulist
      LEFT JOIN Go2B\Models\Anaiva i ON i.cdaiva = a.cdesen
      LEFT JOIN Go2B\Models\Cttest ct ON o.cdcata = ct.cdcata
      LEFT JOIN Go2B\Models\Tabstg ts ON ct.cdstag = ts.cdstag
      LEFT JOIN Go2B\Models\Indorc ic ON o.tpindo = ic.tpindo
      WHERE o.id_usr = :id_usr: AND o.flstat = 0";

    $order = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
    return count($order) == 1 ? $order[0] : null;
  }

  /**
   * Query:   SELECT
   * Return:  Octest array
   */
  public static function getOrderDetail($nuordc)
  {
    $query = "SELECT ot.nuordc, bu.username, COALESCE(aa.cdagen,'') AS cdagen,
      COALESCE(aa.dsagen,'') AS dsagen, ot.cdanag,
      CONVERT(CAST(ag.descri AS BINARY) USING utf8) as descri,
      COALESCE(CONVERT(CAST(dm.desvid AS BINARY) USING utf8),'') AS dsdesm,
      ot.cdcata, ct.dscata, COALESCE(bo.indema,ag.indema,'') AS indema,
      COALESCE(bo.conrif,'') AS conrif,
      DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea,
      DATE_FORMAT(ot.dtmcli, '%d/%m/%Y') AS dtmcli,
      DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y') AS dtmcoi,
      DATE_FORMAT(ot.dtmcof, '%d/%m/%Y') AS dtmcof,
      DATE_FORMAT(ot.dtinvi, '%d/%m/%Y') AS dtinvi,
      COALESCE(tg.dspaga,'') AS dspaga, COALESCE(tt.dstpor,'') AS dstpor,
      ot.notcli, ot.notazi, lt.cdvalu, lt.dslist, ot.flnosc
      FROM octest ot
      LEFT JOIN b2b_usrage ua ON ua.id_usr = ot.id_usr
      LEFT JOIN b2b_sysusr bu ON bu.id = ua.id_usr
      LEFT JOIN anaage aa ON aa.cdagen = ua.cdagen
      INNER JOIN cttest ct ON ct.cdcata = ot.cdcata
      INNER JOIN lstest lt ON ot.nulist = lt.nulist
      INNER JOIN anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
      LEFT JOIN desmer dm ON ot.tpanag = dm.tpanag AND ot.cddesm = dm.cddesm AND ot.cdanag = dm.cdanag
      LEFT JOIN tppaga tg ON ot.tppaga = tg.tppaga
      LEFT JOIN tpport tt ON ot.tpport = tt.tpport
      LEFT JOIN b2b_ordema bo ON bo.nuordc = ot.nuordc
      WHERE ot.nuordc = :nuordc";
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc))->fetchAll()[0];
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCountAllOrders($dtiniz, $dtfine, $cdstag = -1)
  {
    $params = array('dtiniz' => $dtiniz, 'dtfine' => $dtfine);
    if ($cdstag != -1) {
      $params['cdstag'] = $cdstag;
      $andWhere = ' AND ot.cdstag = :cdstag: ';
    } else {
      $andWhere = '';
    }
    $query = "SELECT COUNT(ot.nuordc) AS total
      FROM Go2B\Models\Octest ot
      WHERE ot.flstat != 0 AND ot.flstat != 4
      AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $andWhere";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->total : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCountOrdersAgents($whereCatalogs, $whereAgents, $params)
  {
    $query = "SELECT COUNT(ot.nuordc) AS total
      FROM Go2B\Models\Octest ot
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->total : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCountOrdersCustomers($whereCatalogs, $whereCustomers, $params)
  {
    $query = "SELECT COUNT(ot.nuordc) AS total
      FROM Go2B\Models\Octest ot
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->total : 0;
  }

  /**
   * Query:   INSERT
   * Return:  bool
   */
  public static function insertNewOrder($items)
  {
    $params = array(
      'id_usr' => $items['id_usr'],
      'tpanag' => $items['tpanag'],
      'cdanag' => $items['cdanag'],
      'cddesm' => $items['cddesm'],
      'cdcata' => $items['cdcata'],
      'nulist' => $items['nulist'],
      'tpordc' => $items['tpordc'],
      'tpindo' => $items['tpindo'],
      'cdetic' => $items['cdetic'],
      'dtcrea' => $items['dtcrea'],
      'dtmcli' => $items['dtmcli'],
      'dtmcoi' => $items['dtmcoi'],
      'dtmcof' => $items['dtmcof'],
      'cdstag' => $items['cdstag'],
      'cdtipord' => $items['cdtipord'],
  );
    $query = "INSERT INTO octest (nuordc, id_usr, tpanag, cdanag, cddesm,
      cdcata, nulist, tpordc, cdtipord, tppaga, tpport, tpindo, cdetic, dtcrea, dtmcli,
      dtmcoi, dtmcof, dtinvi, flstat, notcli, nuordn, dtordn, cdvett, cdcoup,
      notazi, cdstag)
      SELECT null, :id_usr, :tpanag, :cdanag, :cddesm, :cdcata, :nulist,
      :tpordc, :cdtipord, NULL, NULL, :tpindo, :cdetic, :dtcrea, :dtmcli, :dtmcoi,
      :dtmcof, NULL, 0, NULL, NULL, NULL, '', NULL, NULL, :cdstag
      FROM (
        SELECT COUNT(nuordc) AS tot_orders
        FROM octest
        WHERE id_usr = :id_usr AND flstat = 0
        HAVING tot_orders = 0) AS p";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  int
   */
  public static function insertNewOrderFromAdminDuplicate($oldOrder, $id_usr, $tpanag, $cdanag, $cddesm)
  {
    $octest = new self();
    $octest->id_usr = $id_usr;
    $octest->tpanag = $tpanag;
    $octest->cdanag = $cdanag;
    $octest->cddesm = $cddesm;
    $octest->cdcata = !empty($oldOrder->cdcata) ? $oldOrder->cdcata : new RawValue('""');
    $octest->nulist = !empty($oldOrder->nulist) ? $oldOrder->nulist : new RawValue('""');
    $octest->tpordc = 1;
    $octest->tppaga = !empty($oldOrder->tppaga) ? $oldOrder->tppaga : null;
    $octest->tpport = !empty($oldOrder->tpport) ? $oldOrder->tpport : null;
    $octest->tpindo = !empty($oldOrder->tpindo) ? $oldOrder->tpindo : null;
    $octest->cdetic = !empty($oldOrder->cdetic) ? $oldOrder->cdetic : null;
    $octest->dtcrea = date('Y-m-d');
    $octest->dtmcli = !empty($oldOrder->dtmcli) ? $oldOrder->dtmcli : null;
    $octest->dtmcoi = !empty($oldOrder->dtmcoi) ? $oldOrder->dtmcoi : null;
    $octest->dtmcof = !empty($oldOrder->dtmcof) ? $oldOrder->dtmcof : null;
    $octest->dtinvi = null;
    $octest->flstat = 1;
    $octest->notcli = !empty($oldOrder->notcli) ? $oldOrder->notcli : null;
    $octest->nuordn = null;
    $octest->dtordn = null;
    $octest->cdvett = !empty($oldOrder->cdvett) ? $oldOrder->cdvett : new RawValue('""');
    $octest->cdcoup = !empty($oldOrder->cdcoup) ? $oldOrder->cdcoup : null;
    $octest->notazi = !empty($oldOrder->notazi) ? $oldOrder->notazi : null;
    $octest->cdstag = !empty($oldOrder->cdstag) ? $oldOrder->cdstag : new RawValue('""');
    $octest->save();

    return $octest->nuordc;
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderHeader($nuordc, $cddesm, $tppaga, $tpport, $notcli, $notazi)
  {
    $params = array('nuordc' => $nuordc, 'cddesm' => $cddesm, 'tppaga' => $tppaga, 'tpport' => $tpport, 'notcli' => $notcli, 'notazi' => $notazi);
    $query = "UPDATE octest ot
      SET ot.cddesm = :cddesm, ot.tppaga = :tppaga, ot.tpport = :tpport, ot.notcli = :notcli, ot.notazi = :notazi
      WHERE ot.nuordc = :nuordc";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderState($nuordc, $flstat)
  {
    $query = "UPDATE octest ot
      SET ot.flstat = :flstat
      WHERE ot.nuordc = :nuordc";
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'flstat' => $flstat));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function removeCoupon($id_usr)
  {
    $query = "UPDATE octest ot
      SET ot.cdcoup = NULL
      WHERE ot.id_usr = :id_usr AND ot.flstat = 0";
    Di::getDefault()->get('db')->query($query, array('id_usr' => $id_usr));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag)
  {
    $query = 'UPDATE octest o
      INNER JOIN anagra a ON a.tpanag = o.tpanag AND a.cdanag = o.cdanag
      SET o.tpanag = "CL", o.cdanag = :cdanag
      WHERE o.tpanag = "CN" AND o.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updatePriceList($nuordc, $nulist)
  {
    $query = 'UPDATE octest o
      SET o.nulist = :nulist
      WHERE o.nuordc = :nuordc';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'nulist' => $nulist));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateIndicative($nuordc, $tpindo)
  {
    $query = 'UPDATE octest o
      SET o.tpindo = :tpindo
      WHERE o.nuordc = :nuordc';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'tpindo' => $tpindo));
  }

  public static function updateTppaga($nuordc, $tppaga)
  {
    $query = 'UPDATE octest o SET o.tppaga = :tppaga WHERE o.nuordc = :nuordc';
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'tppaga' => $tppaga)) != false;
  }

  public static function updateTpport($nuordc, $tpport)
  {
    $query = 'UPDATE octest o SET o.tpport = :tpport WHERE o.nuordc = :nuordc';
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'tpport' => $tpport)) != false;
  }

  public static function countArticlesInOrder($nuordc)
  {
    if (!empty($nuordc)) {
      $query = 'SELECT SUM(quanti) as tot_articoli FROM occorp WHERE nuordc = :nuordc';
      return intval(Di::getDefault()->get('db')->fetchColumn($query, array('nuordc' => $nuordc)));
    }
    return false;
  }

  public static function retriveSpendInOrder($nuordc)
  {
    if (!empty($nuordc)) {
      $query = 'SELECT SUM(ot.quanti * (ot.prezzo * (1 - (ot.scont1 / 100)) * (1 - (ot.scont2 / 100)) * (1 - (ot.scont3 / 100)))) FROM occorp o LEFT JOIN octagl ot ON (o.nurorc = ot.nurorc) WHERE o.nuordc = :nuordc';
      return round(floatval(Di::getDefault()->get('db')->fetchColumn($query, array('nuordc' => $nuordc))), 2);
    }
    return false;
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function toggleDiscounts($nuordc, $flnosc)
  {
    $query = 'UPDATE octest o
      SET o.flnosc = :flnosc
      WHERE o.nuordc = :nuordc';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'flnosc' => $flnosc));
  }

  /**
   * Query:   DELETE
   * Return:  boolean
   */
  public static function cleanOlderOrders()
  {
    $query = "DELETE octest, occorp, octagl
        FROM octest
        LEFT JOIN occorp ON occorp.nuordc = octest.nuordc
        LEFT JOIN octagl ON octagl.nurorc = occorp.nurorc
        WHERE octest.flstat = 0 AND octest.dtcrea <= DATE_ADD( CURDATE(), INTERVAL -7 DAY )";
    return Di::getDefault()->get('db')->query($query);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteOrdersForNewCustomer($cdanag)
  {
    $params = array('cdanag' => $cdanag);
    $query = "DELETE FROM octest WHERE tpanag = 'CN' AND cdanag = :cdanag AND flstat = 4 ";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion

  public function sendOrderToNav()
  {
    $api = new ApiKOC();
    $api->sendHeader($this);
  }

  public static function getParamToColumnNuordc($tableAlias = null)
  {
      if (!empty($tableAlias)) {
          $tableAlias = rtrim($tableAlias, ' .') . '.';
      }
    $ownerB2B = Di::getDefault()->get('config')->release->user;
    return ($ownerB2B == "koc") ? "CONCAT('PROP', LPAD({$tableAlias}nuordc, 6, '0')) AS codice_ordine, {$tableAlias}nuordc" : "{$tableAlias}nuordc AS codice_ordine, {$tableAlias}nuordc";
  }

    public function getCodiceOrdine()
  {
      if (empty($this->codice_ordine) && !empty($this->nuordc)) {
          if ($this->getDI()->get('config')->release->user == 'koc') {
              $this->codice_ordine = 'PROP' . str_pad($this->nuordc, 6, '0', STR_PAD_LEFT);
          } else {
              $this->codice_ordine = $this->nuordc;
          }
      }
      return $this->codice_ordine;
  }
}
