<?php

namespace Go2B\Models;

use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Octagl extends Model
{
    //region Fields
    /**
     *
     * @var integer
     * @Primary
     * @Column(type="integer", length=11, nullable=false)
     */
    public $nurorc;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=30, nullable=false)
     */
    public $dstagl;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $quanti;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $prezzo;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont1;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont2;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont3;
    //endregion

    //region Default functions

    /**
     * Sync from xml
     */
    public static function saveRecord($rec, $tipoagg)
    {
        $values = array(
            'nurorc' => isset($rec->nurorc) && (string)$rec->nurorc !== '' ? (string)$rec->nurorc : 0,
            'dstagl' => isset($rec->dstagl) && (string)$rec->dstagl !== '' ? (string)$rec->dstagl : new RawValue('""'),
            'quanti' => isset($rec->quanti) && (string)$rec->quanti !== '' ? (string)$rec->quanti : 0,
            'prezzo' => isset($rec->prezzo) && (string)$rec->prezzo !== '' ? (string)$rec->prezzo : 0,
            'scont1' => isset($rec->scont1) && (string)$rec->scont1 !== '' ? (string)$rec->scont1 : 0,
            'scont2' => isset($rec->scont2) && (string)$rec->scont2 !== '' ? (string)$rec->scont2 : 0,
            'scont3' => isset($rec->scont3) && (string)$rec->scont3 !== '' ? (string)$rec->scont3 : 0
        );

        $query = 'nurorc = :nurorc: AND dstagl = :dstagl:';
        $params = array(
            'nurorc' => $values['nurorc'],
            'dstagl' => $values['dstagl']
        );

        if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
            $row = new self();
        }

        $row->save($values);
    }
    //endregion

    //region Sync functions

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getTotalSizesQuantity($nurorc)
    {
        // Anaart and Tipolo need LEFT JOIN to avoid problems with FRO (customization), given the fact they are only needed by assortments
        $query = "SELECT og.dstagl, (og.quanti + COALESCE(oa.quanti * ac.qtatgl, 0)) AS quanti,
      og.prezzo, og.scont1, og.scont2, og.scont3, og.quanti AS loose_qty,
      COALESCE(oa.quanti * ac.qtatgl, 0) AS assortment_qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      LEFT JOIN Go2B\Models\Ocasso oa ON oc.nurorc = oa.nurorc
      LEFT JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Ascorp ac ON ac.cdtagl = tp.cdtagl AND ac.taglia = og.dstagl
      WHERE og.nurorc = :nurorc:
      GROUP BY og.dstagl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }
    //endregion

    //region Custom queries

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getAllSizeQuantities($nurorc)
    {
        $query = "SELECT og.dstagl, og.quanti
      FROM Go2B\Models\Octagl og
      WHERE og.nurorc = :nurorc:";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantitiesForCart($nurorc, $isPT)
    {
        if ($isPT) {
            $cdcolo = 'c.cdcolo';
            $cdvari = 'c.cdvari';
        } else {
            $cdcolo = "'' AS cdcolo";
            $cdvari = "'' AS cdvari";
        }

        $query = "SELECT o.dstagl AS taglia, o.quanti, o.prezzo,
      COALESCE(IF(l.preven > 0,l.preven,r.prezzo),0) AS prezzo_r,
      COALESCE(l.cdvalu,r.cdvalu,'') AS cdvalu_r,
      o.scont1, o.scont2, o.scont3,
      $cdcolo, $cdvari
      FROM Go2B\Models\Octagl o
      INNER JOIN Go2B\Models\Occorp c ON c.nurorc = o.nurorc
      INNER JOIN Go2B\Models\Octest s ON s.nuordc = c.nuordc
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      INNER JOIN Go2B\Models\Tipolo t ON t.cdartn = a.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON o.dstagl = pt.taglia AND t.cdtagl = pt.cdtagl
      LEFT JOIN Go2B\Models\Lscorp l ON l.nulist = s.nulist AND l.cdarti = a.cdarti
      LEFT JOIN Go2B\Models\Anagra g ON g.tpanag = s.tpanag AND g.cdanag = s.cdanag
      LEFT JOIN Go2B\Models\Lscorp r ON r.cdarti = a.cdarti AND r.nulist = g.rulist
      WHERE o.nurorc = :nurorc:
      GROUP BY taglia
      ORDER BY pt.postgl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantitiesForCustomArticlesCart($nurorc)
    {
        $query = "SELECT o.dstagl AS taglia, o.quanti, o.prezzo,
      0 AS prezzo_r, '' AS cdvalu_r, o.scont1, o.scont2, o.scont3,
      '' AS cdcolo, '' AS cdvari
      FROM Go2B\Models\Octagl o
      INNER JOIN Go2B\Models\Occorp c ON c.nurorc = o.nurorc
      INNER JOIN Go2B\Models\Octest s ON s.nuordc = c.nuordc
      INNER JOIN Go2B\Models\Ocpert p ON p.nupers = c.cdarti
      INNER JOIN Go2B\Models\Tipolo t ON t.cdartn = p.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON o.dstagl = pt.taglia AND t.cdtagl = pt.cdtagl
      WHERE o.nurorc = :nurorc:
      GROUP BY taglia
      ORDER BY pt.postgl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantitiesForAvailabilityCart($nurorc, $cdtagl, $dtmcli, $isPT)
    {
        if ($isPT) {
            $cdcolo = 'c.cdcolo';
            $cdvari = 'c.cdvari';
            $whereOctagl = 'AND oc.cdcolo = dc.cdcolo AND oc.cdvari = dc.cdvari';
            $whereDscorp = 'AND dc.cdcolo = c.cdcolo AND dc.cdvari = c.cdvari';
        } else {
            $cdcolo = "'' AS cdcolo";
            $cdvari = "'' AS cdvari";
            $whereOctagl = '';
            $whereDscorp = '';
        }

        $selDcQuanti = $dtmcli == date('Y-m-d') ? 'SUM(dc.quanti)' : 'dc.quanti';

        $query = "SELECT o.dstagl AS taglia, o.quanti, o.prezzo, COALESCE(l.preven,0) AS preven, o.scont1, o.scont2, o.scont3, $cdcolo, $cdvari,
      DATE_FORMAT(:dtdisp:, '%d/%m/%Y') AS dtdisp,
      COALESCE(
        (SELECT $selDcQuanti -
          COALESCE(
            (SELECT SUM(og.quanti)
            FROM Go2B\Models\Octagl og
            INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
            INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
            WHERE oc.cdarti = dc.cdarti $whereOctagl AND ot.flstat = 2 AND og.dstagl = dc.taglia),
          0)
        FROM Go2B\Models\Dscorp dc
        WHERE dc.taglia = o.dstagl $whereDscorp AND dc.cdarti = c.cdarti AND dc.dtdisp <= :dtdisp:
        ORDER BY dc.dtdisp DESC
        LIMIT 1),
      0) AS disp
      FROM Go2B\Models\Octagl o
      INNER JOIN Go2B\Models\Occorp c ON c.nurorc = o.nurorc
      INNER JOIN Go2B\Models\Octest s ON s.nuordc = c.nuordc
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      INNER JOIN Go2B\Models\Tipolo t ON t.cdartn = a.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON o.dstagl = pt.taglia AND t.cdtagl = pt.cdtagl
      LEFT JOIN Go2B\Models\Lscorp l ON l.nulist = s.nulist AND l.cdarti = a.cdarti
      WHERE o.nurorc = :nurorc: AND pt.cdtagl = :cdtagl:
      GROUP BY taglia
      ORDER BY pt.postgl";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc, 'dtdisp' => $dtmcli, 'cdtagl' => $cdtagl));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantitiesForOrderDetail($nurorc)
    {
        $query = "SELECT og.dstagl, og.quanti, og.prezzo, og.scont1, og.scont2, og.scont3
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON og.dstagl = pt.taglia AND tp.cdtagl = pt.cdtagl
      WHERE og.nurorc = :nurorc:
      GROUP BY og.dstagl
      ORDER BY pt.postgl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantitiesForOrderDetailConfigurator($nurorc)
    {
        $query = "SELECT og.dstagl, og.quanti, og.prezzo, og.scont1, og.scont2, og.scont3
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Ocpert pr ON pr.nuordc = oc.nuordc AND pr.nupers = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON pr.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON og.dstagl = pt.taglia AND tp.cdtagl = pt.cdtagl
      WHERE og.nurorc = :nurorc:
      GROUP BY og.dstagl
      ORDER BY pt.postgl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Postgl objects
     */
    public static function getSizeQuantitiesWithRulesForWizard($nurorc)
    {
        $query = "SELECT DISTINCT pt.postgl, ot.dstagl, ot.quanti, ot.prezzo, ot.scont1, ot.scont2, ot.scont3,
      COALESCE(r5.qtamin,r6.qtamin,1) AS qtamin, COALESCE(r5.qtamul,r6.qtamul,1) AS qtamul,
      COALESCE(r5.qtamax,r6.qtamax,0) AS qtamax, COALESCE(r5.flbloc,0) AS flbloc
      FROM Go2B\Models\Octagl ot
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = ot.nurorc
      INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl AND pt.taglia = ot.dstagl
      LEFT JOIN Go2B\Models\Regqta r5 ON r5.cdartn = tp.cdartn AND r5.taglia = pt.taglia
      LEFT JOIN Go2B\Models\Regqta r6 ON r6.cdartn = tp.cdartn AND r6.taglia = ''
      WHERE ot.nurorc = :nurorc:
      ORDER BY pt.postgl ASC";

        $params = array('nurorc' => $nurorc);
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantityForPdf($nurorc)
    {
        $query = "SELECT og.dstagl AS taglia, og.quanti, og.prezzo,
      og.scont1, og.scont2, og.scont3, pt.postgl
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON og.dstagl = pt.taglia AND pt.cdtagl = tp.cdtagl
      WHERE og.nurorc = :nurorc:
      GROUP BY taglia
      ORDER BY pt.postgl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantityForConfiguratorPdf($nurorc)
    {
        $query = "SELECT og.dstagl AS taglia, og.quanti, og.prezzo,
      og.scont1, og.scont2, og.scont3, pt.postgl
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Ocpert pr ON pr.nuordc = oc.nuordc AND pr.nupers = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON pr.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON og.dstagl = pt.taglia AND pt.cdtagl = tp.cdtagl
      WHERE og.nurorc = :nurorc:
      GROUP BY taglia
      ORDER BY pt.postgl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantityWithDiscount($nuordc, $numdis)
    {
        $query = "SELECT og.nurorc, og.dstagl,
      COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_sconto
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c6.numdis = :numdis:
      WHERE ot.nuordc = :nuordc:
      GROUP BY og.nurorc, og.dstagl";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc, 'numdis' => $numdis));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getSizeQuantityDiscounts($id_usr, $numdis)
    {
        $query = "SELECT og.nurorc, og.dstagl,
      COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_sconto
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
      LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c6.numdis = :numdis:
      WHERE ot.id_usr = :id_usr: AND ot.flstat = 0";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr, 'numdis' => $numdis));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getTotalQuantityAndValueAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT aa.cdagen, aa.dsagen,
      COALESCE((SELECT
        COUNT(o1.nuordc)
        FROM Go2B\Models\Octest o1
        INNER JOIN Go2B\Models\B2bUsrage u1 ON o1.id_usr = u1.id_usr
        WHERE o1.flstat != 0 AND o1.flstat != 4 AND o1.dtcrea >= :dtiniz: AND o1.dtcrea <= :dtfine:
        AND u1.cdagen = aa.cdagen),0) AS totord,
      SUM(og.quanti) AS qty, SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS val
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      INNER JOIN Go2B\Models\Anaage aa ON aa.cdagen = ua.cdagen
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY aa.cdagen
      ORDER BY aa.dsagen DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForBrandAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT tl.cdtitl,
      tl.dstitl AS name, SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY tl.cdtitl
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForBrandCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT tl.cdtitl,
      tl.dstitl AS name, SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY tl.cdtitl
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForLineAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT lm.cdlinm, CONCAT(tl.dstitl, ' - ', lm.dslinm) AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY lm.cdlinm
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForLineCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT lm.cdlinm, CONCAT(tl.dstitl, ' - ', lm.dslinm) AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY lm.cdlinm
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForSeriesAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT lm.cdlinm, COALESCE(sm.cdserm,'') AS cdserm,
      CONCAT_WS(' - ', tl.dstitl, lm.dslinm, (CASE sm.dsserm WHEN '' THEN NULL ELSE sm.dsserm END)) AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY lm.cdlinm
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForSeriesCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT lm.cdlinm, COALESCE(sm.cdserm,'') AS cdserm,
      CONCAT_WS(' - ', tl.dstitl, lm.dslinm, (CASE sm.dsserm WHEN '' THEN NULL ELSE sm.dsserm END)) AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY lm.cdlinm
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForModelTypeAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT tm.tpmode,
      tm.dstmod AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY tm.tpmode
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForModelTypeCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT tm.tpmode,
      tm.dstmod AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY tm.tpmode
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForGenreAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT tg.tpgene,
      tg.dsgene AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Tpgene tg ON tg.tpgene = tp.tpgene
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY tg.tpgene
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getRevenueForGenreCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT tg.tpgene,
      tg.dsgene AS name,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Tpgene tg ON tg.tpgene = tp.tpgene
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY tp.tpgene
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getCountriesRevenueAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT LOWER((CASE aa.cdnazi WHEN '' THEN 'undefined' ELSE aa.cdnazi END)) AS cdnazi,
      COALESCE(an.dsnazi,'') AS dsnazi,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anagra aa ON ot.tpanag = aa.tpanag AND ot.cdanag = aa.cdanag
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      LEFT JOIN Go2B\Models\Ananaz an ON aa.cdnazi = an.cdnazi
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY cdnazi
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getCountriesRevenueCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT LOWER((CASE aa.cdnazi WHEN '' THEN 'undefined' ELSE aa.cdnazi END)) AS cdnazi,
      COALESCE(an.dsnazi,'') AS dsnazi,
      SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS value,
      SUM(og.quanti) AS qty
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anagra aa ON ot.tpanag = aa.tpanag AND ot.cdanag = aa.cdanag
      LEFT JOIN Go2B\Models\Ananaz an ON aa.cdnazi = an.cdnazi
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY cdnazi
      ORDER BY value DESC";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getCurrentSituationForBudget($tpanag, $cdanag, $cdstag, $tpindo, $cdtitl, $cdlinm, $cdserm)
    {
        $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'cdstag' => $cdstag, 'tpindo' => $tpindo, 'cdtitl' => $cdtitl, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm);
        $query = "SELECT
     SUM(og.quanti) AS totQty,
     ROUND(SUM(og.quanti * og.prezzo *
       IF(
         og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
         (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
         (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
       )),2) AS totAmt
     FROM Go2B\Models\Octagl og
     INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
     INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
     INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
     INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
     INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
     INNER JOIN Go2B\Models\Anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
     WHERE ot.tpanag = :tpanag: AND ot.cdanag = :cdanag:
     AND ot.tpindo = :tpindo: AND ot.flstat != 4 AND ot.cdstag = :cdstag:
     AND lm.cdtitl = :cdtitl: AND tp.cdlinm = :cdlinm: AND tp.cdserm = :cdserm:
     GROUP BY lm.cdtitl, tp.cdlinm, tp.cdserm";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($result) > 0 ? $result[0]->toArray() : array('totQty' => 0, 'totAmt' => 0);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Octagl objects
     */
    public static function getCurrentGlobalSituationForBudget($tpanag, $cdanag, $cdstag, $cdlinm, $tpindo)
    {
        $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'cdstag' => $cdstag);

        $andWhere = '';

        // Line filter
        if ($cdlinm != -1) {
            $andWhere .= ' AND tp.cdlinm = :cdlinm: ';
            $params['cdlinm'] = $cdlinm;
        }

        // Drop filter
        if ($tpindo != -1) {
            $andWhere .= ' AND ot.tpindo = :tpindo: ';
            $params['tpindo'] = $tpindo;
        }

        $query = "SELECT
     SUM(og.quanti) AS totQty,
     ROUND(SUM(og.quanti * og.prezzo *
       IF(
         og.scont1 > 0 OR og.scont2 > 0 OR og.scont3 > 0,
         (1 - (og.scont1 / 100)) * (1 - (og.scont2 / 100)) * (1 - (og.scont3 / 100)),
         (1 - (ag.scont1 / 100)) * (1 - (ag.scont2 / 100)) * (1 - (ag.scont3 / 100))
       )),2) AS totAmt
     FROM Go2B\Models\Octagl og
     INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
     INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
     INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
     INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
     INNER JOIN Go2B\Models\Anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
     WHERE ot.tpanag = :tpanag: AND ot.cdanag = :cdanag: AND ot.flstat != 4 AND ot.cdstag = :cdstag:
     $andWhere
     GROUP BY ot.tpanag, ot.cdanag";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($result) > 0 ? $result[0]->toArray() : array('totQty' => 0, 'totAmt' => 0);
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getTotalValue($dtiniz, $dtfine, $cdstag = -1)
    {
        $params = array('dtiniz' => $dtiniz, 'dtfine' => $dtfine);
        if ($cdstag != -1) {
            $params['cdstag'] = $cdstag;
            $andWhere = ' AND ot.cdstag = :cdstag: ';
        } else {
            $andWhere = '';
        }
        $query = "SELECT SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS total
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      WHERE ot.flstat != 0 AND ot.flstat != 4
      AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $andWhere";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($result) > 0 ? $result[0]->total : 0;
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getTotalValueAgents($whereCatalogs, $whereAgents, $params)
    {
        $query = "SELECT SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS total
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($result) > 0 ? $result[0]->total : 0;
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getTotalValueCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS total
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($result) > 0 ? $result[0]->total : 0;
    }

    /**
     * Query:   SELECT
     * Return:  bool
     */
    public static function hasSizeQuantityDiscount($nuordc)
    {
        $query = "SELECT og.nurorc, og.dstagl
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      WHERE ot.nuordc = :nuordc: AND og.scont1 > 0";
        $octagl = Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
        return count($octagl) > 0;
    }

    /**
     * Query:   SELECT
     * Return:  bool
     */
    public static function hasCartSizeQuantityDiscount($id_usr)
    {
        $query = "SELECT og.nurorc, og.dstagl
      FROM Go2B\Models\Octagl og
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      WHERE ot.id_usr = :id_usr: AND ot.flstat = 0 AND og.scont1 > 0";
        $params = array('id_usr' => $id_usr);
        $octagl = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);

        return count($octagl) > 0;
    }

    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function insertSizeQuantity($nurorc, $dstagl, $quanti)
    {
        $octagl = new self;
        $octagl->nurorc = isset($nurorc) && (string)$nurorc !== '' ? (string)$nurorc : 0;
        $octagl->dstagl = isset($dstagl) && (string)$dstagl !== '' ? (string)$dstagl : new RawValue('""');
        $octagl->quanti = isset($quanti) && (string)$quanti !== '' ? (string)$quanti : 0;
        $octagl->prezzo = 0;
        $octagl->scont1 = 0;
        $octagl->scont2 = 0;
        $octagl->scont3 = 0;
        $octagl->save();
    }

    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function initializeSizesStructure($nurorc, $sizes)
    {
        foreach ($sizes as $size) {
            $dstagl = $size->taglia;
            $prezzo = $size->prezzo;

            $octagl = new self;
            $octagl->nurorc = isset($nurorc) && (string)$nurorc !== '' ? (string)$nurorc : 0;
            $octagl->dstagl = isset($dstagl) && (string)$dstagl !== '' ? (string)$dstagl : new RawValue('""');
            $octagl->quanti = 0;
            $octagl->prezzo = isset($prezzo) && (string)$prezzo !== '' ? (string)$prezzo : 0;
            $octagl->scont1 = 0;
            $octagl->scont2 = 0;
            $octagl->scont3 = 0;
            $octagl->save();
        }
    }

    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function duplicateOrderRowQuantities($oldNurorc, $newNurorc)
    {
        $params = array('nurorc1' => $oldNurorc, 'nurorc2' => $newNurorc);
        $query = "INSERT INTO octagl (nurorc, dstagl, quanti, prezzo, scont1, scont2, scont3)
      SELECT :nurorc2, og.dstagl, og.quanti, og.prezzo, og.scont1, og.scont2, og.scont3
      FROM octagl og
      WHERE og.nurorc = :nurorc1";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function insertSizeQuantityForVariant($nuordc, $nurorc, $dstagl, $quanti, $addPrice)
    {
        $params = array('nuordc' => $nuordc, 'nurorc' => $nurorc, 'dstagl' => $dstagl, 'quanti' => $quanti, 'prezzo' => $addPrice);
        $query = "INSERT INTO octagl (nurorc, dstagl, quanti, prezzo, scont1, scont2, scont3)
      SELECT :nurorc, :dstagl, :quanti, lc.prezzo + :prezzo, 0, 0, 0
      FROM occorp oc
      INNER JOIN octest ot ON oc.nuordc = ot.nuordc
      INNER JOIN lscorp lc ON ot.nulist = lc.nulist AND oc.cdarti = lc.cdarti
      WHERE ot.nuordc = :nuordc
      LIMIT 1";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateMultipleSizeQuantities($nurorc, $dstagl, $quanti, $scont1, $scont2, $scont3)
    {
        $params = array('dstagl' => $dstagl, 'quanti' => $quanti, 'scont1' => $scont1, 'scont2' => $scont2, 'scont3' => $scont3);
        $whereNurorc = array();
        for ($i = 0; $i < count($nurorc); $i++) {
            $whereNurorc[] = ':nurorc' . $i;
            $params['nurorc' . $i] = $nurorc[$i];
        }
        $where = implode(',', $whereNurorc);

        $query = "UPDATE octagl og
      SET og.quanti = :quanti, og.scont1 = :scont1, og.scont2 = :scont2, og.scont3 = :scont3
      WHERE og.nurorc IN ($where) AND og.dstagl = :dstagl";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateQuantitySizeMoreRows($dstagl, $quanti, $nurorcs)
    {
        $params = array('dstagl' => $dstagl, 'quanti' => $quanti);
        $inNurorc = '';
        for ($i = 0; $i < count($nurorcs); $i++) {
            $params['nurorc' . $i] = $nurorcs[$i];
            $inNurorc .= ':nurorc' . $i . ($i != count($nurorcs) - 1 ? ',' : '');
        }
        $query = "UPDATE octagl og
      SET og.quanti = :quanti
      WHERE og.dstagl = :dstagl AND og.nurorc IN ($inNurorc)";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateSizeQuantity($nurorc, $dstagl, $quanti, $strict = true)
    {
        $sumQta = '';
        // strict means the quantity will be updated, if false it should be added instead
        if (!$strict) {
            $sumQta = 'og.quanti + ';
        }

        $query = "UPDATE octagl og
      SET og.quanti = $sumQta :quanti
      WHERE og.nurorc = :nurorc AND og.dstagl = :dstagl";
        Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc, 'dstagl' => $dstagl, 'quanti' => $quanti));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateSizePrice($nurorc, $dstagl, $prezzo)
    {
        $query = 'UPDATE octagl og
      SET og.prezzo = :prezzo
      WHERE og.nurorc = :nurorc AND og.dstagl = :dstagl';
        Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc, 'dstagl' => $dstagl, 'prezzo' => $prezzo));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateSizeQuantityDiscount($nurorc, $dstagl, $scont1)
    {
        $query = 'UPDATE octagl og
      SET og.scont1 = :scont1
      WHERE og.nurorc = :nurorc AND og.dstagl = :dstagl';
        Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc, 'dstagl' => $dstagl, 'scont1' => $scont1));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateSizeQuantityPrice($nurorc, $price, $strict = false)
    {
        $sumPrz = '';
        // strict means the price will be updated, if false it should be added instead
        if (!$strict) {
            $sumPrz = 'og.prezzo + ';
        }

        $query = "UPDATE octagl og
      SET og.prezzo = $sumPrz :price
      WHERE og.nurorc = :nurorc";
        Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc, 'price' => $price));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateSizeQuantityDiscountForNurorc($nurorc, $field, $value)
    {
        $query = "UPDATE octagl og
      SET og.$field = :sconto
      WHERE og.nurorc = :nurorc";
        $params = array('nurorc' => $nurorc, 'sconto' => $value);
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function emptyOrderRow($nurorc)
    {
        $query = 'UPDATE octagl og
      SET og.quanti = 0
      WHERE og.nurorc = :nurorc';
        Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function recalculatePrices($nuordc, $nulist)
    {
        $query = 'UPDATE octagl og
      INNER JOIN occorp oc2 ON og.nurorc = oc2.nurorc
      SET og.prezzo = (
        SELECT lc.prezzo
        FROM lscorp lc
        INNER JOIN occorp oc ON lc.cdarti = oc.cdarti
        WHERE oc.nuordc = :nuordc AND oc.nurorc = og.nurorc AND lc.nulist = :nulist
      ), og.scont1 = 0, og.scont2 = 0, og.scont3 = 0
      WHERE oc2.nuordc = :nuordc';
        Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'nulist' => $nulist));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function applyDiscounts($nuordc, $scont1, $scont2, $scont3)
    {
        $query = 'UPDATE octagl og
      INNER JOIN occorp oc ON og.nurorc = oc.nurorc
      SET og.scont1 = :scont1, og.scont2 = :scont2, og.scont3 = :scont3
      WHERE oc.nuordc = :nuordc';
        Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'scont1' => $scont1, 'scont2' => $scont2, 'scont3' => $scont3));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateOrderSizesPrices()
    {
        $query = 'UPDATE octagl og
      INNER JOIN occorp oc ON og.nurorc = oc.nurorc
      INNER JOIN octest ot ON oc.nuordc = ot.nuordc
      SET og.prezzo = COALESCE((SELECT MAX(lc.prezzo) FROM lscorp lc WHERE ot.nulist = lc.nulist AND oc.cdarti = lc.cdarti), 0)
      WHERE ot.flstat IN (0, 1, 5, 6)';
        Di::getDefault()->get('db')->query($query);
    }

    /**
     * Query:   DELETE
     * Return:  void
     */
    public static function deleteQuantitiesForOrder($nuordc)
    {
        $query = 'DELETE og.*
      FROM octagl og
      INNER JOIN occorp oc ON oc.nurorc = og.nurorc
      WHERE oc.nuordc = :nuordc';
        Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc));
    }

    /**
     * Query:   DELETE
     * Return:  void
     */
    public static function emptyQuantitiesForRow($nurorc)
    {
        $query = 'DELETE og.*
      FROM octagl og
      WHERE og.nurorc = :nurorc';
        Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc));
    }

    public static function removeOrderRowForArticle($nuordc, $cdarti)
    {
        $query = 'DELETE octagl.* FROM octagl
            INNER JOIN occorp ON octagl.nurorc = occorp.nurorc
            WHERE occorp.cdarti = :cdarti AND occorp.nuordc = :nuordc ';
        Di::getDefault()->get('db')->query($query, array('cdarti' => $cdarti, 'nuordc' => $nuordc));
    }

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('octagl');
    }
    //endregion
}
