<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ocpert extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nupers;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuordc;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ocpert');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nupers' => isset($rec->nupers) && (string)$rec->nupers !== '' ? (string)$rec->nupers : 0,
      'nuordc' => isset($rec->nuordc) && (string)$rec->nuordc !== '' ? (string)$rec->nuordc : 0,
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'nupers = :nupers:';
    $params = array(
      'nupers' => $values['nupers']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ocpert objects
   */
  public static function getAllCustomsForOrderAndModel($nuordc, $cdartn) {
    $query = 'SELECT pt.nupers, pt.nuordc, pt.cdartn, pt.seqrap, COALESCE(oc.nurorc,-1) AS presence
      FROM Go2B\Models\Ocpert pt
      LEFT JOIN Go2B\Models\Occorp oc ON oc.nuordc = pt.nuordc AND oc.cdarti = pt.nupers
      WHERE pt.nuordc = :nuordc: AND pt.cdartn = :cdartn:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc, 'cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  Ocpert object
   */
  public static function getCustomArticle($nuordc, $cdartn, $seqrap) {
    $params = array('nuordc' => $nuordc, 'cdartn' => $cdartn, 'seqrap' => $seqrap);
    $query = 'SELECT pt.nupers, pt.nuordc, pt.cdartn, pt.seqrap
      FROM Go2B\Models\Ocpert pt
      WHERE pt.nuordc = :nuordc: AND pt.cdartn = :cdartn: AND pt.seqrap = :seqrap:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNextIndex($nuordc, $cdartn) {
    $params = array('nuordc' => $nuordc, 'cdartn' => $cdartn);
    $query = 'SELECT COALESCE(MAX(pt.seqrap) + 1, 1) AS nextIndex
      FROM ocpert pt
      WHERE pt.nuordc = :nuordc AND pt.cdartn = :cdartn ';
    $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    return $result[0]['nextIndex'];
  }

  /**
   * Query:   INSERT
   * Return:  Ocpert object
   */
  public static function saveNewCustom($nuordc, $cdartn) {
    $ocpert = new self();
    $ocpert->nuordc = $nuordc;
    $ocpert->cdartn = $cdartn;
    $ocpert->seqrap = self::getNextIndex($nuordc, $cdartn);
    $ocpert->save();

    return $ocpert;
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllNewCustomsForOrder($nuordc) {
    $query = "DELETE pt.*
      FROM ocpert pt
      WHERE pt.nuordc = :nuordc";
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc));
  }
}
