<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ocperc extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nurper;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nupers;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $tpcomp;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmate;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ocperc');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nurper' => isset($rec->nurper) && (string)$rec->nurper !== '' ? (string)$rec->nurper : 0,
      'nupers' => isset($rec->nupers) && (string)$rec->nupers !== '' ? (string)$rec->nupers : 0,
      'tpcomp' => isset($rec->tpcomp) && (string)$rec->tpcomp !== '' ? (string)$rec->tpcomp : new RawValue('""'),
      'cdmate' => isset($rec->cdmate) && (string)$rec->cdmate !== '' ? (string)$rec->cdmate : new RawValue('""')
    );

    $query  = 'nurper = :nurper:';
    $params = array(
      'nurper' => $values['nurper']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ocperc objects
   */
  public static function getAllComponents($nupers) {
    $query = 'SELECT pc.tpcomp, tc.dscomp, tm.cdmatn, tm.dsmatn, pc.cdmate,
      am.dsmate, am.cdcolo, am.flimag, tm.cdmacr,
      COALESCE(sm.riflis, 0) AS riflis, COALESCE(sm.varpre, 0) AS varpre,
      COALESCE(sm.inplib, 0) AS inplib, COALESCE(sm.flcamp, 0) AS flcamp
      FROM Go2B\Models\Ocperc pc
      INNER JOIN Go2B\Models\Ocpert pt ON pc.nupers = pt.nupers
      LEFT JOIN Go2B\Models\Spmate sm ON pt.cdartn = sm.cdartn AND pc.tpcomp = sm.tpcomp AND pc.cdmate = sm.cdmate
      INNER JOIN Go2B\Models\Tpcomp tc ON pc.tpcomp = tc.tpcomp
      INNER JOIN Go2B\Models\Anamat am ON pc.cdmate = am.cdmate
      INNER JOIN Go2B\Models\Tipmat tm ON am.cdmatn = tm.cdmatn
      WHERE pc.nupers = :nupers:
      GROUP BY pc.tpcomp
      ORDER BY sm.tpcomp, tm.dsmatn, am.cdmate';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nupers' => $nupers));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ocperc arrays
   */
  public static function isCurrentFeatureDuplicated($nuordc, $cdartn, $tpcomp, $cdmate) {
    $params = array('nuordc' => $nuordc, 'cdartn' => $cdartn, 'tpcomp' => $tpcomp, 'cdmate' => $cdmate);
    $query = 'SELECT COALESCE(COUNT(pc.nurper),0) AS numItems
      FROM ocperc pc
      INNER JOIN ocpert pt ON pt.nupers = pc.nupers
      WHERE pt.nuordc = :nuordc AND pt.cdartn = :cdartn AND pc.tpcomp = :tpcomp AND pc.cdmate = :cdmate ';
    $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    return $result[0]['numItems'] > 0;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveNewCustomFeature($nupers, $tpcomp, $cdmate) {
    $ocperc = new self();
    $ocperc->nupers = $nupers;
    $ocperc->tpcomp = $tpcomp;
    $ocperc->cdmate = $cdmate;
    $ocperc->save();
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllNewCustomFeaturesForOrder($nuordc) {
    $query = "DELETE pc.*
      FROM ocperc pc
      INNER JOIN ocpert pt ON pt.nupers = pc.nupers
      WHERE pt.nuordc = :nuordc";
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc));
  }
  //endregion
}
