<?php

namespace Go2B\Models;

use Go2B\Controllers\Utility;
use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Occorp extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nurorc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuordc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdvari;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $quanti;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $seqdet;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmcli;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=false)
   */
  public $sgrifc;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=true)
   */
  public $tpindo;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=true)
   */
  public $indorc;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=true)
   */
  public $tpnoco;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=true)
   */
  public $dsnoco;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cddesm;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('occorp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nurorc' => isset($rec->nurorc) && (string)$rec->nurorc !== '' ? (string)$rec->nurorc : 0,
      'nuordc' => isset($rec->nuordc) && (string)$rec->nuordc !== '' ? (string)$rec->nuordc : 0,
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'cdvari' => isset($rec->cdvari) && (string)$rec->cdvari !== '' ? (string)$rec->cdvari : new RawValue('""'),
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'quanti' => isset($rec->quanti) && (string)$rec->quanti !== '' ? (string)$rec->quanti : 0,
      'seqdet' => isset($rec->seqdet) && (string)$rec->seqdet !== '' ? (string)$rec->seqdet : 0,
      'dtmcli' => isset($rec->dtmcli) && (string)$rec->dtmcli !== '' ? (string)$rec->dtmcli : '0000-00-00',
      'sgrifc' => isset($rec->sgrifc) && (string)$rec->sgrifc !== '' ? (string)$rec->sgrifc : new RawValue('""'),
      'tpindo' => isset($rec->tpindo) && (string)$rec->tpindo !== '' ? (string)$rec->tpindo : new RawValue('""'),
      'indorc' => isset($rec->indorc) && (string)$rec->indorc !== '' ? (string)$rec->indorc : new RawValue('""'),
      'tpnoco' => isset($rec->tpnoco) && (string)$rec->tpnoco !== '' ? (string)$rec->tpnoco : new RawValue('""'),
      'dsnoco' => isset($rec->dsnoco) && (string)$rec->dsnoco !== '' ? (string)$rec->dsnoco : new RawValue('""'),
      'cddesm' => isset($rec->cddesm) && (string)$rec->cddesm !== '' ? (string)$rec->cddesm : new RawValue('""')
    );

    $query  = 'nurorc = :nurorc:';
    $params = array(
      'nurorc' => $values['nurorc']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Aux functions
  /**
   * Return "order by" clause from parameter
   */
  private static function getOrderBy($ordering) {
    switch ($ordering) {
      case 0:
        // aggiunto seqrap ma seqdet serve!? Samuele 14.12.2023
        return 'ORDER BY oc.cdarti, oc.seqdet, oc.seqrap';
      case 1:
        return 'ORDER BY oc.seqrap ';
      case 2:
        return 'ORDER BY oc.seqrap DESC ';
    }
  }

  private static function getConfiguratorOrderBy($ordering) {
    switch ($ordering) {
      case 0:
          // aggiunto seqrap ma seqdet serve!? Samuele 14.12.2023
          return 'ORDER BY cdarti, seqdet, seqrap ';
      case 1:
        return 'ORDER BY seqrap ';
      case 2:
        return 'ORDER BY seqrap DESC ';
    }
  }
  //endregion

  //region Custom queries

  /**
   * Query:   SELECT
   * Return:  Resultset Simple object
   */
  public static function getOrderRow($nuordc, $cdcata, $cdarti) {
    $params = array();
    $params['nuordc'] = $nuordc;
    $params['cdarti'] = $cdarti;
    $params['cdcata'] = $cdcata;

    $query = '
      SELECT 
        COALESCE(o.nurorc, "-1") AS nurorc,
        COALESCE(o.cdarti, a.cdarti, "") AS codart,
        COALESCE(o.cdcolo, a.cdcolo, "") AS cdcolo,
        COALESCE(quanti, "0") AS quanti
      FROM Go2B\Models\Anaart a
      LEFT JOIN Go2B\Models\Occorp o ON o.cdarti = a.cdarti AND o.nuordc = :nuordc:
      LEFT JOIN Go2B\Models\Ctarti c ON a.cdarti = c.cdarti
      WHERE a.cdarti = :cdarti: AND c.cdcata = :cdcata:';

    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0] : false;
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrderRows($nuordc) {
    $query = 'SELECT o.nurorc, o.cdarti, o.cdcolo, o.cdvari, t.tppers
      FROM Go2B\Models\Occorp o
      INNER JOIN Go2B\Models\Anaart a ON o.cdarti = a.cdarti
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      WHERE o.nuordc = :nuordc:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrderRowsForJoor($nuordc) {
    $query = "SELECT ot.cdcata AS A, ct.dscata AS B,
      IF(ot.dtmcoi != NULL AND ot.dtmcoi != '0000-00-00', DATE_FORMAT(ot.dtmcoi, '%d/%m/%Y'), DATE_FORMAT(ot.dtmcli, '%d/%m/%Y')) AS C,
      IF(ot.dtmcof != NULL AND ot.dtmcof != '0000-00-00', DATE_FORMAT(ot.dtmcof, '%d/%m/%Y'), DATE_FORMAT(ot.dtmcli, '%d/%m/%Y')) AS D,
      '' AS E, '' AS F, ot.cdstag AS G, tp.dsartn AS H, aa.cdartn AS I, aa.cdpers AS J,
      COALESCE(ac.dscolo,aa.dscolo) AS K, COALESCE(ac.cdcolo,aa.cdcolo) AS L,
      GROUP_CONCAT(DISTINCT pt.taglia ORDER BY pt.postgl SEPARATOR ',') AS M,
      COALESCE(tg.dsgene, '') AS N, lm.dslinm AS O, COALESCE(sm.dsserm, '') AS P,
      '' AS Q, '' AS R, '' AS S, '' AS T, '' AS U, '' AS V, '' AS W, '' AS X,
      '' AS Y, '' AS Z, '' AS AA, '' AS AA, '' AS AB, lc.cdvalu AS AC, '' AS AD,
      lc.prezzo AS AE, lc.preven AS AF
      FROM occorp oc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN cttest ct ON ct.cdcata = ot.cdcata
      INNER JOIN anaart aa ON oc.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
      LEFT JOIN artcol ac ON oc.cdarti = ac.cdarti AND oc.cdcolo = ac.cdcolo
      LEFT JOIN tpgene tg ON tp.tpgene = tg.tpgene
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      INNER JOIN lscorp lc ON lc.nulist = ot.nulist AND lc.cdarti = oc.cdarti
      WHERE oc.nuordc = :nuordc
      GROUP BY oc.nurorc
      ORDER BY oc.seqrap ASC";
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrderRowsForXls($nuordc) {
    $utility =  new Utility();
    $ordering = $utility->getAppSettings('ParamTypeOrdering');
    $orderBy = self::getOrderBy($ordering);



    $query = "SELECT oc.nurorc, tp.flimag AS flimag_n, aa.flimag AS flimag_i,
      COALESCE(ac.flimag, '') AS flimag_c, tp.cdartn, tp.dsartn, oc.cdarti, aa.dsarti, aa.cdpers,
      COALESCE(ap.dspers,aa.cdpers) AS dspers, COALESCE(ac.cdcolo,aa.cdcolo) AS cdcolo,
      COALESCE(ac.dscolo,aa.dscolo) AS dscolo, oc.cdvari, tp.tpmode,
      COALESCE(tm.dstmod,'') AS dstmod, tp.tpgene, COALESCE(tg.dsgene,'') AS dsgene,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, lm.dslinm, tl.dstitl,
      COALESCE(sm.dsserm,'') AS dsserm, ag.dstagl, oc.quanti,
      COALESCE(ra.qtamin,1) AS ra_qtamin, COALESCE(ra.qtamul,1) AS ra_qtamul, COALESCE(ra.qtamax,0) AS ra_qtamax,
      COALESCE(rm.qtamin,1) AS rm_qtamin, COALESCE(rm.qtamul,1) AS rm_qtamul
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anatgl ag ON tp.cdtagl = ag.cdtagl
      LEFT JOIN Go2B\Models\Tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN Go2B\Models\Tpgene tg ON tp.tpgene = tg.tpgene
      LEFT JOIN Go2B\Models\Artcol ac ON oc.cdarti = ac.cdarti AND oc.cdcolo = ac.cdcolo
      LEFT JOIN Go2B\Models\Regqta ra ON ra.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Regqtm rm ON rm.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Anaper ap ON aa.cdpers = ap.cdpers
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      WHERE oc.nuordc = :nuordc:
      GROUP BY oc.nurorc
      $orderBy";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getZanottiOrderRowsForXls($nuordc) {
    $query = "SELECT oc.nurorc, tp.flimag AS flimag_n, aa.flimag AS flimag_i,
      tp.cdartn, tp.dsartn, oc.cdarti, aa.dsarti, aa.cdpers, COALESCE(ap.dspers,aa.cdpers) AS dspers,
      COALESCE(ac.cdcolo,aa.cdcolo) AS cdcolo, COALESCE(ac.dscolo,aa.dscolo) AS dscolo, oc.cdvari,
      tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, COALESCE(sb.valore,'') AS bolla,
      COALESCE(st.valore,'') AS tomaia, COALESCE(sc.valore,'') AS tacco,
      COALESCE(rc.prezzo,0) AS prezzo_r, COALESCE(rc.cdvalu,'') AS cdvalu_r,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, lm.dslinm, tl.dstitl, COALESCE(sm.dsserm,'') AS dsserm,
      ag.dstagl, oc.quanti,
      COALESCE(ra.qtamin,1) AS ra_qtamin, COALESCE(ra.qtamul,1) AS ra_qtamul, COALESCE(ra.qtamax,0) AS ra_qtamax,
      COALESCE(rm.qtamin,1) AS rm_qtamin, COALESCE(rm.qtamul,1) AS rm_qtamul
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anatgl ag ON tp.cdtagl = ag.cdtagl
      LEFT JOIN Go2B\Models\Tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN Go2B\Models\Artcol ac ON oc.cdarti = ac.cdarti AND oc.cdcolo = ac.cdcolo
      LEFT JOIN Go2B\Models\Regqta ra ON ra.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Regqtm rm ON rm.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Anaper ap ON aa.cdpers = ap.cdpers
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Sparti sb ON sb.cdarti = aa.cdarti AND sb.tpcomp = 'BOLLA'
      LEFT JOIN Go2B\Models\Sparti st ON st.cdarti = aa.cdarti AND st.tpcomp = 'TOMAIA'
      LEFT JOIN Go2B\Models\Sparti sc ON sc.cdarti = aa.cdarti AND sc.tpcomp = 'TACCO'
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anagra an ON an.tpanag = ot.tpanag AND an.cdanag = ot.cdanag
      LEFT JOIN Go2B\Models\Lscorp rc ON rc.nulist = an.rulist AND rc.cdarti = aa.cdarti
      WHERE oc.nuordc = :nuordc:
      GROUP BY oc.nurorc
      ORDER BY lm.seqrap, sm.seqrap, tp.cdartn, oc.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrderRowsForXlsConfigurator($nuordc) {


    $query = "SELECT oc1.nurorc, tp.flimag AS flimag_n, aa.flimag AS flimag_i,
      tp.cdartn, tp.dsartn, oc1.cdarti, oc1.cdcolo AS cdcolo, '' AS cdvari,
      tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, tp.tpgene, COALESCE(tg.dsgene,'') AS dsgene,
      DATE_FORMAT(oc1.dtmcli, '%d/%m/%Y') AS dtmcli, lm.dslinm, tl.dstitl,
      COALESCE(sm.dsserm,'') AS dsserm, ag.dstagl, oc1.quanti,
      COALESCE(ra.qtamin,1) AS ra_qtamin, COALESCE(ra.qtamul,1) AS ra_qtamul, COALESCE(ra.qtamax,0) AS ra_qtamax,
      COALESCE(rm.qtamin,1) AS rm_qtamin, COALESCE(rm.qtamul,1) AS rm_qtamul,
      oc1.seqrap
      FROM occorp oc1
      INNER JOIN anaart aa ON oc1.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN anatgl ag ON tp.cdtagl = ag.cdtagl
      LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN tpgene tg ON tp.tpgene = tg.tpgene
      LEFT JOIN regqta ra ON ra.cdartn = aa.cdartn
      LEFT JOIN regqtm rm ON rm.cdartn = aa.cdartn
      LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      WHERE oc1.nuordc = :nuordc AND oc1.cdcolo != 'CUSTOM'
      GROUP BY oc1.nurorc
      UNION
      SELECT oc2.nurorc, tp.flimag AS flimag_n, tp.flimag AS flimag_i,
      tp.cdartn, tp.dsartn, oc2.cdarti, oc2.cdcolo AS cdcolo, '' AS cdvari,
      tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, tp.tpgene, COALESCE(tg.dsgene,'') AS dsgene,
      DATE_FORMAT(oc2.dtmcli, '%d/%m/%Y') AS dtmcli, lm.dslinm, tl.dstitl,
      COALESCE(sm.dsserm,'') AS dsserm, ag.dstagl, oc2.quanti,
      COALESCE(ra.qtamin,1) AS ra_qtamin, COALESCE(ra.qtamul,1) AS ra_qtamul, COALESCE(ra.qtamax,0) AS ra_qtamax,
      COALESCE(rm.qtamin,1) AS rm_qtamin, COALESCE(rm.qtamul,1) AS rm_qtamul,
      oc2.seqrap
      FROM occorp oc2
      INNER JOIN ocpert pt ON pt.nuordc = oc2.nuordc AND pt.nupers = oc2.cdarti
      INNER JOIN tipolo tp ON pt.cdartn = tp.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN anatgl ag ON tp.cdtagl = ag.cdtagl
      LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN tpgene tg ON tp.tpgene = tg.tpgene
      LEFT JOIN regqta ra ON ra.cdartn = tp.cdartn
      LEFT JOIN regqtm rm ON rm.cdartn = tp.cdartn
      LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      WHERE oc2.nuordc = :nuordc AND oc2.cdcolo = 'CUSTOM'
      GROUP BY oc2.nurorc
      ORDER BY seqrap ASC";
    return Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrderRowsForSummary($items) {
    $params = array('nuordc' => $items['nuordc'], 'tpdato' => 'des_' . strtolower($items['idlang']));

    // Dsarti, dsartn translation
    if ($items['idlang'] != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $leftJoinDsartn = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang ";
      $leftJoinDsarti = "LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang ";
      $params['idlang'] = $items['idlang'];
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dsartn = 'tp.dsartn AS dsartn';
      $leftJoinDsartn = $leftJoinDsarti = '';
    }

    // Order by
    $orderBy = "";
    switch ($items['ordering']) {
      case 0:
        $orderBy = "ORDER BY oc.cdarti, oc.seqdet ";
        break;
      case 1:
        $orderBy = "ORDER BY oc.seqrap ";
        break;
      case 2:
        $orderBy = "ORDER BY oc.seqrap DESC ";
        break;
    }

    $query = "SELECT oc.nurorc, oc.cdarti, aa.cdpers, oc.cdcolo,
      COALESCE(ac.flimag,'') AS flimag_c, aa.dscolo, aa.flimag AS flimag_i, tp.cdartn,
      $dsarti, $dsartn, tp.flimag AS flimag_n, tp.cdtagl, tp.tppers, oc.cdvari,
      COALESCE(av.dsvari,'') AS dsvari, COALESCE(av.preagg,'') AS preagg,
      oc.quanti, COALESCE(sc.dsscad,'') AS dsscad,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, oc.sgrifc,
      oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
      oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
      tp.tpmode, COALESCE(i.valore,tm.dstmod,'') AS dstmod,
      COALESCE(oa.cdasso,'') AS cdasso, COALESCE(oa.quanti,'') AS asso_quanti,
      lm.cdlinm, lm.dslinm, COALESCE(sm.cdserm,'') AS cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      tl.dstitl, tp.tppers, tp.tglini, tp.tglfin, oc.cddesm AS cddesm,
      COALESCE(dd.codic2,'') AS dtdrop, COALESCE(dd2.valore,'') AS cddrop,
      COALESCE(op.prezzo, 0) AS promo_prezzo, COALESCE(op.scont1, 0) AS promo_scont1,
      COALESCE(op.scont2, 0) AS promo_scont2, COALESCE(op.scont3, 0) AS promo_scont3
      FROM occorp oc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN artcol ac ON ac.cdarti = oc.cdarti AND ac.cdcolo = oc.cdcolo
      LEFT JOIN indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      LEFT JOIN b2b_addinf dd ON dd.tabell = 'anaart' AND dd.codic1 = aa.cdarti AND dd.tpdato = 'dtmcli'
      LEFT JOIN b2b_addinf dd2 ON dd2.tabell = 'anaper' AND dd2.codic1 = aa.cdpers AND dd2.tpdato = 'cddrop'
      LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN b2b_addinf i ON i.tabell = 'tpmode' AND i.codic1 = tp.tpmode AND i.codic2 = '' AND i.tpdato = :tpdato
      $leftJoinDsartn
      $leftJoinDsarti
      LEFT JOIN artvar av ON av.cdarti = oc.cdarti AND av.cdvari = oc.cdvari
      LEFT JOIN ocasso oa ON oa.nurorc = oc.nurorc
      LEFT JOIN ocproc op ON op.nuordc = ot.nuordc AND op.cdarti = oc.cdarti
      WHERE ot.nuordc = :nuordc AND ot.flstat != 0 AND ot.flstat != 4
      GROUP BY oc.nurorc
      $orderBy ";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getCustomSummaryOrderRows($items) {
    $params = array('nuordc' => $items['nuordc'], 'tpdato' => 'des_' . strtolower($items['idlang']));

    // Dsarti, dsartn translation
    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $leftJoinDsartn = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang ";
      $params['idlang'] = $items['idlang'];
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $leftJoinDsartn = '';
    }

    // Order by
    $orderBy = "";
    switch ($items['ordering']) {
      case 0:
        $orderBy = "ORDER BY oc.cdarti, oc.seqdet ";
        break;
      case 1:
        $orderBy = "ORDER BY oc.seqrap ";
        break;
      case 2:
        $orderBy = "ORDER BY oc.seqrap DESC ";
        break;
    }

    $query = "SELECT oc.nurorc, oc.cdarti, '' AS cdpers, oc.cdcolo,
      '' AS flimag_c, '' AS dscolo, tp.flimag AS flimag_i, tp.cdartn,
      CONCAT(tp.cdartn, '-', pt.nupers) AS dsarti, $dsartn, tp.flimag AS flimag_n,
      tp.cdtagl, tp.tppers, oc.cdvari, '' AS dsvari, 0 AS preagg,
      oc.quanti, COALESCE(sc.dsscad,'') AS dsscad,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, oc.sgrifc,
      oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
      oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
      tp.tpmode, COALESCE(i.valore, tm.dstmod,'') AS dstmod,
      '' AS cdasso, 0 AS asso_quanti, lm.cdlinm, lm.dslinm,
      COALESCE(sm.cdserm,'') AS cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      tl.dstitl, tp.tppers, tp.tglini, tp.tglfin,
      0 AS promo_prezzo, 0 AS promo_scont1, 0 AS promo_scont2, 0 AS promo_scont3
      FROM occorp oc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN ocpert pt ON pt.nupers = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = pt.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN b2b_addinf i ON i.tabell = 'tpmode' AND i.codic1 = tp.tpmode AND i.codic2 = '' AND i.tpdato = :tpdato
      $leftJoinDsartn
      WHERE ot.nuordc = :nuordc AND ot.flstat != 0 AND ot.flstat != 4
      GROUP BY oc.nurorc
      $orderBy";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getCartOrderRows($id_usr, $ordering, $idlang = 'IT') {
    $params = array('id_usr' => $id_usr, 'tpdato' => 'des_' . strtolower($idlang));
    $orderBy = self::getOrderBy($ordering);

    if ($idlang != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang
                 LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
    }

    $query = "SELECT oc.nurorc, oc.cdarti, aa.cdpers, oc.cdcolo,
      COALESCE(ac.flimag,'') AS flimag_c, aa.dscolo, aa.flimag AS flimag_i,
      tp.cdartn, $dsarti, $dsartn, tp.flimag AS flimag_n, tp.cdtagl, tp.tppers,
      oc.cdvari, COALESCE(av.dsvari,'') AS dsvari,
      tp.tpmode, COALESCE(i.valore,tm.dstmod,'') AS dstmod,
      COALESCE(av.preagg,0) AS preagg, oc.quanti, COALESCE(sc.dsscad,'') AS dsscad,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, oc.dtmcli AS dtmcli_raw,
      oc.sgrifc, oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
      oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
      COALESCE(oa.cdasso,'') AS cdasso, COALESCE(oa.quanti,'') AS asso_quanti,
      lm.cdlinm, lm.dslinm, COALESCE(sm.cdserm,'') AS cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      tl.dstitl, tp.tppers, tp.tglini, tp.tglfin, oc.cddesm AS cddesm,
      COALESCE(dd.codic2,'') AS dtdrop, COALESCE(dd2.valore,'') AS cddrop,
      COALESCE(rm.qtamin, 1) AS rm_qtamin, COALESCE(rm.qtamul, 1) AS rm_qtamul,
      COALESCE(op.prezzo, 0) AS promo_prezzo,
      COALESCE(op.scont1, 0) AS promo_scont1,
      COALESCE(op.scont2, 0) AS promo_scont2,
      COALESCE(op.scont3, 0) AS promo_scont3,
      COALESCE((
        SELECT COUNT(oc1.nurorc)
        FROM occorp oc1
        WHERE oc1.nuordc = oc.nuordc
        AND oc1.cdarti = oc.cdarti AND oc1.cdcolo = oc.cdcolo
        AND oc1.cdvari = oc.cdvari),0) AS doubleCount
      FROM occorp oc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN b2b_addinf i ON i.tabell = 'tpmode' AND i.codic1 = tp.tpmode AND i.codic2 = '' AND i.tpdato = :tpdato
      LEFT JOIN b2b_addinf dd ON dd.tabell = 'anaart' AND dd.codic1 = aa.cdarti AND dd.tpdato = 'dtmcli'
      LEFT JOIN b2b_addinf dd2 ON dd2.tabell = 'anaper' AND dd2.codic1 = aa.cdpers AND dd2.tpdato = 'cddrop'
      $lnJoin
      LEFT JOIN artcol ac ON ac.cdarti = oc.cdarti AND ac.cdcolo = oc.cdcolo
      LEFT JOIN artvar av ON av.cdarti = oc.cdarti AND av.cdvari = oc.cdvari
      LEFT JOIN ocasso oa ON oa.nurorc = oc.nurorc
      LEFT JOIN ocproc op ON op.nuordc = ot.nuordc AND op.cdarti = oc.cdarti
      LEFT JOIN regqtm rm ON rm.cdartn = tp.cdartn
      WHERE ot.id_usr = :id_usr AND ot.flstat = 0
      GROUP BY oc.nurorc
      $orderBy";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getCustomCartOrderRows($id_usr, $ordering, $idlang = 'IT') {
    $params = array('id_usr' => $id_usr, 'tpdato' => 'des_' . strtolower($idlang));
    $orderBy = self::getOrderBy($ordering);

    if ($idlang != 'IT') {
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
    }

    $query = "SELECT oc.nurorc, oc.cdarti, '' AS cdpers, oc.cdcolo,
      '' AS flimag_c, tp.flimag AS flimag_i, tp.cdartn, CONCAT(tp.cdartn, '-', pt.nupers) AS dsarti,
      $dsartn, tp.flimag AS flimag_n, tp.cdtagl, tp.tppers, oc.cdvari, '' AS dsvari,
      tp.tpmode, COALESCE(i.valore,tm.dstmod,'') AS dstmod, 0 AS preagg, oc.quanti,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, oc.dtmcli AS dtmcli_raw,
      COALESCE(sc.dsscad,'') AS dsscad, oc.sgrifc, oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
      oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
      '' AS cdasso, '' AS asso_quanti, lm.cdlinm, lm.dslinm,
      COALESCE(sm.cdserm,'') AS cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      tl.dstitl, tp.tppers, tp.tglini, tp.tglfin, oc.cddesm AS cddesm,
      COALESCE(rm.qtamin, 1) AS rm_qtamin, COALESCE(rm.qtamul, 1) AS rm_qtamul,
      0 AS promo_prezzo, 0 AS promo_scont1, 0 AS promo_scont2, 0 AS promo_scont3,
      0 AS doubleCount
      FROM occorp oc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN ocpert pt ON pt.nupers = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = pt.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN b2b_addinf i ON i.tabell = 'tpmode' AND i.codic1 = tp.tpmode AND i.codic2 = '' AND i.tpdato = :tpdato
      $lnJoin
      LEFT JOIN regqtm rm ON rm.cdartn = tp.cdartn
      WHERE ot.id_usr = :id_usr AND ot.flstat = 0
      GROUP BY oc.nurorc
      $orderBy";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrderDetailRows($nuordc, $ordering, $idlang = 'IT') {
    $params = array('nuordc' => $nuordc);
    $orderBy = self::getOrderBy($ordering);




    if ($idlang != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang
                 LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
    }

    $query = "SELECT oc.nurorc, oc.cdarti, aa.cdpers, oc.cdcolo, aa.tpvend,
      COALESCE(ac.flimag,'') AS flimag_c, aa.dscolo, aa.flimag AS flimag_i,
      tp.cdartn, $dsarti, $dsartn, tp.flimag AS flimag_n, tp.cdtagl, tp.tppers,
      oc.cdvari, COALESCE(av.dsvari,'') AS dsvari, tp.tpmode,
      COALESCE(av.preagg,0) AS preagg, oc.quanti,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, oc.dtmcli AS dtmcli_raw,
      COALESCE(sc.dsscad,'') AS dsscad, oc.sgrifc, oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
      oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
      COALESCE(oa.cdasso,'') AS cdasso, COALESCE(oa.quanti,'') AS asso_quanti,
      tl.dstitl, tp.tppers, tp.tglini, tp.tglfin,
      COALESCE(op.prezzo, 0) AS promo_prezzo,
      COALESCE(op.scont1, 0) AS promo_scont1,
      COALESCE(op.scont2, 0) AS promo_scont2,
      COALESCE(op.scont3, 0) AS promo_scont3
      FROM occorp oc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      $lnJoin
      LEFT JOIN artcol ac ON ac.cdarti = oc.cdarti AND ac.cdcolo = oc.cdcolo
      LEFT JOIN artvar av ON av.cdarti = oc.cdarti AND av.cdvari = oc.cdvari
      LEFT JOIN ocasso oa ON oa.nurorc = oc.nurorc
      LEFT JOIN ocproc op ON op.nuordc = ot.nuordc AND op.cdarti = oc.cdarti
      WHERE ot.nuordc = :nuordc
      GROUP BY oc.nurorc
      $orderBy";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getCustomOrderDetailRows($nuordc, $ordering, $idlang = 'IT') {
    $params = array('nuordc' => $nuordc);
    $orderBy = self::getOrderBy($ordering);


    if ($idlang != 'IT') {
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
    }

    $query = "SELECT oc.nurorc, oc.cdarti, '' AS cdpers, oc.cdcolo, '' AS tpvend,
      COALESCE(ac.flimag,'') AS flimag_c, '' AS dscolo, '' AS flimag_i,
      tp.cdartn, CONCAT(tp.cdartn, '-', pt.nupers) AS dsarti, $dsartn,
      tp.flimag AS flimag_n, tp.cdtagl, tp.tppers,
      oc.cdvari, COALESCE(av.dsvari,'') AS dsvari, tp.tpmode,
      COALESCE(av.preagg,0) AS preagg, oc.quanti,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, oc.dtmcli AS dtmcli_raw,
      COALESCE(sc.dsscad,'') AS dsscad, oc.sgrifc, oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
      oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
      COALESCE(oa.cdasso,'') AS cdasso, COALESCE(oa.quanti,'') AS asso_quanti,
      tl.dstitl, tp.tppers, tp.tglini, tp.tglfin,
      COALESCE(op.prezzo, 0) AS promo_prezzo,
      COALESCE(op.scont1, 0) AS promo_scont1,
      COALESCE(op.scont2, 0) AS promo_scont2,
      COALESCE(op.scont3, 0) AS promo_scont3
      FROM occorp oc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN ocpert pt ON pt.nupers = oc.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = pt.cdartn
      INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      $lnJoin
      LEFT JOIN artcol ac ON ac.cdarti = oc.cdarti AND ac.cdcolo = oc.cdcolo
      LEFT JOIN artvar av ON av.cdarti = oc.cdarti AND av.cdvari = oc.cdvari
      LEFT JOIN ocasso oa ON oa.nurorc = oc.nurorc
      LEFT JOIN ocproc op ON op.nuordc = ot.nuordc AND op.cdarti = oc.cdarti
      WHERE ot.nuordc = :nuordc
      GROUP BY oc.nurorc
      $orderBy";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getPdfOrderRows($nuordc, $ordering, $style, $idlang = 'IT') {
    $params = array('nuordc' => $nuordc);
    $orderBy = self::getOrderBy($ordering);
    $dsscad = '';

    // Overwrite $orderBy if style is 1 or 999
    switch ($style) {
      case 1:
        $orderBy = 'ORDER BY tl.dstitl, ' . ($idlang != 'IT' ? 'dslinm' : 'lm.dslinm');
        break;
      // case 100:
      //   $orderBy = 'ORDER BY tp.cdlinm, oc.seqrap, oc.nurorc';
      //   break;
      case 200:
        $orderBy = 'ORDER BY lm.seqrap, sm.seqrap, tp.cdartn, oc.cdarti';
        break;
      case 300:
        $orderBy = 'ORDER BY oc.dtmcli, oc.seqrap';
        $dsscad  = 'sc2.dsscad, ';
        break;
      case 999:
        $orderBy = 'ORDER BY tp.cdartn, oc.cdarti, oc.seqdet';
        break;
    }

    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(d3.descri,lm.dslinm) AS dslinm';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d3 ON d3.tpdato = 'dslinm' AND d3.codic1 = lm.cdlinm AND d3.idlang = :idlang: ";
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = '';
    }

    $style999Info = $style == 999
      ? '(SELECT COUNT(ocs.nurorc)
        FROM Go2B\Models\Occorp ocs
        INNER JOIN Go2B\Models\Octest ots ON ots.nuordc = ocs.nuordc
        INNER JOIN Go2B\Models\Anaart aas ON aas.cdarti = ocs.cdarti
        WHERE ots.id_usr = ot.id_usr AND ots.nuordc = ot.nuordc AND aas.cdartn = tp.cdartn) AS arti_rows, '
      : '';

    $query = "SELECT oc.nurorc, oc.seqrap, tp.cdtagl, tp.tppers, oc.quanti,
      DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, COALESCE($dsscad sc.dsscad,'') AS dsscad,
      oc.sgrifc, oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
      oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
      tp.cdartn, $dsartn, tp.flimag AS flimag_n,
      $style999Info
      oc.cdarti, $dsarti, aa.flimag AS flimag_i, aa.cdpers, aa.tpvend,
      oc.cdcolo, COALESCE(ac.dscolo,aa.dscolo) AS dscolo, COALESCE(ac.flimag,'') AS flimag_c,
      oc.cdvari, COALESCE(av.dsvari,'') AS dsvari, COALESCE(av.preagg,0) AS preagg,
      COALESCE(oa.cdasso,'') AS cdasso, COALESCE(oa.quanti,'') AS asso_quanti,
      tl.dstitl, tp.cdlinm, $dslinm, tp.cdserm, COALESCE(sm.dsserm,'') AS dsserm,
      COALESCE(rc.prezzo,0) AS prezzo_r, COALESCE(rc.cdvalu,0) AS cdvalu_r,
      COALESCE(dd.codic2,'') AS dtdrop, COALESCE(dd2.valore,'') AS cddrop, oc.cddesm
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN Go2B\Models\Noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN Go2B\Models\Scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      LEFT JOIN Go2B\Models\Scmcon sc2 ON oc.cdcata = sc2.cdcata AND oc.dtmcli = sc2.dtmcli AND oc.cdarti = sc2.cdarti
      LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = oc.cdarti AND ac.cdcolo = oc.cdcolo
      LEFT JOIN Go2B\Models\Artvar av ON av.cdarti = oc.cdarti AND av.cdvari = oc.cdvari
      LEFT JOIN Go2B\Models\Ocasso oa ON oa.nurorc = oc.nurorc
      LEFT JOIN Go2B\Models\Anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag
      LEFT JOIN Go2B\Models\Lscorp rc ON rc.cdarti = aa.cdarti AND rc.nulist = ag.rulist
      LEFT JOIN Go2B\Models\B2bAddinf dd ON dd.tabell = 'anaart' AND dd.codic1 = aa.cdarti AND dd.tpdato = 'dtmcli'
      LEFT JOIN Go2B\Models\B2bAddinf dd2 ON dd2.tabell = 'anaper' AND dd2.codic1 = aa.cdpers AND dd2.tpdato = 'cddrop'
      $lnJoin
      WHERE ot.nuordc = :nuordc:
      GROUP BY oc.nurorc
      $orderBy ";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getConfiguratorPdfOrderRows($nuordc, $ordering, $idlang = 'IT') {
    $params = array('nuordc' => $nuordc);
    $orderBy = self::getConfiguratorOrderBy($ordering);

    $dsarti2 = "'' AS dsarti";
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(d3.descri,lm.dslinm) AS dslinm';
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang
                 LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang
                 LEFT JOIN deslin d3 ON d3.tpdato = 'dslinm' AND d3.codic1 = lm.cdlinm AND d3.idlang = :idlang ";
      $lnJoin2 = "LEFT JOIN deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang
                 LEFT JOIN deslin d3 ON d3.tpdato = 'dslinm' AND d3.codic1 = lm.cdlinm AND d3.idlang = :idlang ";
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = $lnJoin2 = '';
    }

    $query = "SELECT DISTINCT tt.nurorc, tt.seqrap, tt.seqdet, tt.cdtagl,
      tt.tppers, tt.quanti, tt.dtmcli, tt.dsscad, tt.sgrifc, tt.tpindo,
      tt.dsindo, tt.indorc, tt.tpnoco, tt.noccom_dsnoco, tt.dsnoco, tt.cdartn,
      tt.dsartn, tt.flimag_n, tt.cdarti, tt.flimag_i, tt.cdpers, tt.tpvend,
      tt.cdcolo, tt.dscolo, tt.flimag_c, tt.cdvari, tt.dsvari, tt.preagg,
      tt.cdasso, tt.asso_quanti, tt.dstitl, tt.cdlinm, tt.dslinm, tt.cdserm,
      tt.dsserm, 0 AS prezzo_r, 0 AS cdvalu_r
      FROM (
        SELECT oc.nurorc AS nurorc, oc.seqrap AS seqrap, oc.seqdet AS seqdet,
        tp.cdtagl, tp.tppers, oc.quanti,
        DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli, COALESCE(sc.dsscad,'') AS dsscad,
        oc.sgrifc, oc.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc.indorc,
        oc.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc.dsnoco,
        tp.cdartn, $dsartn, tp.flimag AS flimag_n,
        oc.cdarti AS cdarti, $dsarti, aa.flimag AS flimag_i, aa.cdpers, aa.tpvend,
        oc.cdcolo, COALESCE(ac.dscolo,aa.dscolo) AS dscolo, COALESCE(ac.flimag,'') AS flimag_c,
        oc.cdvari, '' AS dsvari, 0 AS preagg, '' AS cdasso, '' AS asso_quanti,
        tl.dstitl, tp.cdlinm, $dslinm, tp.cdserm, COALESCE(sm.dsserm,'') AS dsserm,
        0 AS prezzo_r, 0 AS cdvalu_r
        FROM occorp oc
        INNER JOIN octest ot ON ot.nuordc = oc.nuordc
        INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
        INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
        LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
        INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN indorc ic ON oc.tpindo = ic.tpindo
        LEFT JOIN noccom nc ON oc.tpnoco = nc.tpnoco
        LEFT JOIN scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
        LEFT JOIN artcol ac ON ac.cdarti = oc.cdarti AND ac.cdcolo = oc.cdcolo
        LEFT JOIN anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag
        $lnJoin
        WHERE ot.nuordc = :nuordc AND oc.cdcolo != 'CUSTOM'
        UNION
        SELECT oc2.nurorc AS nurorc, oc2.seqrap AS seqrap, oc2.seqdet AS seqdet,
        tp.cdtagl, tp.tppers, oc2.quanti,
        DATE_FORMAT(oc2.dtmcli, '%d/%m/%Y') AS dtmcli, COALESCE(sc.dsscad,'') AS dsscad,
        oc2.sgrifc, oc2.tpindo, COALESCE(ic.dsindo,'') AS dsindo, oc2.indorc,
        oc2.tpnoco, COALESCE(nc.dsnoco,'') AS noccom_dsnoco, oc2.dsnoco,
        tp.cdartn, $dsartn, tp.flimag AS flimag_n,
        oc2.cdarti AS cdarti, $dsarti2, '' AS flimag_i, '' AS cdpers, '' AS tpvend,
        oc2.cdcolo, COALESCE(ac.dscolo,'') AS dscolo, COALESCE(ac.flimag,'') AS flimag_c,
        oc2.cdvari, '' AS dsvari, 0 AS preagg, '' AS cdasso, '' AS asso_quanti,
        tl.dstitl, tp.cdlinm, $dslinm, tp.cdserm, COALESCE(sm.dsserm,'') AS dsserm,
        0 AS prezzo_r, 0 AS cdvalu_r
        FROM occorp oc2
        INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
        INNER JOIN ocpert pt ON pt.nuordc = oc2.nuordc AND pt.nupers = oc2.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = pt.cdartn
        INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
        LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
        INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN indorc ic ON oc2.tpindo = ic.tpindo
        LEFT JOIN noccom nc ON oc2.tpnoco = nc.tpnoco
        LEFT JOIN scacon sc ON oc2.cdcata = sc.cdcata AND oc2.dtmcli = sc.dtmcli
        LEFT JOIN artcol ac ON ac.cdarti = oc2.cdarti AND ac.cdcolo = oc2.cdcolo
        LEFT JOIN anagra ag ON ag.tpanag = ot2.tpanag AND ag.cdanag = ot2.cdanag
        $lnJoin2
        WHERE ot2.nuordc = :nuordc AND oc2.cdcolo = 'CUSTOM'
        GROUP BY nurorc
        $orderBy
      ) AS tt
      GROUP BY tt.nurorc";

    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getPdfOrderRowsInfo($nuordc, $ordering, $idlang = 'IT') {
    $params = array('nuordc' => $nuordc, 'idlang' => $idlang);
    $orderBy = self::getOrderBy($ordering);

    if ($idlang != 'IT') {
      $dsartn = 'COALESCE(d2.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsartn' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $lnJoin = '';
    }

    $query = "SELECT DISTINCT tp.cdartn, $dsartn, tp.flimag AS flimag_n,
      oc.cdarti, $dsarti, aa.flimag AS flimag_i,
      aa.cdpers, ap.dspers, ap.compos, ap.flimag AS flimag_p,
      oc.cdcolo, COALESCE(ac.dscolo,aa.dscolo) AS dscolo, COALESCE(ac.flimag,'') AS flimag_c,
      COALESCE(dc.descri,'') AS dscomm, COALESCE(dt.descri,'') AS dstecn
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = oc.cdarti AND ac.cdcolo = oc.cdcolo
      LEFT JOIN Go2B\Models\Desart dc ON dc.tpinpu = 'AN' AND dc.codice = tp.cdartn AND dc.tpdesc = 'COMM' AND dc.idlang = :idlang:
      LEFT JOIN Go2B\Models\Desart dt ON dt.tpinpu = 'AN' AND dt.codice = tp.cdartn AND dt.tpdesc = 'TECN' AND dt.idlang = :idlang:
      $lnJoin
      WHERE ot.nuordc = :nuordc:
      $orderBy ";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getMinimalOrderRows($nuordc, $cdarti, $cdcolo, $nurorc = null) {
    if ($nurorc != null) {
      $params = array('nurorc' => $nurorc);
      $where = 'WHERE oc.nurorc = :nurorc:';
    } else {
      $params = array('nuordc' => $nuordc, 'cdarti' => $cdarti, 'cdcolo' => $cdcolo);
      $where = 'WHERE oc.nuordc = :nuordc: AND oc.cdarti = :cdarti: AND oc.cdcolo = :cdcolo:';
    }
    $query = "SELECT oc.*
      FROM Go2B\Models\Occorp oc
      $where
      ORDER BY oc.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrderRowsWithTotals($nuordc) {
    $query = "SELECT oc.nuordc, oc.nurorc, oc.cdarti, aa.dsarti, oc.cdcolo, oc.cdvari,
      COALESCE(av.dsvari,'') AS dsvari, DATE_FORMAT(oc.dtmcli, '%d/%m/%Y') AS dtmcli,
      oc.quanti,
      (SELECT SUM(og.quanti * og.prezzo * (1 - (og.scont1 / 100)))
        FROM Go2B\Models\Octagl og
        WHERE oc.nurorc = og.nurorc) AS totnet,
      (SELECT SUM(og.quanti * og.prezzo)
        FROM Go2B\Models\Octagl og
        WHERE oc.nurorc = og.nurorc) AS totgrs
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\Artvar av ON av.cdarti = oc.cdarti AND av.cdvari = oc.cdvari
      WHERE oc.nuordc = :nuordc:
      ORDER BY oc.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getXlsCategoriesRows($nuordc, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $dslinm = "COALESCE(d2.descri,lm.dslinm) AS dslinm";
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = lm.cdlinm AND d2.idlang = :idlang: ";
      $params = array('nuordc' => $nuordc, 'idlang' => $idlang);
    } else {
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = '';
      $params = array('nuordc' => $nuordc);
    }

    $query = "SELECT DISTINCT tl.dstitl, $dslinm, COALESCE(sm.dsserm,'') AS dsserm
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      $lnJoin
      WHERE oc.nuordc = :nuordc:
      ORDER BY tl.dstitl, lm.dslinm, dsserm ";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getXlsCategoriesRowsForConfigurator($nuordc, $idlang = 'IT') {
    $params = array('nuordc' => $nuordc);

    if ($idlang != 'IT') {
      $dslinm = "COALESCE(d2.descri,lm.dslinm) AS dslinm";
      $lnJoin = "LEFT JOIN deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = lm.cdlinm AND d2.idlang = :idlang ";
      $params = array('nuordc' => $nuordc, 'idlang' => $idlang);
    } else {
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = '';
      $params = array('nuordc' => $nuordc);
    }

    $query = "SELECT DISTINCT tt.dstitl, tt.dslinm, tt.dsserm
      FROM (
        SELECT tl.dstitl, $dslinm, COALESCE(sm.dsserm,'') AS dsserm
        FROM occorp oc
        INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
        INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
        INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
        $lnJoin
        WHERE oc.nuordc = :nuordc AND oc.cdcolo != 'CUSTOM'
        UNION
        SELECT tl.dstitl, $dslinm, COALESCE(sm.dsserm,'') AS dsserm
        FROM occorp oc
        INNER JOIN ocpert pt ON pt.nuordc = oc.nuordc AND pt.nupers = oc.cdarti
        INNER JOIN tipolo tp ON tp.cdartn = pt.cdartn
        INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
        INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
        $lnJoin
        WHERE oc.nuordc = :nuordc AND oc.cdcolo = 'CUSTOM'
        GROUP BY dstitl, dslinm, dsserm
      ) AS tt
      GROUP BY tt.dstitl, tt.dslinm, tt.dsserm
      ORDER BY tt.dstitl, tt.dslinm, tt.dsserm";

    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getOrdersAndQuantityForCustomArticle($cdarti) {
    $query = "SELECT oc.nuordc, SUM(oc.quanti) AS quanti
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      WHERE aa.cdarti = :cdarti: AND aa.tpvend = 'CUSTOM'
      GROUP BY oc.nuordc";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getAllArticlesWithNoPrice($catalogs = array(), $seasons = array(), $dates = '') {
    $andWhere = '';
    $params = array();
    if (count($catalogs) > 0) {
      $andWhere .= ' AND ';
      $catalogsOr = '';
      for ($i = 0; $i < count($catalogs); $i++) {
        $params['cdcata' . $i] = $catalogs[$i];
        $catalogsOr .= 'ct.cdcata = :cdcata' . $i . ': OR ';
      }
      $andWhere .= '(' . substr($catalogsOr, 0, -3) . ')';
    }
    if (count($seasons) > 0) {
      $andWhere .= ' AND ';
      $seasonsOr = '';
      for ($i = 0; $i < count($seasons); $i++) {
        $params['cdstag' . $i] = $seasons[$i];
        $seasonsOr .= 'ts.cdstag = :cdstag' . $i . ': OR ';
      }
      $andWhere .= '(' . substr($seasonsOr, 0, -3) . ')';
    }
    if ($dates != '') {
      $dates = explode(',', $dates);
      $andWhere .= ' AND ot.dtcrea >= :dtmini: AND ot.dtcrea <= :dtmaxi: ';
      $params['dtmini'] = $dates[0];
      $params['dtmaxi'] = $dates[1];
    }

    $query = "SELECT oc.cdarti, oc.quanti, oc.nuordc, ot.dtcrea, DATE_FORMAT(ot.dtcrea, '%d/%m/%Y') AS dtcrea_human,
      ot.cdcata, ot.cdstag, COALESCE(ct.dscata,'') AS dscata, COALESCE(ts.dsstag,'') AS dsstag
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Octagl og ON oc.nurorc = og.nurorc
      LEFT JOIN Go2B\Models\Cttest ct ON ct.cdcata = ot.cdcata
      LEFT JOIN Go2B\Models\Tabstg ts ON ts.cdstag = ot.cdstag
      WHERE og.prezzo = 0 $andWhere
      GROUP BY oc.nurorc
      ORDER BY oc.cdarti, oc.nuordc";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp objects
   */
  public static function getArticlesWithNoPrice($nuordc) {
    $query = "SELECT oc.cdarti, oc.quanti
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octagl og ON oc.nurorc = og.nurorc
      WHERE oc.nuordc = :nuordc: AND og.prezzo = 0
      GROUP BY oc.nurorc";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Occorp arrays
   */
  public static function getNumOrdersFromSize($cdtagl, $taglia) {
    $query = "SELECT count(oc.nurorc)
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octagl ot ON ot.nurorc = oc.nurorc
      INNER JOIN Go2B\Models\Anaart ar ON ar.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = ar.cdartn
      WHERE tp.cdtagl = :cdtagl AND ot.dstagl = :taglia
      GROUP BY tp.cdtagl, ot.dstagl";
    return Di::getDefault()->get('db')->query($query, array('cdtagl' => $cdtagl, 'taglia' => $taglia))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Occorp object
   */
  public static function getOrderRowInfoFromNuordcAndNurorc($nuordc, $nurorc) {
    $params = array('nuordc' => $nuordc, 'nurorc' => $nurorc);
    $query = 'SELECT oc.nurorc, oc.cdarti,
      DATE_FORMAT(oc.dtmcli, "%d/%m/%Y") AS dtmcli, oc.dtmcli AS dtmcli_raw,
      COALESCE(sc.dsscad,"") AS dsscad, oc.sgrifc, oc.tpindo,
      COALESCE(ic.dsindo,"") AS dsindo, oc.indorc, oc.tpnoco,
      COALESCE(nc.dsnoco,"") AS noccom_dsnoco, oc.dsnoco
      FROM Go2B\Models\Occorp oc
      LEFT JOIN Go2B\Models\Indorc ic ON oc.tpindo = ic.tpindo
      LEFT JOIN Go2B\Models\Noccom nc ON oc.tpnoco = nc.tpnoco
      LEFT JOIN Go2B\Models\Scacon sc ON oc.cdcata = sc.cdcata AND oc.dtmcli = sc.dtmcli
      WHERE oc.nurorc = :nurorc: AND oc.nuordc = :nuordc:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Occorp object
   */
  public static function getOrderRowFromNuordcAndSeqrap($nuordc, $seqrap) {
    $params = array('nuordc' => $nuordc, 'seqrap' => $seqrap);
    $query = 'SELECT oc.nurorc, oc.cdarti, oc.cdcolo, COALESCE(aa.cdartn,pt.cdartn,"") AS cdartn
      FROM Go2B\Models\Occorp oc
      LEFT JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\Ocpert pt ON oc.cdcolo = "CUSTOM" AND oc.nuordc = pt.nuordc AND oc.cdarti = pt.nupers
      WHERE oc.nuordc = :nuordc: AND oc.seqrap = :seqrap:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Occorp object
   */
  public static function getOrderRowFromNuordcAndSeqrapAndCdarti($nuordc, $seqrap, $cdarti) {
    $params = array('nuordc' => $nuordc, 'cdarti' => $cdarti, 'seqrap' => $seqrap);
    $query = 'SELECT oc.nurorc, oc.cdarti, oc.cdcolo, aa.cdartn
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Anaart aa ON oc.cdarti = aa.cdarti
      WHERE oc.nuordc = :nuordc: AND oc.cdarti = :cdarti: AND oc.seqrap = :seqrap:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Array of int
   * @deprecated
   */
  public static function getCurrentCartTotal($id_usr) {
    $query = 'SELECT SUM(o.quanti) AS tot_cart, COUNT(o.nurorc) AS tot_rows
      FROM Go2B\Models\Occorp o
      INNER JOIN Go2B\Models\Octest t ON t.nuordc = o.nuordc
      WHERE t.id_usr = :id_usr: AND t.flstat = 0';
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr))[0];
    return array(
      'totCart' => $result->tot_cart,
      'totRows' => $result->tot_rows,
      'totSpend' => $result->tot_spend
    );
  }

    /**
     * @param int $nuordc
     * @return array{totCart: int, totRows: int, totSpend: double}
     */
  public static function getOrderTotals($nuordc)
  {
      $query = "SELECT COUNT(DISTINCT o.nurorc) AS tot_rows, SUM(tg.quanti) AS tot_cart, SUM(tg.quanti * tg.prezzo * (1 - tg.scont1 / 100)) AS tot_spend FROM occorp o
         INNER JOIN octest t ON t.nuordc = o.nuordc AND t.flstat = 0 AND t.nuordc = :nuordc
         INNER JOIN octagl tg ON tg.nurorc = o.nurorc"; // AND tg.quanti > 0
      $result = Di::getDefault()->get('db')
          ->query($query, [
              'nuordc' => $nuordc,
          ])->fetch(Db::FETCH_ASSOC);

      return [
          'totCart' => $result['tot_cart'],
          'totRows' => $result['tot_rows'],
          'totSpend' => $result['tot_spend']
      ];
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getTotalOrdersQuantity($dtiniz, $dtfine, $cdstag = -1) {
    $params = array('dtiniz' => $dtiniz, 'dtfine' => $dtfine);
    if ($cdstag != -1) {
      $params['cdstag'] = $cdstag;
      $andWhere = ' AND ot.cdstag = :cdstag: ';
    } else {
      $andWhere = '';
    }
    $query = "SELECT SUM(oc.quanti) AS total
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      WHERE ot.flstat != 0 AND ot.flstat != 4
      AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $andWhere";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->total : 0;
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function isWaitingForQuantity($nuordc) {
    $query = 'SELECT COUNT(o.nurorc) AS presence
      FROM Go2B\Models\Occorp o
      WHERE o.nuordc = :nuordc: AND o.quanti = 0';
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
    return count($result) > 0 ? $result[0]->presence > 0 : true;
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function hasPriceForEveryRow($nuordc) {
    $query = 'SELECT oc.nurorc
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octagl og ON oc.nurorc = og.nurorc
      WHERE oc.nuordc = :nuordc: AND og.prezzo = 0';
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
    return count($result) == 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCurrentCartTotalForArticle($id_usr, $cdarti) {
    $query = 'SELECT SUM(o.quanti) AS tot_arti
      FROM Go2B\Models\Occorp o
      INNER JOIN Go2B\Models\Octest t ON t.nuordc = o.nuordc
      WHERE t.id_usr = :id_usr: AND o.cdarti = :cdarti: AND t.flstat = 0';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr, 'cdarti' => $cdarti))[0]->tot_arti;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCurrentCartTotalForModel($id_usr, $cdarti) {
    $query = 'SELECT SUM(o.quanti) AS tot_artn
      FROM Go2B\Models\Occorp o
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = o.cdarti
      INNER JOIN Go2B\Models\Octest t ON t.nuordc = o.nuordc
      WHERE t.id_usr = :id_usr: AND a.cdartn = (SELECT a1.cdartn FROM Go2B\Models\Anaart a1 WHERE a1.cdarti = :cdarti:) AND t.flstat = 0';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr, 'cdarti' => $cdarti))[0]->tot_artn;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getMaxIndexForOrder($nuordc) {
    $query = "SELECT MAX(o.seqrap) AS seqrap
      FROM Go2B\Models\Occorp o
      WHERE o.nuordc = :nuordc:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('nuordc' => $nuordc));
    return $result != null && $result[0]->seqrap > 0 ? $result[0]->seqrap : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getTotalQuantityAgents($whereCatalogs, $whereAgents, $params) {
    $query = "SELECT SUM(oc.quanti) AS total
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->total : 0;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getTotalQuantityCustomers($whereCatalogs, $whereCustomers, $params) {
    $query = "SELECT SUM(oc.quanti) AS total
      FROM Go2B\Models\Occorp oc
      INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->total : 0;
  }

  /**
   * Query:   INSERT
   * Return:  int
   */
  public static function insertOrderRow($nuordc, $seqrap, $cdarti, $cdcolo, $cdcata, $quanti, $cdvari = '') {
    $occorp = new self;
    $occorp->nuordc = isset($nuordc) && (string)$nuordc !== '' ? (string)$nuordc : 0;
    $occorp->seqrap = isset($seqrap) && (string)$seqrap !== '' ? (string)$seqrap : 0;
    $occorp->cdarti = isset($cdarti) && (string)$cdarti !== '' ? (string)$cdarti : new RawValue('""');
    $occorp->cdcolo = isset($cdcolo) && (string)$cdcolo !== '' ? (string)$cdcolo : new RawValue('""');
    $occorp->cdvari = isset($cdvari) && (string)$cdvari !== '' ? (string)$cdvari : new RawValue('""');
    $occorp->cdcata = isset($cdcata) && (string)$cdcata !== '' ? (string)$cdcata : new RawValue('""');
    $occorp->quanti = isset($quanti) && (string)$quanti !== '' ? (string)$quanti : 0;
    $occorp->seqdet = 1;
    $occorp->dtmcli = '0000-00-00';
    $occorp->sgrifc = new RawValue('""');
    $occorp->tpindo = new RawValue('""');
    $occorp->indorc = new RawValue('""');
    $occorp->tpnoco = new RawValue('""');
    $occorp->dsnoco = new RawValue('""');
    $occorp->save();
    return $occorp->nurorc;
  }

  /**
   * Query:   INSERT
   * Return:  int
   */
  public static function insertNewOrderRowFromAdminDuplicate($order_row, $nuordc) {
    $occorp = new self;
    $occorp->nuordc = $nuordc;
    $occorp->seqrap = $order_row->seqrap ? (string)$order_row->seqrap : 0;
    $occorp->cdarti = $order_row->cdarti ? (string)$order_row->cdarti : new RawValue('""');
    $occorp->cdcolo = $order_row->cdcolo ? (string)$order_row->cdcolo : new RawValue('""');
    $occorp->cdvari = $order_row->cdvari ? (string)$order_row->cdvari : new RawValue('""');
    $occorp->cdcata = $order_row->cdcata ? (string)$order_row->cdcata : new RawValue('""');
    $occorp->quanti = $order_row->quanti ? (string)$order_row->quanti : 0;
    $occorp->seqdet = $order_row->seqdet ? (string)$order_row->seqdet : 1;
    $occorp->dtmcli = '0000-00-00';
    $occorp->sgrifc = $order_row->sgrifc ? (string)$order_row->sgrifc : new RawValue('""');
    $occorp->tpindo = $order_row->tpindo ? (string)$order_row->tpindo : new RawValue('""');
    $occorp->indorc = $order_row->indorc ? (string)$order_row->indorc : new RawValue('""');
    $occorp->tpnoco = $order_row->tpnoco ? (string)$order_row->tpnoco : new RawValue('""');
    $occorp->dsnoco = $order_row->dsnoco ? (string)$order_row->dsnoco : new RawValue('""');
    $occorp->save();
    return $occorp->nurorc;
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function sortOrderRows($nuordc) {
    // First sort with a very big number to avoid duplicate key
    $query = 'UPDATE occorp
      JOIN (SELECT @rank := 999999) r
      SET seqrap = @rank := @rank + 1
      WHERE nuordc = :nuordc ';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc));
    // Then sort as we expect
    $query = 'UPDATE occorp
      JOIN (SELECT @rank := 0) r
      SET seqrap = @rank := @rank + 1
      WHERE nuordc = :nuordc ';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function emptyOrderRow($nurorc) {
    $query = 'UPDATE occorp oc
      SET oc.quanti = 0
      WHERE oc.nurorc = :nurorc';
    Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateMultipleOrderRows($nurorc, $dtmcli = null, $dsnoco = null) {
    $params = array();

    $set = '';
    if (!empty($dtmcli)) {
      $params['dtmcli'] = $dtmcli;
      $set .= ' oc.dtmcli = :dtmcli, ';
    }
    if (!empty($dsnoco)) {
      $params['dsnoco'] = $dsnoco;
      $set .= ' oc.dsnoco = :dsnoco, ';
    }

    $whereNurorc = array();
    for ($i = 0; $i < count($nurorc); $i++) {
      $whereNurorc[] = ':nurorc' . $i;
      $params['nurorc' . $i] = $nurorc[$i];
    }
    $where = implode(',', $whereNurorc);

    $query = "UPDATE occorp oc
      SET $set
      oc.quanti = (SELECT COALESCE(SUM(og.quanti),0) AS quanti FROM octagl og WHERE og.nurorc = oc.nurorc)
      WHERE oc.nurorc IN ($where)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowQuantity($nurorc) {
    $query = 'UPDATE occorp oc
      SET oc.quanti = (SELECT COALESCE(SUM(og.quanti),0) AS quanti FROM octagl og WHERE og.nurorc = :nurorc)
      WHERE oc.nurorc = :nurorc';
    Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowInfo($nurorc, $dtmcli, $dsnoco, $quanti) {
    $query = 'UPDATE occorp oc
      SET oc.dtmcli = :dtmcli, oc.dsnoco = :dsnoco, oc.quanti = :quanti
      WHERE oc.nurorc = :nurorc';
    $params = array('nurorc' => $nurorc, 'dtmcli' => $dtmcli, 'dsnoco' => $dsnoco, 'quanti' => $quanti);
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowFullInfo($nuordc, $nurorc, $dtmcli, $tpindo, $indorc, $tpnoco, $dsnoco, $sgrifc) {
    $params = array(
      'nuordc' => $nuordc,
      'nurorc' => $nurorc,
      'tpindo' => $tpindo,
      'indorc' => $indorc,
      'tpnoco' => $tpnoco,
      'dsnoco' => $dsnoco,
      'sgrifc' => $sgrifc
    );

    $dateInc = '';
    if (!empty($dtmcli)){
      $params['dtmcli'] = $dtmcli;
      $dateInc = ', oc.dtmcli = :dtmcli';
    }
    $query = "UPDATE occorp oc
      SET oc.tpindo = :tpindo $dateInc, oc.indorc = :indorc,
      oc.tpnoco = :tpnoco, oc.dsnoco = :dsnoco, oc.sgrifc = :sgrifc
      WHERE oc.nurorc = :nurorc AND oc.nuordc = :nuordc";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowDate($nurorc, $dtmcli) {
    $query = 'UPDATE occorp oc
      SET oc.dtmcli = :dtmcli
      WHERE oc.nurorc = :nurorc';
    $params = array('nurorc' => $nurorc, 'dtmcli' => $dtmcli);
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowNotes($nurorc, $dsnoco) {
    $query = 'UPDATE occorp oc
      SET oc.dsnoco = :dsnoco
      WHERE oc.nurorc = :nurorc';
    Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc, 'dsnoco' => $dsnoco));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowCdvari($nurorc, $cdvari) {
    $query = 'UPDATE occorp oc
      SET oc.cdvari = :cdvari
      WHERE oc.nurorc = :nurorc';
    Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc, 'cdvari' => $cdvari));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowFromNuordcAndSeqrap($nuordc, $seqrap, $quanti) {
    $query = 'UPDATE occorp oc
      SET oc.quanti = :quanti
      WHERE oc.nuordc = :nuordc AND oc.seqrap = :seqrap';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'seqrap' => $seqrap, 'quanti' => $quanti));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowFromNuordcAndNurorc($nuordc, $nurorc, $quanti) {
    $query = 'UPDATE occorp oc
      SET oc.quanti = :quanti
      WHERE oc.nuordc = :nuordc AND oc.nurorc = :nurorc';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'nurorc' => $nurorc, 'quanti' => $quanti));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateOrderRowFromNuordcAndSeqrapAndCdarti($nuordc, $seqrap, $quanti, $cdarti) {
    $query = 'UPDATE occorp oc
      SET oc.quanti = :quanti
      WHERE oc.nuordc = :nuordc AND oc.cdarti = :cdarti AND oc.seqrap = :seqrap';
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc, 'cdarti' => $cdarti, 'seqrap' => $seqrap, 'quanti' => $quanti));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateRowShipping($nurorc, $cddesm) {
    $query = 'UPDATE occorp oc
      SET oc.cddesm = :cddesm
      WHERE oc.nurorc = :nurorc';
    Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc, 'cddesm' => $cddesm));
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function replaceCustomArticleWithOfficialArticle($oldCdarti, $newCdarti, $newCdcolo) {
    $query = 'UPDATE occorp oc
      SET oc.cdarti = :newcdarti, oc.cdcolo = :newcdcolo
      WHERE oc.cdarti = :old';
    Di::getDefault()->get('db')->query($query, array('newcdarti' => $newCdarti, 'newcdcolo' => $newCdcolo, 'old' => $oldCdarti));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function removeOrderRowForArticle($nuordc, $cdarti) {
    $query = 'DELETE oc.* FROM occorp oc
      WHERE oc.cdarti = :cdarti AND oc.nuordc = :nuordc ';
    Di::getDefault()->get('db')->query($query, array('cdarti' => $cdarti, 'nuordc' => $nuordc));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function removeAllRowsForModel($nuordc, $cdarti) {
    $query = 'DELETE oc.* FROM occorp oc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      WHERE aa.cdartn = (SELECT a.cdartn FROM anaart a WHERE a.cdarti = :cdarti) AND oc.nuordc = :nuordc ';
    Di::getDefault()->get('db')->query($query, array('cdarti' => $cdarti, 'nuordc' => $nuordc));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteMultipleOrderRows($nurorc) {
    $params = array();
    $whereNurorc = array();
    for ($i = 0; $i < count($nurorc); $i++) {
      $whereNurorc[] = ':nurorc' . $i;
      $params['nurorc' . $i] = $nurorc[$i];
    }
    $where = implode(',', $whereNurorc);

    $query = "DELETE oc.*
      FROM occorp oc
      WHERE oc.nurorc IN ($where)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteOrderRowsWithNoQuantity($nuordc) {
    $query = "DELETE oc.*
      FROM occorp oc
      WHERE oc.nuordc = :nuordc AND oc.quanti = 0";
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteOrderRowsForOrder($nuordc) {
    $query = "DELETE oc.*
      FROM occorp oc
      WHERE oc.nuordc = :nuordc";
    Di::getDefault()->get('db')->query($query, array('nuordc' => $nuordc));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCartRowsWithNoQuantity($id_usr) {
    $query = "DELETE oc.*
      FROM occorp oc
      INNER JOIN octest ot ON oc.nuordc = ot.nuordc
      WHERE ot.id_usr = :id_usr AND ot.flstat = 0 AND oc.quanti = 0";
    Di::getDefault()->get('db')->query($query, array('id_usr' => $id_usr));
  }
  //endregion
}
