<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ocasso extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nurorc;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdasso;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $quanti;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ocasso');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nurorc' => isset($rec->nurorc) && (string)$rec->nurorc !== '' ? (string)$rec->nurorc : 0,
      'cdasso' => isset($rec->cdasso) && (string)$rec->cdasso !== '' ? (string)$rec->cdasso : new RawValue('""'),
      'quanti' => isset($rec->quanti) && (string)$rec->quanti !== '' ? (string)$rec->quanti : 0
    );

    $query  = 'nurorc = :nurorc: AND cdasso = :cdasso:';
    $params = array(
      'nurorc' => $values['nurorc'],
      'cdasso' => $values['cdasso']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ocasso objects
   */
  public static function getAssortmentQuantity($nurorc, $checkQuantity = true) {
    $andWhere = $checkQuantity ? 'AND o.quanti > 0' : '';
    $query = "SELECT o.cdasso, o.quanti
      FROM Go2B\Models\Ocasso o
      WHERE o.nurorc = :nurorc: $andWhere
      ORDER BY o.cdasso";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ocasso objects
   */
  public static function getAssortmentQuantityWithAvailability($nurorc, $dtdisp) {
    $query = "SELECT o.cdasso, o.quanti,
      COALESCE(DATE_FORMAT(dc.dtdisp, '%d/%m/%Y'),DATE_FORMAT(:dtdisp:, '%d/%m/%Y')) AS dtdisp,
      COALESCE(dc.quanti -
        COALESCE(
          (SELECT SUM(oa.quanti)
          FROM Go2B\Models\Ocasso oa
          INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = oa.nurorc
          INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
          WHERE oc.cdarti = dc.cdarti AND ot.flstat = 2 AND oa.cdasso = dc.cdasso),
        0),
      0) AS disp
      FROM Go2B\Models\Ocasso o
      INNER JOIN Go2B\Models\Occorp c ON c.nurorc = o.nurorc
      LEFT JOIN Go2B\Models\Dscorp dc ON dc.cdasso = o.cdasso AND dc.cdarti = c.cdarti AND dc.dtdisp = :dtdisp:
      WHERE o.nurorc = :nurorc:
      GROUP BY o.cdasso
      ORDER BY o.cdasso";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc, 'dtdisp' => $dtdisp));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Ocasso objects
   */
  public static function getAssortmentSizeQuantity($nurorc) {
    $query = "SELECT ac.dstagl, (oa.quanti * ac.qtatgl) AS quanti
      FROM Go2B\Models\Ocasso oa
      INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = oa.nurorc
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Ascorp ac ON ac.cdtagl = tp.cdtagl
      WHERE oa.nurorc = :nurorc:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('nurorc' => $nurorc));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function duplicateOrderRowAssortments($oldNurorc, $newNurorc) {
    $params = array('nurorc1' => $oldNurorc, 'nurorc2' => $newNurorc);
    $query = "INSERT INTO ocasso (nurorc, cdasso, quanti)
      SELECT :nurorc2, oa.cdasso, oa.quanti
      FROM ocasso oa
      WHERE oa.nurorc = :nurorc1";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function emptyOrderRow($nurorc) {
    $query = 'UPDATE ocasso oa
      SET oa.quanti = 0
      WHERE oa.nurorc = :nurorc';
    Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc));
  }
  //endregion
}
