<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Modvar extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdregv;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdvari;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('modvar');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdregv' => isset($rec->cdregv) && (string)$rec->cdregv !== '' ? (string)$rec->cdregv : new RawValue('""'),
      'cdvari' => isset($rec->cdvari) && (string)$rec->cdvari !== '' ? (string)$rec->cdvari : new RawValue('""'),
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""')
    );

    $query  = 'cdregv = :cdregv: AND cdvari = :cdvari: AND cdartn = :cdartn:';
    $params = array(
      'cdregv' => $values['cdregv'],
      'cdvari' => $values['cdvari'],
      'cdartn' => $values['cdartn']
    );

    if (trim($tipoagg) == 'del') {
      $row = new self();
      $row->save($values);
    }
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewRecord($cdregv, $cdvari, $cdartn) {
    $query = 'INSERT INTO modvar (cdregv, cdvari, cdartn)
      VALUES(:cdregv, :cdvari, :cdartn)';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'cdvari' => $cdvari, 'cdartn' => $cdartn));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregv($cdregv) {
    $query = 'DELETE m
      FROM modvar m
      WHERE m.cdregv = :cdregv';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari) {
    $query = 'DELETE m
      FROM modvar m
      INNER JOIN tabvar t ON m.cdregv = t.cdregv
      WHERE m.cdregv = :cdregv AND t.tpvari = :tpvari';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'tpvari' => $tpvari));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregvAndCdvari($cdregv, $cdvari) {
    $query = 'DELETE m
      FROM modvar m
      WHERE m.cdregv = :cdregv AND m.cdvari = :cdvari';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'cdvari' => $cdvari));
  }
  //endregion
}
