<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Lsvcat extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $nulist;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $catpre;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdvalu;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $prezzo;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('lsvcat');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nulist' => isset($rec->nulist) && (string)$rec->nulist !== '' ? (string)$rec->nulist : new RawValue('""'),
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'catpre' => isset($rec->catpre) && (string)$rec->catpre !== '' ? (string)$rec->catpre : new RawValue('""'),
      'cdvalu' => isset($rec->cdvalu) && (string)$rec->cdvalu !== '' ? (string)$rec->cdvalu : new RawValue('""'),
      'prezzo' => isset($rec->prezzo) && (string)$rec->prezzo !== '' ? (string)$rec->prezzo : 0
    );

    $query  = 'nulist = :nulist: AND cdartn = :cdartn: AND catpre = :catpre:';
    $params = array(
      'nulist' => $values['nulist'],
      'cdartn' => $values['cdartn'],
      'catpre' => $values['catpre']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
