<?php

namespace Go2B\Models;

use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Lscorp extends Model
{
    //region Fields
    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=10, nullable=false)
     */
    public $nulist;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=30, nullable=false)
     */
    public $cdarti;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=30, nullable=false)
     */
    public $taglia;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdvalu;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $prezzo;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $preven;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('lscorp');
    }
    //endregion

    //region Sync functions
    /**
     * Sync from xml
     */
    public static function saveRecord($rec, $tipoagg)
    {
        $prezzo_vendita = 0;
        if (isset($rec->preven)) {
            $prezzo = explode("|", $rec->preven);
            if (isset($prezzo[0]) && $prezzo[0] > 0) {
                $prezzo_vendita = $prezzo[0];
            } else {
                $prezzo_vendita = $prezzo[1];
            }
        }

        $values = array(
            'nulist' => isset($rec->nulist) && (string) $rec->nulist !== '' ? (string) $rec->nulist : new RawValue('""'),
            'cdarti' => isset($rec->cdarti) && (string) $rec->cdarti !== '' ? (string) $rec->cdarti : new RawValue('""'),
            'taglia' => isset($rec->taglia) && (string) $rec->taglia !== '' ? (string) $rec->taglia : new RawValue('""'),
            'cdvalu' => isset($rec->cdvalu) && (string) $rec->cdvalu !== '' ? (string) $rec->cdvalu : new RawValue('""'),
            'prezzo' => isset($rec->prezzo) && (string) $rec->prezzo !== '' ? (string) $rec->prezzo : 0,
            'preven' => $prezzo_vendita,
        );

        $query  = 'nulist = :nulist: AND cdarti = :cdarti: AND taglia = :taglia:';
        $params = array(
            'nulist' => $values['nulist'],
            'cdarti' => $values['cdarti'],
            'taglia' => $values['taglia'],
        );

        if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
            $row = new self();
        }

        $row->save($values);
    }
    //endregion

    //region Custom queries
    /**
     * Query:   SELECT
     * Return:  Array of Lscorp objects
     */
    public static function getArticlePrices($cdarti, $nulist)
    {
        $query = 'SELECT l.taglia, l.cdvalu, l.prezzo, l.preven
      FROM Go2B\Models\Lscorp l
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = l.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Postgl pt ON pt.taglia = l.taglia AND tp.cdtagl = pt.cdtagl
      WHERE l.nulist = :nulist: AND l.cdarti = :cdarti:
      ORDER BY pt.postgl, l.taglia';
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti, 'nulist' => $nulist));
    }

    /**
     * Query:   SELECT
     * Return:  double
     */
    public static function getPriceForArticle($nulist, $cdarti)
    {
        $params = array('nulist' => $nulist, 'cdarti' => $cdarti);
        $query  = 'SELECT COALESCE(lc.prezzo, 0) AS prezzo
      FROM Go2B\Models\Lscorp lc
      WHERE lc.nulist = :nulist: AND lc.cdarti = :cdarti:';
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($result) > 0 ? $result[0]->prezzo : 0;
    }

    /**
     * Query:   TRUNCATE
     * Return:  void
     */
    public static function emptyTable()
    {
        $query = "TRUNCATE lscorp";
        Di::getDefault()->get('db')->query($query);
    }
    //endregion
}
