<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Lkmode extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlkbk;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlook;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('lkmode');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlkbk' => isset($rec->cdlkbk) && (string)$rec->cdlkbk !== '' ? (string)$rec->cdlkbk : new RawValue('""'),
      'cdlook' => isset($rec->cdlook) && (string)$rec->cdlook !== '' ? (string)$rec->cdlook : new RawValue('""'),
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'cdlkbk = :cdlkbk: AND cdlook = :cdlook: AND cdartn = :cdartn:';
    $params = array(
      'cdlkbk' => $values['cdlkbk'],
      'cdlook' => $values['cdlook'],
      'cdartn' => $values['cdartn']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Lkmode objects
   */
  public static function getModelsForLook($cdlkbk, $cdlook, $nulist, $numdis, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'nulist' => $nulist, 'idlang' => $idlang);
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
    } else {
      $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'nulist' => $nulist);
      $dsartn = 'tp.dsartn AS dsartn';
      $lnJoin = '';
    }

    if ($numdis > 0) {
      $params['numdis'] = $numdis;
      $sconto = 'COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
      $lnJoin .= "LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = tl.cdtitl AND c1.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis: ";
    } else {
      $sconto = '0 AS cust_disc ';
    }

    $query = "SELECT tp.cdartn, $dsartn, tp.flimag,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $sconto
      FROM Go2B\Models\Lkmode km
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = km.cdartn
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = km.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
      $lnJoin
      WHERE km.cdlkbk = :cdlkbk: AND km.cdlook = :cdlook:
      GROUP BY tp.cdartn";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lkmode objects
   */
  public static function getMinimalModelsForLook($cdlkbk, $cdlook) {
    $query = 'SELECT l.cdartn AS code, t.dsartn AS description
      FROM Go2B\Models\Lkmode l
      INNER JOIN Go2B\Models\Tipolo t ON t.cdartn = l.cdartn
      WHERE l.cdlkbk = :cdlkbk: AND l.cdlook = :cdlook:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewModelIntoLook($cdlkbk, $cdlook, $cdartn, $seqrap) {
    $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'cdartn' => $cdartn, 'seqrap' => $seqrap);
    $query = 'INSERT INTO lkmode (cdlkbk, cdlook, cdartn, seqrap)
      VALUES (:cdlkbk, :cdlook, :cdartn, :seqrap)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteLookbook($cdlkbk) {
    $query = 'DELETE lm.*
      FROM lkmode lm
      WHERE lm.cdlkbk = :cdlkbk';
    Di::getDefault()->get('db')->query($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE lkmode";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
