<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Lkimag extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlkbk;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlook;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $filimg;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('lkimag');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlkbk' => isset($rec->cdlkbk) && (string)$rec->cdlkbk !== '' ? (string)$rec->cdlkbk : new RawValue('""'),
      'cdlook' => isset($rec->cdlook) && (string)$rec->cdlook !== '' ? (string)$rec->cdlook : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'filimg' => isset($rec->filimg) && (string)$rec->filimg !== '' ? (string)$rec->filimg : new RawValue('""')
    );

    $query  = 'cdlkbk = :cdlkbk: AND cdlook = :cdlook: AND seqrap = :seqrap:';
    $params = array(
      'cdlkbk' => $values['cdlkbk'],
      'cdlook' => $values['cdlook'],
      'seqrap' => $values['seqrap']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Lkimag objects
   */
  public static function getImagesForLook($cdlkbk, $cdlook) {
    $query = 'SELECT l.filimg, l.seqrap
      FROM Go2B\Models\Lkimag l
      WHERE l.cdlkbk = :cdlkbk: AND l.cdlook = :cdlook:
      ORDER BY l.seqrap';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewLookImage($cdlkbk, $cdlook, $seqrap, $filimg) {
    $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'seqrap' => $seqrap, 'filimg' => $filimg);
    $query = 'INSERT INTO lkimag (cdlkbk, cdlook, seqrap, filimg)
      VALUES (:cdlkbk, :cdlook, :seqrap, :filimg)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteLookbook($cdlkbk) {
    $query = 'DELETE li.*
      FROM lkimag li
      WHERE li.cdlkbk = :cdlkbk';
    Di::getDefault()->get('db')->query($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE lkimag";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
