<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Lkcorp extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlkbk;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlook;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dslook;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('lkcorp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlkbk' => isset($rec->cdlkbk) && (string)$rec->cdlkbk !== '' ? (string)$rec->cdlkbk : new RawValue('""'),
      'cdlook' => isset($rec->cdlook) && (string)$rec->cdlook !== '' ? (string)$rec->cdlook : new RawValue('""'),
      'dslook' => isset($rec->dslook) && (string)$rec->dslook !== '' ? (string)$rec->dslook : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'cdlkbk = :cdlkbk: AND cdlook = :cdlook:';
    $params = array(
      'cdlkbk' => $values['cdlkbk'],
      'cdlook' => $values['cdlook']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Lkcorp objects
   */
  public static function getMinimalLooksFromLookbook($cdlkbk) {
    $query = 'SELECT l.cdlook, l.dslook, l.seqrap
      FROM Go2B\Models\Lkcorp l
      WHERE l.cdlkbk = :cdlkbk:
      ORDER BY l.seqrap';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lkcorp objects
   */
  public static function getLooksFromLookbook($cdlkbk) {
    $query = "SELECT lc.cdlook, lc.dslook, lc.seqrap,
      COALESCE(
        IF(lt.fltipo = 0,
          (SELECT COUNT(*)
          FROM Go2B\Models\Lkmode lm
          WHERE lc.cdlkbk = lm.cdlkbk AND lc.cdlook = lm.cdlook),
          (SELECT COUNT(*)
          FROM Go2B\Models\Lkarti la
          WHERE lc.cdlkbk = la.cdlkbk AND lc.cdlook = la.cdlook)
        ),0) AS num_items,
      COALESCE((SELECT li.filimg
        FROM Go2B\Models\Lkimag li
        WHERE lc.cdlkbk = li.cdlkbk
        AND lc.cdlook = li.cdlook LIMIT 1),'') AS filimg
      FROM Go2B\Models\Lkcorp lc
      INNER JOIN Go2B\Models\Lktest lt ON lt.cdlkbk = lc.cdlkbk
      WHERE lc.cdlkbk = :cdlkbk:
      ORDER BY lc.seqrap, lc.dslook";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   SELECT
   * Return:  Lkcorp object
   */
  public static function getLook($cdlkbk, $cdlook) {
    $query = "SELECT l.dslook,
      COALESCE((SELECT i.filimg
        FROM Go2B\Models\Lkimag i
        WHERE i.cdlkbk = l.cdlkbk AND i.cdlook = l.cdlook LIMIT 1),'') AS filimg
      FROM Go2B\Models\Lkcorp l
      WHERE l.cdlkbk = :cdlkbk: AND l.cdlook = :cdlook:";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook))[0];
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function createNewLook($cdlkbk, $cdlook, $dslook, $seqrap) {
    $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'dslook' => $dslook, 'seqrap' => $seqrap);
    $query = 'INSERT INTO lkcorp (cdlkbk, cdlook, dslook, seqrap)
      VALUES (:cdlkbk, :cdlook, :dslook, :seqrap)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteLookbook($cdlkbk) {
    $query = 'DELETE lc.*
      FROM lkcorp lc
      WHERE lc.cdlkbk = :cdlkbk';
    Di::getDefault()->get('db')->query($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE lkcorp";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
