<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Lkarti extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlkbk;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlook;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdpers;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $filimg;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('lkarti');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlkbk' => isset($rec->cdlkbk) && (string)$rec->cdlkbk !== '' ? (string)$rec->cdlkbk : new RawValue('""'),
      'cdlook' => isset($rec->cdlook) && (string)$rec->cdlook !== '' ? (string)$rec->cdlook : new RawValue('""'),
      'cdarti' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'filimg' => isset($rec->filimg) && (string)$rec->filimg !== '' ? (string)$rec->filimg : new RawValue('""')
    );

    $query  = 'cdlkbk = :cdlkbk: AND cdlook = :cdlook: AND cdarti = :cdarti:';
    $params = array(
      'cdlkbk' => $values['cdlkbk'],
      'cdlook' => $values['cdlook'],
      'cdarti' => $values['cdarti']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Lkarti objects
   */
  public static function getArticlesForLook($cdlkbk, $cdlook, $nulist, $numdis, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'nulist' => $nulist, 'idlang' => $idlang);
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
    } else {
      $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'nulist' => $nulist);
      $dsarti = 'aa.dsarti AS dsarti';
      $lnJoin = '';
    }

    if ($numdis > 0) {
      $params['numdis'] = $numdis;
      $sconto = 'COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
      $lnJoin .= "LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = tl.cdtitl AND c1.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c6.numdis = :numdis: ";
    } else {
      $sconto = '0 AS cust_disc ';
    }

    $query = "SELECT aa.cdarti, $dsarti, la.filimg AS flimag_look, aa.flimag AS flimag_arti, tp.flimag AS flimag_artn,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $sconto
      FROM Go2B\Models\Lkarti la
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = la.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = la.cdarti
      $lnJoin
      WHERE la.cdlkbk = :cdlkbk: AND la.cdlook = :cdlook:
      GROUP BY aa.cdarti
      ORDER BY la.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lkarti objects
   */
  public static function getLardiniArticlesForLook($cdlkbk, $cdlook, $nulist, $numdis, $idlang = 'IT') {
    if ($idlang != 'IT') {
      $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'nulist' => $nulist, 'idlang' => $idlang);
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
    } else {
      $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'nulist' => $nulist);
      $dsarti = 'aa.dsarti AS dsarti';
      $lnJoin = '';
    }

    if ($numdis > 0) {
      $params['numdis'] = $numdis;
      $sconto = 'COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
      $lnJoin .= "LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = tl.cdtitl AND c1.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
                  LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c6.numdis = :numdis: ";
    } else {
      $sconto = '0 AS cust_disc ';
    }

    $query = "SELECT aa.cdarti, $dsarti, aa.cdartn, aa.cdpers, ap.dspers, la.cdcolo, la.filimg AS flimag_look, aa.flimag AS flimag_arti, tp.flimag AS flimag_artn,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $sconto
      FROM Go2B\Models\Lkarti la
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = la.cdarti
      INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = la.cdpers
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = la.cdarti
      $lnJoin
      WHERE la.cdlkbk = :cdlkbk: AND la.cdlook = :cdlook:
      GROUP BY la.cdarti, la.cdpers, la.cdcolo
      ORDER BY la.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lkarti objects
   */
  public static function getMinimalArticlesForLook($cdlkbk, $cdlook) {
    $query = 'SELECT l.cdarti AS code, a.dsarti AS description, l.filimg AS image
      FROM Go2B\Models\Lkarti l
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = l.cdarti
      WHERE l.cdlkbk = :cdlkbk: AND l.cdlook = :cdlook:
      ORDER BY l.seqrap';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Lkarti objects
   */
  public static function getMinimalLardiniArticlesForLook($cdlkbk, $cdlook) {
    $query = 'SELECT l.cdarti AS code, a.dsarti AS description, l.cdpers, l.cdcolo, l.filimg AS image
      FROM Go2B\Models\Lkarti l
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = l.cdarti
      WHERE l.cdlkbk = :cdlkbk: AND l.cdlook = :cdlook:
      ORDER BY l.seqrap';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewArticleIntoLook($cdlkbk, $cdlook, $cdarti, $seqrap, $filimg) {
    $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'cdarti' => $cdarti, 'seqrap' => $seqrap, 'filimg' => $filimg);
    $query = "INSERT INTO lkarti (cdlkbk, cdlook, cdarti, cdpers, cdcolo, seqrap, filimg)
      VALUES (:cdlkbk, :cdlook, :cdarti, '', '', :seqrap, :filimg)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewLardiniArticleIntoLook($cdlkbk, $cdlook, $cdarti, $cdpers, $cdcolo, $seqrap, $filimg) {
    $params = array('cdlkbk' => $cdlkbk, 'cdlook' => $cdlook, 'cdarti' => $cdarti, 'cdpers' => $cdpers, 'cdcolo' => $cdcolo, 'seqrap' => $seqrap, 'filimg' => $filimg);
    $query = 'INSERT INTO lkarti (cdlkbk, cdlook, cdarti, cdpers, cdcolo, seqrap, filimg)
      VALUES (:cdlkbk, :cdlook, :cdarti, :cdpers, :cdcolo, :seqrap, :filimg)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteLookbook($cdlkbk) {
    $query = 'DELETE la.*
      FROM lkarti la
      WHERE la.cdlkbk = :cdlkbk';
    Di::getDefault()->get('db')->query($query, array('cdlkbk' => $cdlkbk));
  }
  //endregion
}
