<?php

namespace Go2B\Models;

use Exception;
use Go2B\Plugins\Nav\ApiKOC;
use Go2B\Plugins\Nav\NewAddressCustomerKOC;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;
use Ramsey\Uuid\Uuid;

class Desmer extends Model
{
    //region Fields
    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=2, nullable=false)
     */
    public $tpanag;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=30, nullable=false)
     */
    public $cddesm;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=30, nullable=false)
     */
    public $cdanag;

    /**
     *
     * @var string
     * @Column(type="string", length=80, nullable=false)
     */
    public $descri;

    /**
     *
     * @var string
     * @Column(type="string", length=20, nullable=false)
     */
    public $desvid;

    /**
     *
     * @var string
     * @Column(type="string", length=80, nullable=false)
     */
    public $indiri;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $codcap;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $ccitta;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $provin;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdnazi;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdzona;

    /**
     *
     * @var string
     * @Column(type="string", length=40, nullable=false)
     */
    public $numtel;

    /**
     *
     * @var string
     * @Column(type="string", length=40, nullable=false)
     */
    public $numcel;

    /**
     *
     * @var string
     * @Column(type="string", length=40, nullable=false)
     */
    public $numfax;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $intern;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $indema;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $percon;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $cdvett;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdblco;

    /**
     *
     * @var integer
     * @Column(type="integer", length=2, nullable=false)
     */
    public $flsb2b;

    /**
     *
     * @var string
     * @Column(type="string", length=36, nullable=true)
     */
    public $uuid;
    //endregion

    //region Default functions

    /**
     * Sync from xml
     */
    public static function saveRecord($rec, $tipoagg)
    {
        $values = array(
            'tpanag' => isset($rec->tpanag) && (string)$rec->tpanag !== '' ? (string)$rec->tpanag : new RawValue('""'),
            'cddesm' => isset($rec->cddesm) && (string)$rec->cddesm !== '' ? (string)$rec->cddesm : new RawValue('""'),
            'cdanag' => isset($rec->cdanag) && (string)$rec->cdanag !== '' ? trim((string)$rec->cdanag) : new RawValue('""'),
            'descri' => isset($rec->descri) && (string)$rec->descri !== '' ? (string)$rec->descri : new RawValue('""'),
            'desvid' => isset($rec->desvid) && (string)$rec->desvid !== '' ? (string)$rec->desvid : new RawValue('""'),
            'indiri' => isset($rec->indiri) && (string)$rec->indiri !== '' ? (string)$rec->indiri : new RawValue('""'),
            'codcap' => isset($rec->codcap) && (string)$rec->codcap !== '' ? (string)$rec->codcap : new RawValue('""'),
            'ccitta' => isset($rec->ccitta) && (string)$rec->ccitta !== '' ? (string)$rec->ccitta : new RawValue('""'),
            'provin' => isset($rec->provin) && (string)$rec->provin !== '' ? (string)$rec->provin : new RawValue('""'),
            'cdnazi' => isset($rec->cdnazi) && (string)$rec->cdnazi !== '' ? (string)$rec->cdnazi : new RawValue('""'),
            'cdzona' => isset($rec->cdzona) && (string)$rec->cdzona !== '' ? (string)$rec->cdzona : new RawValue('""'),
            'numtel' => isset($rec->numtel) && (string)$rec->numtel !== '' ? (string)$rec->numtel : new RawValue('""'),
            'numcel' => isset($rec->numcel) && (string)$rec->numcel !== '' ? (string)$rec->numcel : new RawValue('""'),
            'numfax' => isset($rec->numfax) && (string)$rec->numfax !== '' ? (string)$rec->numfax : new RawValue('""'),
            'intern' => isset($rec->intern) && (string)$rec->intern !== '' ? (string)$rec->intern : new RawValue('""'),
            'indema' => isset($rec->indema) && (string)$rec->indema !== '' ? (string)$rec->indema : new RawValue('""'),
            'percon' => isset($rec->percon) && (string)$rec->percon !== '' ? (string)$rec->percon : new RawValue('""'),
            'cdvett' => isset($rec->cdvett) && (string)$rec->cdvett !== '' ? (string)$rec->cdvett : new RawValue('""'),
            'cdblco' => isset($rec->cdblco) && (string)$rec->cdblco !== '' ? (string)$rec->cdblco : new RawValue('""')
        );

        $query = 'tpanag = :tpanag: AND cddesm = :cddesm: AND cdanag = :cdanag:';
        $params = array(
            'tpanag' => $values['tpanag'],
            'cddesm' => $values['cddesm'],
            'cdanag' => $values['cdanag']
        );

        if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
            $row = new self();
        }

        $row->save($values);
    }
    //endregion

    //region Sync functions

    /**
     * Query:   SELECT
     * Return:  Array of Desmer arrays
     */
    public static function getShippings()
    {
        $query = "SELECT dm.cddesm AS cddesm, dm.desvid AS desdsm,
      CONCAT_WS(' - ', dm.indiri, dm.ccitta, dm.codcap, (CASE dm.provin WHEN '' THEN NULL ELSE dm.provin END), an.dsnazi) AS indiri,
      ag.tpanag AS tpanag, ag.cdanag AS cdanag, ag.descri AS desana, COALESCE(bu.id,-1) AS id_usr,
      COALESCE(bu.username,'') AS usrnam, COALESCE(bu.enabled,-1) AS enable
      FROM desmer dm
      INNER JOIN anagra ag ON ag.tpanag = dm.tpanag AND ag.cdanag = dm.cdanag
      LEFT JOIN ananaz an ON an.cdnazi = dm.cdnazi
      LEFT JOIN b2b_usrdsm ud ON ud.cddesm = dm.cddesm
      LEFT JOIN b2b_sysusr bu ON bu.id = ud.id_usr
      WHERE dm.cdblco = 0
      ORDER BY cdanag, cddesm";
        return Di::getDefault()->get('db')->query($query)->fetchAll();
    }
    //endregion

    //region Custom queries

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getAllShippings()
    {
        $query = "SELECT dm.cddesm AS cddesm, dm.desvid AS desdsm,
      CONCAT_WS(' - ', dm.indiri, dm.ccitta, dm.codcap, (CASE dm.provin WHEN '' THEN NULL ELSE dm.provin END), an.dsnazi) AS indiri,
      ag.tpanag AS tpanag, ag.cdanag AS cdanag, ag.descri AS desana, bu.id AS id_usr, bu.username AS usrnam, bu.enabled AS enable
      FROM Go2B\Models\Desmer dm
      INNER JOIN Go2B\Models\Anagra ag ON ag.tpanag = dm.tpanag AND ag.cdanag = dm.cdanag
      LEFT JOIN Go2B\Models\Ananaz an ON an.cdnazi = dm.cdnazi
      INNER JOIN Go2B\Models\B2bUsrdsm ud ON ud.cddesm = dm.cddesm
      INNER JOIN Go2B\Models\B2bSysusr bu ON bu.id = ud.id_usr
      WHERE dm.cdblco = 0
      ORDER BY cdanag, cddesm";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getAllEnabledShippings()
    {
        $query = "SELECT dm.cddesm AS cddesm, dm.desvid AS desdsm,
      CONCAT_WS(' - ', dm.indiri, dm.ccitta, dm.codcap, (CASE dm.provin WHEN '' THEN NULL ELSE dm.provin END), an.dsnazi) AS indiri,
      ag.tpanag AS tpanag, ag.cdanag AS cdanag, ag.descri AS desana, bu.id AS id_usr, bu.username AS usrnam, bu.enabled AS enable
      FROM Go2B\Models\Desmer dm
      INNER JOIN Go2B\Models\Anagra ag ON ag.tpanag = dm.tpanag AND ag.cdanag = dm.cdanag
      LEFT JOIN Go2B\Models\Ananaz an ON an.cdnazi = dm.cdnazi
      INNER JOIN Go2B\Models\B2bUsrdsm ud ON ud.cddesm = dm.cddesm
      INNER JOIN Go2B\Models\B2bSysusr bu ON bu.id = ud.id_usr
      WHERE bu.enabled = 1 AND dm.cdblco = 0
      ORDER BY cdanag, cddesm";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getShippingsForCustomer($tpanag, $cdanag)
    {
        $query = 'tpanag = :tpanag: AND cdanag = :cdanag: AND cdblco = 0';
        $params = ['tpanag' => $tpanag, 'cdanag' => $cdanag];
        $di = Di::getDefault();
        if ($di->get('config')->release->user == 'koc') {
            $query .= ' AND flsb2b = 0';
        }
        return self::find([$query, 'bind' => $params]);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getShippingsAddressForCustomer($tpanag, $cdanag)
    {
        $query = "SELECT d.cddesm, d.desvid AS dsdesm, d.indiri,
      d.ccitta, d.provin, COALESCE(n.dsnazi,'') AS dsnazi
      FROM Go2B\Models\Desmer d
      LEFT JOIN Go2B\Models\Ananaz n ON d.cdnazi = n.cdnazi
      WHERE d.tpanag = :tpanag: AND d.cdanag = :cdanag: AND d.cdblco = 0";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getShippingsForAgent($cdagen, $anagra = null)
    {
        $params = ['cdagen' => $cdagen];
        $where = '';
        if ($anagra) {
            $where = 'AND d.tpanag = :tpanag: AND d.cdanag = :cdanag:';
            $params['tpanag'] = $anagra->tpanag;
            $params['cdanag'] = $anagra->cdanag;
        }

        $query = "SELECT d.*
      FROM Go2B\Models\Desmer d
      INNER JOIN Go2B\Models\Ageana aa ON aa.tipdat = 'D' AND aa.cdagen = :cdagen: AND aa.codice = d.cddesm
      WHERE d.cdblco = 0 $where
      ORDER BY d.tpanag, d.cdanag";

        return Di::getDefault()->get('modelsManager')
            ->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getShippingsForHeadquarterAgentUser()
    {
        $query = 'SELECT d.*
      FROM Go2B\Models\Desmer d
      WHERE d.cdblco = 0
      ORDER BY d.tpanag, d.cdanag';
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getShippingsForShippingUser($id_usr)
    {
        $query = 'SELECT d.*
      FROM Go2B\Models\Desmer d
      INNER JOIN Go2B\Models\B2bUsrdsm u ON u.cddesm = d.cddesm
      WHERE u.id_usr = :id: AND d.cdblco = 0';
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id' => $id_usr));
    }

    /**
     * Query:   SELECT
     * Return:  Desmer object
     */
    public static function getShippingForPdf($tpanag, $cdanag, $cddesm)
    {
        $query = "SELECT d.cddesm, d.desvid, d.indiri, d.codcap, d.ccitta, d.provin,
      d.numtel, d.numcel, d.numfax, COALESCE(n.dsnazi,'') AS dsnazi
      FROM Go2B\Models\Desmer d
      LEFT JOIN Go2B\Models\Ananaz n ON d.cdnazi = n.cdnazi
      WHERE d.tpanag = :tpanag: AND d.cddesm = :cddesm: AND d.cdanag = :cdanag:";
        $desmer = Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cddesm' => $cddesm, 'cdanag' => $cdanag));
        return count($desmer) == 1 ? $desmer[0] : null;
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getShippingPriceListCodeFromUser($id_usr)
    {
        $query = "SELECT a.nulist
      FROM Go2B\Models\Desmer d
      INNER JOIN Go2B\Models\B2bUsrdsm u ON u.cddesm = d.cddesm
      INNER JOIN Go2B\Models\Anagra a ON d.tpanag = a.tpanag AND d.cdanag = a.cdanag
      WHERE u.id_usr = :id_usr:";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
        return count($result) > 0 ? $result[0]->nulist : 0;
    }

    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function insertShipping($tpanag, $cdanag, $descri, $indiri, $codcap, $ccitta, $provin, $cdnazi, $cdzona, $cdblco, $numtel, $numcel, $numfax)
    {
        $params = array(
            'tpanag' => $tpanag,
            'cdanag' => $cdanag,
            'descri' => $descri,
            'indiri' => $indiri,
            'codcap' => $codcap,
            'ccitta' => $ccitta,
            'provin' => $provin,
            'cdnazi' => $cdnazi,
            'cdzona' => $cdzona,
            'cdblco' => $cdblco,
            'numtel' => $numtel,
            'numcel' => $numcel,
            'numfax' => $numfax
        );
        //N.B. Il codice di destinazione deve essere assoluto e non per cliente
        /* $query = "INSERT INTO desmer (tpanag, cddesm, cdanag, descri, desvid,
           indiri, codcap, ccitta, provin, cdnazi, cdzona, numtel, numcel, numfax,
           intern, indema, percon, cdvett, cdblco)
           VALUES (:tpanag, COALESCE((SELECT MAX(CAST(d.cddesm AS SIGNED)) + 1 FROM desmer d WHERE d.tpanag = :tpanag AND d.cdanag = :cdanag),1),
           :cdanag, :descri, :descri, :indiri, :codcap, :ccitta, :provin,
           :cdnazi, :cdzona, :numtel, :numcel, :numfax, '', '', '', '', :cdblco)";*/
        $query = "INSERT INTO desmer (tpanag, cddesm, cdanag, descri, desvid,
      indiri, codcap, ccitta, provin, cdnazi, cdzona, numtel, numcel, numfax,
      intern, indema, percon, cdvett, cdblco)
      VALUES (:tpanag, COALESCE((SELECT MAX(CAST(d.cddesm AS SIGNED)) + 1 FROM desmer d WHERE d.tpanag = :tpanag),1),
      :cdanag, :descri, :descri, :indiri, :codcap, :ccitta, :provin,
      :cdnazi, :cdzona, :numtel, :numcel, :numfax, '', '', '', '', :cdblco)";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateShipping($cddesm, $tpanag, $cdanag, $descri, $indiri, $codcap, $ccitta, $provin, $cdnazi, $cdzona, $cdblco, $numtel, $numcel, $numfax)
    {
        $params = array(
            'cddesm' => $cddesm,
            'tpanag' => $tpanag,
            'cdanag' => $cdanag,
            'descri' => $descri,
            'indiri' => $indiri,
            'codcap' => $codcap,
            'ccitta' => $ccitta,
            'provin' => $provin,
            'cdnazi' => $cdnazi,
            'cdzona' => $cdzona,
            'cdblco' => $cdblco,
            'numtel' => $numtel,
            'numcel' => $numcel,
            'numfax' => $numfax
        );
        $query = "UPDATE desmer
      SET descri = :descri, desvid = :descri, indiri = :indiri,
      codcap = :codcap, ccitta = :ccitta, provin = :provin, cdnazi = :cdnazi,
      cdzona = :cdzona, numtel = :numtel, numcel = :numcel, numfax = :numfax,
      cdblco = :cdblco
      WHERE tpanag = :tpanag AND cddesm = :cddesm AND cdanag = :cdanag";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * @param array $values
     * @return Model
     * @throws Exception
     */
    public static function saveNewDesmer($values)
    {
        $di = Di::getDefault();
        $i18n = $di->get('i18n');
        $auth = $di->get('session')->get('auth');

        $values = array_replace([
            'flsb2b' => 1,
            'cddesm' => uniqid($values['cdanag'] . '-'),
        ], $values);

        $newDesmer = new Desmer($values);

        if ($newDesmer->create() === false) {
            throw new Exception($i18n->_('admin.customers.newshipping.error'), 001);
        }

        if ($auth['type'] == B2bSysusr::TYPE_AGENT) {
            $newAgeana = new Ageana();
            $newAgeana->tipdat = Ageana::TIPDAT_DESTINATION;
            $newAgeana->cdagen = $auth['code'];
            $newAgeana->tpanag = $newDesmer->tpanag;
            $newAgeana->codice = $newDesmer->cddesm;
            if ($newAgeana->create() === false) {
                throw new Exception($i18n->_('admin.customers.newshipping.error'), 002);
            }
        }

        throw new Exception('Test clear');

        if ($di->get('config')->release->user == 'koc') {
            /** @var \Phalcon\Db\Adapter\Pdo\Mysql $db */
            $db = $di->get('db');
            do {
                $uuid = Uuid::uuid4();
                $result = $db->query("SELECT * FROM cnv_datast WHERE tipdat = :tp AND newdat = :dt",
                    array(
                        'tp' => "desmer.newcod",
                        'dt' => $uuid->toString()
                    )
                )->fetchAll();
            } while ($result);

            $cnvIndert = $db->query("INSERT INTO cnv_datast VALUES(:tipdat, :dato01, :dato02, :dato03, :uuid, '', '')",
                array(
                    "tipdat" => 'desmer.newcod',
                    "dato01" => $newDesmer->tpanag,
                    "dato02" => $newDesmer->cdanag,
                    "dato03" => $newDesmer->cddesm,
                    "uuid" => $uuid->toString()
                )
            );

            if ($cnvIndert === false) {
                throw new Exception($i18n->_('admin.customers.newshipping.error'), 003);
            }

            try {
                $api = new ApiKOC();
                $api->sendNewAddressCustomer($newDesmer);
            } catch (Exception $ex) {
                $di->get('logger')->error('Errore durante la creazione di una nuova destinazione: Impossibile inviare i dati a nav');
                $di->get('logger')->error($ex->getTraceAsString());
            }
        }

        return $newDesmer->refresh();
    }

    public static function clearUncompletedNewDesmer($desmerData)
    {
        $desmerToDelete = null;
        if (!empty($desmerData['cddesm'])) {
            $desmerToDelete = self::findFirstByCddesm($desmerData['cddesm']);
        } else {
            $params = [];
            $queryPcs = [];
            foreach ($desmerData as $key => $value) {
                if (property_exists(self::class, $key)) {
                    $params[$key] = $value;
                    $queryPcs[] = "$key = :$key:";
                }
            }

            $query = implode(' AND ', $queryPcs);

            $desmerToDeleteEligibleList = self::find([$query, 'bind' => $params]);
            if ($desmerToDeleteEligibleList->count()) {
                $desmerToDelete = $desmerToDeleteEligibleList->getFirst();
            }
        }

        if ($desmerToDelete instanceof Desmer) {
            // Prima eliminiamo Ageana se la trova
            Ageana::findFirst([
                'tipdat = :tipdat: AND tpanag = :tpanag: AND codice = :cddesm:',
                'bind' => [
                    'tipdat' => Ageana::TIPDAT_DESTINATION,
                    'tpanag' => $desmerToDelete->tpanag,
                    'cddesm' => $desmerToDelete->cddesm,
                ]
            ])->delete();
            // Poi desmer
            $desmerToDelete->delete();
        }
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function blockAllShippings()
    {
        $query = 'UPDATE desmer d
      SET d.cdblco = 1';
        Di::getDefault()->get('db')->query($query);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateCustomerCode($oldcode, $cdanag)
    {
        $query = 'UPDATE desmer d
      INNER JOIN anagra a ON a.tpanag = d.tpanag AND a.cdanag = d.cdanag
      SET d.tpanag = "CL", d.cdanag = :cdanag
      WHERE d.tpanag = "CN" AND d.cdanag = :oldcode AND a.cdblco = 0';
        Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
    }

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('desmer');
    }

    public function getAddress($printCountry = true)
    {
        $res = $this->indiri;
        if ($this->ccitta != '') {
            $res .= ' - ' . $this->ccitta;
        }
        if ($this->provin != '') {
            $res .= ' (' . $this->provin . ')';
        }
        if ($printCountry && isset($this->dsnazi) && $this->dsnazi != '') {
            $res .= ' - ' . $this->dsnazi;
        }

        return $res;
    }

    //endregion

    /**
     * Torna l'oggetto NewCustomerKOC
     *
     * @return NewAddressCustomerKOC
     * @throws Exception
     */
    public function exportToNav()
    {
        $cnvDat = $this->getDI()->get('db')
            ->query("SELECT * FROM cnv_datast WHERE tipdat = :tipdat AND dato01 = :dato01 and dato02 = :dato02 AND dato03 = :dato03",
                array(
                    'tipdat' => "desmer.newcod",
                    "dato01" => $this->tpanag,
                    "dato02" => $this->cdanag,
                    "dato03" => $this->cddesm,
                )
            )->fetch();

        if ($cnvDat) {
            $uuid = $cnvDat["newdat"];
        } else {
            $u = Uuid::uuid4();
            $uuid = $u->toString();
        }

        $addressCustomerKOC = new NewAddressCustomerKOC();
        $addressCustomerKOC->id = $uuid;
        $addressCustomerKOC->customerNo = $this->cdanag;

        // Andiamo a cercare il codice incrementale più grande presente su nostro db
        $index = 0;
        $currentShippings = Desmer::getAllShippingsForCustomer($this->tpanag, $this->cdanag);
        /** @var Desmer $shipping */
        foreach ($currentShippings as $shipping) {
            if ($shipping->cddesm != $this->cddesm && $shipping->flsb2b == 0 && strpos($shipping->cddesm, $this->cdanag . '-') !== false) {
                $currentIndex = intval(substr($shipping->cddesm, strlen($this->cdanag . '-')));
                if ($currentIndex > $index) {
                    $index = $currentIndex;
                }
            }
        }
        $addressCustomerKOC->code = str_pad($index + 1, 3, '0', STR_PAD_LEFT);

        $addressCustomerKOC->name = $this->desvid;
        $addressCustomerKOC->address = $this->indiri;
        $addressCustomerKOC->city = $this->ccitta;
        $addressCustomerKOC->postCode = $this->codcap;
        $addressCustomerKOC->county = $this->provin;
        $addressCustomerKOC->countryRegionCode = $this->cdnazi;

        $addressCustomerKOC->phoneNo = $this->numtel;
        $addressCustomerKOC->eMail = $this->indema;

        $addressCustomerKOC->setEtag($uuid);

        return $addressCustomerKOC;
    }

    /**
     * Query:   SELECT
     * Return:  Array of Desmer objects
     */
    public static function getAllShippingsForCustomer($tpanag, $cdanag)
    {
        return self::find(array('tpanag = :tpanag: AND cdanag = :cdanag:', 'bind' => array('tpanag' => $tpanag, 'cdanag' => $cdanag)));
    }
}
