<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Deslin extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=6, nullable=false)
   */
  public $tpdato;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codic1;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codic2;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $idlang;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $descri;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('deslin');
  }

  /**
   * Checks record uniqueness before to save
   *
   * @return bool
   */
  public function validation() {
    $validator = new \Phalcon\Validation();
    $validator->add(
      array(
        'tpdato',
        'codic1',
        'codic2',
        'idlang'
      ),
      new \Phalcon\Validation\Validator\Uniqueness()
    );
    return $this->validate($validator);
  }
  //endregion

  //region Sync functions
  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function importDescriTipolo($cdartn, $descri) {
    $params = array('cdartn' => $cdartn);
    foreach ( $descri AS $idlang => $des ) {
      if ($des != '') {
        $params['idlang'] = $idlang;
        $params['descri'] = $des;

        $query = "INSERT INTO deslin(tpdato, codic1, idlang, descri)
          VALUES('dsartn', :cdartn, :idlang, :descri) ON DUPLICATE KEY
          UPDATE descri = :descri";
        Di::getDefault()->get('db')->query($query, $params);
      }
    }
  }

  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpdato' => isset($rec->tpdato) && (string)$rec->tpdato !== '' ? (string)$rec->tpdato : new RawValue('""'),
      'codic1' => isset($rec->codic1) && (string)$rec->codic1 !== '' ? (string)$rec->codic1 : new RawValue('""'),
      'codic2' => isset($rec->codic2) && (string)$rec->codic2 !== '' ? (string)$rec->codic2 : new RawValue('""'),
      'idlang' => isset($rec->idlang) && (string)$rec->idlang !== '' ? (string)$rec->idlang : new RawValue('""'),
      'descri' => isset($rec->descri) && (string)$rec->descri !== '' ? (string)$rec->descri : new RawValue('""')
    );

    $query  = 'tpdato = :tpdato: AND codic1 = :codic1: AND codic2 = :codic2: AND idlang = :idlang:';
    $params = array(
      'tpdato' => $values['tpdato'],
      'codic1' => $values['codic1'],
      'codic2' => $values['codic2'],
      'idlang' => $values['idlang']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
