<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Cracol extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $idlang;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdfini;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dscolo;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('cracol');
  }
  //endregion

  //region Sync functions
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'idlang' => isset($rec->idlang) && (string)$rec->idlang !== '' ? (string)$rec->idlang : new RawValue('""'),
      'cdfini' => isset($rec->cdfini) && (string)$rec->cdfini !== '' ? (string)$rec->cdfini : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'dscolo' => isset($rec->dscolo) && (string)$rec->dscolo !== '' ? (string)$rec->dscolo : new RawValue('""')
    );

    $query  = 'cdcolo = :cdcolo:';
    $params = array(
      'cdcolo' => $values['cdcolo']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
