<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class CnvSyncro extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Identity
   * @Column(type="string", length=20, nullable=false)
   */
  public $tipdat;
  
  /**
   *
   * @var string
   * @Primary
   * @Identity
   * @Column(type="string", length=80, nullable=false)
   */
  public $vals01;
  
  /**
   *
   * @var string
   * @Primary
   * @Identity
   * @Column(type="string", length=80, nullable=false)
   */
  public $vals02;
  
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $valn01;

  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $valn02;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $descri;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('cnv_syncro');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Anaart or Tpmode or Tpgene or Postgl objects
   */
  //endregion

    public static function keyExists($tipdat,$vals01,$vals02='',$valn01=0,$valn02=0) {
        $num = self::count(
        array('tipdat = :tipdat: AND vals01 = :vals01: AND vals02 = :vals02: AND valn01 = :valn01: AND valn02 = :valn02:',
                'bind' => array('tipdat' => $tipdat, 'vals01' => $vals01, 'vals02' => $vals02, 'valn01' => $valn01, 'valn02' => $valn02)));
        return ($num > 0);
    }

}
