<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;
use Go2B\Controllers\Utility;

class CnvDatast extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Identity
   * @Column(type="string", length=20, nullable=false)
   */
  public $tipdat;
  
  /**
   *
   * @var string
   * @Primary
   * @Identity
   * @Column(type="string", length=80, nullable=false)
   */
  public $dato01;
  
  /**
   *
   * @var string
   * @Primary
   * @Identity
   * @Column(type="string", length=80, nullable=false)
   */
  public $dato02;
  
  /**
   *
   * @var string
   * @Primary
   * @Identity
   * @Column(type="string", length=80, nullable=false)
   */
  public $dato03;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $newdat;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $newnum;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $descri;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('cnv_datast');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Newnum
   */
    public static function dataInSerial($db,$tipdat,$dato01,$dato02 = '',$dato03 = '') {
      
        if ( Utility::emptyOrSpace($dato01) && 
             Utility::emptyOrSpace($dato02) && 
             Utility::emptyOrSpace($dato03) ) {
            return false;
        } 

        $p = array('tipdat = :tipdat: AND dato01 = :dato01: AND dato02 = :dato02: AND dato03 = :dato03:', 
                    'bind' => array('tipdat' => $tipdat, 
                                    'dato01' => $dato01, 
                                    'dato02' => $dato02, 
                                    'dato03' => $dato03));
        if ( $rs = self::findFirst($p) ) {
            return $rs->newnum;
        } else {
            try {
                $p = array('tipdat' => $tipdat, 'dato01' => $dato01, 'dato02' => $dato02, 'dato03' => $dato03);
                $query = "INSERT IGNORE INTO cnv_datast 
                        ( tipdat, dato01, dato02, dato03, newnum ) 
                    SELECT :tipdat AS tipdat,
                        :dato01 AS dato01,
                        :dato02 AS dato02,
                        :dato03 AS dato03,
                        IFNULL((
                            SELECT MAX( newnum )+ 1 
                            FROM cnv_datast 
                            WHERE tipdat = :tipdat),1) AS newnum";
                $rs = Di::getDefault()->get('db')->query($query, $p);    
                
                $p = array('tipdat' => $tipdat,'dato01' => $dato01, 'dato02' => $dato02, 'dato03' => $dato03);
                $query = "SELECT newnum 
                    FROM cnv_datast
                    WHERE tipdat = :tipdat
                        AND dato01 = :dato01
                        AND dato02 = :dato02
                        AND dato03 = :dato03
                    LIMIT 1"; 
                return ($res = Di::getDefault()->get('db')->query($query,$p)->fetch()) ? $res['newnum'] : false;
            } catch (\Exception $exception) {
                echo $exception->getMessage() . PHP_EOL;
                // echo $exception->getTraceAsString() . PHP_EOL;
                return false;
            }
        }
    }

    public static function convertIn($db,$tipdat,$dato01,$dato02 = '',$dato03 = '') {
      
        if ( Utility::emptyOrSpace($dato01) && 
             Utility::emptyOrSpace($dato02) && 
             Utility::emptyOrSpace($dato03) ) {
            return false;
        } 

        $p = array('tipdat = :tipdat: AND dato01 = :dato01: AND dato02 = :dato02: AND dato03 = :dato03:', 
                    'bind' => array('tipdat' => $tipdat, 
                                    'dato01' => $dato01, 
                                    'dato02' => $dato02, 
                                    'dato03' => $dato03));
        return ($rs = self::findFirst($p)) ? $rs : false;

    }
    public static function convertOut($db,$tipdat,$newdat,$newnum = 0) {
      
        if ( Utility::emptyOrSpace($newdat) && intval($newnum) == 0 ) {
            return false;
        } 

        $p = array('tipdat = :tipdat: AND newdat = :newdat: AND newnum = :newnum:', 
                    'bind' => array('tipdat' => $tipdat, 
                                    'newdat' => $newdat, 
                                    'newnum' => $newnum));
        return ($rs = self::findFirst($p)) ? $rs : false;

    }
    //endregion

}
