<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Barcod extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=20, nullable=false)
   */
  public $nubrcd;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $taglia;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $path = realpath('..') . '/app/config/config.ini';
    $this->setSchema($config->database->dbname);
    $this->setSource('barcod');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nubrcd' => isset($rec->nubrcd) && (string)$rec->nubrcd !== '' ? (string)$rec->nubrcd : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'taglia' => isset($rec->taglia) && (string)$rec->taglia !== '' ? (string)$rec->taglia : new RawValue('""')
    );

    $query  = 'nubrcd = :nubrcd:';
    $params = array(
      'nubrcd' => $values['nubrcd']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
