<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bUsrctl extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id_usr;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_usrctl');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertAllRecordsFromCtanag() {
    $query = "INSERT IGNORE INTO b2b_usrctl (id, id_usr, cdcata)
      SELECT '', ua.id_usr, ca.cdcata
      FROM ctanag ca
      INNER JOIN b2b_usrana ua ON ua.tpanag = ca.tpanag AND ua.cdanag = ca.cdanag";
    Di::getDefault()->get('db')->query($query);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCatalogsForUser($id_usr, $catalogs) {
    $values = '';
    $i = 0;
    $params['id'] = $id_usr;
    foreach ($catalogs as $cdcata) {
      $values .= "(:id, :cdcata" . $i . "),";
      $params['cdcata' . $i] = $cdcata;
      $i++;
    }
    $values = substr($values, 0, -1);
    $query = "INSERT INTO b2b_usrctl (id_usr, cdcata) VALUES $values";
    try {
        Di::getDefault()->get('db')->query($query, $params);
    } catch (\Exception $e) {
        echo $e->getMessage();
    }
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCatalogsForUsers($ids, $catalogs) {
    $values = '';
    $i = 0;
    foreach ($ids as $id) {
      foreach ($catalogs as $cdcata) {
        $values .= "('',:id$i, :cdcata$i),";
        $params['id' . $i] = $id;
        $params['cdcata' . $i] = $cdcata;
        $i++;
      }
    }
    $values = substr($values, 0, -1);
    $query = "REPLACE INTO b2b_usrctl (id, id_usr, cdcata) VALUES $values";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllCatalogsForUsers($ids) {
    $where  = 'WHERE id_usr IN ';
    $values = '';
    $params = array();
    $i = 0;
    foreach ($ids as $id) {
      $values .= ':value' . $i . ', ';
      $params['value' . $i] = $id;
      $i++;
    }
    $where = $where . '(' . substr($values, 0, -2) . ')';
    $query = "DELETE FROM b2b_usrctl $where ";

    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllCatalogsForUser($id_usr) {
    $query = 'DELETE uc
      FROM b2b_usrctl uc
      WHERE uc.id_usr = :id';
    Di::getDefault()->get('db')->query($query, array('id' => $id_usr));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsFromCtanag() {
    $query = 'DELETE uc
      FROM b2b_usrctl uc
      INNER JOIN b2b_usrana ua ON uc.id_usr = ua.id_usr
      INNER JOIN ctanag ca ON ua.tpanag = ca.tpanag AND ua.cdanag = ca.cdanag';
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
