<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bTktest extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdtick;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdargo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuordc;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cduser;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $inmail;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $dstitl;

  /**
   *
   * @var integer
   * @Column(type="integer", length=4, nullable=false)
   *
   * Status:
   * 0 - Open
   * 1 - In progress
   * 2 - Waiting for user
   * 3 - Waiting for supplier
   * 4 - Closed
   */
  public $cdstat;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtcrea;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtchiu;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_tktest');
  }
  //endregion

  //region Custom queries

  /**
   * Query:   SELECT
   * Return:  Object
   */
  public static function getTicketsList($user_id = '') {
    if (!empty($user_id)){
      $andWhereUser = '';
      $params     = [];

      if ( !in_array(B2bSysusr::findFirst($user_id)->type, [1, 2, 6]) ) {
        // Se è admin, superadmin o support non filtra per utente
        $andWhereUser = ' AND tt.cduser = :user_id:';
        $params     = ['user_id' => $user_id];
      }

      $query = "SELECT
                  tt.cdtick, tt.numdoc,
                  tt.cduser, tt.cdargo,
                  tt.dstitl, tt.dtcrea,
                  tt.dtchiu, tt.cdstat,
                  su.username,
                  CONCAT(so.codart, ' - ', so.desart) AS dsarti,
                  COALESCE(NULLIF(tt.inmail,''), cl.indema, '-') AS inmail
                FROM
                  Go2B\Models\B2bTktest tt
                LEFT JOIN Go2B\Models\B2bSysusr su ON tt.cduser = su.id
                LEFT JOIN Go2B\Models\B2bUsrana ua ON su.id = ua.id_usr
                LEFT JOIN Go2B\Models\Anagra cl ON ua.tpanag = cl.tpanag AND ua.cdanag = cl.cdanag
                LEFT JOIN Go2B\Models\Stoord so ON tt.numdoc = so.numdoc AND tt.codart = so.codart
                WHERE
                  1=1 $andWhereUser
                ORDER BY
                  tt.cdstat ASC,
                  tt.dtcrea DESC";
      $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
      return $result;
    }
  }

  /**
   * Query:   SELECT
   * Return:  Object
   */
  public function getTicketsListForAdmin() {
    $query = "SELECT
              t.cdargo, t.cdstat,
              t.dstitl, t.dtcrea,
              t.dtchiu, u.inmail,
              u.nmuser, u.cdsoci
            FROM
              Go2B\Models\B2bTktest t
            LEFT JOIN Go2B\Models\B2bSysusr u ON u.cduser = t.cduser
            ORDER BY
              t.cdstat DESC,
              t.dtcrea DESC";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, ['user_id' => $user_id]);
    return $result->fetchAll();
  }

  /**
   * Query:   UPDATE
   * Return:  boolean
   */
  public static function updateTicketState($cdtick, $cdstat) {
    $ticket = B2bTktest::findFirst($cdtick);
    $ticket->cdstat = $cdstat;
    if ($cdstat == '4') {
      $ticket->dtchiu = new RawValue('now()');
    }
    return $ticket->save();
  }

  //endregion
}
