<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bTkstat extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=10, nullable=false)
   */
  public $cdsttk;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdtick;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cduser;

  /**
   *
   * @var integer
   * @Column(type="integer", length=4, nullable=false)
   *
   * 0 - Aperto
   * 1 - In corso
   * 2 - In attesa del fornitore
   * 3 - In attesa dell'utente
   * 4 - Chiuso
   */
  public $cdstat;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmodi;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_tkstat');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  boolean
   */
  public static function insertStateUpdate($cdtick, $cdstat, $cduser) {
    $tkstat = new B2bTkstat();
    $tkstat->cdtick = $cdtick;
    $tkstat->cdstat = $cdstat;
    $tkstat->cduser = $cduser;
    $tkstat->dtmodi = date('Y-m-d H:i:s');
    $tkstat->save();

    return $tkstat->cdsttk;
  }
  //endregion
}
