<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bTkcorp extends Model
{
    //region Fields
    /**
     *
     * @var integer
     * @Primary
     * @Identity
     * @Column(type="integer", length=8, nullable=false)
     */
    public $cdmtck;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdtick;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $cduser;

    /**
     *
     * @var string
     * @Column(type="string", length=255, nullable=false)
     */
    public $descri;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $dtmodi;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     * JSON Format:
     * [
     *     {
     *         "name": "file.pdf",
     *         "path": "\/asdad\/",
     *         "size": 1231312,
     *         "ext": "pdf"
     *     }
     * ]
     */
    public $allega;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('b2b_tkcorp');
    }
    //endregion

    //region Custom queries

    /**
     * Query:   INSERT
     * Return:  string
     */
    public static function addMessage($cdtick, $descri, $cduser, $allega = "")
    {
        $tkcorp = new B2bTkcorp();
        $tkcorp->cdtick = $cdtick;
        $tkcorp->cduser = $cduser;
        $tkcorp->descri = $descri;
        $curr_date = new \DateTime("now");
        $tkcorp->dtmodi = $curr_date->format('Y-m-d H:i:s');
        $tkcorp->allega = $allega;
        $result = $tkcorp->save() ? "OK" : $tkcorp->getMessages();

        return $result;
    }

    public function getAllegati()
    {
        return json_decode($this->allega ?: '[]') ?: [];
    }

    //endregion
}
