<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bModevi extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_modevi');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bModevi objects
   */
  public static function getFeaturedModels($items) {
    $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist']);

    // Dsartn translation
    $dsartn = 'tp.dsartn AS dsartn';
    $leftJoinDsartn = '';
    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d2.descri,d1.descri,tp.dsartn) AS dsartn';
      $leftJoinDsartn = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
      $leftJoinDsartn .= " LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
    
      $params['idlang'] = $items['idlang'];
    }

    // Custom discount
    $custDisc = '0 AS cust_disc ';
    $leftJoinDisbdy = '';
    if ($items['numdis'] > 0) {
      $custDisc = 'COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
      $leftJoinDisbdy =
       "INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
        INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = tl.cdtitl AND c1.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis: ";
      $params['numdis'] = $items['numdis'];
    }

    // Presence and availability
    $presence = '';
    $is_available = '';
    $leftJoinArtcol = '';
    $havingNotAvailable = '';
    if ($items['isOrder']) {
      // Presence
      $whr1_pr = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
      }

      $params['id_usr'] = $items['id_usr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailabilityOrder']) {
        $whr1_av = '';
        $whr2_av = '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
        }

        $is_available = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $havingNotAvailable = ' HAVING is_available = 1 ';
        }
      }
    }

    $orderBy = 'ORDER BY me.seqrap, me.cdartn';
    switch ($items['featuredSorting']) {
      case 0:
        $orderBy = 'ORDER BY catalogPrice ASC, me.seqrap';
        break;
      case 1:
        $orderBy = 'ORDER BY catalogPrice DESC, me.seqrap';
        break;
      case 2:
        $orderBy = 'ORDER BY me.cdartn ASC, me.seqrap';
        break;
      case 3:
        $orderBy = 'ORDER BY me.cdartn DESC, me.seqrap';
        break;
      case 4:
        $orderBy = 'ORDER BY dsartn ASC, me.seqrap';
        break;
      case 5:
        $orderBy = 'ORDER BY dsartn DESC, me.seqrap';
        break;
    }

    $query = "SELECT tp.cdartn, $dsartn, tp.tppers, tp.flimag,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $custDisc
      $presence $is_available
      FROM Go2B\Models\B2bModevi me
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = me.cdartn
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
      $leftJoinArtcol
      $leftJoinDisbdy
      $leftJoinDsartn
      WHERE me.cdcata = :cdcata:
      GROUP BY tp.cdartn
      $orderBy";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bModevi objects
   */
  public static function getFeaturedArticles($items) {
    $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist']);

    // Dsarti translation
    $dsarti = 'aa.dsarti AS dsarti';
    $leftJoinDsarti = '';
    if ($items['idlang'] != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $leftJoinDsarti = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
      $params['idlang'] = $items['idlang'];
    }

    // Custom discount
    $custDisc = '0 AS cust_disc ';
    $leftJoinDisbdy = '';
    if ($items['numdis'] > 0) {
      $custDisc = 'COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
      $leftJoinDisbdy =
       "INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
        INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = tl.cdtitl AND c1.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c5.numdis = :numdis: ";
      $params['numdis'] = $items['numdis'];
    }

    // Presence and availability
    $presence = '';
    $is_available = '';
    $leftJoinArtcol = '';
    $havingNotAvailable = '';
    if ($items['isOrder']) {
      // Presence
      $whr1_pr = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
      }

      $params['id_usr'] = $items['id_usr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailabilityOrder']) {
        $whr1_av = '';
        $whr2_av = '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
        }

        $is_available = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $havingNotAvailable = ' HAVING is_available = 1 ';
        }
      }
    }

    $orderBy = 'ORDER BY me.seqrap, me.cdartn';
    switch ($items['featuredSorting']) {
      case 0:
        $orderBy = 'ORDER BY catalogPrice ASC, me.seqrap';
        break;
      case 1:
        $orderBy = 'ORDER BY catalogPrice DESC, me.seqrap';
        break;
      case 2:
        $orderBy = 'ORDER BY me.cdartn ASC, me.seqrap';
        break;
      case 3:
        $orderBy = 'ORDER BY me.cdartn DESC, me.seqrap';
        break;
      case 4:
        $orderBy = 'ORDER BY dsarti ASC, me.seqrap';
        break;
      case 5:
        $orderBy = 'ORDER BY dsarti DESC, me.seqrap';
        break;
    }

    $query = "SELECT aa.cdarti, $dsarti, tp.tppers, aa.flimag,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $custDisc
      $presence $is_available
      FROM Go2B\Models\B2bModevi me
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = me.cdartn
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
      $leftJoinArtcol
      $leftJoinDisbdy
      $leftJoinDsarti
      WHERE me.cdcata = :cdcata:
      GROUP BY aa.cdarti
      $orderBy";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bModevi objects
   */
  public static function getFeaturedArtCol($items) {
    $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist']);

    // Dsarti translation
    $dsarti = 'aa.dsarti AS dsarti';
    $leftJoinDsarti = '';
    if ($items['idlang'] != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $leftJoinDsarti = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
      $params['idlang'] = $items['idlang'];
    }

    // Custom discount
    $custDisc = '0 AS cust_disc ';
    $leftJoinDisbdy = '';
    if ($items['numdis'] > 0) {
      $custDisc = 'COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
      $leftJoinDisbdy =
       "INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
        INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
        LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = tl.cdtitl AND c1.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
        LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c5.numdis = :numdis: ";
      $params['numdis'] = $items['numdis'];
    }

    // Presence and availability
    $presence = '';
    $is_available = '';
    $leftJoinArtcol = '';
    $havingNotAvailable = '';
    if ($items['isOrder']) {
      // Presence
      $whr1_pr = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
      }

      $params['id_usr'] = $items['id_usr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailabilityOrder']) {
        $whr1_av = '';
        $whr2_av = '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
        }

        $is_available = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $havingNotAvailable = ' HAVING is_available = 1 ';
        }
      }
    }

    $orderBy = 'ORDER BY me.seqrap, me.cdartn';
    switch ($items['featuredSorting']) {
      case 0:
        $orderBy = 'ORDER BY catalogPrice ASC, me.seqrap';
        break;
      case 1:
        $orderBy = 'ORDER BY catalogPrice DESC, me.seqrap';
        break;
      case 2:
        $orderBy = 'ORDER BY me.cdartn ASC, me.seqrap';
        break;
      case 3:
        $orderBy = 'ORDER BY me.cdartn DESC, me.seqrap';
        break;
      case 4:
        $orderBy = 'ORDER BY dsarti ASC, me.seqrap';
        break;
      case 5:
        $orderBy = 'ORDER BY dsarti DESC, me.seqrap';
        break;
    }

    $query = "SELECT aa.cdarti, co.cdcolo as color, $dsarti, tp.tppers, co.flimag,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $custDisc
      $presence $is_available
      FROM Go2B\Models\B2bModevi me
      INNER JOIN Go2B\Models\Artcol co ON me.cdartn = CONCAT(co.cdarti, ' ', co.cdcolo)
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = co.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
      $leftJoinArtcol
      $leftJoinDisbdy
      $leftJoinDsarti
      WHERE me.cdcata = :cdcata:
      GROUP BY co.cdcolo, aa.cdarti
      $orderBy, co.cdcolo";

      // Di::getDefault()->get('logger')->info($query);
      // Di::getDefault()->get('logger')->info(print_r($params, true));
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewFeaturedModel($cdcata, $cdartn, $seqrap) {
    $query = 'INSERT INTO b2b_modevi (cdcata, cdartn, seqrap)
      VALUES (:cdcata, :cdartn, :seqrap)';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata, 'cdartn' => $cdartn, 'seqrap' => $seqrap));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteFeaturedModelsForCatalog($cdcata) {
    $query = 'DELETE FROM b2b_modevi WHERE cdcata = :cdcata';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }
  //endregion
}
