<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bMngpar extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=255, nullable=false)
   */
  public $param;

  /**
   *
   * @var int
   * @Column(type="integer", length="6" nullable=false)
   * 0 = switch (enable/disable)
   */
  public $type;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $value;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_mngpar');
  }
  //endregion

  //region Aux functions
  public static function getCurrentManagementParams() {
    return array(
      array('param' => 'EnableAgentManager',        'type' => 0,  'value' => '0'),
      array('param' => 'EnableAvailabilityManager', 'type' => 0,  'value' => '0'),
      array('param' => 'EnableBrandManager',        'type' => 0,  'value' => '0'),
      array('param' => 'EnableCatalogManager',      'type' => 0,  'value' => '0'),
      array('param' => 'EnableConditionManager',    'type' => 0,  'value' => '0'),
      array('param' => 'EnableExpirationManager',   'type' => 0,  'value' => '0'),
      array('param' => 'EnableGoAppUserManager',    'type' => 0,  'value' => '0'),
      array('param' => 'EnableLineManager',         'type' => 0,  'value' => '0'),
      array('param' => 'EnableLookbookManager',     'type' => 0,  'value' => '0'),
      array('param' => 'EnablePromoManager',        'type' => 0,  'value' => '0'),
      array('param' => 'EnableSeasonsManager',      'type' => 0,  'value' => '0'),
      array('param' => 'EnableSeriesManager',       'type' => 0,  'value' => '0'),
      array('param' => 'EnableSizeScaleManager',    'type' => 0,  'value' => '0'),
    );
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2BApputi arrays
   */
  public static function getAllParams() {
    $query = 'SELECT p.param, p.type, p.value
      FROM b2b_mngpar p';
    $params = Di::getDefault()->get('db')->query($query);
    $paramsArray = array();
    foreach ($params as $param) {
      $paramsArray[$param['param']] = array('type' => $param['type'], 'value' => $util['value']);
    }
    return $paramsArray;
  }

  /**
   * Query:   UPDATE
   * Return:  bool
   */
  public static function updateRow($param, $value) {
    $query = 'UPDATE b2b_mngpar p
      SET p.value = :value
      WHERE p.param = :param';
    return Di::getDefault()->get('db')->query($query, array('param' => $param, 'value' => $value));
  }
  //endregion
}
