<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bHptest extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $flimg1;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $flimg2;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $flimg3;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_hptest');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   REPLACE
   * Return:  void
   */
  public static function insertOrReplaceHomePageHeaderImagesForCatalog($cdcata, $flimg1, $flimg2, $flimg3) {
    $params = array('cdcata' => $cdcata, 'flimg1' => $flimg1, 'flimg2' => $flimg2, 'flimg3' => $flimg3);
    $query = 'REPLACE INTO b2b_hptest (cdcata, flimg1, flimg2, flimg3)
      VALUES (:cdcata, :flimg1, :flimg2, :flimg3)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteHomePageHeaderForCatalog($cdcata) {
    $query = 'DELETE FROM b2b_hptest WHERE cdcata = :cdcata';
    Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }
  //endregion
}
