<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bGltest extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nugall;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_fr;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_de;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_gltest');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bGltest objects
   */
  public static function getGalleriesForCatalog($cdcata, $idlang = 'it') {
    $descri = 'des_' . strtolower($idlang);
    $params = array('cdcata' => $cdcata);
    $query = "SELECT gt.nugall, $descri AS descri, gt.des_it, gt.des_en, gt.des_es,
      gt.des_fr, gt.des_de, gt.flimag, gt.seqrap
      FROM Go2B\Models\B2bGltest gt
      WHERE gt.cdcata = :cdcata:
      ORDER BY gt.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bGltest objects
   */
  public static function getGalleryForCatalog($cdcata, $seqrap, $idlang = 'it') {
    $descri = 'des_' . strtolower($idlang);
    $params = array('cdcata' => $cdcata, 'seqrap' => $seqrap);
    $query = "SELECT gt.nugall, $descri AS descri, gt.des_it, gt.des_en, gt.des_es,
      gt.des_fr, gt.des_de, gt.flimag, gt.seqrap
      FROM Go2B\Models\B2bGltest gt
      WHERE gt.cdcata = :cdcata: AND gt.seqrap = :seqrap:
      ORDER BY gt.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getNextSeqrapForCatalog($cdcata) {
    $params = array('cdcata' => $cdcata);
    $query = "SELECT COALESCE(MAX(gt.seqrap),0) + 1 AS nextIndex
      FROM Go2B\Models\B2bGltest gt
      WHERE gt.cdcata = :cdcata: ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0]->nextIndex;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveGallery($cdcata, $des_it, $des_en, $des_es, $des_fr, $des_de, $flimag, $seqrap) {
    $params = array('cdcata' => $cdcata, 'des_it' => $des_it, 'des_en' => $des_en, 'des_es' => $des_es, 'des_fr' => $des_fr, 'des_de' => $des_de, 'flimag' => $flimag, 'seqrap' => $seqrap);
    $query = "INSERT INTO b2b_gltest (nugall, cdcata, des_it, des_en, des_es, des_fr, des_de, flimag, seqrap)
      VALUES ('', :cdcata, :des_it, :des_en, :des_es, :des_fr, :des_de, :flimag, :seqrap)";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateGalleryOrder($nugall, $seqrap) {
    $params = array('nugall' => $nugall, 'seqrap' => $seqrap);
    $query = "UPDATE b2b_gltest
      SET seqrap = :seqrap
      WHERE nugall = :nugall";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateGalleryImage($nugall, $flimag) {
    $params = array('nugall' => $nugall, 'flimag' => $flimag);
    $query = "UPDATE b2b_gltest
      SET flimag = :flimag
      WHERE nugall = :nugall";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateGalleryDescription($nugall, $des_it, $des_en, $des_fr, $des_de, $des_es) {
    $params = array('nugall' => $nugall, 'des_it' => $des_it, 'des_en' => $des_en, 'des_fr' => $des_fr, 'des_de' => $des_de, 'des_es' => $des_es);
    $query = "UPDATE b2b_gltest
      SET des_it = :des_it, des_en = :des_en, des_fr = :des_fr, des_de = :des_de, des_es = :des_es
      WHERE nugall = :nugall";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteGallery($nugall) {
    $params = array('nugall' => $nugall);
    $query = "DELETE FROM b2b_gltest
      WHERE nugall = :nugall";
    return Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
