<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bGlcorp extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nupunt;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nugall;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $coordx;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $coordy;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $radius;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $codice;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpdato;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_fr;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $des_de;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_glcorp');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveNewPointForGallery($glcorp, $nugall) {
    $params = array(
      'nugall' => $nugall,
      'coordx' => $glcorp['coordx'],
      'coordy' => $glcorp['coordy'],
      'radius' => $glcorp['radius'],
      'codice' => $glcorp['codice'],
      'des_it' => $glcorp['des_it'],
      'des_en' => $glcorp['des_en'],
      'des_es' => $glcorp['des_es'],
      'des_fr' => $glcorp['des_fr'],
      'des_de' => $glcorp['des_de']
    );
    $query = "INSERT INTO b2b_glcorp (nupunt, nugall, coordx, coordy, radius, codice, tpdato, des_it, des_en, des_es, des_fr, des_de)
      VALUES ('', :nugall, :coordx, :coordy, :radius, :codice, 'AN', :des_it, :des_en, :des_es, :des_fr, :des_de)";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllPointsForGallery($nugall) {
    $params = array('nugall' => $nugall);
    $query = "DELETE FROM b2b_glcorp
      WHERE nugall = :nugall";
    return Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
