<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bFlvisi extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=6, nullable=false)
   */
  public $codic1;

  /**
   *
   * @var string
   * @Identity
   * @Column(type="string", length=10, nullable=false)
   */
  public $codic2;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_de;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_fr;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_flvisi');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bFlvisi objects
   */
  public static function getCommonFilters() {
      /*
    $query = "SELECT *
      FROM (
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = 'dscolo'
        UNION
        SELECT 'dscolo', '', 0, '', '', '', '', '', 0
        UNION
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = 'tpmode'
        UNION
        SELECT 'tpmode', '', 0, '', '', '', '', '', 0
        UNION
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = 'tpgene'
        UNION
        SELECT 'tpgene', '', 0, '', '', '', '', '', 0
        UNION
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = 'taglia'
        UNION
        SELECT 'taglia', '', 0, '', '', '', '', '', 0
        UNION
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = 'cdpers'
        UNION
        SELECT 'cdpers', '', 0, '', '', '', '', '', 0
        UNION
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = 'prezzo'
        UNION
        SELECT 'prezzo', '', 0, '', '', '', '', '', 0
      ) AS t
      GROUP BY t.codic1";
*/
      // FIXME Leonardo Bravi - Non ho capito benissimo il giro ma se non escludiamo quelle che hanno codic1='tipcla' si dovrebbero raddoppiare perché escono anche dalla query presente in Tipcla::getFilterTags()
    $query = "SELECT *
      FROM b2b_flvisi v";

return Di::getDefault()->get('db')->query($query)->fetchAll();
}

  /**
   * Query:   SELECT
   * Return:  B2bFlvisi object
   */
  public static function getCommonFilterVisibility($filter) {
    $query = "SELECT *
      FROM (
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = :filter
        UNION
        SELECT :filter, '', 0, '', '', '', '', '', 0
      ) AS t
      GROUP BY t.codic1";
    return Di::getDefault()->get('db')->query($query, array('filter' => $filter))->fetchAll()[0];
  }

  /**
   * Query:   SELECT
   * Return:  B2bFlvisi object
   */
  public static function getAdditionalFilterVisibility($codic1, $codic2) {
    $query = "SELECT *
      FROM (
        SELECT v.codic1, v.codic2, v.flbloc, v.des_it, v.des_en, v.des_es, v.des_de, v.des_fr, v.seqrap
        FROM b2b_flvisi v
        WHERE v.codic1 = :codic1 AND v.codic2 = :codic2
        UNION
        SELECT :codic1, :codic2, 0, '', '', '', '', '', 0
      ) AS t
      GROUP BY t.codic1";
    return Di::getDefault()->get('db')->query($query, array('codic1' => $codic1, 'codic2' => $codic2))->fetchAll()[0];
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveFilterVisibility($flt) {
    $params = array(
      'codic1' => $flt['codic1'],
      'codic2' => $flt['codic2'],
      'des_it' => $flt['des_it'],
      'des_en' => $flt['des_en'],
      'des_es' => $flt['des_es'],
      'des_de' => $flt['des_de'],
      'des_fr' => $flt['des_fr'],
      'flbloc' => $flt['flbloc'],
      'seqrap' => $flt['seqrap']
    );
    $query = 'INSERT INTO b2b_flvisi (codic1, codic2, des_it, des_en, des_es, des_de, des_fr, flbloc, seqrap)
      VALUES (:codic1, :codic2, :des_it, :des_en, :des_es, :des_de, :des_fr, :flbloc, :seqrap)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function deleteAllFilterVisibilities() {
    $query = 'TRUNCATE b2b_flvisi';
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
