<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bFltest extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nutpfl;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $tpfilt;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_de;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $des_fr;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_fltest');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bFltest objects
   */
  public static function getAllArticleCustomFilterFromCatalog($cdcata, $type, $items) {
    $params = array('cdcata' => $cdcata, 'type' => $type);

    $innerJoinFilter = '';
    switch ($type) {
      case 'tpmode':
        $innerJoinFilter = 'INNER JOIN Go2B\Models\Tpmode tm ON fc.codice = tm.tpmode
                            INNER JOIN Go2B\Models\Tipolo tp ON tp.tpmode = tm.tpmode
                            INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn';
        break;
      case 'tpgene':
        $innerJoinFilter = 'INNER JOIN Go2B\Models\Tpgene tg ON fc.codice = tg.tpgene
                            INNER JOIN Go2B\Models\Tipolo tp ON tp.tpgene = tg.tpgene
                            INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn';
        break;
      case 'dscolo':
        $innerJoinFilter = 'INNER JOIN Go2B\Models\Anaart aa ON fc.codice = aa.dscolo
                            INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn';
        break;
      case 'cdpers':
        $innerJoinFilter = 'INNER JOIN Go2B\Models\Anaart aa ON fc.codice = aa.cdpers
                            INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn';
        break;
      case 'taglia':
        $innerJoinFilter = 'INNER JOIN Go2B\Models\Postgl pt ON fc.codice = pt.taglia
                            INNER JOIN Go2B\Models\Tipolo tp ON tp.cdtagl = pt.cdtagl
                            INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn';
        break;
    }

    $innerJoinAnaper = '';
    $andWhere = '';
    if (isset($items['cdpers'])) {
      $params['cdpers'] = $items['cdpers'];
      $andWhere .= ' AND ap.cdpers = :cdpers: ';
      $innerJoinAnaper = 'INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers ';
    }

    $join = '';
    if ($items['from'] != 'all') {
      switch ($items['from']) {
        case 'sermod':
          $params['code1'] = $items['code1'];
          $params['code2'] = $items['code2'];
          $andWhere .= ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ';
          break;
        case 'linmod':
          $params['code'] = $items['code'];
          $andWhere .= ' AND tp.cdlinm = :code: ';
          break;
        case 'titlin':
          $params['code'] = $items['code'];
          $join = 'INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
                   INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl';
          $andWhere .= ' AND tl.cdtitl = :code: ';
          break;
      }
    }

    $dsfilt = "ft.des_" . $items['lang'];
    $query = "SELECT ft.nutpfl AS codice, $dsfilt AS descri
      FROM Go2B\Models\B2bFltest ft
      INNER JOIN Go2B\Models\B2bFlcorp fc ON ft.nutpfl = fc.nutpfl
      $innerJoinFilter
      $innerJoinAnaper
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      $join
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND ft.tpfilt = :type:
      $andWhere
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY ft.nutpfl
      ORDER BY $dsfilt, ft.nutpfl";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function saveCustomFilter($tpfilt, $des_it, $des_en, $des_es, $des_de, $des_fr) {
    $fltest = new B2bFltest();
    $fltest->tpfilt = $tpfilt;
    $fltest->des_it = $des_it;
    $fltest->des_en = $des_en;
    $fltest->des_es = $des_es;
    $fltest->des_de = $des_de;
    $fltest->des_fr = $des_fr;
    $fltest->save();
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomFilter($nutpfl, $tpfilt, $des_it, $des_en, $des_es, $des_de, $des_fr) {
    $query = 'UPDATE b2b_fltest f
      SET f.tpfilt = :tpfilt, f.des_it = :des_it, f.des_en = :des_en,
          f.des_es = :des_es, f.des_de = :des_de, f.des_fr = :des_fr
      WHERE f.nutpfl = :nutpfl';
    $params = array(
      'nutpfl' => $nutpfl,
      'tpfilt' => $tpfilt,
      'des_it' => $des_it,
      'des_en' => $des_en,
      'des_es' => $des_es,
      'des_de' => $des_de,
      'des_fr' => $des_fr,
    );
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCustomFilter($nutpfl) {
    $query = 'DELETE f.* FROM b2b_fltest f WHERE f.nutpfl = :nutpfl';
    return Di::getDefault()->get('db')->query($query, array('nutpfl' => $nutpfl));
  }
  //endregion
}
