<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bDislst extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numdis;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $nulist;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_dislst');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomDiscountForPriceLists($numdis, $priceLists) {
    $params = array('numdis' => $numdis);
    $values = '';
    $query  = 'INSERT INTO b2b_dislst (numdis, nulist) VALUES';

    // Loop to raw insert max 200 rows each query
    for ($i = 0; $i < count($priceLists); $i++) {
      if ($i > 0 && $i % 200 == 0) {
        $query .= substr($values, 0, -1);
        Di::getDefault()->get('db')->query($query, $params);

        $params = array('numdis' => $numdis);
        $values = '';
        $query  = 'INSERT INTO b2b_dislst (numdis, nulist) VALUES';
      }

      $params['nulist' . $i] = $priceLists[$i];
      $values .= "(:numdis, :nulist" . $i . "),";
    }

    $query .= substr($values, 0, -1);
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForNumdis($numdis) {
    $query = 'DELETE d
      FROM b2b_dislst d
      WHERE d.numdis = :numdis';
    Di::getDefault()->get('db')->query($query, array('numdis' => $numdis));
  }
  //endregion
}
