<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bDishea extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numdis;

  /**
   *
   * @var string
   * @Column(type="string", length=25, nullable=false)
   */
  public $cddisc;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsdisc;

  /**
   *
   * @var string
   * @Column(type="int", length=3, nullable=false)
   */
  public $tpdisc;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtiniz;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $dtfine;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $fltota;

  /**
   *
   * @var integer
   * @Column(type="integer", length=1, nullable=false)
   */
  public $flpora;

  /**
   *
   * @var integer
   * @Column(type="integer", length=1, nullable=false)
   */
  public $flpaga;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_dishea');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bDishea objects
   */
  public static function getAllCustomDiscounts() {
    $query = "SELECT DISTINCT c.numdis, c.dsdisc, c.tpdisc, c.flbloc, c.fltota,
      COALESCE((SELECT COUNT(*) FROM Go2B\Models\B2bDisana a WHERE a.numdis = c.numdis),0) AS totana,
      COALESCE((SELECT COUNT(*) FROM Go2B\Models\B2bDislst l WHERE l.numdis = c.numdis),0) AS totlis,
      COALESCE((SELECT COUNT(*) FROM Go2B\Models\B2bDisctl t WHERE t.numdis = c.numdis),0) AS totctl,
      DATE_FORMAT(c.dtiniz, '%d/%m/%Y') AS dtiniz, DATE_FORMAT(c.dtfine, '%d/%m/%Y') AS dtfine,
      DATE_FORMAT(c.dtiniz, '%Y%m%d') AS dtiniz_sort, DATE_FORMAT(c.dtfine, '%Y%m%d') AS dtfine_sort
      FROM Go2B\Models\B2bDishea c
      ORDER BY c.numdis";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bDishea objects
   */
  public static function getAllAvailableCustomDiscountCodes($nulist, $cdcata, $tpanag, $cdanag, $tpport, $tppaga) {
      $params = array(
          'nulist' => $nulist,
          'cdcata' => $cdcata,
          'today'  => date('Y-m-d'),
      );

      $additionalJoin = '';
      $additionalWhere = [];

      if (!empty($tpanag) && !empty($cdanag)) {
          $additionalJoin .= ' LEFT JOIN Go2B\Models\B2bDisana ca ON ch.numdis = ca.numdis AND ca.tpanag = :tpanag: AND ca.cdanag = :cdanag:';
          $additionalWhere[] = '(ch.fltota = 1 AND ca.cdanag IS NULL) OR (ch.fltota = 0 AND ca.cdanag IS NOT NULL)';
          $params['tpanag'] = $tpanag;
          $params['cdanag'] = $cdanag;
      } else {
          $additionalWhere[] = 'ch.fltota = 1';
      }

      if (!empty($tpport)) {
          $additionalJoin .= ' LEFT JOIN Go2B\Models\B2bDispor pr ON ch.numdis = pr.numdis AND pr.tpport = :tpport:';
          $additionalWhere[] = 'ch.flpora = 1 OR pr.tpport IS NOT NULL';
          $params['tpport'] = $tpport;
      } else {
          $additionalWhere[] = 'ch.flpora = 1';
      }

      if (!empty($tppaga)) {
          $additionalJoin .= ' LEFT JOIN Go2B\Models\B2bDispag pg ON ch.numdis = pg.numdis AND pg.tppaga = :tppaga:';
          $additionalWhere[] = 'ch.flpaga = 1 OR pg.tppaga IS NOT NULL';
          $params['tppaga'] = $tppaga;
      } else {
          $additionalWhere[] = 'ch.flpaga = 1';
      }

    $query = "SELECT ch.numdis
      FROM Go2B\Models\B2bDishea ch
      INNER JOIN Go2B\Models\B2bDislst cl ON ch.numdis = cl.numdis AND cl.nulist = :nulist:
      INNER JOIN Go2B\Models\B2bDisctl cc ON ch.numdis = cc.numdis AND cc.cdcata = :cdcata:   
      $additionalJoin   
      WHERE ch.dtiniz <= :today: AND ch.dtfine >= :today: AND ch.flbloc = 0 AND ("
        . implode(') AND (', $additionalWhere) . ")
      ORDER BY ch.fltota ASC, (ch.flpora + ch.flpaga) DESC";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bDishea objects
   */
  public static function getAllAvailableGlobalCustomDiscountCodes($nulist, $cdcata, $tpport, $tppaga) {
      $params = array(
          'nulist' => $nulist,
          'cdcata' => $cdcata,
          'today'  => date('Y-m-d'),
      );

      $additionalJoin = '';
      $additionalWhere = [];
      if (!empty($tpport)) {
          $additionalJoin .= ' LEFT JOIN Go2B\Models\B2bDispor pr ON ch.numdis = pr.numdis AND pr.tpport = :tpport:';
          $additionalWhere[] = '(ch.flpora = 1 OR pr.tpport IS NOT NULL)';
          $params['tpport'] = $tpport;
      } else {
          $additionalWhere[] = 'ch.flpora = 1';
      }

      if (!empty($tppaga)) {
          $additionalJoin .= ' LEFT JOIN Go2B\Models\B2bDispag pg ON ch.numdis = pg.numdis AND pg.tppaga = :tppaga:';
          $additionalWhere[] = '(ch.flpaga = 1 OR pg.tppaga IS NOT NULL)';
          $params['tppaga'] = $tppaga;
      } else {
          $additionalWhere[] = 'ch.flpaga = 1';
      }

    $query = "SELECT ch.numdis
      FROM Go2B\Models\B2bDishea ch
      INNER JOIN Go2B\Models\B2bDislst cl ON ch.numdis = cl.numdis AND cl.nulist = :nulist:
      INNER JOIN Go2B\Models\B2bDisctl cc ON ch.numdis = cc.numdis AND cc.cdcata = :cdcata:
      $additionalJoin
      WHERE ch.dtiniz <= :today: AND ch.dtfine >= :today: AND ch.flbloc = 0 AND ch.fltota = 1 AND " .
        implode(' AND ', $additionalWhere);

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function isCurrentCustomDiscountAllowed($catalogs, $customers, $priceLists, $allPortsFlag, $ports, $allPaymentsFlag, $payments, $allCustomersFlag, $dtiniz, $dtfine) {
    $params = array(
        'dtiniz' => $dtiniz,
        'dtfine' => $dtfine,
        'fltota' => $allCustomersFlag,
        'flpora' => $allPortsFlag,
        'flpaga' => $allPaymentsFlag,
    );

    $whereCatalogs = '';
    for ($i = 0; $i < count($catalogs); $i++) {
      $whereCatalogs .= ":cttest$i,";
      $params['cttest' . $i] = $catalogs[$i];
    }
    $whereCatalogs = substr($whereCatalogs, 0, -1);

    if (!$allCustomersFlag) {
      $whereCustomers = '';
      for ($i = 0; $i < count($customers); $i++) {
        $whereCustomers .= "(ca.tpanag = :tpanag$i AND ca.cdanag = :cdanag$i) OR ";
        $params['tpanag' . $i] = $customers[$i][0];
        $params['cdanag' . $i] = $customers[$i][1];
      }
      $whereCustomers = substr($whereCustomers, 0, -4);

      $customersSubquery = "
        (SELECT COUNT(DISTINCT ca.numdis, ca.tpanag, ca.cdanag)
        FROM b2b_disana ca
        WHERE ca.numdis = ch.numdis AND ($whereCustomers)) > 0 AS same_cus,";
    } else {
      $customersSubquery = '';
    }

    $wherePriceLists = '';
    for ($i = 0; $i < count($priceLists); $i++) {
      $wherePriceLists .= ":lstest$i,";
      $params['lstest' . $i] = $priceLists[$i];
    }
    $wherePriceLists = substr($wherePriceLists, 0, -1);

    $portsSubquery = "0";
    if (!empty($ports)) {
        $wherePorts = '';
        for ($i = 0; $i < count($ports); $i++) {
            $wherePorts .= ":tpport$i,";
            $params['tpport' . $i] = $ports[$i];
        }
        $wherePorts = substr($wherePorts, 0, -1);
        $portsSubquery = "(SELECT COUNT(DISTINCT pt.numdis, pt.tpport)
        FROM b2b_dispor pt
        WHERE pt.numdis = ch.numdis AND pt.tpport IN ($wherePorts)) > 0";
    }

    $paymentsSubquery = "0";
    if (!empty($payments)) {
        $wherePayments = '';
        for ($i = 0; $i < count($payments); $i++) {
            $wherePayments .= ":tppaga$i,";
            $params['tppaga' . $i] = $payments[$i];
        }
        $wherePayments = substr($wherePayments, 0, -1);
        $paymentsSubquery = "(SELECT COUNT(DISTINCT pg.numdis, pg.tppaga)
        FROM b2b_dispag pg
        WHERE pg.numdis = ch.numdis AND pg.tppaga IN ($wherePayments)) > 0";
    }

    // check period
    $query = "SELECT ch.numdis,
      (SELECT COUNT(DISTINCT cc.numdis, cc.cdcata)
        FROM b2b_disctl cc
        WHERE cc.numdis = ch.numdis AND cc.cdcata IN ($whereCatalogs)) > 0 AS same_ctl,
      $customersSubquery
      (SELECT COUNT(DISTINCT cl.numdis, cl.nulist)
        FROM b2b_dislst cl
        WHERE cl.numdis = ch.numdis AND cl.nulist IN ($wherePriceLists)) > 0 AS same_lis,
      $portsSubquery AS same_por,
      $paymentsSubquery AS same_pag
      FROM b2b_dishea ch
      WHERE ch.fltota = :fltota AND ch.flpora = :flpora AND ch.flpaga = :flpaga
      AND ((ch.dtiniz <= :dtiniz AND ch.dtfine >= :dtiniz) OR (ch.dtiniz <= :dtfine AND ch.dtfine >= :dtfine))";

    $cdhead = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

    $isAllowed = true;
    for ($i = 0; $i < count($cdhead); $i++) {
      if ($cdhead[$i]['same_ctl'] > 0 && ($allCustomersFlag || $cdhead[$i]['same_cus'] > 0) && $cdhead[$i]['same_lis'] > 0 && $cdhead[$i]['same_por'] > 0 && $cdhead[$i]['same_pag'] > 0) {
        $isAllowed = false;
        break;
      }
    }

    return $isAllowed;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomDiscount($cddisc, $dsdisc, $tpdisc, $dtiniz, $dtfine, $fltota, $flpora, $flpaga) {
    $cdhead = new self();
    $cdhead->cddisc = $cddisc;
    $cdhead->dsdisc = $dsdisc;
    $cdhead->fltota = $fltota;
    $cdhead->tpdisc = $tpdisc;
    $cdhead->dtiniz = $dtiniz;
    $cdhead->dtfine = $dtfine;
    $cdhead->flpora = $flpora;
    $cdhead->flpaga = $flpaga;
    $cdhead->flbloc = 0;
    $cdhead->save();
    return $cdhead;
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateBlockFlag($numdis, $flbloc) {
    $query = 'UPDATE b2b_dishea
      SET flbloc = :flbloc
      WHERE numdis = :numdis';
    Di::getDefault()->get('db')->query($query, array('numdis' => $numdis, 'flbloc' => $flbloc));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForNumdis($numdis) {
    $query = 'DELETE d
      FROM b2b_dishea d
      WHERE d.numdis = :numdis';
    Di::getDefault()->get('db')->query($query, array('numdis' => $numdis));
  }
  //endregion
}
