<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bDisbdy extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numrow;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numdis;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdtitl;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdserm;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpmode;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $sconto;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_disbdy');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  B2bDisbdy array
   */
  public static function getCustomDiscountForCdarti($numdis, $cdarti) {
    $query = "SELECT 1 AS priority, cb.sconto AS sconto
      FROM b2b_disbdy cb
      INNER JOIN linmod lm ON lm.cdtitl = cb.cdtitl
      INNER JOIN tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN anaart aa ON aa.cdartn = tp.cdartn
      WHERE cb.numdis = :numdis AND aa.cdarti = :cdarti AND cb.cdtitl != ''
      UNION
      SELECT 2 AS priority, cb.sconto AS sconto
      FROM b2b_disbdy cb
      INNER JOIN tipolo tp ON tp.cdlinm = cb.cdlinm
      INNER JOIN anaart aa ON aa.cdartn = tp.cdartn
      WHERE cb.numdis = :numdis AND aa.cdarti = :cdarti AND cb.cdlinm != '' AND cb.cdserm = ''
      UNION
      SELECT 3 AS priority, cb.sconto AS sconto
      FROM b2b_disbdy cb
      INNER JOIN tipolo tp ON tp.cdlinm = cb.cdlinm AND tp.cdserm = cb.cdserm
      INNER JOIN anaart aa ON aa.cdartn = tp.cdartn
      WHERE cb.numdis = :numdis AND aa.cdarti = :cdarti AND cb.cdlinm != '' AND cb.cdserm != ''
      UNION
      SELECT 4 AS priority, cb.sconto AS sconto
      FROM b2b_disbdy cb
      INNER JOIN tipolo tp ON tp.tpmode = cb.tpmode
      INNER JOIN anaart aa ON aa.cdartn = tp.cdartn
      WHERE cb.numdis = :numdis AND aa.cdarti = :cdarti AND cb.tpmode != ''
      UNION
      SELECT 5 AS priority, cb.sconto AS sconto
      FROM b2b_disbdy cb
      INNER JOIN anaart aa ON aa.cdartn = cb.cdartn
      WHERE cb.numdis = :numdis AND aa.cdarti = :cdarti AND cb.cdartn != ''
      UNION
      SELECT 6 AS priority, cb.sconto AS sconto
      FROM b2b_disbdy cb
      WHERE cb.numdis = :numdis AND cb.cdarti = :cdarti
      ORDER BY priority DESC
      LIMIT 1";
    $discount = Di::getDefault()->get('db')->query($query, array('numdis' => $numdis, 'cdarti' => $cdarti))->fetchAll();

    return count($discount) > 0 ? $discount[0] : array();
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomDiscountBody($numdis, $cdbody) {
    $params = array('numdis' => $numdis);
    $values = '';
    $query  = 'INSERT INTO b2b_disbdy (numrow, numdis, sconto, cdtitl, cdlinm, cdserm, tpmode, cdartn, cdarti) VALUES';

    // Loop to raw insert max 200 rows each query
    for ($i = 0; $i < count($cdbody); $i++) {
      if ($i > 0 && $i % 200 == 0) {
        $query .= substr($values, 0, -1);
        Di::getDefault()->get('db')->query($query, $params);

        $params = array('numdis' => $numdis);
        $values = '';
        $query  = 'INSERT INTO b2b_disbdy (numrow, numdis, sconto, cdtitl, cdlinm, cdserm, tpmode, cdartn, cdarti) VALUES';
      }

      $params['sconto' . $i] = $cdbody[$i]['sconto'];
      $params['cdtitl' . $i] = $cdbody[$i]['cdtitl'];
      $params['cdlinm' . $i] = $cdbody[$i]['cdlinm'];
      $params['cdserm' . $i] = $cdbody[$i]['cdserm'];
      $params['tpmode' . $i] = $cdbody[$i]['tpmode'];
      $params['cdartn' . $i] = $cdbody[$i]['cdartn'];
      $params['cdarti' . $i] = $cdbody[$i]['cdarti'];
      $values .= "('', :numdis, :sconto" . $i . ", :cdtitl" . $i .
        ", :cdlinm" . $i . ", :cdserm" . $i . ", :tpmode" . $i .
        ", :cdartn" . $i . ", :cdarti" . $i . "),";
    }

    $query .= substr($values, 0, -1);
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForNumdis($numdis) {
    $query = 'DELETE d
      FROM b2b_disbdy d
      WHERE d.numdis = :numdis';
    Di::getDefault()->get('db')->query($query, array('numdis' => $numdis));
  }
  //endregion
}
