<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bCuspor extends Model
{
    //region Fields
    /**
     *
     * @var integer
     * @Primary
     * @Identity
     * @Column(type="integer", length=11, nullable=false)
     */
    public $numpor;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=4, nullable=false)
     */
    public $tpport;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $dstpor;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */


    public $cdnazi;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $valmin;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $valmax;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $preagg;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $contra;

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('b2b_cuspor');
    }
    //endregion

    //region Custom queries
    public static function convertRowsWithJsonToOldStyleRows($rows) {
        $oldStyleCuport = [];
        foreach ($rows as $tupla) {
            $scaglioni = json_decode($tupla['config'] ?: '[]', true) ?: [];
            foreach ($scaglioni as $idx => $scaglione) {
                $oldStyleCuport[] = [
                    'id' => $tupla['numpor'] . '-' . $idx,
                    'numpor' => $tupla['numpor'],
                    'tpport' => $tupla['tpport'],
                    'dstpor' => $tupla['dstpor'],
                    'cdnazi' => $tupla['cdnazi'],
                    'valmin' => $scaglione['valmin'],
                    'valmax' => $scaglione['valmax'],
                    'preagg' => $scaglione['preagg'],
                    'contra' => $scaglione['contra'],
                ];
            }
        }
        return $oldStyleCuport;
    }

    /**
     * Query:   SELECT
     * Return:  Array of B2bCuspor objects
     */
    public static function getAllCustomShipments()
    {
        $query = "SELECT c.numpor AS id, c.numpor, c.tpport, c.dstpor, c.cdnazi, c.config, GROUP_CONCAT(cdnazi) AS codici_nazioni
  FROM b2b_cuspor c
  GROUP BY tpport, config
  ORDER BY tpport";
        return Di::getDefault()->get('db')->query($query)->fetchAll(\PDO::FETCH_ASSOC);
    }

    public static function getCustomShipmentsByTpport($tpport)
    {
        $query = "SELECT c.numpor, c.tpport, c.dstpor, c.config, c.cdnazi FROM b2b_cuspor c WHERE c.tpport = :tpport";
        $params = ['tpport' => $tpport];
        return self::convertRowsWithJsonToOldStyleRows(Di::getDefault()->get('db')->query($query, $params)->fetchAll(\PDO::FETCH_ASSOC));
    }

    /**
     * Query:   SELECT
     * Return:  Array of B2bCuspor arrays
     */
    public static function getCustomShipmentsForCountry($cdnazi)
    {
        $params = array('cdnazi' => $cdnazi);
        $query = "SELECT c.numpor, c.tpport, c.dstpor, c.config, c.cdnazi FROM b2b_cuspor c WHERE c.cdnazi = :cdnazi OR c.cdnazi = 'ALL' ";
        return self::convertRowsWithJsonToOldStyleRows(Di::getDefault()->get('db')->query($query, $params)->fetchAll(\PDO::FETCH_ASSOC));
    }

    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function insertNewCustomShipment($items)
    {
        $params = $items;
        $query = "INSERT INTO b2b_cuspor (numpor, tpport, dstpor, cdnazi, config)
      VALUES (0, :tpport, :dstpor, :cdnazi, :config)";

        Di::getDefault()->get('db')->query($query, $params);
    }

    //endregion

    public static function deleteCustomShipment($numpor)
    {
        $query = "DELETE a.*
      FROM b2b_cuspor a
      WHERE a.nuport = $numpor";
        Di::getDefault()->get('db')->query($query);
    }

    public static function deleteCustomShipmentsByTpport($tpport)
    {

        $query = 'DELETE d.*
      FROM b2b_cuspor d
      WHERE d.tpport = :tpport';

        Di::getDefault()->get('db')->query($query, array('tpport' => $tpport));
    }

    public static function deleteCustomShipmentsByTpportAndCdnazi($tpport, $cdnazi)
    {
        Di::getDefault()->get('db')->query(
            'DELETE FROM b2b_cuspor d WHERE d.tpport = :tpport AND cdnazi = :cdnazi',
            ['tpport' => $tpport, 'cdnazi' => $cdnazi]
        );
    }


}
