<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bCuspag extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numpag;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tppaga;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dspaga;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdnazi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valmin;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valmax;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $preagg;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_cuspag');
  }
  //endregion

  //region Custom queries
    public static function convertRowsWithJsonToOldStyleRows($rows) {
        $oldStyleCupaga = [];
        foreach ($rows as $tupla) {
            $scaglioni = json_decode($tupla['config'] ?: '[]', true) ?: [];
            foreach ($scaglioni as $idx => $scaglione) {
                $oldStyleCupaga[] = [
                    'id' => $tupla['numpag'] . '-' . $idx,
                    'numpag' => $tupla['numpag'],
                    'tppaga' => $tupla['tppaga'],
                    'dspaga' => $tupla['dspaga'],
                    'cdnazi' => $tupla['cdnazi'],
                    'valmin' => $scaglione['valmin'],
                    'valmax' => $scaglione['valmax'],
                    'preagg' => $scaglione['preagg'],
                ];
            }
        }
//        var_dump($oldStyleCupaga);
        return $oldStyleCupaga;
    }

    /**
   * Query:   SELECT
   * Return:  Array of B2bCuspag objects
   */
  public static function getAllCustomPayments() {
    $query = "SELECT c.numpag, c.numpag, c.tppaga, c.dspaga, c.cdnazi, c.config, GROUP_CONCAT(cdnazi) AS codici_nazioni
    FROM b2b_cuspag c
    GROUP BY tppaga, config
    ORDER BY tppaga";
          return Di::getDefault()->get('db')->query($query)->fetchAll(\PDO::FETCH_ASSOC);
  }

  /**
   * Query:   SELECT
   * Return:  Array of B2bCuspag arrays
   */
  public static function getCustomPaymentsForCountry($cdnazi) {
    $params = array('cdnazi' => $cdnazi);
    $query = "SELECT c.numpag, c.tppaga, c.dspaga, c.config, c.cdnazi
      FROM b2b_cuspag c
      WHERE c.cdnazi = :cdnazi OR c.cdnazi = 'ALL' ";
    // GROUP BY c.tppaga ";
    return self::convertRowsWithJsonToOldStyleRows(Di::getDefault()->get('db')->query($query, $params)->fetchAll(\PDO::FETCH_ASSOC));
  }
  //endregion


  public static function insertNewCustomPayment($items)
  {
      $params = $items;
      $query = "INSERT INTO b2b_cuspag (numpag, tppaga, dspaga, cdnazi, config)
    VALUES (0, :tppaga, :dspaga, :cdnazi, :config)";

      Di::getDefault()->get('db')->query($query, $params);
  }

  public static function deleteCustomPayment($numpag)
  {
      $query = "DELETE a.*
    FROM b2b_cuspag a
    WHERE a.nupag = $numpag";
      Di::getDefault()->get('db')->query($query);
  }




}
