<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bCtlcpn extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Identity
   * @Column(type="integer", length=11, nullable=false)
   */
  public $id;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cdcoup;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_ctlcpn');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  B2bCtlcpn object
   */
  public static function isCouponPresentInCatalog($cdcata, $cdcoup) {
    $params = array('cdcata' => $cdcata, 'cdcoup' => $cdcoup);
    $query = "SELECT COUNT(cc.id) AS count
      FROM Go2B\Models\B2bCtlcpn cc
      WHERE cc.cdcata = :cdcata: AND cc.cdcoup = :cdcoup:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0]->count > 0;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCatalogsForCoupon($cdcoup, $catalogs) {
    $values = '';
    $i = 0;
    $params['cdcoup'] = $cdcoup;
    foreach ($catalogs as $cdcata) {
      $values .= "('', :cdcata" . $i . ", :cdcoup),";
      $params['cdcata' . $i] = $cdcata;
      $i++;
    }
    $values = substr($values, 0, -1);
    $query = "INSERT INTO b2b_ctlcpn (id, cdcata, cdcoup) VALUES $values";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdcoup($cdcoup) {
    $query = 'DELETE cc
      FROM b2b_ctlcpn cc
      WHERE cc.cdcoup = :cdcoup';
    Di::getDefault()->get('db')->query($query, array('cdcoup' => $cdcoup));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCoupons($coupons) {
    $params = array();
    $where  = 'WHERE ';
    for ($i = 0; $i < count($coupons); $i++) {
      $params['cdcoup' . $i] = $coupons[$i];
      $where .= ($i != 0 ? ' OR ' : '') . 'cc.cdcoup = :cdcoup' . $i;
    }
    $query = "DELETE cc
      FROM b2b_ctlcpn cc
      $where ";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
