<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bCsmenu extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpdato;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=true)
   */
  public $codic1;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=true)
   */
  public $codic2;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_it;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_en;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_es;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_fr;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=true)
   */
  public $des_de;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=true)
   */
  public $flsblv;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_csmenu');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bCsmenu objects
   */
  public static function getCustomMenuForCatalog($cdcata) {
    $query = "SELECT c.cdcata, c.seqrap, c.tpdato, c.codic1, c.codic2,
      t.dstitl AS br_fulldescr,
      COALESCE(tl.cdtitl,'') AS lm_cdtitl, CONCAT(tl.dstitl, ' - ', l.dslinm) AS lm_fulldescr,
      COALESCE(ts.cdtitl,'') AS sm_cdtitl, CONCAT(ts.dstitl, ' - ', ls.dslinm, ' - ', s.dsserm) AS sm_fulldescr,
      g.dsgene AS tg_fulldescr, m.dstmod AS tm_fulldescr, st.des_it AS ss_fulldescr,
      IF(c.des_it != '', c.des_it, COALESCE(t.dstitl, l.dslinm, s.dsserm, g.dsgene, m.dstmod, st.des_it)) AS des_it,
      IF(c.des_en != '', c.des_en, COALESCE(dten.descri, dlen.descri, dsen.descri, dgen.descri, dmen.descri, st.des_en)) AS des_en,
      IF(c.des_es != '', c.des_es, COALESCE(dtes.descri, dles.descri, dses.descri, dges.descri, dmes.descri, st.des_es)) AS des_es,
      IF(c.des_fr != '', c.des_fr, COALESCE(dtfr.descri, dlfr.descri, dsfr.descri, dgfr.descri, dmfr.descri, st.des_fr)) AS des_fr,
      IF(c.des_de != '', c.des_de, COALESCE(dtde.descri, dlde.descri, dsde.descri, dgde.descri, dmde.descri, st.des_de)) AS des_de,
      c.flsblv
      FROM Go2B\Models\B2bCsmenu c
      LEFT JOIN Go2B\Models\Titlin t ON c.tpdato = 'BR' AND t.cdtitl = c.codic1 AND c.codic2 = ''
      LEFT JOIN Go2B\Models\Deslin dten ON dten.tpdato = 'dstitl' AND dten.codic1 = t.cdtitl AND dten.codic2 = '' AND dten.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin dtes ON dtes.tpdato = 'dstitl' AND dtes.codic1 = t.cdtitl AND dtes.codic2 = '' AND dtes.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dtfr ON dtfr.tpdato = 'dstitl' AND dtfr.codic1 = t.cdtitl AND dtfr.codic2 = '' AND dtfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dtde ON dtde.tpdato = 'dstitl' AND dtde.codic1 = t.cdtitl AND dtde.codic2 = '' AND dtde.idlang = 'DE'
      LEFT JOIN Go2B\Models\Linmod l ON c.tpdato = 'LM' AND l.cdlinm = c.codic1 AND c.codic2 = ''
      LEFT JOIN Go2B\Models\Titlin tl ON l.cdtitl = tl.cdtitl
      LEFT JOIN Go2B\Models\Deslin dlen ON dlen.tpdato = 'dslinm' AND dlen.codic1 = l.cdlinm AND dlen.codic2 = '' AND dlen.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin dles ON dles.tpdato = 'dslinm' AND dles.codic1 = l.cdlinm AND dles.codic2 = '' AND dles.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dlfr ON dlfr.tpdato = 'dslinm' AND dlfr.codic1 = l.cdlinm AND dlfr.codic2 = '' AND dlfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dlde ON dlde.tpdato = 'dslinm' AND dlde.codic1 = l.cdlinm AND dlde.codic2 = '' AND dlde.idlang = 'DE'
      LEFT JOIN Go2B\Models\Sermod s ON c.tpdato = 'SM' AND s.cdlinm = c.codic1 AND s.cdserm = c.codic2
      LEFT JOIN Go2B\Models\Linmod ls ON s.cdlinm = ls.cdlinm
      LEFT JOIN Go2B\Models\Titlin ts ON ls.cdtitl = ts.cdtitl
      LEFT JOIN Go2B\Models\Deslin dsen ON dsen.tpdato = 'dsserm' AND dsen.codic1 = s.cdlinm AND dsen.codic2 = s.cdserm AND dten.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin dses ON dses.tpdato = 'dsserm' AND dses.codic1 = s.cdlinm AND dses.codic2 = s.cdserm AND dtes.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dsfr ON dsfr.tpdato = 'dsserm' AND dsfr.codic1 = s.cdlinm AND dsfr.codic2 = s.cdserm AND dtfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dsde ON dsde.tpdato = 'dsserm' AND dsde.codic1 = s.cdlinm AND dsde.codic2 = s.cdserm AND dtde.idlang = 'DE'
      LEFT JOIN Go2B\Models\Tpgene g ON c.tpdato = 'TG' AND g.tpgene = c.codic1 AND c.codic2 = ''
      LEFT JOIN Go2B\Models\Deslin dgen ON dgen.tpdato = 'dsgene' AND dgen.codic1 = g.tpgene AND dgen.codic2 = '' AND dgen.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin dges ON dges.tpdato = 'dsgene' AND dges.codic1 = g.tpgene AND dges.codic2 = '' AND dges.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dgfr ON dgfr.tpdato = 'dsgene' AND dgfr.codic1 = g.tpgene AND dgfr.codic2 = '' AND dgfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dgde ON dgde.tpdato = 'dsgene' AND dgde.codic1 = g.tpgene AND dgde.codic2 = '' AND dgde.idlang = 'DE'
      LEFT JOIN Go2B\Models\Tpmode m ON c.tpdato = 'TM' AND m.tpmode = c.codic1 AND c.codic2 = ''
      LEFT JOIN Go2B\Models\Deslin dmen ON dmen.tpdato = 'dstmod' AND dmen.codic1 = m.tpmode AND dmen.codic2 = '' AND dmen.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin dmes ON dmes.tpdato = 'dstmod' AND dmes.codic1 = m.tpmode AND dmes.codic2 = '' AND dmes.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dmfr ON dmfr.tpdato = 'dstmod' AND dmfr.codic1 = m.tpmode AND dmfr.codic2 = '' AND dmfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dmde ON dmde.tpdato = 'dstmod' AND dmde.codic1 = m.tpmode AND dmde.codic2 = '' AND dmde.idlang = 'DE'
      LEFT JOIN Go2B\Models\B2bSstest st ON c.tpdato = 'SS' AND st.cdspsl = c.codic1 AND c.codic2 = ''
      WHERE c.cdcata = :cdcata:
      ORDER BY c.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCustomMenuRow($row) {
    $params = array(
      'cdcata' => $row[0],
      'seqrap' => $row[1],
      'tpdato' => $row[2],
      'codic1' => $row[3],
      'codic2' => $row[4],
      'des_it' => $row[5],
      'des_en' => $row[6],
      'des_es' => $row[7],
      'des_fr' => $row[8],
      'des_de' => $row[9],
      'flsblv' => $row[10] == 'true' ? 1 : 0,
    );
    $query = "INSERT INTO b2b_csmenu (cdcata, seqrap, tpdato, codic1, codic2,
        des_it, des_en, des_es, des_fr, des_de, flsblv)
      VALUES (:cdcata, :seqrap, :tpdato, :codic1, :codic2, :des_it, :des_en,
        :des_es, :des_fr, :des_de, :flsblv)";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCustomMenuForCatalog($cdcata) {
    $query = "DELETE c.*
      FROM b2b_csmenu c
      WHERE c.cdcata = :cdcata";
    return Di::getDefault()->get('db')->query($query, array('cdcata' => $cdcata));
  }
  //endregion
}
