<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bColors extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=60, nullable=false)
   */
  public $codice;

  /**
   *
   * @var string
   * @Column(type="string", length=6, nullable=true)
   */
  public $rgbcd1;

  /**
   *
   * @var string
   * @Column(type="string", length=6, nullable=true)
   */
  public $rgbcd2;

  /**
   *
   * @var string
   * @Column(type="string", length=6, nullable=true)
   */
  public $rgbcd3;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=true)
   */
  public $flimag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flmult;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_colors');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   DELETE
   * Return:  bool
   */
  public static function deleteAllColors() {
    $query = 'DELETE c.* FROM b2b_colors c';
    return Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
