<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bClassificazione extends Model
{
    /**
     * @var integer
     * @Primary
     * @Column(type="integer", length=20, nullable=false)
     */
    public $id;

    /**
     * @var integer
     * @Column(type="integer", length=20, nullable=false)
     */
    public $parent_id;

    /**
     * @var string
     * @Column(type="string", length=56, nullable=false)
     */
    public $slug;

    /**
     * @var string
     * @Column(type="string", length=125, nullable=false)
     */
    public $desc_it;

    /**
     * @var string
     * @Column(type="string", length=125, nullable=true)
     */
    public $desc_en;

    /**
     * @var string
     * @Column(type="string", length=125, nullable=true)
     */
    public $desc_es;

    /**
     * @var string
     * @Column(type="string", length=125, nullable=true)
     */
    public $desc_fr;

    /**
     * @var string
     * @Column(type="string", length=125, nullable=true)
     */
    public $desc_de;

    /**
     * @var integer
     * @Column(type="integer", length=1, nullable=false)
     */
    public $enabled;

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('b2b_classificazione');
    }

    public function getLabel($lang = 'it')
    {
        $availableLang = ['it', 'en', 'es', 'fr', 'de'];
        $propName = 'desc_' . (in_array($lang, $availableLang) ? $lang : 'it');

        return $this->$propName ?: $this->slug;
    }

    public function isRoot()
    {
        return empty($this->parent_id);
    }

    public static function fakeRootClassification()
    {
        $translator = Di::getDefault()->get('i18n');
        return new B2bClassificazione([
            'id' => 0,
            'slug' => 'root',
            'desc_it' => $translator->_('_common.products'),
            'desc_en' => $translator->_('_common.products'),
            'desc_es' => $translator->_('_common.products'),
            'desc_fr' => $translator->_('_common.products'),
            'desc_de' => $translator->_('_common.products'),
            'enabled' => true,
        ]);
    }

    public static function getAvailableTree($startId = null)
    {
        $tree = [];

        if (empty($startId)) {
            $classifications = B2bClassificazione::find('parent_id IS NULL');
        } else {
            $classifications = B2bClassificazione::find(['parent_id = :parentId:', 'bind' => ['parentId' => $startId]]);
        }

        $pathMap = [];
        $urlMap = [];

        while (count($classifications) > 0) {
            $subIds = [];
            /** @var B2bClassificazione $classification */
            foreach ($classifications as $classification) {
                $basePath = (!empty($classification->parent_id) && !empty($pathMap[$classification->parent_id]) ? $pathMap[$classification->parent_id] : '');
                $path = $classification->id;

                $baseUrl = (!empty($classification->parent_id) && !empty($urlMap[$classification->parent_id]) ? $urlMap[$classification->parent_id] : '');
                $url = $classification->slug;

                if (!empty($baseUrl)) {
                    $url = $baseUrl . '/' . $url;
                }

                $cursor = &$tree;
                if (!empty($basePath)) {
                    $path = $basePath . '-' . $path;
                    $basePathPieces = explode('-', $basePath);
                    while ($basePathPieces && \count($basePathPieces) > 0) {
                        $cursor = &$cursor[\array_shift($basePathPieces)]['sub'];
                        if (!\is_array($cursor)) {
                            break;
                        }
                    }
                }

                $cursor[$classification->id] = ['element' => $classification, 'url' => $url, 'sub' => []];
                $pathMap[$classification->id] = $path;
                $urlMap[$classification->id] = $url;
                $subIds[] = $classification->id;
            }

            if (!empty($subIds)) {
                $classifications = B2bClassificazione::find('parent_id IN ( ' . implode(',', $subIds) . ' )');
            } else {
                $classifications = [];
            }
        }

        return $tree;
    }

    public function getArticles($cdcata, $nulist, $idlang)
    {
        $articles = [];
        if (!empty($this->id)) {
            $articles = [];
        }

        return $articles;
    }

    public function getModels($cdcata, $nulist, $idlang)
    {
        $models = [];
        if (!empty($this->id)) {
            $models = Tipolo::getModelsFromClassification($this->id, $cdcata, $nulist, $idlang);
        }

        return $models;
    }
}
