<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bBgcorp extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nubudg;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtastg;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $valstg;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('b2b_bgcorp');
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of B2bBgcorp objects
   */
  public static function getComparingSeasons() {
    $query = "SELECT DISTINCT bc.cdstag, COALESCE(ts.dsstag,'') AS dsstag
      FROM Go2B\Models\B2bBgcorp bc
      LEFT JOIN Go2B\Models\Tabstg ts ON ts.cdstag = bc.cdstag
      ORDER BY bc.cdstag DESC";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE b2b_bgcorp";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
