<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bApputi extends Model
{
    const CLIENTI_CON_IMGCLOUD = ['lde'];

    //region Fields
    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=255, nullable=false)
     */
    public $param;

    /**
     *
     * @var string
     * @Column(type="string", nullable=true)
     */
    public $value;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('b2b_apputi');
    }
    //endregion

    //region Aux functions
    public static function getCurrentAppUtils()
    {
        $config = Di::getDefault()->get('config');

        return array(
            array('param' => 'licenses', 'value' => '0'),
            array('param' => 'prefix', 'value' => 'cli'),
            array('param' => 'index', 'value' => '1'),
            array('param' => 'banner', 'value' => ''),
            array('param' => 'company', 'value' => 'CLI'),
            array('param' => 'company_extended', 'value' => 'Azienda di test S.p.A.'),
            array('param' => 'db_version', 'value' => Di::getDefault()->get('config')->dbupdate->currentversion),
            array('param' => 'descr_de', 'value' => ''),
            array('param' => 'descr_en', 'value' => ''),
            array('param' => 'descr_es', 'value' => ''),
            array('param' => 'descr_fr', 'value' => ''),
            array('param' => 'descr_it', 'value' => ''),
            array('param' => 'shipment_cond_de', 'value' => ''),
            array('param' => 'shipment_cond_en', 'value' => ''),
            array('param' => 'shipment_cond_es', 'value' => ''),
            array('param' => 'shipment_cond_fr', 'value' => ''),
            array('param' => 'shipment_cond_it', 'value' => ''),
            array('param' => 'enable_gogateway_features', 'value' => '0'),
            array('param' => 'enable_export_all_orders', 'value' => '0'),
            array('param' => 'header_image', 'value' => ''),
            array('param' => 'logo_image', 'value' => ''),
            array('param' => 'logo_pdf', 'value' => ''),
            array('param' => 'login_bg', 'value' => ''),
            // Condizione clienti con immagini in cluod
            array('param' => 'images_prefix', 'value' => (in_array($config->release->user, self::CLIENTI_CON_IMGCLOUD)) ? 'https://czaiacfcja.cloudimg.io' : ''),

            // Paypal: email or merchant_id needed by definition of payee
            array('param' => 'paypal_email', 'value' => ''),
            array('param' => 'paypal_merchant_id', 'value' => ''),
            // Stripe: publishable_key or secret_key
            array('param' => 'publishable_key', 'value' => ''),
            array('param' => 'secret_key', 'value' => ''),
            array('param' => 'business_name', 'value' => 'Sinergiattiva s.r.l.'),
            array('param' => 'address', 'value' => 'Via Ancona, 15'),
            array('param' => 'city', 'value' => 'Jesi'),
            array('param' => 'cap', 'value' => '60035'),
            array('param' => 'custom_title', 'value' => 'Go 2B'),
            array('param' => 'province', 'value' => 'Ancona'),
            array('param' => 'country', 'value' => 'Italia'),
            array('param' => 'tel', 'value' => '+39 0731 288050'),
            array('param' => 'email', 'value' => 'info@sinergiattiva.com'),
            array('param' => 'fb_link', 'value' => ''),
            array('param' => 'ig_link', 'value' => ''),
            array('param' => 'tw_link', 'value' => ''),
            array('param' => 'default_catalog', 'value' => ''),
            array('param' => 'email_for_customvariants', 'value' => ''),
            array('param' => 'email_for_newcustomers', 'value' => ''),
            array('param' => 'email_for_notifyorder', 'value' => ''),
            array('param' => 'email_for_support', 'value' => ''),
            array('param' => 'lar_date_ddmmyy', 'value' => ''),
            array('param' => 'zan_date_start', 'value' => '2021-01-01'),
            array('param' => 'zan_date_end', 'value' => '2021-01-31'),
            array('param' => 'zan_default_ind', 'value' => 'MAIN'),
            array('param' => 'smtp_server', 'value' => 'srv89035.netsons.net'),
            array('param' => 'smtp_protocol', 'value' => 'ssl'),
            array('param' => 'smtp_port', 'value' => '465'),
            array('param' => 'smtp_auth', 'value' => 'true'),
            array('param' => 'noreply_address', 'value' => 'noreply@go-2b.it'),
            array('param' => 'noreply_password', 'value' => '$SUL177L=EK%'),
            array('param' => 'additional_header_btn_text', 'value' => ''),
            array('param' => 'additional_header_btn_link', 'value' => ''),
            array('param' => 'availabilityYellowLimit', 'value' => '1'),
            array('param' => 'availabilityGreenLimit', 'value' => '10'),
            array('param' => 'additional_order_header_notecli', 'value' => ''),
            array('param' => 'nav_odata_api_url', 'value' => ''),
            array('param' => 'nav_odata_api_user', 'value' => ''),
            array('param' => 'nav_odata_api_password', 'value' => ''),
        );
    }
    //endregion

    //region Custom queries
    /**
     * Query:   SELECT
     * Return:  Array of B2BApputi arrays
     */
    public static function getAllUtils()
    {
        $query = 'SELECT u.param, u.value
      FROM b2b_apputi u';
        $utils = Di::getDefault()->get('db')->query($query);
        $utilsArray = array();
        foreach ($utils as $util) {
            $utilsArray[$util['param']] = $util['value'];
        }
        return $utilsArray;
    }

    /**
     * Query:   UPDATE
     * Return:  bool
     */
    public static function updateRow($param, $value)
    {
        $query = 'INSERT INTO b2b_apputi (param,value) VALUES (:param, :value) ON DUPLICATE KEY UPDATE value = :value';
        return Di::getDefault()->get('db')->query($query, array('param' => $param, 'value' => $value));
    }
    //endregion
}
