<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class B2bAppset extends Model
{
    //region Fields
    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=60, nullable=false)
     */
    public $name;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $descr;

    /**
     *
     * @var integer
     * @Column(type="integer", length=1, nullable=false)
     */
    public $privileges;

    /**
     *
     * @var string
     * @Column(type="string", length=100, nullable=false)
     */
    public $value;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $options;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $tab;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path   = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('b2b_appset');
    }
    //endregion

    //region Aux functions
    public static function getCurrentAppSettings()
    {
        return array(
            array('name' => 'SpreadNeutralImages',
                'descr' => serialize(array(
                    'it' => "Abilita la funzione di diffusione delle immagini neutre su tutti gli articoli senza immagine",
                    'en' => 'Enables the neutral image diffusion feature on all non-image items'
                )),
                'privileges' => '1',
                'value' => '0',
                'options' => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab' => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'CartTimeout',
                'descr'      => serialize(array(
                    'it' => 'Timeout del carrello espresso in minuti',
                    'en' => 'Cart timeout in minutes',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'AdditionalNotePdf',
                'descr'      => serialize(array(
                    'it' => 'Nota aggiuntiva sul pdf',
                    'en' => 'Additional note on pdf file',
                )),
                'privileges' => '2',
                'value'      => '',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'AllowExcelCart',
                'descr'      => serialize(array(
                    'it' => "Permette di riempire il carrello importando un file Excel (non compatibile con gestione articoli con tessuti)",
                    'en' => 'Allows you to fill your cart by importing an Excel file (not compatible with managing items by fabrics)',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ApplyTaxOnOrder',
                'descr'      => serialize(array(
                    'it' => "Abilita l'applicazione dell'iva o altre tasse sull'ordine",
                    'en' => 'Enabling of the application of taxes to order',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;, con codice esenzione cliente ', 'en' => 'Yes, with customer exemption code')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ArticleDescriptionOnList',
                'descr'      => serialize(array(
                    'it' => 'Definisce il tipo di codice/descrizione visualizzata sulla lista',
                    'en' => 'Define code/description type on list',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'cdcolo/dscolo', 'en' => 'cdcolo/dscolo')),
                    array('value' => 1, 'descr' => array('it' => 'cdarti/dsarti', 'en' => 'cdarti/dsarti')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ArticleName',
                'descr'      => serialize(array(
                    'it' => 'Definisce i campi da utilizzare come nome dell\'Articolo',
                    'en' => 'Defines the fields to be used as the Article name',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Descrizione', 'en' => 'Description')),
                    array('value' => 1, 'descr' => array('it' => 'Descrizione + Scala taglie', 'en' => 'Description + Size scale')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'AutoAcceptOrders',
                'descr'      => serialize(array(
                    'it' => 'Gli ordini in stato "inviato" verranno accettati automaticamente durante la notte',
                    'en' => 'Orders with status code "sent" will be accepted automatically during the night',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'BreakRegqta',
                'descr'      => serialize(array(
                    'it' => 'Permette di infrangere le regole regqta per svuotare il magazzino',
                    'en' => 'Allow to infringe regqta rules in order to empty warehouse',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'BudgetManagement',
                'descr'      => serialize(array(
                    'it' => 'Definisce se il budget è gestito',
                    'en' => 'Defines if the budget is handled',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato (scollegato da tabelle)', 'en' => 'Enabled (not linked to tables)')),
                    array('value' => 2, 'descr' => array('it' => 'Abilitato (collegato a indorc)', 'en' => 'Enabled (linked to indorc)')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'CanDuplicateRows',
                'descr'      => serialize(array(
                    'it' => 'Abilita la possibilità di avere righe duplicate',
                    'en' => 'Enable the possibility to duplicate rows',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'CartMode',
                'descr'      => serialize(array(
                    'it' => 'Definisce la modalità del carrello.',
                    'en' => 'Define cart mode',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 1, 'descr' => array('it' => 'Con riepilogo per linee', 'en' => 'With lines summary')),
                    array('value' => 2, 'descr' => array('it' => 'Con riepilogo per tipo modello', 'en' => 'With model type summary')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'CatalogAccessType',
                'descr'      => serialize(array(
                    'it' => 'Definisce se accedere di default al catalogo visuale o al catalogo lista',
                    'en' => 'Defines if access by default to visual catalog or list catalog',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Visuale', 'en' => 'Visual')),
                    array('value' => 1, 'descr' => array('it' => 'Lista', 'en' => 'List')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'CatalogMenuAlignment',
                'descr'      => serialize(array(
                    'it' => 'Modifica la posizione e l\'allineamento del menu del catalogo',
                    'en' => 'Change the position and alignment of the catalog menu',
                )),
                'privileges' => '2',
                'value'      => 'standard',
                'options'    => serialize(array(
                    array('value' => 'standard', 'descr' => array('it' => 'Standard', 'en' => 'Standard')),
                    array('value' => 'central-center', 'descr' => array('it' => 'Centrale', 'en' => 'Central')),
                    array('value' => 'central-right', 'descr' => array('it' => 'Centro-Destra', 'en' => 'Central-Right')),
                    array('value' => 'central-left', 'descr' => array('it' => 'Centro-Sinistra', 'en' => 'Central-Left')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'HideBlockedItems',
                'descr'      => serialize(array(
                    'it' => 'Permette di nascondere completamente gli item bloccati o fuori dalla scala taglie (non solo la label con scritto \'Bloccata\')',
                    'en' => 'Allows you to completely hide items that are blocked or out of size scale (not just the \'Blocked\' label)',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => '0', 'descr' => array('it' => 'Mostra', 'en' => 'Show')),
                    array('value' => '1', 'descr' => array('it' => 'Nascondi', 'en' => 'Hide')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'InfoPackMode',
                'descr'      => serialize(array(
                    'it' => 'Permette di modificare la visibilità delle info sui pacchetti con i tooltip',
                    'en' => 'Allows you to change the visibility of package info with tooltips',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => '0', 'descr' => array('it' => 'Se descrizione presente', 'en' => 'Show')),
                    array('value' => '1', 'descr' => array('it' => 'Sempre', 'en' => 'Always')),
                    array('value' => '-1', 'descr' => array('it' => 'Mai', 'en' => 'Never')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'CategoryBanner',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione di un banner sul catalogo per ogni categoria',
                    'en' => 'Enable the visualizatioon of a category banner on catalog',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'BrandBanner',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione di un banner sul catalogo per ogni brand',
                    'en' => 'Enable the visualizatioon of a brand banner on catalog',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'showAssortments',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione degli asssortimenti',
                    'en' => 'Enable the visualizatioon of assortmens',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ParamCollectionNoTitle',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione senza il titolo per ogni sezione',
                    'en' => 'Enable the visualizatioon whithout title of session',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),

            array('name' => 'VariantInCollection',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione delle varianti nella collection',
                    'en' => 'Enable the visualizatioon of a Variants on catalog ',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'MaxDiscountInCollection',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione dello sconto massimo nella collection',
                    'en' => 'Enable the visualizatioon of max discount on catalog ',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ShowFilterLeftSide',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione della barra dei filtri fissa a Sinistra',
                    'en' => 'Enable the visualizatioon of fixed filter bar on left side ',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),

            array('name' => 'ColoredPriceBackground',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione del box del prezzo colorata',
                    'en' => 'Enable the visualizatioon of price colered Background',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),

            array('name' => 'ChangeModelPreview',
                'descr'      => serialize(array(
                    'it' => 'Abilita il cambio immagine modello/articolo della preview nella scheda modello',
                    'en' => 'Enable the change of model/article image preview in model detail',
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ChangePriceList',
                'descr'      => serialize(array(
                    'it' => "Permette di cambiare il listino durante l'ordine",
                    'en' => 'Allow to change the price list while ordering',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ChoosePriceListOnNewOrder',
                'descr'      => serialize(array(
                    'it' => 'Permette di scegliere il listino quando si crea un nuovo ordine',
                    'en' => 'Allow to choose the price list when creating a new order',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ColorAssignmentSource',
                'descr'      => serialize(array(
                    'it' => 'Definisce dove prendere i colori da assegnare',
                    'en' => 'Defines where assignable colors must be picken',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'dscolo', 'en' => 'dscolo')),
                    array('value' => 1, 'descr' => array('it' => 'cdcolo', 'en' => 'cdcolo')),
                    array('value' => 2, 'descr' => array('it' => 'artcol.cdcolo', 'en' => 'artcol.cdcolo')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'CloseModalAfterInsertQuantity',
                'descr'      => serialize(array(
                    'it' => 'Chiude la modale dopo aver inserito le quantità',
                    'en' => 'Close modal window after inserting quantity',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'DefaultImageOnModelDetail',
                'descr'      => serialize(array(
                    'it' => "Definisce quale immagine è visualizzata nel dettaglio modello: immagine del modello o immagine dell'articolo selezionato",
                    'en' => 'Defines which image is displayed in model detail: image of the model or image of the selected article',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
//                            array('value' => 0, 'descr' => array('it' => 'Modello', 'en' => 'Model')),
//                            array('value' => 1, 'descr' => array('it' => 'Articolo', 'en' => 'Article')),
                    array('value' => 0, 'descr' => array('it' => 'Articolo Galleria', 'en' => 'Article Gallery')),
                    array('value' => 1, 'descr' => array('it' => 'Articolo Singola Immagine', 'en' => 'Single Image Item')),
                    array('value' => 2, 'descr' => array('it' => 'Galleria Completa (Modello + Articolo)', 'en' => 'Complete Gallery (Model + Article)')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'DefaultOrderType',
                'descr'      => serialize(array(
                    'it' => 'Permette di scegliere quale ordine è selezionato di default quando si crea un nuovo ordine',
                    'en' => 'Allow to choose the default selected order typ when creating a new order',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Prenotazione', 'en' => 'Reservation')),
                    array('value' => 1, 'descr' => array('it' => 'Disponibilit&agrave;', 'en' => 'Availability')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'DefaultShipping',
                'descr'      => serialize(array(
                    'it' => 'Seleziona la destinazione merci default nel caso sia presente',
                    'en' => 'Select the default shipping where it is present',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => -1, 'descr' => array('it' => 'Nessuno', 'en' => 'None')),
                    array('value' => 0, 'descr' => array('it' => 'Indirizzo principale', 'en' => 'Main address')),
                    array('value' => 1, 'descr' => array('it' => 'Primo indirizzo', 'en' => 'First address')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            // Samuele Filtri per customizzazione del Custom Shipping
            array('name' => 'CustomShipping',
                'descr'      => serialize(array(
                    'it' => 'Seleziona il parametro sul tipo di spedizione a scaglioni',
                    'en' => 'Select the staggered shipping type parameter',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Prezzo', 'en' => 'Price')),
                    array('value' => 1, 'descr' => array('it' => 'Quantità', 'en' => 'Quantity')),
//                        array('value' => 2, 'descr' => array('it' => 'Peso', 'en' => 'Weight')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            // fine Custom Shipping
            // Samuele Filtri per customizzazione del Custom Payment
            array('name' => 'CustomPayment',
                'descr'      => serialize(array(
                    'it' => 'Seleziona il parametro sul tipo di pagamento a scaglioni',
                    'en' => 'Select the staggered payment type parameter',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Prezzo', 'en' => 'Price')),
                    array('value' => 1, 'descr' => array('it' => 'Quantità', 'en' => 'Quantity')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            // fine Custom Payment
            array('name' => 'DuplicateOrderFromBackEnd',
                'descr'      => serialize(array(
                    'it' => 'Abilita la duplicazione degli ordini da back end',
                    'en' => 'Enable duplicate orders from back end',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableBarcode',
                'descr'      => serialize(array(
                    'it' => "Abilita l'inserimento da barcode",
                    'en' => 'Enable insert from barcode',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Solo bulk', 'en' => 'Only bulk')),
                    array('value' => 2, 'descr' => array('it' => 'Singolo e quantit&agrave;', 'en' => 'Single and quantity')),
                    array('value' => 3, 'descr' => array('it' => 'Entrambi', 'en' => 'Both')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableBlockedItems',
                'descr'      => serialize(array(
                    'it' => 'Abilita la possibilità di bloccare tessuti e/o colori (anaper, artcol)',
                    'en' => 'Enabling of the possibility to block fabrics and/or colors (anaper, artcol)',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableChoiceForDoubleRowsOnNewOrder',
                'descr'      => serialize(array(
                    'it' => 'Abilita la possibilità di decidere nella finestra del nuovo ordine, se si possono duplicare le righe o meno',
                    'en' => 'Enabling of the possibility to select on new order modal, if you can duplicate order rows',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'EnableCustomFilter',
                'descr'      => serialize(array(
                    'it' => 'Permette di personalizzare le sottocategorie dei filtri',
                    'en' => 'Allow to customize filters subcategories',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'EnableDifferentBehaviourForAgent',
                'descr'      => serialize(array(
                    'it' => 'Abilita la possibilità di definire comportamenti diversi per singoli agenti',
                    'en' => 'Enabling of the possibility to define different behaviours for single agents',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'Zanotti', 'en' => 'Zanotti')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableCatalogGalleries',
                'descr'      => serialize(array(
                    'it' => 'Permette di creare le gallerie con le immagini con i punti per i cataloghi',
                    'en' => 'Allow to create galleries with images and points for catalogs',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;, modelli', 'en' => 'Yes, models')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave;, articoli', 'en' => 'Yes, articles')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'EnableProductClassifications',
                'descr'      => serialize(array(
                    'it' => 'Permette di aggiungere e gestire le classificazioni custom dei prodotti',
                    'en' => 'Allow to add and manage custom product classifications',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'EnableCatalogSorting',
                'descr'      => serialize(array(
                    'it' => 'Permette di gestire l\'ordinamento del catalogo da backend',
                    'en' => 'Allow to manage catalog sorting from backend',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave;, doppio ordinamento', 'en' => 'Yes, double sorting')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'EnableDescriptionLoadingOnProductInfo',
                'descr'      => serialize(array(
                    'it' => "Abilita la possibilità di caricare file con le descrizioni tecniche e commerciali da backend",
                    'en' => 'Enabling the possibility to upload files with technical and commercial descriptions from backend',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'Xls: Codice, COMM - IT, TECN - IT', 'en' => 'Xls: Code, COMM - IT, TECN - IT')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableExportOrderJoor',
                'descr'      => serialize(array(
                    'it' => "Abilita l'esportazione dell'ordine Excel per caricarlo su Joor",
                    'en' => 'Enabling the export of Excel order export to be uploaded on Joor',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableMinMulLabel',
                'descr'      => serialize(array(
                    'it' => 'Permette di visualizzare i minimi e i multipli nell\'inserimento quantità',
                    'en' => 'Allow to display min and multiplier on quantity insert',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'EnableOrderXmlAgent',
                'descr'      => serialize(array(
                    'it' => "Abilita l'ordine Excel per gli agente",
                    'en' => 'Enabling of the Excel order for agents',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'Creazione', 'en' => 'Creation')),
                    array('value' => 2, 'descr' => array('it' => 'Modifica', 'en' => 'Edit')),
                    array('value' => 3, 'descr' => array('it' => 'Entrambe', 'en' => 'Both')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableOrderXmlCustomer',
                'descr'      => serialize(array(
                    'it' => "Abilita l'ordine Excel per i clienti + destinazioni merci",
                    'en' => 'Enabling of the Excel order for customers + shipping users',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'Creazione', 'en' => 'Creation')),
                    array('value' => 2, 'descr' => array('it' => 'Modifica', 'en' => 'Edit')),
                    array('value' => 3, 'descr' => array('it' => 'Entrambe', 'en' => 'Both')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableQuickOrder',
                'descr'      => serialize(array(
                    'it' => "Abilita l'ordine rapido (valido solo per articoli colore e ordine di prenotazione)",
                    'en' => 'Enabling of quick order (valid only for color articles and reservation order)',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ExportOrderType',
                'descr'      => serialize(array(
                    'it' => "Definisce la modalità di esportazione dell'ordine",
                    'en' => 'Define how orders are exported',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default (xml)', 'en' => 'Default (xml)')),
                    array('value' => 1, 'descr' => array('it' => 'Lardini (csv)', 'en' => 'Lardini (csv)')),
                    array('value' => 2, 'descr' => array('it' => 'Zanotti (csv)', 'en' => 'Zanotti (csv)')),
                    array('value' => 3, 'descr' => array('it' => 'Nav (json)', 'en' => 'Nav (json)')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'EnableSpecialStats',
                'descr'      => serialize(array(
                    'it' => 'Abilita le statistiche speciali nel backend',
                    'en' => 'Enabling of special stats on back-end side',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitate', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Zanotti', 'en' => 'Zanotti')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'EnableVisualView',
                'descr'      => serialize(array(
                    'it' => "Scelta di far visualizzare il catalogo visuale",
                    'en' => "Selection of the visibility of visual catalog",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'FabricVisualization',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione per tessuti.',
                    'en' => 'Enable the fabric visualization',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'FeaturedModelsSorting',
                'descr'      => serialize(array(
                    'it' => "Definisce l'ordine in cui vengono presentati i modelli in evidenza",
                    'en' => 'Defines how featured models are sorted',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Prezzo crescente', 'en' => 'Increasing price')),
                    array('value' => 1, 'descr' => array('it' => 'Prezzo decrescente', 'en' => 'Decreasing price')),
                    array('value' => 2, 'descr' => array('it' => 'Codice crescente', 'en' => 'Increasing code')),
                    array('value' => 3, 'descr' => array('it' => 'Codice decrescente', 'en' => 'Decreasing code')),
                    array('value' => 4, 'descr' => array('it' => 'Descrizione crescente', 'en' => 'Increasing description')),
                    array('value' => 5, 'descr' => array('it' => 'Descrizione decrescente', 'en' => 'Decreasing description')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'HideDeliveryDateOnCreatingOrder',
                'descr'      => serialize(array(
                    'it' => "Nasconde la data dalla creazione dell'ordine",
                    'en' => 'Hide date on creating order',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Visible', 'en' => 'Visible')),
                    array('value' => 1, 'descr' => array('it' => 'Nascosta', 'en' => 'Hidden')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'HideAvailabilityOnAvailabilityOrder',
                'descr'      => serialize(array(
                    'it' => "Nasconde la disponibilità nell'ordine al disponibile",
                    'en' => 'Hide availability on availability order',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Visible', 'en' => 'Visible')),
                    array('value' => 1, 'descr' => array('it' => 'Nascosta', 'en' => 'Hidden')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ImageOnCatalogList',
                'descr'      => serialize(array(
                    'it' => 'Definisce quale immagine visualizzare nel catalogo list',
                    'en' => 'Define which is the image on catalog list',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Modello + Articolo', 'en' => 'Model + Article')),
                    array('value' => 1, 'descr' => array('it' => 'Articolo', 'en' => 'Article')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ImageOnCatalogModal',
                'descr'      => serialize(array(
                    'it' => 'Definisce quale immagine visualizzare nella modale di acquisto nel catalogo',
                    'en' => 'Define which is the image on catalog buy modal',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Modello + Articolo', 'en' => 'Model + Article')),
                    array('value' => 1, 'descr' => array('it' => 'Articolo', 'en' => 'Article')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ImageOnXls',
                'descr'      => serialize(array(
                    'it' => "Definisce quale immagine visualizzare nell'ordine da Excel",
                    'en' => 'Define which is the image on Excel file',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Modello + Articolo', 'en' => 'Model + Article')),
                    array('value' => 1, 'descr' => array('it' => 'Articolo', 'en' => 'Article')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ImagesOnSummary',
                'descr'      => serialize(array(
                    'it' => "Definisce quali immagini far vedere sul riepilogo",
                    'en' => 'Define which images are shown on summary',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 1, 'descr' => array('it' => 'Solo immagine articolo (anaart.flimag)', 'en' => 'Only article image (anaart.flimag)')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'IndicativeText',
                'descr'      => serialize(array(
                    'it' => "Definisco che testo mostrare come indicativo",
                    'en' => 'Define which text to shown as indicative',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Indicativo', 'en' => 'Indicative')),
                    array('value' => 1, 'descr' => array('it' => 'Tipo ordine', 'en' => 'Order type')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ItemsPerRowOnVisualCatalog',
                'descr'      => serialize(array(
                    'it' => 'Definisce quanti articoli visualizzare per riga sul catalogo visuale',
                    'en' => 'Defines how many articles are to display on each row for visual catalog',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => '4', 'en' => '4')),
                    array('value' => 1, 'descr' => array('it' => '3', 'en' => '3')),
                    array('value' => 2, 'descr' => array('it' => '2', 'en' => '2')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'LookbookItemType',
                'descr'      => serialize(array(
                    'it' => 'Definisce il tipo di prodotto visualizzato sul lookbook',
                    'en' => 'Defines the type of product in lookbook',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Modello (default)', 'en' => 'Model (default)')),
                    array('value' => 1, 'descr' => array('it' => 'Articolo', 'en' => 'Article')),
                    array('value' => 2, 'descr' => array('it' => 'Articolo + Tessuto + Colore (Lardini)', 'en' => 'Article + Fabric + Color (Lardini)')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'LookbookViewType',
                'descr'      => serialize(array(
                    'it' => 'Definisce la modalità di visualizzazione del lookbook',
                    'en' => 'Defines how the lookbook is displayed',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Lista dei look', 'en' => 'Look list')),
                    array('value' => 1, 'descr' => array('it' => 'Lista dei dettagli dei look', 'en' => 'Detail look list')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ModelDetailStyle',
                'descr'      => serialize(array(
                    'it' => 'Definisce lo stile di visualizzazione della scheda modello',
                    'en' => 'Defines the style of model detail page',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 1, 'descr' => array('it' => 'Compatta', 'en' => 'Compact')),
                    array('value' => 2, 'descr' => array('it' => 'Personalizzazioni tessuto', 'en' => 'Fabric customizations')),
                    array('value' => 3, 'descr' => array('it' => 'Personalizzazioni articolo', 'en' => 'Article customizations')),
                    array('value' => 4, 'descr' => array('it' => 'Personalizzazioni tessuto (con anteprima)', 'en' => 'Fabric customizations (with preview)')),
                    array('value' => 5, 'descr' => array('it' => 'Configuratore materiali', 'en' => 'Materials configurator')),
                    array('value' => 6, 'descr' => array('it' => 'Compatta con tutte le taglie visibili', 'en' => 'Compact with all sizes visible')),
                    array('value' => 7, 'descr' => array('it' => 'Compatta con le immagini degli articoli', 'en' => 'Compact with article images')),
                    array('value' => 8, 'descr' => array('it' => 'Compatta senza box selezione colore/taglia', 'en' => 'Compact without color/size selection box')),
                    array('value' => 9, 'descr' => array('it' => 'Compatta senza articoli stesso tessuto', 'en' => 'Compact without same fabric articles')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ModelDetailPickerSize',
                'descr'      => serialize(array(
                    'it' => 'Definisce la dimensione del picker per la selezione del colore/taglia nella scheda modello',
                    'en' => 'Defines the size of the picker for color/size selection in the model sheet',
                )),
                'privileges' => '1',
                'value'      => '',
                'options'    => serialize(array(
                    array('value' => '', 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 'sm', 'descr' => array('it' => 'Piccola', 'en' => 'Small')),
                    array('value' => 'md', 'descr' => array('it' => 'Media', 'en' => 'Medium')),
                    array('value' => 'lg', 'descr' => array('it' => 'Grande', 'en' => 'Large')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ModelDetailHighlight',
                'descr'      => serialize(array(
                    'it' => 'Definisce se utilizzare o meno la funzionalità \'effetto evidenziato\' in alcuni dettagli grafici della scheda modello',
                    'en' => 'Defines whether or not to use the \'highlight effect\' functionality in some graphic details of the model sheet',
                )),
                'privileges' => '1',
                'value'      => 1,
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ModelSearchType',
                'descr'      => serialize(array(
                    'it' => 'Definisce il tipo di ricerca dei modelli',
                    'en' => 'Defines the type of model search',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default (cdartn, dsartn)', 'en' => 'Default (cdartn, dsartn)')),
                    array('value' => 1, 'descr' => array('it' => 'Estesa (cdartn, dsartn, tpmode, dstmod, dslinm, dsserm)', 'en' => 'Extended (cdartn, dsartn, tpmode, dstmod, dslinm, dsserm)')),
                    array('value' => 2, 'descr' => array('it' => 'Zanotti (cdartn, dsartn, tpmode, dstmod, sparti.tpcomp = BOLLA)', 'en' => 'Zanotti (cdartn, dsartn, tpmode, dstmod, sparti.tpcomp = BOLLA)')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'MultipleInsertQuantityOnCart',
                'descr'      => serialize(array(
                    'it' => 'Fornisce la possibilità di inserire le quantità in maniera bulk per gli articoli nel carrello',
                    'en' => 'Enable the bulk insert quantity for articles on cart',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'NavbarContent',
                'descr'      => serialize(array(
                    'it' => 'Definisce il contenuto della barra di navigazione',
                    'en' => 'Defines the content of navigation bar',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default (brand o linee con sottomenu)', 'en' => 'Default (brands or lines with submenus)')),
                    array('value' => 1, 'descr' => array('it' => 'Tipi modello', 'en' => 'Model types')),
                    array('value' => 2, 'descr' => array('it' => 'Generi con linea-serie', 'en' => 'Genres with line-series')),
                    array('value' => 3, 'descr' => array('it' => 'Uguale al default, ma senza sottomenu', 'en' => 'Like default, without submenus')),
                    array('value' => 4, 'descr' => array('it' => 'Personalizzato (da back-end)', 'en' => 'Custom (from back-end)')),
                    array('value' => 5, 'descr' => array('it' => 'Generi-linee (senza sottomenu)', 'en' => 'Genres-lines (without submenus)')),
                    array('value' => 6, 'descr' => array('it' => 'Classificazioni custom', 'en' => 'Custom classifications')),
                    array('value' => 7, 'descr' => array('it' => 'Default + Classificazioni custom', 'en' => 'Default + Custom classifications')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'NewCustomerCanSendOrders',
                'descr'      => serialize(array(
                    'it' => 'Permette ad un cliente nuovo di inviare ordini',
                    'en' => 'New customer can send orders',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ManageCustomerStatus',
                'descr'      => serialize(array(
                    'it' => 'Permette la gestione dello stato (blocco) dei clienti',
                    'en' => 'It allows the management of the status (ban) of the customers',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ManageCustomerStatus',
                'descr'      => serialize(array(
                    'it' => 'Permette la gestione dello stato (blocco) dei clienti',
                    'en' => 'It allows the management of the status (ban) of the customers',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'OrderExcelType',
                'descr'      => serialize(array(
                    'it' => 'Tipo di ordine Excel (da finestra nuovo ordine)',
                    'en' => 'Order Excel type (on new order windows)',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 1, 'descr' => array('it' => 'No immagini, scala taglia ogni riga', 'en' => 'No images, size scale on every row')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'OrderExcelTypeFromOrderList',
                'descr'      => serialize(array(
                    'it' => 'Tipo di ordine Excel (da riepilogo ordini utente)',
                    'en' => 'Order Excel type (on user order list)',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Nuovo default', 'en' => 'New default')),
                    array('value' => 1, 'descr' => array('it' => 'Vecchio default', 'en' => 'Old default')),
                    array('value' => 2, 'descr' => array('it' => 'Zanotti', 'en' => 'Zanotti')),
                    array('value' => 3, 'descr' => array('it' => 'Rossetti', 'en' => 'Rossetti')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'OrderInfoButtonType',
                'descr'      => serialize(array(
                    'it' => 'Tipo di pulsante per info ordine',
                    'en' => 'Order info button type',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 1, 'descr' => array('it' => 'Con descrizione cliente', 'en' => 'With customer description')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'OrderPopup',
                'descr'      => serialize(array(
                    'it' => 'Definisce se aprire il popup di creazione ordine',
                    'en' => 'Define if order popup should be open',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                    array('value' => 1, 'descr' => array('it' => 'No', 'en' => 'No')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'OrderStateManagement',
                'descr'      => serialize(array(
                    'it' => 'Possibilità di gestire lo stato degli ordini da backend',
                    'en' => 'Ability to manage the status of orders from backend',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'OrderTypeAgent',
                'descr'      => serialize(array(
                    'it' => 'Abilita la selezione della tipologia ordine per gli agenti',
                    'en' => 'Enabling of the order type selection for agents',
                )),
                'privileges' => '1',
                'value'      => '2',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Prenotazione', 'en' => 'Reservation')),
                    array('value' => 1, 'descr' => array('it' => 'Al pronto', 'en' => 'Availability')),
                    array('value' => 2, 'descr' => array('it' => 'Entrambe', 'en' => 'Both')),
                    array('value' => 3, 'descr' => array('it' => 'Regole Anagrafica', 'en' => 'Customer Data Rules')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'OrderTypeCustomer',
                'descr'      => serialize(array(
                    'it' => 'Abilita la selezione della tipologia ordine per clienti + destinazione merci',
                    'en' => 'Enabling of the order type selection for customers + shippings users',
                )),
                'privileges' => '1',
                'value'      => '2',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Prenotazione', 'en' => 'Reservation')),
                    array('value' => 1, 'descr' => array('it' => 'Al pronto', 'en' => 'Availability')),
                    array('value' => 2, 'descr' => array('it' => 'Entrambe', 'en' => 'Both')),
                    array('value' => 3, 'descr' => array('it' => 'Regole Anagrafica', 'en' => 'Customer Data Rules')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'OrderTypeForExcel',
                'descr'      => serialize(array(
                    'it' => 'Tipo di ordine per Excel',
                    'en' => 'Order type for Excel',
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disponibilità', 'en' => 'Availability')),
                    array('value' => 1, 'descr' => array('it' => 'Prenotazione', 'en' => 'Reservation')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamAvailabilityDateManagement',
                'descr'      => serialize(array(
                    'it' => "Scelta dei giorni di consegna per l'ordine di riassortimento",
                    'en' => "Selection of the amount of days for shipping when replenishment order",
                )),
                'privileges' => '2',
                'value'      => '7',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamAvailabilityList',
                'descr'      => serialize(array(
                    'it' => "Scelta di far visualizzare la nuova lista disponibilit&agrave;",
                    'en' => "Selection of the visibility of new availability list",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamCouponPromo',
                'descr'      => serialize(array(
                    'it' => 'Attivazione dei coupon, promo, sconti nel carrello',
                    'en' => 'Enabling of coupons, promos, discounts on cart',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                    array('value' => 2, 'descr' => array('it' => 'Promo', 'en' => 'Promo')),
                    array('value' => 3, 'descr' => array('it' => 'Sconti', 'en' => 'Discounts')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamDateManagement',
                'descr'      => serialize(array(
                    'it' => 'Scelta di come gestire la data di testa per ordini di prenotazione (se facoltativa e assente prendere data di oggi)',
                    'en' => 'Selection of the management type for date of standard order (if optional and absent, take today as date)',
                )),
                'privileges' => '1',
                'value'      => '2',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Periodo obbligatorio', 'en' => 'Mandatory period time')),
                    array('value' => 1, 'descr' => array('it' => 'Periodo facoltativo', 'en' => 'Optional period time')),
                    array('value' => 2, 'descr' => array('it' => 'Libera obbligatoria', 'en' => 'Mandatory free date')),
                    array('value' => 3, 'descr' => array('it' => 'Libera facoltativa', 'en' => 'Optional free date')),
                    array('value' => 4, 'descr' => array('it' => 'Date "Da-A"', 'en' => '"From-To" dates')),
                    array('value' => 5, 'descr' => array('it' => 'Data a scelta in un set (fro)', 'en' => 'Date of your choice in a set (fro)')),
                    array('value' => 6, 'descr' => array('it' => 'Regole Anagrafica', 'en' => 'Customer Data Rules')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamDateManagementAvailability',
                'descr'      => serialize(array(
                    'it' => 'Scelta di come gestire la data di testa per ordini su disponibilità (se facoltativa e assente prendere data di oggi)',
                    'en' => 'Selection of the management type for date of availability order (if optional and absent, take today as date)',
                )),
                'privileges' => '1',
                'value'      => '2',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Periodo obbligatorio', 'en' => 'Mandatory period time')),
                    array('value' => 1, 'descr' => array('it' => 'Periodo facoltativo', 'en' => 'Optional period time')),
                    array('value' => 2, 'descr' => array('it' => 'Libera obbligatoria', 'en' => 'Mandatory free date')),
                    array('value' => 3, 'descr' => array('it' => 'Libera facoltativa', 'en' => 'Optional free date')),
                    array('value' => 4, 'descr' => array('it' => 'Usa ParamAvailabilityDateManagement', 'en' => 'Use ParamAvailabilityDateManagement')),
                    array('value' => 5, 'descr' => array('it' => 'Regole Anagrafica', 'en' => 'Customer Data Rules')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamEnableCompanyNoteConcludeOrder',
                'descr'      => serialize(array(
                    'it' => 'Gestisce la visualizzazione delle note azienda in chiusura ordine',
                    'en' => 'Enabling of the company notes on closing order',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamEnableCustomerNoteConcludeOrder',
                'descr'      => serialize(array(
                    'it' => 'Gestisce la visualizzazione delle note cliente in chiusura ordine',
                    'en' => 'Enabling of the customer notes on closing order',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamEnablePoNumberConcludeOrder',
                'descr'      => serialize(array(
                    'it' => 'Gestisce la visualizzazione del Po Number in chiusura ordine',
                    'en' => 'Enabling of the Po Number on closing order',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamEnableRifOrdCliConcludeOrder',
                'descr'      => serialize(array(
                    'it' => 'Gestisce la visualizzazione del Rif Ord Cli in chiusura ordine',
                    'en' => 'Enabling of the customer order reference on closing order',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamEnableCreditCardPayment',
                'descr'      => serialize(array(
                    'it' => 'Abilita il pagamento immediato con carta di credito via Paypal in deroga alle condizioni standard',
                    'en' => 'Enabling of immediate payment via credit card/Paypal notwithstanding the standard conditions',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamIndicativeManagement',
                'descr'      => serialize(array(
                    'it' => "Scelta di gestione dell'indicativo",
                    'en' => "Enabling of the indicative management",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Non visibile', 'en' => 'Hidden')),
                    array('value' => 1, 'descr' => array('it' => 'Visibile ma facoltativo', 'en' => 'Visible but optional')),
                    array('value' => 2, 'descr' => array('it' => 'Visibile e obbligatorio', 'en' => 'Visible and mandatory')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamLabel',
                'descr'      => serialize(array(
                    'it' => "Abilita la scelta dell'etichetta legata al catalogo in creazione ordine",
                    'en' => "Enabling of the label selection depending on catalog while creating new order",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamModelDetailQuantityStyle',
                'descr'      => serialize(array(
                    'it' => "Scelta della tipologia di inserimento quantit&agrave;",
                    'en' => "Selection of the type of quantity insertion",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Standard', 'en' => 'Standard')),
                    array('value' => 1, 'descr' => array('it' => 'Calzini', 'en' => 'Socks')),
                    array('value' => 2, 'descr' => array('it' => 'Posate', 'en' => 'Cutlery')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamNewRegistrationAvailable',
                'descr'      => serialize(array(
                    'it' => "Abilita la possibilit&agrave; di richiedere la registrazione all'azienda",
                    'en' => "Enabling the sending of registration request",
                )),
                'privileges' => '1',
                'value'      => '',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'sendMailNewRequestAccess',
                'descr'      => serialize(array(
                    'it' => "Definisce il modo di invio della mail in richiesta di accesso",
                    'en' => "Defines the mode of sending the e-mail in access request",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Invia da JS', 'en' => 'Send from JS')),
                    array('value' => 1, 'descr' => array('it' => 'Invia da Php', 'en' => 'Send from Php')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'CreateSysusrForNewCustomer',
                'descr'      => serialize(array(
                    'it' => "Abilita la possibilit&agrave; creare in automatico gli utenti per i nuovi clienti provenienti dai servizi di sincronizzazione",
                    'en' => "Enable the ability to automatically create users for new customers from synchronization services",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave; (inattivo)', 'en' => 'Yes (not active)')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave; (attivo)', 'en' => 'Yes (active)')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),

            array('name' => 'NotifySysusrToCustomer',
                'descr'      => serialize(array(
                    'it' => "Permette di notificare la creazione dei nuovi account al relativo cliente",
                    'en' => "It allows you to notify the creation of new accounts to the relevant customer",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamPriceSellPublicVisible',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione del prezzo di vendita al pubblico",
                    'en' => "Enabling of the public price visualization",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamPrintVertical',
                'descr'      => serialize(array(
                    'it' => "Definisce se il Pdf &egrave; verticale (max 11 taglie) o orizzontale",
                    'en' => "Vertical pdf (max 11 sizes) or horizontal",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Orizzontale', 'en' => 'Horizontal')),
                    array('value' => 1, 'descr' => array('it' => 'Verticale', 'en' => 'Vertical')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamReturnsManagement',
                'descr'      => serialize(array(
                    'it' => 'Abilita la gestione dei resi e cambi merce',
                    'en' => 'Enabling of return and exchange goods management',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;, con minimo %', 'en' => 'Yes, with minimum %')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave;, con listino maggiorato', 'en' => 'Yes, with plus list')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamQuantityDeliveryView',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione della data di consegna per righe ordine",
                    'en' => "Enabling of the delivery date visualization on order rows",
                )),
                'privileges' => '2',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;, data libera', 'en' => 'Yes, free date')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave;, periodo', 'en' => 'Yes, period')),
                    array('value' => 3, 'descr' => array('it' => 'S&igrave;, periodo (preset)', 'en' => 'Yes, period (preset)')),
                    array('value' => 4, 'descr' => array('it' => 'Scmcon Data per articolo', 'en' => 'Scmcon Date for Article')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamQuantityIndicativeView',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione dell'indicativo per righe ordine",
                    'en' => "Enabling of the indicative visualization on order rows",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;, testo libero', 'en' => 'Yes, free text')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave;, da tabella', 'en' => 'Yes, from table')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamQuantityMultipleDeliveryView',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione della consegna multipla (max 3) nell'inserisci quantit&agrave;",
                    'en' => "Enabling of the multiple delivery (max 3) visualization on quantity insertion",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamQuantityNoPrice',
                'descr'      => serialize(array(
                    'it' => "Rende visibile il prezzo in inserisci quantit&agrave;",
                    'en' => "Display price while inserting quantities",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                    array('value' => 1, 'descr' => array('it' => 'No', 'en' => 'No')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamQuantityNotesView',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione della nota per righe ordine",
                    'en' => "Enabling of the notes visualization on order rows",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;, testo libero', 'en' => 'Yes, free text')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;, da tabella', 'en' => 'Yes, from table')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamQuantityReferenceView',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione del riferimento per righe ordine",
                    'en' => "Enabling of the reference visualization on order rows",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamSaveOrderType',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione del riferimento nell'inserisci quantit&agrave;",
                    'en' => "Enabling of the reference visualization on quantity insertion",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Salva + Salva e invia', 'en' => 'Save + Save and send')),
                    array('value' => 1, 'descr' => array('it' => 'Solo salva', 'en' => 'Only save')),
                    array('value' => 2, 'descr' => array('it' => 'Solo salva e invia', 'en' => 'Only save and send')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamSendMailForVariations',
                'descr'      => serialize(array(
                    'it' => "Abilita la possibilit&agrave; di inviare un'email ad uno o pi&ugrave; indirizzi aziendali per gestire le variazioni dei dati",
                    'en' => "Enabling the sending of email to one or more business address to handle data variations",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowNotAvailableItems',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione dei prodotti non disponibli, quando si è nell'ordine di disponibilit&agrave;",
                    'en' => "Enabling of the visualization of not available items, when in availability order",
                )),
                'privileges' => '2',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ParamShowPriceCatalog',
                'descr'      => serialize(array(
                    'it' => "Abilita la visualizzazione del prezzo in modalit&agrave; catalogo in base al listino cliente",
                    'en' => "Enabling of the price visualization depending on client price list",
                )),
                'privileges' => '2',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave;, solo per ordine', 'en' => 'Yes, only for order')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ParamShowTabCustomerAgent',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Clienti per gli agenti",
                    'en' => "Visualization of the tab Customers in the account area for agents",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabCustomerCustomer',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Clienti per i clienti",
                    'en' => "Visualization of the tab Customers in the account area for customers",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabDeadlinesAgent',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Scadenziario per gli agenti",
                    'en' => "Visualization of tab Deadlines in the account area for agents",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabDeadlinesCustomer',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Scadenziario per i clienti",
                    'en' => "Visualization of tab Deadlines in the account area for customers",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabDestinationsAgent',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Destinazioni Merci per gli agenti",
                    'en' => "Visualization of the tab Goods Destinations in the account area for agents",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabDestinationsCustomer',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Destinazioni Merci per i clienti",
                    'en' => "Visualization of the tab Goods Destinations in the account area for customers",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabOrdersAgent',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Ordini per gli agenti",
                    'en' => "Visualization of tab Orders in the account area for agents",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabOrdersCustomer',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Ordini per i clienti",
                    'en' => "Visualization of tab Orders in the account area for customers",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabOrdersHistory',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Storico Ordini",
                    'en' => 'Visualization of tab Orders History in the account area',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabInvoicesHistory',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Storico Fatture",
                    'en' => 'Visualization of tab Invoices History in the account area',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabTransDocHistory',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Storico Documenti di Trasporto",
                    'en' => 'Visualization of tab Transport Documents History in the account area',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabProfileAgent',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Profilo per gli agenti",
                    'en' => "Visualization of the tab Profile in the account area for agents",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamShowTabProfileCustomer',
                'descr'      => serialize(array(
                    'it' => "Visualizzazione nell'area account del tab Profilo per i clienti",
                    'en' => "Visualization of the tab Profile in the account area for customers",
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'ParamTypeDescrCatalogDetail',
                'descr'      => serialize(array(
                    'it' => 'Descrizione da visualizzare nel dettaglio prodotto (scheda articolo)',
                    'en' => 'What to write as description in product detail',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'cdcolo', 'en' => 'cdcolo')),
                    array('value' => 1, 'descr' => array('it' => 'dscolo', 'en' => 'dscolo')),
                    array('value' => 2, 'descr' => array('it' => 'cdcolo + dscolo', 'en' => 'cdcolo + dscolo')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ParamTypeDescrOrder',
                'descr'      => serialize(array(
                    'it' => "Definisce il modo in cui l'articolo viene visualizzato (non valido per tessuti)",
                    'en' => "How article description must be displayed (not valid for tissues)",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'cdarti + dsarti', 'en' => 'cdarti + dsarti')),
                    array('value' => 1, 'descr' => array('it' => 'cdcolo + dsarti', 'en' => 'cdcolo + dsarti')),
                    array('value' => 2, 'descr' => array('it' => 'cdcolo + dscolo', 'en' => 'cdcolo + dscolo')),
                    array('value' => 3, 'descr' => array('it' => 'cdarti + dscolo', 'en' => 'cdarti + dscolo')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamTypeDescrSummary',
                'descr'      => serialize(array(
                    'it' => 'Gestisce la visualizzazione della descrizione in Wishlist, Carrello e Pdf',
                    'en' => 'Description management (wishlist, cart, pdf)',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'dsarti', 'en' => 'dsarti')),
                    array('value' => 1, 'descr' => array('it' => 'cdcolo + dsartn + dsarti', 'en' => 'cdcolo + dsartn + dsarti')),
                    array('value' => 2, 'descr' => array('it' => 'dsartn + dscolo', 'en' => 'dsartn + dscolo')),
                    array('value' => 3, 'descr' => array('it' => 'dstitl + dsarti', 'en' => 'dstitl + dsarti')),
                    array('value' => 4, 'descr' => array('it' => 'dsarti + dscolo', 'en' => 'dsarti + dscolo')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamTypeOrdering',
                'descr'      => serialize(array(
                    'it' => "Gestisce l'ordinamento degli articoli nel carrello, nella wishlist e nel pdf",
                    'en' => "Article ordering (cart, wishlist, pdf)",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Alfabetico (codice) A-Z', 'en' => 'Alphabetical (code) A-Z')),
                    array('value' => 1, 'descr' => array('it' => 'Carrello crescente (primo inserito in cima)',
                        'en'                                      => 'Ascending cart (first to the top)')),
                    array('value' => 2, 'descr' => array('it' => 'Carrello decrescente (primo inserito in fondo)',
                        'en'                                      => 'Descending cart (first to the bottom)')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamTypePdfCompleteOrder',
                'descr'      => serialize(array(
                    'it' => 'Scelta del Pdf in chiusura ordine (vedi numerazione iPad)',
                    'en' => 'Selection of pdf type (see iPad)',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 1, 'descr' => array('it' => '1', 'en' => '1')),
                    array('value' => 2, 'descr' => array('it' => '2', 'en' => '2')),
                    array('value' => 3, 'descr' => array('it' => '3', 'en' => '3')),
                    array('value' => 4, 'descr' => array('it' => '5', 'en' => '5')),
                    array('value' => 5, 'descr' => array('it' => '6', 'en' => '6')),
                    array('value' => 6, 'descr' => array('it' => '7', 'en' => '7')),
                    array('value' => 7, 'descr' => array('it' => '10', 'en' => '10')),
                    array('value' => 100, 'descr' => array('it' => 'Doppio (Lardini)', 'en' => 'Double (Lardini)')),
                    array('value' => 101, 'descr' => array('it' => 'Doppio (Tommy Hilfiger)', 'en' => 'Double (Tommy Hilfiger)')),
                    array('value' => 200, 'descr' => array('it' => 'Zanotti', 'en' => 'Zanotti')),
                    array('value' => 300, 'descr' => array('it' => 'Dolly Noire', 'en' => 'Dolly Noire')),
                    array('value' => 400, 'descr' => array('it' => 'Kocca', 'en' => 'Kocca')),
                    array('value' => 999, 'descr' => array('it' => 'Joor', 'en' => 'Joor')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamPdfSectionsOrder',
                'descr'      => serialize(array(
                    'it' => 'Scelta dell\'ordinamento delle sezioni del Pdf in chiusura ordine',
                    'en' => 'Choice of sorting of PDF sections at the end of the order',
                )),
                'privileges' => '1',
                'value'      => '_main,_additional,_conditions',
                'options'    => serialize(array(
                    array('value' => '_main,_additional,_conditions', 'descr' => array('it' => 'Articoli, Dettagli, Condizioni (default)', 'en' => 'Articles, Details, Conditions (default)')),
                    array('value' => '_main,_conditions,_additional', 'descr' => array('it' => 'Articoli, Condizioni, Dettagli', 'en' => 'Articles, Conditions, Details')),
                    array('value' => '_conditions,_main,_additional', 'descr' => array('it' => 'Condizioni, Articoli, Dettagli', 'en' => 'Conditions, Articles, Details')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ParamUseMoreCatalogs',
                'descr'      => serialize(array(
                    'it' => "Scelta fra 1 catalogo e pi&ugrave; cataloghi",
                    'en' => "Selection between one or more catalogs",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => '1 catalogo', 'en' => '1 catalogo')),
                    array('value' => 1, 'descr' => array('it' => 'Pi&ugrave; cataloghi', 'en' => 'More catalogs')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'FirstColorSelected',
                'descr'      => serialize(array(
                    'it' => "Indicare se si desidera che la prima variante di colore venga selezionata automaticamente o meno",
                    'en' => "Indicate whether you want the first color variant to be selected automatically or not",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ParamVariation',
                'descr'      => serialize(array(
                    'it' => "Abilita la scelta della variante nell'inserimento quantit&agrave;",
                    'en' => "Enabling of the variant selection while inserting quantities",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamViewDiscountedPrice',
                'descr'      => serialize(array(
                    'it' => "Gestione della visibilit&agrave; dei prezzi (scontati o listino)",
                    'en' => "Price management (discounted or price list)",
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Listino', 'en' => 'Price list')),
                    array('value' => 1, 'descr' => array('it' => 'Scontati', 'en' => 'Discounted')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamViewRegqtaAndCellSize',
                'descr'      => serialize(array(
                    'it' => "Gestisce la visualizzazione di min, mul, mas e la larghezza doppia della cella nell'inserimento quantit&agrave;",
                    'en' => "Min, mul, mas management and double width cell on quantity insert",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'default', 'en' => 'default')),
                    array('value' => 1, 'descr' => array('it' => 'min, mul, mas e doppia larghezza', 'en' => 'min, mul, mas and double width')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ParamWishlistActive',
                'descr'      => serialize(array(
                    'it' => 'Abilita la wishlist',
                    'en' => 'Enabling of the wishlist',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'PaymentOnCloseOrder',
                'descr'      => serialize(array(
                    'it' => 'Scelta della condizione di pagamento selezionabile',
                    'en' => 'Choose of selectable payment condition',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Condizione default', 'en' => 'Default condition')),
                    array('value' => 1, 'descr' => array('it' => 'Condizione personalizzata', 'en' => 'Custom condition')),
                    array('value' => 2, 'descr' => array('it' => 'Entrambe', 'en' => 'Both')),
                    array('value' => 3, 'descr' => array('it' => 'Scelta libera (menu a tendina)', 'en' => 'Free choice (dropdown menu)')),
                    array('value' => 4, 'descr' => array('it' => 'Personalizzata (in un range), senn&ograve; default', 'en' => 'Custom in a range, else default')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'PdfFooterRow1',
                'descr'      => serialize(array(
                    'it' => 'Testo visualizzato nella prima riga del pdf ordine',
                    'en' => 'Text shown on first row of the order pdf',
                )),
                'privileges' => '1',
                'value'      => '',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'PdfFooterRow2',
                'descr'      => serialize(array(
                    'it' => 'Testo visualizzato nella seconda riga del pdf ordine',
                    'en' => 'Text shown on second row of the order pdf',
                )),
                'privileges' => '1',
                'value'      => '',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'PdfFooterRow3',
                'descr'      => serialize(array(
                    'it' => 'Testo visualizzato nella terza riga del pdf ordine',
                    'en' => 'Text shown on third row of the order pdf',
                )),
                'privileges' => '1',
                'value'      => '',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'PriceListsManagementForAgent',
                'descr'      => serialize(array(
                    'it' => "Abilita la possibilità di assegnare i listini selezionabili dall'agente",
                    'en' => 'Enabling the management of price lists for agent',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'PreventOrderToBeSentWithoutPrices',
                'descr'      => serialize(array(
                    'it' => "Impedisci l'invio di ordini senza prezzi",
                    'en' => 'Prevent order to be sent without prices',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ProductTypeOnCatalog',
                'descr'      => serialize(array(
                    'it' => 'Definisce che tipo di prodotto vedere sul catalogo',
                    'en' => 'Define what type of products to display on catalog',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Tipolo', 'en' => 'Tipolo')),
                    array('value' => 1, 'descr' => array('it' => 'Anaart', 'en' => 'Anaart')),
                    array('value' => 2, 'descr' => array('it' => 'Anaart + color', 'en' => 'Anaart + color')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ModalTypeOnCatalog',
                'descr'      => serialize(array(
                    'it' => 'Definisce come visualizzare la modale di acquisto rapido',
                    'en' => 'Defines how to display the quick purchase modal',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Colori come tab', 'en' => 'Colors as tab')),
                    array('value' => 1, 'descr' => array('it' => 'Colori come righe', 'en' => 'Colors as rows')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'QuickNavigation',
                'descr'      => serialize(array(
                    'it' => 'Salta la modale nel catalogo e permettere di andare automaticamente allo step successivo nel wizard, una volta selezionato il tessuto',
                    'en' => 'Skip the modal in the catalog and allow you to automatically go to the next step in the wizard, once the fabric has been selected',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'RemoveSliderArticlesOnModelDetail',
                'descr'      => serialize(array(
                    'it' => 'Toglie lo slider degli articoli dalla scheda modello, si vedranno tutti',
                    'en' => 'No article slider on model detail, so all articles will be shown',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'SendEmailWhenClosingOrder',
                'descr'      => serialize(array(
                    'it' => "Abilita l'invio per email dell'ordine",
                    'en' => 'Enable order email send',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                    array('value' => 2, 'descr' => array('it' => 'S&igrave;, anche per agente', 'en' => 'Yes, for agent too')),
                    array('value' => 3, 'descr' => array('it' => 'S&igrave;, anche notifica ordine da parametro', 'en' => 'Yes, order notification too')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ShippingOnCloseOrder',
                'descr'      => serialize(array(
                    'it' => 'Scelta della condizione di spedizione selezionabile',
                    'en' => 'Choose of selectable shipping condition',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Condizione default', 'en' => 'Default condition')),
                    array('value' => 1, 'descr' => array('it' => 'Condizione personalizzata', 'en' => 'Custom condition')),
                    array('value' => 2, 'descr' => array('it' => 'Entrambe', 'en' => 'Both')),
                    array('value' => 3, 'descr' => array('it' => 'Scelta libera (menu a tendina)', 'en' => 'Free choice (dropdown menu)')),
                    array('value' => 4, 'descr' => array('it' => 'Personalizzata (in un range), senn&ograve; default', 'en' => 'Custom in a range, else default')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ShippingsOnOrderRows',
                'descr'      => serialize(array(
                    'it' => 'Fornisce la possibilità di scegliere la destinazione merce su ogni singola riga ordine',
                    'en' => 'Enable the choice of shipping on every single order row',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ShowAvailabilityFlag',
                'descr'      => serialize(array(
                    'it' => 'Mostra il flag per la disponibilità',
                    'en' => 'Show availability flag',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'Zanotti', 'en' => 'Zanotti')),
                    array('value' => 2, 'descr' => array('it' => 'Semaforo', 'en' => 'Traffic light')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ShowContactInfo',
                'descr'      => serialize(array(
                    'it' => 'Mostra le informazioni di contatto sul footer',
                    'en' => 'Show contact info on footer',
                )),
                'privileges' => '2',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ShowDownloadModelDetail',
                'descr'      => serialize(array(
                    'it' => 'Mostra la sezione download nel dettaglio articolo',
                    'en' => 'Show the download section in the model detail page',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ShowMinMulOnModelDetail',
                'descr'      => serialize(array(
                    'it' => 'Abilita la visualizzazione del minimo e multiplo sulla scheda modello',
                    'en' => 'Enable the visualization of minimum and multiple on model detail',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'ShowPriceOverImage',
                'descr'      => serialize(array(
                    'it' => "Mostra prezzo e info sopra l'immagine del prodotto",
                    'en' => 'Show price and info over product image',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'SpecialSelections',
                'descr'      => serialize(array(
                    'it' => 'Abilita la possibilità di creare selezioni speciali per ogni catalogo',
                    'en' => 'Give the possibility to create special selections for each catalog',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitate', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitate (cdartn)', 'en' => 'Enabled (cdartn)')),
                    array('value' => 2, 'descr' => array('it' => 'Abilitate (cdarti)', 'en' => 'Enabled (cdarti)')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'SplitLardiniOrderCsv',
                'descr'      => serialize(array(
                    'it' => 'Definisce cosa valutare per dividere i csv degli ordini',
                    'en' => 'Define how to split orders csv',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'cddrop, cddesm, cdlinm, 100 righe', 'en' => 'cddrop, cddesm, cdlinm, 100 lines')),
                    array('value' => 1, 'descr' => array('it' => 'cddesm, cdlinm, 100 righe', 'en' => 'cddesm, cdlinm, 100 lines')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'StartingHomePage',
                'descr'      => serialize(array(
                    'it' => 'Definisce quale pagina visualizzare dopo il login',
                    'en' => 'Define which page is displayed after login',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default', 'en' => 'Default')),
                    array('value' => 1, 'descr' => array('it' => 'Tutte le collezioni', 'en' => 'All collections')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'SupportAvailable',
                'descr'      => serialize(array(
                    'it' => 'Abilita la sezione supporto',
                    'en' => 'Enable the support section',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Abilitato', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'SyncIgnoreDescriptions',
                'descr'      => serialize(array(
                    'it' => 'Se impostato su "Sì", le descrizioni degli articoli saranno ignorate durante la sincronizzazione',
                    'en' => 'If set to "Yes", item descriptions will be ignored during synchronisation',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'SyncImageType',
                'descr'      => serialize(array(
                    'it' => 'Definisce la tipologia di sincronizzazione per le immagini',
                    'en' => 'Define the synchronization type for images',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Default con sync principale', 'en' => 'Default with main sync')),
                    array('value' => 1, 'descr' => array('it' => 'Con XLS, esclusa da sync principale', 'en' => 'With XLS, skipped by main sync')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'SyncType',
                'descr'      => serialize(array(
                    'it' => 'Definisce la tipologia di sincronizzazione',
                    'en' => 'Define the synchronization type ',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'XML Default', 'en' => 'XML Default')),
                    array('value' => 1, 'descr' => array('it' => 'CSV Lardini', 'en' => 'CSV Lardini')),
                    array('value' => 2, 'descr' => array('it' => 'CSV Zanotti', 'en' => 'CSV Zanotti')),
                    array('value' => 3, 'descr' => array('it' => 'Excel', 'en' => 'Excel')),
                    array('value' => 4, 'descr' => array('it' => 'CSV Lardini 2', 'en' => 'CSV Lardini 2')),
                    array('value' => 5, 'descr' => array('it' => 'Nav', 'en' => 'Nav')),
                    array('value' => 6, 'descr' => array('it' => 'CSV Thi', 'en' => 'CSV Thi')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'HighlightEffects',
                'descr'      => serialize(array(
                    'it' => 'Definisce se usare un \'effetto evidenziato\' su alcuni dettagli e nel caso quale colore usare',
                    'en' => 'Defines whether to use the \'highlight effect\' on some details and if so which color to use',
                )),
                'privileges' => '1',
                'value'      => 'yellow',
                'options'    => serialize(array(
                    array('value' => '', 'descr' => array('it' => 'Disabilitato', 'en' => 'Disabled')),
                    array('value' => 'yellow', 'descr' => array('it' => 'Giallo', 'en' => 'Yellow')),
                    array('value' => 'blue', 'descr' => array('it' => 'Blu', 'en' => 'Blue')),
                    array('value' => 'green', 'descr' => array('it' => 'Verde', 'en' => 'Green')),
                    array('value' => 'pink', 'descr' => array('it' => 'Rosa', 'en' => 'Pink')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'SupportSelectArgument',
                'descr'      => serialize(array(
                    'it' => 'Permette di far scegliere agli utenti che inseriscono un nuovo ticket l\'argomento della richiesta',
                    'en' => 'Allows users entering a new ticket to choose the topic of the request',
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'SectionTitle',
                'descr'      => serialize(array(
                    'it' => 'Permette di far scegliere quali informazioni utilizzare per i titoli di sezione nel catalogo',
                    'en' => 'Allows you to choose which information to use for section titles in the catalogue',
                )),
                'privileges' => '1',
                'value'      => 'marchio-linea-serie',
                'options'    => serialize(array(
                    array('value' => 'marchio-linea-serie', 'descr' => array('it' => 'Marchio - Linea - Serie', 'en' => 'Brand - Line - Series')),
                    array('value' => 'linea-serie', 'descr' => array('it' => 'Linea - Serie', 'en' => 'Line - Series')),
                    array('value' => 'serie', 'descr' => array('it' => 'Serie', 'en' => 'Series')),
                )),
                'tab'        => serialize(array('it' => 'Catalogo', 'en' => 'Catalog')),
            ),
            array('name' => 'NewOrderLandingPage',
                'descr'        => serialize(array(
                    'it' => 'Scegliere la pagina su cui atterrare all\'apertura di un nuovo ordine',
                    'en' => 'Choose the page you want to land on when opening a new order',
                )),
                'privileges' => '1',
                'value'      => '-1',
                'options'    => serialize(array(
                    array('value' => '-1', 'descr' => array('it' => 'Come StartingHomePage', 'en' => 'Like StartingHomePage')),
                    array('value' => '0', 'descr' => array('it' => 'Home del catalogo', 'en' => 'Catalog Homepage')),
                    array('value' => '1', 'descr' => array('it' => 'Pagina Collezioni', 'en' => 'Collections Page')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'ExportAvailabilityXls',
                'descr'      => serialize(array(
                    'it' => 'Indicare se si intende consentire o meno l\'esportazione in formato xls della disponibilità degli articoli nel catalogo',
                    'en' => 'Indicate whether or not you want to allow the export of the availability of items in the catalog in XLS format',
                )),
                'privileges' => '1',
                'value'      => '1',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Ordine', 'en' => 'Order')),
            ),
            array('name' => 'NavbarBackgroundColor',
                'descr'      => serialize(array(
                    'it' => 'Specificare un colore da utilizzare come sfondo per la barra superiore e per i titoli delle linee/serie nel catalogo',
                    'en' => 'Specify a color to use as the background for the top bar and line/series titles in the catalog',
                )),
                'privileges' => '1',
                'value'      => '',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'RegistrationMandatoryFields',
                'descr'      => serialize(array(
                    'it' => 'Specificare i campi da rendere obbligatori nel modulo di richiesta registrazione',
                    'en' => 'Specify the fields to be made mandatory in the registration request form',
                )),
                'privileges' => '1',
                'value'      => 'businessname,vatcode,email,address,city,cap,country,province',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'UseNewCustomerReferent',
                'descr'      => serialize(array(
                    'it' => 'Indicare se si intende utilizzare la sezione \'Referente Aziendale\' nel modulo di richiesta registrazione',
                    'en' => 'Indicate whether you intend to use the \'Company Contact\' section in the registration request form',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'S&igrave;', 'en' => 'Yes')),
                )),
                'tab'        => serialize(array('it' => 'Account', 'en' => 'Account')),
            ),
            array('name' => 'OrderLimit',
                'descr'      => serialize(array(
                    'it' => 'Questa funzione permette di attivare il controllo dei limiti minimi per poter inviare un ordine. Il valore va poi indicato nel parametro \'MinOrderLimitValue\'',
                    'en' => 'This function allows you to activate the control of the minimum limits to be able to send an order. The value must then be indicated in the \'MinOrderLimitValue\' parameter',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'No', 'en' => 'No')),
                    array('value' => 1, 'descr' => array('it' => 'Quantità Minima', 'en' => 'Minimum quantity')),
                    array('value' => 2, 'descr' => array('it' => 'Spesa Minima', 'en' => 'Minimum spend')),
                )),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'OrderLimitMinValue',
                'descr'      => serialize(array(
                    'it' => 'Valore minimo che verrà controllato attivando il parametro \'OrderLimit\'',
                    'en' => 'Minimum value that will be controlled by activating the \'OrderLimit\' parameter',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize('free'),
                'tab'        => serialize(array('it' => 'Chiusura ordine', 'en' => 'Closing order')),
            ),
            array('name' => 'ShowBaseCustomerDiscount',
                'descr'      => serialize(array(
                    'it' => 'Valore minimo che verrà controllato attivando il parametro \'OrderLimit\'',
                    'en' => 'Minimum value that will be controlled by activating the \'OrderLimit\' parameter',
                )),
                'privileges' => '2',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Solo nel carrello', 'en' => 'Only on cart')),
                    array('value' => 1, 'descr' => array('it' => 'Catalogo e dettaglio scontati', 'en' => 'Discounted catalog and detail')),
//                    array('value' => 2, 'descr' => array('it' => 'Sconto come prezzo base', 'en' => 'Discount as base price')), // Ipotesi
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamViewNewClient',
                'descr'      => serialize(array(
                    'it' => "Scelta del template per la registrazione di un nuovo cliente",
                    'en' => "Choosing a template for registering a new client",
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Template nuovo cliente standard', 'en' => 'Standard new client templateo')),
                    array('value' => 1, 'descr' => array('it' => 'Template nuovo cliente Kocca', 'en' => 'New Kocca customer template')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
            array('name' => 'ParamAdvancedSync',
                'descr'      => serialize(array(
                    'it' => 'Attiva la sincronizzazione per gruppi su nav(solo se il tipo di sincronizzazione è nav)',
                    'en' => 'Enable synchronization for groups on nav (only if the synchronization type is nav)',
                )),
                'privileges' => '1',
                'value'      => '0',
                'options'    => serialize(array(
                    array('value' => 0, 'descr' => array('it' => 'Spento', 'en' => 'Disabled')),
                    array('value' => 1, 'descr' => array('it' => 'Attivo', 'en' => 'Enabled')),
                )),
                'tab'        => serialize(array('it' => 'Generali', 'en' => 'General')),
            ),
        );
    }
    //endregion

    //region Custom queries
    /**
     * Query:   UPDATE
     * Return:  bool
     */
    public static function updateRow($name, $value)
    {
        $query = 'UPDATE b2b_appset s
      SET s.value = :value
      WHERE s.name = :name';
        return Di::getDefault()->get('db')->query($query, array('name' => $name, 'value' => $value));
    }
    //endregion
}


// Questo ce lo eravamo perso?
// INSERT INTO `b2b_appset` (`name`, `descr`, `privileges`, `value`, `options`, `tab`) VALUES ('sendMailNewRequestAccess', 'a:2:{s:2:\"it\";s:61:\"Definisce il modo di invio della mail in richiesta di accesso\";s:2:\"en\";s:56:\"Defines the mode of sending the e-mail in access request\";}', 1, '1', 'a:2:{i:0;a:2:{s:5:\"value\";i:0;s:5:\"descr\";a:2:{s:2:\"it\";s:10:\"Emailto JS\";s:2:\"en\";s:10:\"Emailto JS\";}}i:1;a:2:{s:5:\"value\";i:1;s:5:\"descr\";a:2:{s:2:\"it\";s:12:\"Email in Php\";s:2:\"en\";s:9:\"Php email\";}}}', 'a:2:{s:2:\"it\";s:8:\"Generali\";s:2:\"en\";s:7:\"General\";}');
